/* Define the political-ecological database.  Note that Derby does
   not have a "drop database"
   command so to replace an existing database, you need to remove its
   directory with the command-line command:
       rmdir /s /q polecol
   Also, "load data" is a MySQL command that derby does not recognize.
   Instead, one could use "call syscs_util.syscal_import_table"
 
   1. Have Storyparse write files of everything needed to build the
      database.

   2. This method will read these files and build the database and/or
      execute queries against it.
*/

/* Definitions of database tables.
   Note 1: Storyutils.findactpttrn_() searches within a sentence for
   a matching combination of m-word verb, direct object phrase, and
   (optionally) a prepositional phrase.  Hence, each such n-gram will
   be attached to a particular sentence.  But findactpttrn_() is called
   twice because there may be more than one action in a sentence.
   Hence, there is a many-to-many relationship between sentences and
   noun phrases.  A junction table is needed.  This applies to m-word
   verbs, direct object phrases, and prepositional phrases.
   
   Note 2: Noun phrases refer to archetypal actors and targets.

   Note 3: If an m-word verb does not match any EMAT m-word verb,
   assign it to ematvrbid=1 which is the EMAT m-word verb "no_match".
   This applies to direct object phrases, and prepositional phrases also. */

/* ---------------- EMAT definitions tables. ------------------ */

create table emat (
   ematid varchar(10) not null primary key,
   action varchar(80));

create table ematvrb (
   vrbuid int not null identity(1,1) primary key,
   ematid varchar(10) not null,
   ematvrbid int not null,
   ematvrb varchar(80),
   foreign key (ematid) references emat (ematid) on delete cascade);

create table ematvrbemat (
   ematid varchar(10) not null,
   vrbuid int not null,
   constraint ematvrbemat_pk primary key (ematid, vrbuid),
   foreign key (ematid) references emat (ematid) on delete no action,
   foreign key (vrbuid) references ematvrb (vrbuid) on delete cascade);

create table ematdoph (
   dophuid int not null identity(1,1) primary key,
   ematid varchar(10) not null,
   ematdophid int not null,
   ematdoph varchar(80),
   foreign key (ematid) references emat (ematid) on delete cascade);

create table ematdophemat (ematid varchar(10) not null, dophuid int not null,
   constraint ematdophemat_pk primary key (ematid, dophuid),
   foreign key (ematid) references emat (ematid) on delete no action,
   foreign key (dophuid) references ematdoph (dophuid) on delete cascade)

create table ematpph (
   pphuid int not null identity(1,1) primary key,
   ematid varchar(10) not null,
   ematpphid int not null,
   ematpph varchar(80),
   foreign key (ematid) references emat (ematid) on delete cascade);

create table ematpphemat (
   ematid varchar(10) not null, pphuid int not null,
   constraint ematpphemat_pk primary key (ematid, pphuid),
   foreign key (ematid) references emat (ematid) on delete no action,
   foreign key (pphuid) references ematpph (pphuid) on delete cascade);

/* ---------------- Observed actions tables. -------------------- */
 
create table story (
   storyid int not null identity(1,1) primary key,
   storydate float not null,
   source varchar(40),
   country varchar(40) not null);

create table sen (
   storyid integer not null,
   senid int not null identity(1,1) primary key,
   foreign key (storyid) references story (storyid) on delete cascade);

create table nph (
   nphid int not null identity(1,1) primary key,
   nph varchar(10));

create table nphsen (
   nphid int not null,
   senid int not null,
   constraint nphsen_pk primary key (nphid, senid),
   foreign key (nphid) references nph (nphid) on delete no action,
   foreign key (senid) references sen (senid) on delete cascade);

create table mwvrb (
   senvrbid int not null identity(1,1) primary key,
   vrbuid int not null default 1,
   ematvrbid int not null default 1,
   mwvrb varchar(10),
   foreign key (vrbuid) references ematvrb (vrbuid) on delete cascade);

create table mwvrbsen (
   senvrbid int not null,
   senid int not null,
   constraint mwvrbsen_pk primary key (senvrbid, senid),
   foreign key (senvrbid) references mwvrb (senvrbid) on delete no action,
   foreign key (senid) references sen (senid) on delete cascade);

create table doph (
   sendophid int not null identity(1,1) primary key,
   dophuid int not null default 1,
   ematdophid int not null default 1,
   doph varchar(10),
   foreign key (dophuid) references ematdoph (dophuid) on delete cascade);

create table dophsen (
   sendophid int not null,
   senid int not null,
   constraint dophsen_pk primary key (sendophid, senid),
   foreign key (sendophid) references doph (sendophid) on delete no action,
   foreign key (senid) references sen (senid) on delete cascade);

create table pph (
senpphid int not null identity(1,1) primary key,
   pphuid int not null default 1,
   ematpphid int not null default 1,
   pph varchar(10),
   foreign key (pphuid) references ematpph (pphuid) on delete cascade);

create table pphsen (
   senpphid int not null,
   senid int not null,
   constraint pphsen_pk primary key (senpphid, senid),
   foreign key (senpphid) references pph (senpphid) on delete no action,
   foreign key (senid) references sen (senid) on delete cascade);

create table ecodatref (
   senid int not null,
   ematid varchar(10) not null,
   constraint ecodatref_pk primary key (ematid, senid),
   foreign key (ematid) references emat (ematid) on delete no action,
   foreign key (senid) references sen (senid) on delete cascade);

