public class Apcnde extends Predict {

static int nmvar;
// static int indx[] = new int[SIMSZE];
static int nmdat[] = new int[NUMVAR];
static double minobs, midobs, maxobs;
static double trendvals[] = new double[NUMVAR];
static double wobs[] = new double[WLSSZE];
static double stdnrms[] = new double[WLSSZE + NUMVAR];
static double realiz[] = new double[WLSSZE + NUMVAR];
static double simdat[][] = new double[WLSSZE][WLSSZE + NUMVAR];
static double simvals[][] = new double[WLSSZE][NUMVAR];
static double simerrs[][] = new double[WLSSZE][NUMVAR];
static double resids[] = new double[WLSSZE + NUMVAR];
// static double stdres[] = new double[SIMSZE];
static double mean[] = new double[WLSSZE + NUMVAR];
static double meanvec[] = new double[NUMVAR];
static double stdvec[] = new double[WLSSZE + NUMVAR];
static double stderrvec[] = new double[NUMVAR];
static double maxvec[] = new double[NUMVAR];
static double trim[] = new double[WLSSZE + NUMVAR];
static double trimfrac[] = new double[NUMVAR];
static double krnlwghts[][] = new double[NUMCNTR][WLSSZE + NUMVAR];

static double wx0[] = new double[NUMVAR];
static double wx0hat[] = new double[NUMVAR];

// -------------------------------------------------------------------------

public static void apcnde_(boolean start, double xcord, double ycord,
   double tmecord, double pred[]) {

/* Approximate Conditional Expectation (ap cnd e).  Computes an
   approximation to the conditional expected value at
   (xcord, ycord, tmecord).  Algorithm: by simulating from each GLOMAP
   component, simulate GLOMAP model realizations on "W" at all observation
   locations.  Then, find the closest "m" of these realizations to the
   sample and take the average over these closest realizations of the
   GLOMAP value at the prediction location.

   Possible extension: By adding all prediction locations to the "w"
   vector, one could compute all predictions at once instead of the
   one-at-a-time method of the current version. */

boolean close;
int i, i1, j, k, cvstrct, maxnmmc = 20000, m = 200;
double diff, retval, trend, tol = .9;

if (start) {

   // Increase cylinder count by the number of variables to be predicted.

   nmvar = nd + parm_mvar;

   // Add prediction location to the end of vardat.

   for (i = nd; i < nmvar; ++i) {
      vardat_vrble[i] = lomapnms[i - nd];
      vardat_x[i] = xcord;
      vardat_y[i] = ycord;
      vardat_t[i] = tmecord;
   }

   // Form and store the Cholesky decomposition of the covariance matrix.

   for (i = 0; i < nmvar; ++i) {
      for (j = 0; j <= i; ++j) {
	 stnmi = idtostnm[vardat_vrble[i] - 1];
	 stnmj = idtostnm[vardat_vrble[j] - 1];
         if (vardat_vrble[i] == vardat_vrble[j]) {
            cvstrct = stnmi;
    
         } else {
            cvstrct = crossmap[stnmi - 1][stnmj - 1];
         }
         form_a[i][j] = Covmodl.covmodl_(i, j, vardat_x[i], vardat_y[i],
            vardat_t[i], vardat_x[j], vardat_y[j], vardat_t[j], cvstrct);
         if (i != j) form_a[j][i] = form_a[i][j];
      }

      // Check for singularity.

      if (i > 0) {
	 exactsg_(form_a, i, "simdist: form_a");
      }
   }
   retval = Choles.choles_(form_a, s, 1, nmvar, false);
   if (retval < 0.) {
      iderr_("apcnde: Cholesky decomposition failed");
   }

   /*  Back-transform observations to the original scale and find the
       maximum of these observations. */

   minobs = 1.e30;
   maxobs = 0.;
   for (i = 0; i < nd; ++i) {
      if (!trnsfrm) {
	 wobs[i] = vardat_obs[i];
      
      } else {
	 wobs[i] = Math.exp(vardat_obs[i]);
      }
      if (maxobs < wobs[i]) {
	 maxobs = wobs[i];
      }
      if (wobs[i] < minobs) {
	 minobs = wobs[i];
      }
   }
   midobs = .5 * (maxobs + minobs);
}

// Simulation loop.

for (i = 0; i < m; ++i) {
   for (k = 0; k < maxnmmc; ++k) {

      // Zero-out this realization.

      for (j = 0; j < nmvar; ++j) realiz[j] = 0.;

      /* Generate a realization on (Z_i(x_1), ... , Z_i(x_n), Z_i(x_0))'
         to compute the realization on whatever mix of variables and
         locations contained in vardat and the prediction location. */

      for (j = 0; j < nmvar; ++j) stdnrms[j] = Rndm.stdnrm_();

      for (j = 0; j < nmvar; ++j) {
         resids[j] = 0.;
         for (i1 = 0; i1 < nmvar; ++i1) {
	    resids[j] += s[j][i1] * stdnrms[i1];
         }

         // Compute trend.

         if (nmstmixcntr == 0) {
            vardat_trend[j] = Trendeval.trendfcn_(0, true, 0, vardat_x[j],
               vardat_y[j], vardat_t[j], vardat_quantval[j],
	       vardat_qualval[j], j + 1);

         } else {
            Trendeval.mixtrend_(true, 0, vardat_x[j], vardat_y[j],
               vardat_t[j], vardat_quantval[j], vardat_qualval[j],
               j + 1, trendvals);
            vardat_trend[j] = trendvals[j];
         }

         /* Back-transform this Z (see Haas (2000)) value to the
            original scale. */

         realiz[j] = Trnsfrm.invgaus_(j + 1, resids[j]);
         realiz[j] += vardat_trend[j];
      }

      // Test for this realization being close to the observed one.

      close = true;
      for (j = 0; j < nd; ++j) {
         if (tol < Math.abs((wobs[j] - realiz[j]) / maxobs)) {
            close = false;
            break;
         }
      }

      // If this is the first realization or if it is close, store it.

      // if (k == 0 || close) {
      if (k == 0) {
         for (j = 0; j < nmvar; ++j) simdat[i][j] = realiz[j];
      // if (close) break;
         break;
      }
   }
   // printf_("apcnde: i= " + i + " k= " + k);
}

/* Compute distance of each simulated vector from the observed vector.
   First, compute standard error at each observation location and
   variable.
for (i = 0; i < nmvar; ++i) {
   nmdat[i] = nmmc;
   trim[i] = 0.;
}
Summry.summry_(false, 1, nmdat, nmvar, trim, simdat, mean, stdvec, maxvec);
   Find Euclidean distance between each simulated realization and the
   sample.  Note: use only the observation locations (1 through nd) to
   compute this distance.
for (i = 0; i < nmmc; ++i) {
   indx[i] = i + 1;
   stdres[i] = 0.;
   for (j = 0; j < nd; ++j) {
      diff = (simdat[i][j] - wobs[j]) / stdvec[j];
      // diff = simdat[i][j] - wobs[j];
      stdres[i] += diff * diff;
   }
}
Idsort.idsort_(stdres, indx, 1, nmmc);
   indx[] sorts the nmmc realizations by their similarity to the
   sample.  Use the first m of these sorted realizations for computing
   the estimate of the conditional expectation on each variable at the
   prediction location. First, compute the number of nearest neighbors
   (m) to use.
m = (int) (.1 * ((double) nmmc));
m = 40;
if (m <= 2) m = 2;
for (i = 0; i < m; ++i) {
   for (j = 0; j < parm_mvar; ++j) {
      simvals[i][j] = simdat[indx[i] - 1][nd + j];
   }
}
*/

// Compute predictions.  First, set trimming parameter.

if (start) {
   for (i = 0; i < parm_mvar; ++i) trimfrac[i] = .00;
}

for (i = 0; i < m; ++i) {
   for (j = 0; j < parm_mvar; ++j) simvals[i][j] = simdat[i][nd + j];
}
Summry.summry_(false, 1, nmdat, parm_mvar, trimfrac, simvals, meanvec,
   stderrvec, maxvec);
for (i = 0; i < parm_mvar; ++i) {
   pred[lomapnms[i] - 1] = meanvec[i];
   if (pred[lomapnms[i] - 1] < 0.) {
      printf_("apcnde: i= " + i + " pred= " + pred[lomapnms[i] - 1]);
      pred[lomapnms[i] - 1] = 0.;
   }
}
// printf_("apcnde: pred= " + pred[lomapnms[0] - 1]);
}

// -----------------------------------------------------------------------

static void apstderr_(double xcord, double ycord, double tmecord,
   double errvar[]) {

/* Approximates the standard error.  s is assumed to have been computed
   previously by a call to apcnde_(). */

int i, i1, j, m = 20;
double trend;

// Simulation loop.

for (i = 0; i < m; ++i) {

   /* Generate a realization on
      (Z_i(x_1), ... , Z_i(x_n), Z_i(x_0), ... , Z_i(x_0))', i.e., use
      the last p deviates to compute the realization of W at x_0 and
      the remaining deviates to compute the realization on whatever
      mix of variables and locations contained in vardat.  Store this
      realization in wobs[] so that it can be passed to apcnde_(). */

   // Zero observation vector and generate standard normals.

   for (j = 0; j < nmvar; ++j) {
      wobs[j] = 0.;
      stdnrms[j] = Rndm.stdnrm_();
   }

   for (j = 0; j < nmvar; ++j) {
      resids[j] = 0.;
      for (i1 = 0; i1 < nmvar; ++i1) {
         resids[j] += s[j][i1] * stdnrms[i1];
      }

      // Compute the trend.

      if (nmstmixcntr == 0) {
         vardat_trend[j] = Trendeval.trendfcn_(0, true, 0, vardat_x[j],
            vardat_y[j], vardat_t[j], vardat_quantval[j], vardat_qualval[j],
            j + 1);

      } else {
         Trendeval.mixtrend_(true, 0, vardat_x[j], vardat_y[j],
            vardat_t[j], vardat_quantval[j], vardat_qualval[j],
            j + 1, trendvals);
         vardat_trend[j] = trendvals[j];
      }

      /* Back-transform this Z (see Haas (2000)) value to the
         original scale. */

      wobs[j] = Trnsfrm.invgaus_(j + 1, resids[j]);
      wobs[j] += vardat_trend[j];
   }

   // Save the "true" original scale values at x_0.

   for (j = 0; j < parm_mvar; ++j) {
      wx0[j] = wobs[nd + j];
   }

   /* Using the parameters estimated from the actual data, compute
      a prediction of W(x_0) based on this simulated sample,
      Z_i(x_1), ... , Z_i(x_n).
    
      Note that if the parameters were re-estimated with each
      simulated sample, the resulting standard error would incorporate
      parameter estimate uncertainty -- an advantage much-touted for
      Bayesian methods. */

   apcnde_(false, xcord, ycord, tmecord, wx0hat);

   // Compute and store the residual.

   for (j = 0; j < parm_mvar; ++j) {
      simerrs[i][j] = wx0[j] - wx0hat[j];
   }
}

/* Compute standard deviation of these differences which is the
   desired standard error of prediction. */

Summry.summry_(false, 1, nmdat, parm_mvar, trimfrac, simerrs,
   meanvec, stderrvec, maxvec);
for (i = 0; i < parm_mvar; ++i) {
   errvar[lomapnms[i] - 1] = stderrvec[i] * stderrvec[i];
   if (errvar[lomapnms[i] - 1] < 1.e-4) errvar[lomapnms[i] - 1] = 1.e-4;
}

// Find minimum length volume C.I..

/*
Idsort.idsort_(vol, index, 1, m);
nfrac = (int) Math.round(cilevel * (double) m);
for (i = 0; i < m - nfrac; ++i) {
   if (i + nfrac > m) break;
   cilength = vol[i + nfrac] - vol[i];
   if (cilength < minlength) {
      minlength = cilength;
      cilow = vol[i];
      cihigh = vol[i + nfrac];
   }
}

// Print C.I.

fprintf_(1, "Volume " + fdble_(100. * cilevel, 5, 1) + "% C.I.= ("
   + fdble_(cilow, 9, 3) + ", " + fdble_(cihigh, 9, 3) + ")");
*/
}
}
