public class Clstr extends Trendeval {

// -------------------------------------------------------------------

public static void clstr_(int nmdim, int npts, double prds[][], int nmclus,
   int nmmmbrs[], int clusmem[][], double clscntr[][]) {

// Performs Average Linkage (hierarchical) or K-Means clustering.

boolean test = false, exchnge;

int i, j, j1, k, newclus = 1, oldclus, itmax, iter, rank, clussum = 0;

int cluster[] = new int[MAXN];
int count[] = new int[MAXCLS];

double ri, rj, mindist, dist;

double minprd[] = new double[2];
double maxprd[] = new double[2];
double rnge[] = new double[2];
double seed[][] = new double[MAXCLS][2];
double coor[] = new double[2];
double cencoor[] = new double[2];
double sortvec[] = new double[MAXN];

if (nmclus > MAXCLS) {
   iderr_("clstr: nmclus= " + nmclus + " MAXCLS= " + MAXCLS);
}
if (npts > MAXN) {
   iderr_("npts>MAXN in clstr_()");
}

// Do Average Linkage if npts is < MAXCLS.

if (npts < MAXCLS) {
   hiercl_(npts, nmdim, prds, nmclus, clusmem, nmmmbrs, clscntr);
   return;
}

// K-Means clustering.  First set iteration maximum.

itmax = 100;

// Find initial seeds to be randomly chosen points in the data set.

for (i = 0; i < nmclus; ++i) {
   j1 = (int) (((double) npts) * Rndm.rndm1_(0, 0));
   printf_("clstr: j1= " + j1);
   for (j = 0; j < nmdim; ++j) {
      clscntr[i][j] = prds[j1][j];
   }
}

// Store these seed centroids and set cluster counts to zero.

for (k = 0; k < nmclus; ++k) {
   for (i = 0; i < nmdim; ++i) {
      seed[k][i] = clscntr[k][i];
   }
   count[k] = 0;
}

// Compute initial cluster assignments.

for (i = 0; i < npts; ++i) {
   for (j = 0; j < nmdim; ++j) {
      coor[j] = prds[i][j];
   }
   mindist = 1.e15;
   for (j = 1; j <= nmclus; ++j) {
      for (j1 = 0; j1 < nmdim; ++j1) {
         cencoor[j1] = clscntr[j - 1][j1];
      }
      dist = dist_(nmdim, coor, cencoor);
      if (dist < mindist) {
         mindist = dist;
         cluster[i] = j;
      }
   }
   ++count[cluster[i] - 1];
}
for (i = 0; i < nmclus; ++i) {
   for (j1 = 0; j1 < nmdim; ++j1) {
      clscntr[i][j1] = 0.;
   }
   for (j = 0; j < npts; ++j) {
      if (cluster[j] == (i + 1)) {
         for (j1 = 0; j1 < nmdim; ++j1) {
            clscntr[i][j1] += prds[j][j1];
         }
      }
   }
   for (j1 = 0; j1 < nmdim; ++j1) {
      clscntr[i][j1] /= ((double) count[i]);
   }
   clussum += count[i];
}

/* Clustering loop: continue to pass through the data until no more
   cluster reassignments occur. */

iter = 0;
do {
   exchnge = false;

   // For each observation, find the closest cluster.

   for (i = 0; i < npts; ++i) {
      for (j = 0; j < nmdim; ++j) {
         coor[j] = prds[i][j];
      }
      mindist = 1.e15;
      for (j = 1; j <= nmclus; ++j) {
	 for (j1 = 0; j1 < nmdim; ++j1) {
            cencoor[j1] = clscntr[j - 1][j1];
         }
	 dist = dist_(nmdim, coor, cencoor);
         if (dist < mindist) {
            mindist = dist;
            newclus = j;
         }
      }

      /* If the closest cluster is not the old cluster, add this
	 observation to the new cluster and recalculate both cluster
	 centroids. */

      if (newclus != cluster[i]) {
	 exchnge = true;
	 oldclus = cluster[i];
	 cnupd_(nmdim, nmclus, seed, clscntr, count, oldclus, newclus, coor);
	 cluster[i] = newclus;
      }
   }
   ++iter;
} while (exchnge && iter < itmax);

// Check for zero cluster sizes and itmax exceedance.

for (i = 0; i < nmclus; ++i) {
   if (test) printf_("clstr: clus= " + (i + 1) + " count= " + count[i] +
      " cen1= " + clscntr[i][0] + " " + " cen2= " + clscntr[i][1]);
}
if (iter >= itmax) {
   iderr_("clstr: hit itmax");

} else {
   printf_("clstr: iter= " + iter);
}

// Load clusmem and nmmmbrs arrays.

for (i = 0; i < nmclus; ++i) {
   nmmmbrs[i] = 0;
}
for (i = 0; i < npts; ++i) {
   clusmem[cluster[i] - 1][nmmmbrs[cluster[i] - 1]] = i + 1;
   ++nmmmbrs[cluster[i] - 1];
   if (nmmmbrs[cluster[i] - 1] > MAXMBRS) {
      printf_("clstr: nmmmbrs(" + cluster[i] + ")= " +
         nmmmbrs[cluster[i] - 1]);
      iderr_("clstr: MAXMBRS exceeded");
   }
}
}

// ----------------------------------------------------------------------

public static void cnupd_(int nmdim, int nmclus, double seed[][],
   double center[][], int count[], int oldclus, int newclus,
   double coor[]) {

// Updates cluster centroids.

int i, j;

double rcount, val;

// Update new cluster.

++count[newclus - 1];
if (count[newclus - 1] == 1) {

   /* If the size of the new cluster is based on just 1 observation, replace
      the new cluster centroid with the observation's coordinates. */

   for (i = 0; i < nmdim; ++i) {
      center[newclus - 1][i] = coor[i];
   }

} else {

   // Otherwise, update the new cluster's centroid.

   rcount = (double) count[newclus - 1];
   for (i = 0; i < nmdim; ++i) {
      val = center[newclus - 1][i];
      val = ((val * rcount) + coor[i]) / (rcount + 1.);
      center[newclus - 1][i] = val;
   }
}

// Update old cluster.

--count[oldclus - 1];
if (count[oldclus - 1] > 0) {
   rcount = (double) (count[oldclus - 1] + 1);
   for (i = 0; i < nmdim; ++i) {
      val = center[oldclus - 1][i];
      val = ((val * rcount) - coor[i]) / (rcount - 1.);
      center[oldclus - 1][i] = val;
   }

} else {
   j = ((int) (((double) nmclus) * Rndm.rndm1_(0, 0)));
   for (i = 0; i < nmdim; ++i) {
      center[oldclus - 1][i] = seed[j][i];
   }
   printf_("cnupd: oldclus= " + oldclus + " zero points");
}
}

// ------------------------------------------------------------------

public static void hiercl_(int npts, int nmdim, double prds[][], int nmclus,
   int clusmem[][], int nmmmbrs[], double clscntr[][]) {

// Performs Average Linkage hierarchical clustering.

int i, j, i1, i2, i3, crrntn, jmin = 1, i1min = 1, c1nm, c2nm;

int c1mem[] = new int[MAXCLS];
int c2mem[] = new int[MAXCLS];

double mindist, avedist;

double dist[][] = new double[MAXCLS][MAXCLS];
double x1[] = new double[2];
double x2[] = new double[2];

if (npts > MAXCLS) {
   iderr_("hiercl: npts > MAXCLS");
}

// Initialize the distance matrix.

for (i = 0; i < npts; ++i) {
   for (j = 0; j < i; ++j) {
      for (i1 = 0; i1 < nmdim; ++i1) {
	 x1[i1] = prds[i][i1];
	 x2[i1] = prds[j][i1];
      }
      dist[i][j] = dist_(nmdim, x1, x2);
   }
   nmmmbrs[i] = 1;
   clusmem[i][0] = i + 1;
}
crrntn = npts;

// Perform m = npts - nmclus clustering steps.

for (i = 0; i < npts - nmclus; ++i) {
   
   // Find closest two clusters in dist.

   mindist = 1.e6;
   for (i1 = 0; i1 < crrntn; ++i1) {
      for (j = 0; j < i1; ++j) {
	 if (dist[i1][j] < 1.e-6) {
	    iderr_("hiercl: crrntn= " + crrntn + " dist(" + i1 + "," +
               j + ")= " + dist[i1][j]);
	 }
	 if (dist[i1][j] < mindist) {
	    jmin = j;
	    i1min = i1;
	    mindist = dist[i1][j];
	 }
      }
   }

   for (i1 = 0; i1 < nmmmbrs[jmin]; ++i1) {
      c1mem[i1] = clusmem[jmin][i1];
   }
   for (i1 = 0; i1 < nmmmbrs[i1min]; ++i1) {
      c2mem[i1] = clusmem[i1min][i1];
   }
   c1nm = nmmmbrs[jmin];
   c2nm = nmmmbrs[i1min];

   // Merge the i1min, jmin clusters and update dist.

   for (i1 = jmin + 1; i1 < crrntn ; ++i1) {
      for (j = 0; j < nmmmbrs[i1]; ++j) {
	 clusmem[i1 - 1][j] = clusmem[i1][j];
      }
      nmmmbrs[i1 - 1] = nmmmbrs[i1];
   }
   for (i1 = i1min; i1 < crrntn - 1; ++i1) {
      for (j = 0; j < nmmmbrs[i1]; ++j) {
	 clusmem[i1 - 1][j] = clusmem[i1][j];
      }
      nmmmbrs[i1 - 1] = nmmmbrs[i1];
   }
   for (j = 0; j < c1nm; ++j) {
      clusmem[crrntn - 2][j] = c1mem[j];
   }
   for (j = 0; j < c2nm; ++j) {
      clusmem[crrntn - 2][j + c1nm] = c2mem[j];
   }
   nmmmbrs[crrntn - 2] = c1nm + c2nm;

   // Update dist matrix.

   for (i1 = jmin + 1; i1 < crrntn; ++i1) {
      for (j = 0; j < crrntn; ++j) {
         dist[i1 - 1][j] = dist[i1][j];
      }
   }
   for (i1 = i1min; i1 < crrntn - 1; ++i1) {
      for (j = 0; j < crrntn; ++j) {
         dist[i1 - 1][j] = dist[i1][j];
      }
   }

   for (i1 = jmin + 1; i1 < crrntn; ++i1) {
      for (j = 0; j < crrntn; ++j) {
         dist[j][i1 - 1] = dist[j][i1];
      }
   }
   for (i1 = i1min; i1 < crrntn - 1; ++i1) {
      for (j = 0; j < crrntn; ++j) {
         dist[j][i1 - 1] = dist[j][i1];
      }
   }

   /* Now compute the average distance between each cluster and
      the new cluster to fill in the new last row of dist. */

   for (j = 0; j < crrntn - 2; ++j) {
      avedist = 0.;
      for (i1 = 0; i1 < nmmmbrs[j]; ++i1) {
         for (i2 = 0; i2 < nmmmbrs[crrntn - 2]; ++i2) {
            for (i3 = 0; i3 < nmdim; ++i3) {
               x1[i3] = prds[clusmem[j][i1] - 1][i3];
	       x2[i3] = prds[clusmem[crrntn - 2][i2] - 1][i3];
            }
            avedist += dist_(nmdim, x1, x2);
         }
      }
      avedist /= (double) (nmmmbrs[j] * nmmmbrs[crrntn - 2]);
      if (avedist < 1.e-6) {
         printf_("hiercl: avedist=0,j= " + j);
      }
      dist[crrntn - 2][j] = avedist;
   }
   --crrntn;
}

// Compute cluster centroids.

for (i = 0; i < nmclus; ++i) {
   for (j = 0; j < nmdim; ++j) {
      clscntr[i][j] = 0.;
      for (i1 = 0; i1 < nmmmbrs[i]; ++i1) {
	 clscntr[i][j] += prds[clusmem[i][i1] - 1][j];
      }
      clscntr[i][j] /= (double) nmmmbrs[i];
   }
}
}

// ---------------------------------------------------------------------

public static double dist_(int nmdim, double x1[], double x2[]) {

// Returns the Euclidean distance between x1 and x2.

int i;

double dist, dif;

dist = 0.;
for (i = 0; i < nmdim; ++i) {
   dif = x1[i] - x2[i];
   dist += dif * dif;
}
dist = Math.sqrt(dist);

return dist;
}
}
