import java.util.Random;

class Conddist extends Beliefs {

static boolean firstloop = false;

static int nmthrdloops;

static int prntcounter[] = new int[NMTHRDS];

// ----------------------------------------------------------------

static void conddist_(int outflenm) {

/* Finds the conditional distribution of each unset (free) chance node
   given the values of the conditioning nodes by simulation. */

boolean flag;

int i, j, k, l, nmrunning = 0;

// Initialize conditioning event counters and arrays.

for (i = 0; i < NMTHRDS; ++i) {
   prntcounter[i] = 0;
   denom[i] = 0.;
   idenom[i] = 0;
}
for (i = 0; i < TNMNDS; ++i) {
   for (j = 0; j < TNMVALS; ++j) {
      for (k = 0; k < 10; ++k) {
	 for (l = 0; l < NMTHRDS; ++l) {
	    beliefh[l][k][i][j] = 0.;
	    beliefc[l][k][i][j] = 0.;
	 }
      }
   }
}
kli1 = 0.;
kli2 = 0.;
Update.chkflag = true;

// Check for insufficient conditioning node settings.

for (i = 0; i < nmcondnds; ++i) {
   if (condnodes[idnmbrm1][i] == 0) {
      iderr_("conddist: nmcondnds= " + nmcondnds +
         " condnodes(" + (i + 1) + ")= " + condnodes[idnmbrm1][i] +
         " node number not set.");
   }
}

// ************** Simulation loops. *****************

nmthrdloops = nmloops / nmthreads;
if (nmthrdloops <= printinterval) {
   printinterval = nmthrdloops - 2;
}

if (belpflag) {
   printf_("\nconddist: nmloops= " + nmloops + " printinterval= " +
      printinterval +
      "\n thrd #-of-tours-completed    #-of-conditioning-events");
}

Thread mcworker[] = new Thread[nmthreads];
for (i = 0; i < nmthreads; ++i) {
   MCworker task = new MCworker((i + 1), nmthrdloops);
   mcworker[i] = new Thread(task);
   mcworker[i].start();
}

do {
   nmrunning = 0;
   for (i = 0; i < nmthreads; ++i) {
      if (mcworker[i].isAlive()) {
         ++nmrunning;
      }
   }
} while (nmrunning > 0);

// Sum number of conditioning events across threads.

for (i = 1; i <= nmthreads; ++i) {
   idenom[0] += idenom[i];
   denom[0] += denom[i];
}

// Load realizations from threads.

if (nmthreads * denom[1] > SIMSZE) {
   iderr_("conddist: nmthreads= " + nmthreads + " denom1= " + denom[1]);
}

l = 0;
for (i = 1; i <= nmthreads; ++i) {
   for (j = 0; j < denom[i]; ++j) {
      for (k = 0; k < nmnds; ++k) {
         simdata[0][l][k][0] = simdata[i][j][k][0];
         simdata[0][l][k][1] = simdata[i][j][k][1];
      }
      ++l;
   }
}

// Write number of conditioning events and check for a zero denominator.

if (idenom[0] == 0) {
   printf_("conddist: idenom=0 nmthreads= " + nmthreads +
      " Number of conditioning nodes= " + nmcondnds);
   for (i = 0; i < nmcondnds; ++i) {
      if (nodenghs[idnmbrm1][condnodes[idnmbrm1][i] - 1][0] > 1) {
         printf_("   " +
            nodelbls[idnmbrm1][condnodes[idnmbrm1][i] - 1][0] + "= " +
            nodelbls[idnmbrm1][condnodes[idnmbrm1][i] - 1]
		    [((int) condvals[i])]);

      } else {
         printf_("   " +
            nodelbls[idnmbrm1][condnodes[idnmbrm1][i] - 1][0] + "= " +
            condvals[i]);
      }
   }
   iderr_("conddist: idname= " + thisidname + " idenom[0]= 0.");
}

if (belpflag) {
   fprintf_(outflenm, "Total number of conditioning events generated" +
      " during the simulation: " + idenom[0]);
}

// Compute probabilities or first 2 moments for each node.

for (i = 0; i < nmoutt; ++i) {
   NODELOOP: for (j = 0; j < nmnds; ++j) {
      for (k = 0; k < nmcondnds; ++k){
         if (j + 1 == condnodes[idnmbrm1][k]) {
	    continue NODELOOP;
	 }
      }
      if (nodenghs[idnmbrm1][j][0] > 1) {

         // Convert discrete node counts to probability approximations.
   
         for (k = 0; k < nodenghs[idnmbrm1][j][0]; ++k) {

            // But first, load individual thread values.

            for (l = 1; l <= nmthreads; ++l) {
	       if (!loadconsdst) {
                  beliefh[0][i][j][k] += beliefh[l][i][j][k];

	       } else {
                  beliefc[0][i][j][k] += beliefc[l][i][j][k];
	       }
	    }

            if (!loadconsdst) {
               beliefh[0][i][j][k] /= denom[0];

            } else {
               beliefc[0][i][j][k] /= denom[0];
            }
         }

      } else {

         /* Compute the mean and standard deviation of non-discrete
            nodes. */

         if (!loadconsdst) {
            for (l = 1; l <= nmthreads; ++l) {
	       beliefh[0][i][j][0] += beliefh[l][i][j][0];
	       beliefh[0][i][j][1] += beliefh[l][i][j][1];
	    }
            beliefh[0][i][j][1] = beliefh[0][i][j][1] -
	       ((beliefh[0][i][j][0] * beliefh[0][i][j][0]) / denom[0]);
	    beliefh[0][i][j][1] /= (denom[0] - 1.);

	    if (beliefh[0][i][j][1] > 1.e-4) {
	       beliefh[0][i][j][1] = Math.sqrt(beliefh[0][i][j][1]);
	    }

            beliefh[0][i][j][0] /= denom[0];
	    
	 } else {
            for (l = 1; l <= nmthreads; ++l) {
	       beliefc[0][i][j][0] += beliefc[l][i][j][0];
	       beliefc[0][i][j][1] += beliefc[l][i][j][1];
	    }
            beliefc[0][i][j][1] = beliefc[0][i][j][1] -
	       ((beliefc[0][i][j][0] * beliefc[0][i][j][0]) / denom[0]);
	    beliefc[0][i][j][1] /= (denom[0] - 1.);

	    if (beliefh[0][i][j][1] > 1.e-4) {
	       beliefc[0][i][j][1] = Math.sqrt(beliefc[0][i][j][1]);
	    }

            beliefc[0][i][j][0] /= denom[0];
	 }
      }
   } // End of loop over nodes.
} // End of loop over output times.
}

// --------------------------------------------------------------------

static void tour_(int thrd, int loopnm) {

/* Logic sampling.  In interactive mode (!cacalc), the hypothesis
   distribution is used.  Conduct tours over time points.  Time is
   the outer loop.  Store solution at desired time points.  First,
   initialize node values arrays. */

boolean flag, flag1;

int i, j, valnm, time, tmeindx, outtmeindx = -1;

double prob1 = 0., prob2 = 0., nodeval = 0.;

for (i = 0; i < nmnds; ++i) {
   nodevalsh[thrd][0][i] = 1.;
   nodevalsc[thrd][0][i] = 1.;
   nodevalsh[thrd][1][i] = 1.;
   nodevalsc[thrd][1][i] = 1.;
}

for (i = 0; i < nmcondnds; ++i) {
   nodevalsh[thrd][0][condnodes[idnmbrm1][i] - 1] = condvals[i];
   nodevalsc[thrd][0][condnodes[idnmbrm1][i] - 1] = condvals[i];
   nodevalsh[thrd][1][condnodes[idnmbrm1][i] - 1] = condvals[i];
   nodevalsc[thrd][1][condnodes[idnmbrm1][i] - 1] = condvals[i];
}

// Loop over temporal solution discretization time points.

if (nmtmefcns[idnmbrm1] > 0) {
   beltmept[thrd] = Ecosyscalcs.tbegin;
 
} else {
   beltmept[thrd] = outputtime[0];
}
tmefcnstep[thrd] = true;
Ecosyscalcs.firsttimepoint[thrd] = true;

for (tmeindx = 0; tmeindx < nmtimepts; ++tmeindx) {

   /* Check if this is one of the output times or if this is a
      non-temporal ID.  First, set output storage flag.  Store
      output if "beltmept" is close to an output time.
      
      NOTE: beltmept is incremented at the bottom of this loop. */

   outflag[thrd] = false;
   outtmeindx = -1;
   for (i = 0; i < nmoutt; ++i) {
      if (nmtmefcns[idnmbrm1] == 0) {
         if (Math.abs(beltmept[thrd] - outputtime[i]) < 1.e-6) {
            outflag[thrd] = true;
            outtmeindx = i;
            break;
         }

      } else if (beltmept[thrd] < outputtime[i] &&
             outputtime[i] <= beltmept[thrd] + Ecosyscalcs.delta) {
         outflag[thrd] = true;
	 outtmeindx = i;
         break;
      }
   } 

   // Loop over nodes.

   for (i = 1; i <= nmnds; ++i) {

      /*
      if (thrd == 1 && thisidname.equals("cheetaheco") &&
         varinfo_dist[idnmbrm1][i - 1].equals("PIBM")) {
	 if (beltmept[thrd] > 2021.0) {
            iderr_("in conddist");
	 }
      }
      */

      Update.update_(thrd, nodevalsh, i, 1);
      nodeval = nodevalsh[thrd][1][i - 1];

      if (tmeindx == 0) {
         initialvals[i - 1] = nodeval;
      }

      if (outflag[thrd]) {
         simdata[thrd][idenom[thrd]][i - 1][0] = nodeval;
         if (nodenghs[idnmbrm1][i - 1][0] == 1) {
            beliefh[thrd][outtmeindx][i - 1][0] += nodeval;
            beliefh[thrd][outtmeindx][i - 1][1] +=
               nodeval * nodeval;
         }

         if (varinfo_dist[idnmbrm1][i - 1].equals("SDE")) {

            /* In an IntIDs model, store SDE time-stepping function
	       solutions so that they can be read at the next time
	       point. */

            SDEcalcs.sdesols[thrd][rgnval[thrd] - 1][idenom[thrd]][i - 1][0]
               = nodeval;
         }
      }

      if (loadconsdst) {

         /* Note that because "update_" is called twice in a CA,
            Monte Carlo approximations to marginal distributions
            will be slightly different between a CA run
            (cacalc=true, loadconsdst=true) and an "evaluate" run
            (cacalc=false, loadconsdst=false). */

         Update.update_(thrd, nodevalsc, i, 2);
         nodeval = nodevalsc[thrd][1][i - 1];

         // Output consistent solution.

         if (outflag[thrd]) {
            simdata[thrd][idenom[thrd]][i - 1][1] = nodeval;
            if (nodenghs[idnmbrm1][i - 1][0] == 1) {
               beliefc[thrd][outtmeindx][i - 1][0] += nodeval;
               beliefc[thrd][outtmeindx][i - 1][1] +=
                  nodeval * nodeval;
            }

            if (varinfo_dist[idnmbrm1][i - 1].equals("SDE")) {
               SDEcalcs.sdesols[thrd][rgnval[thrd] - 1]
	          [idenom[thrd]][i - 1][1] = nodeval;
            }
         }
      }
   } // End of node loop.

   if (nmtmefcns[idnmbrm1] > 0) {
      Ecosyscalcs.firsttimepoint[thrd] = false;
      if (thrd == 1) {
         //HIBMcalcs.lasttme = beltmept[thrd];
         PIBMcalcs.lasttme = beltmept[thrd];
      }

      /* In a CA, break out of this temporal loop if the "outputtime" time
         point has been achieved.  This check is needed because "capn"
         is an integer and hence can only be approximately adjusted in
         "settime." */

      if (outflag[thrd]) {
         if (nmids > 1 || cacalc) {
            break;
         }
      }
      beltmept[thrd] += Ecosyscalcs.delta;
   }
} // End of time loop.

/* Something is wrong if the ecosystem ID within an IntIDs model
   does not end up on a time point equal to "outputtime[0]." */

if (nmids > 1 && nmtmefcns[idnmbrm1] > 0 && !outflag[thrd]) {
   iderr_("tour: thrd= " + thrd + " beltmept= " +
      (beltmept[thrd] - Ecosyscalcs.delta) + " outputtime0= " +
      outputtime[0] +
      "\n   delta= " + Ecosyscalcs.delta + " outflag= false");
}

if (loadconsdst && ch > 0. && ghtype.equals("kullbacklieblerdiv")) {

   /* Compute components needed for the Kullback-Liebler "g_h()"
      agreement measure.  Use t_end realization only.  Compute the
      KL divergence averaging components.  Do this by using this
      t_end tour as a Gibbs sample from the hypothesis distribution
      and compute the I_1 realization. */

   prob1 = Jntprb.jntprb_(thrd, nodevalsh, 1);
   prob2 = Jntprb.jntprb_(thrd, nodevalsh, 2);
   if (prob2 > 0.) {
      kli1 += Math.log(prob1 / prob2);
   }    
 
   // Likewise, compute the I_2 realization.

   prob1 = Jntprb.jntprb_(thrd, nodevalsc, 1);
   prob2 = Jntprb.jntprb_(thrd, nodevalsc, 2);
   if (prob1 > 0.) {
      kli2 += Math.log(prob2 / prob1);
   }
}

/* Check if this tour produced the denominator event:
   setnode_1, ... , setnode_n AT THE LAST LOCATION AND THE LAST TIME
   POINT.  */

flag = true;
for (i = 1; i <= nmcondnds; ++i) {
   
   /*
   if (thrd == 1 && thisidname.equals("cheetaheco")) {
      printf_("conddist: nodevalsh= " + nodevalsh[thrd][1][condnodes[idnmbrm1][i - 1] - 1] +
         "condvals= " + condvals[i - 1]);
   }
   */

   if (!loadconsdst &&
       Math.abs(nodevalsh[thrd][1][condnodes[idnmbrm1][i - 1] - 1] -
       condvals[i - 1]) > 1.e-6) {
      flag = false;
   }

   if (loadconsdst &&
      Math.abs(nodevalsc[thrd][1][condnodes[idnmbrm1][i - 1] - 1] -
      condvals[i - 1]) > 1.e-6) {
      flag = false;
   }
}

// Conditioning event realization processing.

if (flag) {

   /* Update the denominator and all numerator event counters for
      all discrete nodes except those that are conditioning nodes.
      Then, store this realzation. */

   denom[thrd] += 1. ;
   idenom[thrd] = (int) denom[thrd];

   for (i = 1; i <= nmnds; ++i) {
      flag1 = true;
      for (j = 0; j < nmcondnds; ++j) {
         if (i == condnodes[idnmbrm1][j] ||
            nodenghs[idnmbrm1][i - 1][0] == 1) {
            flag1 = false;
         }
      }
      if (!flag1) {
         continue;
      }
      if (varinfo_dist[idnmbrm1][i - 1].equals("Determ_Decision") ||
          varinfo_dist[idnmbrm1][i - 1].equals("Determ_Root") ||
          varinfo_dist[idnmbrm1][i - 1].equals("Determ_Discrete") ||
          varinfo_dist[idnmbrm1][i - 1].equals("Determ_Temporal") ||
          varinfo_dist[idnmbrm1][i - 1].equals("Discrete") ||
          varinfo_dist[idnmbrm1][i - 1].equals("Logit")) {

         // Discrete conditioning node.

         if (!loadconsdst) {
            valnm = (int) nodevalsh[thrd][1][i - 1];
            if (valnm < 1) {
               iderr_("conddist: node= " + nodelbls[idnmbrm1][i - 1][0]
                  + " valnm= " + valnm);
            }

            beliefh[thrd][nmoutt - 1][i - 1][valnm - 1] += 1.;

         } else {
            valnm = (int) nodevalsc[thrd][1][i - 1];
            if (valnm < 1) {
               iderr_("conddist: node= " + nodelbls[idnmbrm1][i - 1][0]
                  + " valnm= " + valnm);
            }
            beliefc[thrd][nmoutt - 1][i - 1][valnm - 1] += 1.;
         }

      } else {
         iderr_("conddist: idname= " + thisidname +
            "\n   node= " + nodelbls[idnmbrm1][i - 1][0] +
            "\n   CA calculation for non-discrete cond. node" +
            " not finished");
      }
   } // End of loop over nodes.
} // End of conditioning event processing.

// Status indicator message.

if (belpflag && prntcounter[thrd] == printinterval) {
   printf_("    " + thrd + "                " + (loopnm + 1) +
      "                 " + idenom[thrd]);
   prntcounter[thrd] = 0;
}
++prntcounter[thrd];
Update.chkflag = false;
}
}
