class Covmodl extends Surf {
static double krnlwghts[][] = new double[2][NUMCNTR];
static int indx[] = new int[NUMMDLS];
static int var1[] = new int[NUMMDLS];
static int var2[] = new int[NUMMDLS];
static double onemmaxcrss[] = new double[NUMMDLS];

// -----------------------------------------------------------------------

static double covmodl_(int loc1, int loc2, double x1, double y1,
   double t1, double x2, double y2, double t2, int k) {

// Evaluates the covariance function.

int l, i, j;
double svar, tvar, covar = 0., dist, dift, difx, dify, krnlsum;

// First, compute distances: spatial distance and then temporal distance.

if (!spatial) {
   dist = 0.;

} else {
   difx = x1 - x2;
   dify = y1 - y2;
   dist = Math.sqrt(difx * difx + dify * dify);
}

if (!temporal) {
   dift = 0.;

} else {
   if (!spatial) {
      dift = t1 - t2;

   } else {
      dift = Math.abs(t1 - t2);
      dift = (1. - varmod_swght) * dift +
         varmod_swght * Wlstrend.sdiff_(t1, t2);
   }
}

// if (dist == 0. && dift == 0. && loc1 != loc2) dist = varmod_epsln;
if (dist == 0. && dift == 0. && k <= parm_mvar) dist = varmod_epsln;
if (loc1 == loc2) {
   dist = 0.;
   dift = 0.;
}

if (covnonstatmdl == 0) {

   // Compute stationary spatio-temporal covariance.

   covar = sttnrycov_(dist, dift, k);

} else if (covnonstatmdl == 1) {

   /* Spatial nonstationarity modeled by scaling residual process by
      a spatial polynomial.  This model only varies the variance of
      the residual process. */

   covar = sttnrycov_(dist, dift, k);
   covar *= (varmod_nonstat[0] + varmod_nonstat[1] * x1 +
	     varmod_nonstat[2] * y1) *
            (varmod_nonstat[0] + varmod_nonstat[1] * x2 +
	     varmod_nonstat[2] * y2);

} else if (covnonstatmdl == 2) {

   /* Kernel mixture of stationary models.  First, compute kernel weights
      at each point in the pair. */

   if (nmstmixcntr > 1) {
      krnlsum = 0.;
      for (j = 0; j < nmstmixcntr; ++j) {
         krnlwghts[0][j] = Trendeval.mixkernel_(j + 1, x1, y1, t1);
         krnlsum += krnlwghts[0][j];
      }
      for (j = 0; j < nmstmixcntr; ++j) krnlwghts[0][j] /= krnlsum;

      krnlsum = 0.;
      for (j = 0; j < nmstmixcntr; ++j) {
         krnlwghts[1][j] = Trendeval.mixkernel_(j + 1, x2, y2, t2);
         krnlsum += krnlwghts[1][j];
      }
      for (j = 0; j < nmstmixcntr; ++j) krnlwghts[1][j] /= krnlsum;

   } else {
      krnlwghts[0][0] = 1.;
      krnlwghts[1][0] = 1.;
   }

   // Now form kernel-weighted sum of component covariogram values.

   covar = 0.;
   for (i = 0; i < nmstmixcntr; ++i) {

      /* Load this component's covariogram parameters and then compute
	 the associated covariance. */

      for (j = 0; j < nmmdls; ++j) {
         varmod_nugget[0][j] = varmod_nugget[i + 1][j];
         varmod_sill[0][j] = varmod_sill[i + 1][j];
         varmod_range[0][0][j] = varmod_range[i + 1][0][j];
         varmod_range[0][1][j] = varmod_range[i + 1][1][j];
         varmod_oddnug[0][j] = varmod_oddnug[i + 1][j];
         varmod_oddsill[0][j] = varmod_oddsill[i + 1][j];
         varmod_oddrnge[0][j] = varmod_oddrnge[i + 1][j];
      }
      covar += krnlwghts[0][i] * krnlwghts[1][i] * sttnrycov_(dist, dift, k);
   }
}

return covar;
}

// ----------------------------------------------------------------------

static double sttnrycov_(double dist, double dift, int k) {

/* Compute isotropic covariance or cross-covariance.  *** NOTE do not
   place a call to covprt_(1) in this routine or an endless loop will
   occur. */

double svar, tvar, covar = 0.;

if (k <= parm_mvar) {

   // Within the same variable.

   if (spatial && !temporal) {
      covar = varmod_nugget[0][k - 1] + varmod_sill[0][k - 1];
      varmod_ttlvar[k - 1] = covar;
      covar -= gmodel_(dist, Math.abs(dift), k);
 
   } else if (!spatial && temporal) {
      covar = varmod_nugget[0][k - 1] + varmod_sill[0][k - 1];
      if (lngmem) covar += varmod_lma[k - 1];
      varmod_ttlvar[k - 1] = covar;
      covar -= gmodel_(dist, Math.abs(dift), k);

   } else if (spatial && temporal) {

      /* Separable spatio-temporal model: product of two continuous
	 covariograms plus a white noise covariogram. */

      svar = varmod_sill[0][k - 1];
      tvar = svar;
      if (lngmem) tvar += varmod_lma[k - 1];
      covar = svar * tvar + varmod_nugget[0][k - 1];
      varmod_ttlvar[k - 1] = covar;
      covar -= gmodel_(dist, Math.abs(dift), k);
   }

} else {

   // Between variables (cross).

   codd = 0.;

   if (varmod_model[k - 1] == 0) {

      // Nugget-only cross-covariogram.

      if (spatial && !temporal) {
         if (dist == 0.) return varmod_nugget[0][k - 1];
         else return 0.;

      } else if (!spatial && temporal) {
         if (dift == 0.) return varmod_nugget[0][k - 1];
         else return 0.;

      } else if (spatial && temporal) {
         if (dist == 0. && dift == 0.) return varmod_nugget[0][k - 1];
         else return 0.;
      }

   } else if (0 < varmod_model[k - 1] && varmod_model[k - 1] < 3) {

      // Symmetric cross-covariogram.

      if (spatial && !temporal) {
         ceven = varmod_nugget[0][k - 1] + varmod_sill[0][k - 1];
      
      } else if (!spatial && temporal) {
         ceven = varmod_nugget[0][k - 1] + varmod_sill[0][k - 1];
      
      } else if (spatial && temporal) {
         svar = varmod_sill[0][k - 1];
         tvar = svar;
	 ceven = varmod_nugget[0][k - 1] + svar * tvar;
      }

      ceven -= gmodel_(dist, Math.abs(dift), k);

   } else if (varmod_model[k - 1] == 3) {

      /* Asymmetric cross-covariogram (multivariate time series).  The
	 cross-covariogram is the sum of even and odd covariogram models.
	 Use a "Hole Effect" (Wackernagel, p. 219) for the even model: */

      if (varmod_nugget[0][k - 1] < 1.e-10) {
         Vargrm.prntcovmdl_(0);
	 iderr_("sttnrycov: invalid even nugget= " + varmod_nugget[0][k - 1]
            + " k= " + k + " dift= " + dift);
      }
      ceven = -Math.abs(dift) / varmod_nugget[0][k - 1];
      ceven = varmod_sill[0][k - 1] * Math.exp(ceven) *
	      Math.cos(2. * PI * Math.abs(dift) / varmod_range[0][1][k - 1]);

      /* For the odd model, use an asymmetric wave model shifted by
	 temporal lag equal to the value of varmod_range[0][k - 1]
	 when k=3 (cross-covariogram model number).  This shifted,
	 asymmetric model is:
	 C_o(h) = b*exp{-(|h|)/a}*cos((r/4 - h)(2Pi/r))
	 where a >= 1/sqrt{3*(2Pi/|r|)}.
	 Hence, the temporal period is r/(2Pi) and the phase shift is r/4.
	 **Note: this phase shift is NOT the delay effect of the
		 cross-covariogram formed by C_even + C_odd.  That
		 delay effect is an emergent value caused by a nonzero
		 odd term.  r/4 is the phase shift needed to assure the
		 odd term is exactly zero when h = 0.

         a = varmod_oddnug[0][k - 1],
         b = varmod_oddsill[0][k - 1],
         r = varmod_oddrnge[0][k - 1],
         The constraint on ``a'' is enforced in loadpar. */

      // Odd term:

      if (varmod_oddnug[0][k - 1] < 1.e-10) {
         Vargrm.prntcovmdl_(0);
	 iderr_("sttnrycov: invalid odd nugget= " + varmod_oddnug[0][k - 1]
            + " k= " + k + " dift= " + dift);
      }
      codd = -Math.abs(dift) / varmod_oddnug[0][k - 1];
      if (codd < -1.e10) {
	 iderr_("covmodl: k= " + k + " dift= " + dift + " oddnug= " +
            varmod_oddnug[0][k - 1]);
      }
      codd = varmod_oddsill[0][k - 1] * Math.exp(codd) *
	       Math.cos((2. * PI * dift /
               varmod_oddrnge[0][k - 1]) - (PI / 2.));

/*
      if (Math.abs(dift) > 2. * Math.max(varmod_range[0][1][0],
                                    varmod_range[0][1][1])) {
         codd = 0.;
         ceven = 0.;
      }
*/
   }
   covar = codd + ceven;
}

return covar;
}

// ----------------------------------------------------------------------

static double gmodel_(double slag, double tlag, int k) {
 
/* This function evaluates the model variogram or covariance cross-variogram
   at the space lag ``slag'' and time lag ``tlag.''  If this is a space
   model only, the time lag is ignored.  The variogram model for variable k
   is used.  ***NOTE: tlag is ALWAYS nonnegative in gmodel_() ***. */

double b, dum1 = 0., dum2, dr, svar, tvar, argmnt, lag = 0., retval;
int indx;

if (varmod_model[k - 1] == 0) {

   // Nugget-only variogram.

   if ((spatial && !temporal) || (!spatial && temporal)) {

      // Spatial-only or Temporal-only.

      if (spatial) lag = slag;
      else lag = tlag;

   } else {
      iderr_("nugget-only model not implemented for s-t model.");
   }

   if (lag == 0.) return 0.;
   else return varmod_nugget[0][k - 1];

} else if (varmod_model[k - 1] == 1) {

   // Spherical variogram.
 
   if ((spatial && !temporal) || (!spatial && temporal)) {

      // Spatial-only or Temporal-only.

      if (spatial) {
	 lag = slag;
         indx = 0;

      } else {
	 lag = tlag;
	 indx = 1;
      }

      if (lag == 0.) return 0.;

      if (lag <= varmod_range[0][indx][k - 1]) {
         dum1 = lag / varmod_range[0][indx][k - 1];
         dum1 = varmod_sill[0][k - 1] *
	    (1.5 * dum1 - .5 * dum1 * dum1 * dum1);
	 dum1 += varmod_nugget[0][k - 1];

      } else if (lag > varmod_range[0][indx][k - 1]) {
	 dum1 = varmod_nugget[0][k - 1] + varmod_sill[0][k - 1];
      }

      // Long temporal memory: a * (1 + h^2 / b)^-c.

      if (lngmem && temporal && lag > 0.) {
         argmnt = 1. + (lag * lag / varmod_lmb[k - 1]);
         if (argmnt > 0.) dum1 += varmod_lma[k - 1] * (1. - 1. /
			          Math.pow(argmnt, varmod_lmc[k - 1]));
      }

      return dum1;

   } else if (spatial && temporal) {

      // Spatio-temporal: product of two continuous semivariograms.

      svar = varmod_sill[0][k - 1];
      tvar = svar;
      if (lngmem) tvar += varmod_lma[k - 1];

      dum1 = 0.;
      dum2 = 0.;

      // Spatial component

      if (0. < slag && slag < varmod_range[0][0][k - 1]) {
         dum1 = slag / varmod_range[0][0][k - 1];
         dum1 = varmod_sill[0][k - 1]
		* (1.5 * dum1 - .5 * (dum1 * dum1 * dum1));

      } else if (slag >= varmod_range[0][0][k - 1]) {
	 dum1 = varmod_sill[0][k - 1];
      }

      // Short Temporal lag component.

      if (0. < tlag && tlag < varmod_range[0][1][k - 1]) {
         dum2 = tlag / varmod_range[0][1][k - 1];
         dum2 = varmod_sill[0][k - 1]
		* (1.5 * dum2 - .5 * dum2 * dum2 * dum2);

      } else if (tlag >= varmod_range[0][1][k - 1]) {
	 dum2 = varmod_sill[0][k - 1];
      }

      // Long temporal memory component: a * (1 + h^2 / b)^-c.

      if (lngmem && tlag > 0.) {
         argmnt = 1. + (tlag * tlag / varmod_lmb[k - 1]);
         if (argmnt > 0.) dum2 += varmod_lma[k - 1] * (1. - 1. /
				Math.pow(argmnt, varmod_lmc[k - 1]));
      }

      /* Separable spatio-temporal model:
	 gam(slag,tlag) = svar * gamt(tlag) + tvar * gams(slag)
                              - gams(slag) * gamt(tlag). */

      retval = svar * dum2 + tvar * dum1 - dum1 * dum2;

      // If not 0,0 lag, add-on nugget.

      if (slag > 0. || Math.abs(tlag) > 0.) {
	 retval += varmod_nugget[0][k - 1];
      }

      return retval;
   }

} else if (varmod_model[k - 1] == 2) {

   // Exponential variogram.

   if (spatial && !temporal) {
      if (slag == 0.) return 0.;
      dum1 = Math.exp(-slag / varmod_range[0][0][k - 1]);
      return varmod_nugget[0][k - 1] + varmod_sill[0][k - 1] * (1. - dum1);

   } else if (!spatial && temporal) {
      if (tlag == 0.) return 0.;
      if (varmod_range[0][1][k - 1] < 1.e-5) iderr_("k= " + k +
         " tlag= " + tlag + " rnge= " + varmod_range[0][1][k - 1]);
      dum1 = varmod_nugget[0][k - 1] + varmod_sill[0][k - 1] *
             (1. - Math.exp(-tlag / varmod_range[0][1][k - 1]));

      // Long temporal memory component: a * (1 + h^2 / b)^-c.

      if (lngmem && tlag > 0.) {
         argmnt = 1. + (tlag * tlag / varmod_lmb[k - 1]);
         if (argmnt > 0.) dum1 += varmod_lma[k - 1] * (1. - 1. /
				Math.pow(argmnt, varmod_lmc[k - 1]));
      }

      return dum1;
   }

} else if (varmod_model[k - 1] == 5) {

   /* Wave model.  So far, only implemented for spatial=false, kmaxt>0.
      This model is:
      gamma(h) = nug+sll*( 1-((rnge/(2*Pi*h)) * sin(2*Pi*h/rnge)) )
      where it is assumed that lim_(h->0) (sin(2*Pi*h)/h) = 1. */

   if (tlag == 0.) return 0.;
   dum1 = varmod_range[0][0][k - 1] / (2. * PI * tlag);
   dum2 = 1. - dum1 * Math.sin(1. / dum1);
   return varmod_nugget[0][k - 1] + varmod_sill[0][k - 1] * dum2;
}

return 0.;
}

// ------------------------------------------------------------------------

static void covprt_(int target) {

/* Prints sample or estimated model variogram, cross-covariogram values.
   target = 0: print only sample covariograms,
   target = 1: print only model covariograms. */

int i, ii, iii, j, k, tlags = 0, v1 = 0, v2 = 0, vnmbr, cvstrct, nmslags,
   nmclags = 0;
double val, nmclass = 0., avecp = 0., maxgamma, sgam, mgam, maxscrss,
   maxmcrss, scrss, mcrss;

if (target == 0) {
   fprintf_(1, "\n------ covprt: Sample Semivariograms and" +
      " Cross-Covariograms -------");

} else {

   // Write all covariogram parameters.

   fprintf_(1, "\n------ covprt: Model Semivariograms and" +
      " Cross-Covariograms -----");
   if (nmstmixcntr == 0) {
      Vargrm.prntcovmdl_(0);
   
   } else {
      for (i = 1; i <= nmstmixcntr; ++i) Vargrm.prntcovmdl_(i);
   }
}

// Print over each variable and variable combination.

for (ii = 0; ii < nmmdls; ++ii) {
   if (ii < parm_mvar) {
      fprintf_(1, "\n               Variable= " +
         nodelbls[idnmbrm1][lomapnms[ii] - 1][0]);
      if (target == 0) fprintf_(1, 
         "Lag_#   SLag    Tlag     Gamma    #_Couples   Average_distance");

      else fprintf_(1, "Lag_#   SLag    Tlag     Gamma");

      tlags = kmaxt;
      iii = 0; 

   } else {
      outer: for (k = 0; k < parm_mvar; ++k) {
         for (j = 0; j < k; ++j) {
            v1 = lomapnms[k];
            v2 = lomapnms[j];
            if (ii + 1 == crossmap[v1 - 1][v2 - 1]) break outer;
         }
      }

      fprintf_(1, "\nCross-covariogram for variables " +
         nodelbls[idnmbrm1][v1 - 1][0] + ", " +
         nodelbls[idnmbrm1][v2 - 1][0]);

      if (target == 0) fprintf_(1, 
"Lag_#        SLag        Tlag     Cross-Cov    #_Couples     Even      Odd");

      else fprintf_(1,
"Lag_#        Slag        Tlag     Cross-Cov         Even         Odd");

      tlags = 2 * kmaxt;
      iii = 1;
   }
   for (k = 0; k <= tlags; ++k) {
      for (j = 0; j <= kmax; ++j) {

         if (target == 0) {

            // Print only sample values.

            if (gama_nc[j][0][k][ii] > 0) {
	       if (iii == 0) {
                  fprintf_(1, "  " + j + "    " + fdble_(lags[j], 7, 3) +
                     "    " + fdble_(lagt[iii][k], 7, 3) +
		     "    " + fdble_(gama_g[j][0][k][ii], 9, 5) +
                     "    " + gama_nc[j][0][k][ii] +
                     "    " + fdble_(gama_d[j][0][k][ii], 9, 5));
	       
	       } else if (iii == 1) {
                  fprintf_(1, "  " + j + "   " + fdble_(lags[j], 7, 3) +
                     "    " + fdble_(lagt[iii][k], 7, 3) +
                     "    " + fdble_(gama_g[j][0][k][ii], 9, 5) +
                     "    " + gama_nc[j][0][k][ii] +
                     "    " + fdble_(gama_geven[j][0][k][ii], 9, 5) +
                     "    " + fdble_(gama_godd[j][0][k][ii], 9, 5));
	       }
               avecp += (double) gama_nc[j][0][k][ii];
               nmclass += 1.;

            } else {
               fprintf_(1, "  " + j + "   " + lags[j] + "    " +
		  lagt[iii][k] + "   ***  nc = 0 ***");
	    }

	 } else {

            // Print only model values.

	    if (ii < parm_mvar) {
	       val = gmodel_(lags[j], lagt[0][k], ii + 1);
         
	    } else {
               val = sttnrycov_(lags[j], lagt[1][k], ii + 1);
            }

            if (iii == 0) {
	       fprintf_(1, j + "    " + lags[j] + "    " + lagt[iii][k] +
                  "    " + fdble_(val, 9, 5));

            } else {
	       fprintf_(1, j + "    " + lags[j] + "    " + lagt[iii][k] +
                  "    " + fdble_(val, 9, 5) + " " + fdble_(ceven, 9, 5) +
                  "  " + fdble_(codd, 9, 5));
            }
	 }
      }
   }
}
if (target == 0) {
   fprintf_(1, "Average number of nonzero couples= " + (avecp / nmclass));
}

if (target == 1 && (!spatial && temporal) || (spatial && !temporal)) {

   /* For a strictly spatial or strictly temporal analysis, write a file of
      each variable's sample and estimated model variograms.  First, open
      the covariogram plotting file.  */

   fleopen_(2, "cov.plt", 'w');

   if (!spatial) nmslags = 1;
   else nmslags = kmax;

   if (!temporal) {
      tlags = 1;
      nmclags = kmax;
   
   } else {
      tlags = kmaxt;
      nmclags = 2 * kmaxt;
   }

   maxgamma = 0.;
   for (j = 0; j < parm_mvar; ++j) {
      vnmbr = lomapnms[j];
      for (k = 0; k < nmslags; ++k) {
         for (i = 0; i < tlags; ++i) {
            sgam = gama_g[k][0][i][j];

            // For regularly spaced time series, set lag 0 variogram to 0.

            if (i == 0 && !spatial && temporal) sgam = 0.;

            mgam = gmodel_(lags[k], lagt[0][i], j + 1);
            fprintf_(2, "  " + vnmbr + "  " + lags[k] + " " + lagt[0][i] +
               "  " + sgam + "   " + mgam);
            if (maxgamma < sgam) maxgamma = sgam;
            if (maxgamma < mgam) maxgamma = mgam;
         }
      }
   }
   fclose_(2, 'w');
   fprintf_(1, "maxgamma= " + maxgamma);
   if (parm_mvar == 1) return;

   /* Write all sample and model cross-covariograms.  First, open
      cross-covariogram plotting file.  For the asymmetric
      cross-covariogram model, print the even and odd cross-covariograms. */

   fleopen_(2, "crsscov.plt", 'w');
   maxscrss = 0.;
   maxmcrss = 0.;
   for (j = 0; j < parm_mvar; ++j) {
      for (k = 0; k < j; ++k) {
         v1 = lomapnms[j];
         v2 = lomapnms[k];
         cvstrct = crossmap[j][k];

         for (i = 0; i <= nmclags; ++i) {
            if (temporal) {
               scrss = gama_g[0][0][i][cvstrct - 1];
               mcrss = sttnrycov_(0., lagt[1][i], cvstrct);
               fprintf_(2, v1 + " " + v2 + " " + lagt[1][i] + " " +
                  scrss + " " +
                  gama_geven[0][0][i][cvstrct - 1] + " " +
                  gama_godd[0][0][i][cvstrct - 1] + " " +
                  mcrss + " " + ceven + " " + codd);

	    } else {
               scrss = gama_g[i][0][0][cvstrct - 1];
               mcrss = sttnrycov_(lags[i], 0., cvstrct);
               fprintf_(2, v1 + " " + v2 + " " + lags[i] + " " +
                  scrss + " " + mcrss);
            }
            if (maxscrss < Math.abs(scrss)) maxscrss = Math.abs(scrss);
            if (maxmcrss < Math.abs(mcrss)) maxmcrss = Math.abs(mcrss);
         }
      }
   }
   fclose_(2, 'w');
   fprintf_(1, "maxscrss= " + maxscrss + " maxmcrss= " + maxmcrss);
}
}

// -----------------------------------------------------------------------

static void cgramplt_(int n) {

String vars;
boolean test = false, start = true;
int i, j, k, l, tlags = 0, v1 = 0, v2 = 0, vnmbr, cvstrct, nmslags, mode;
double maxgamma, sgam, scrss, scrsscorr, s1, s2;

/* Computes and plots the sample covariograms and cross-covariograms.
   First, do spatial or temporal setup. */

Surf.krgset_(0);

// Now, specify a global model and reload vardat structure.

Estimate.local = false;
for (i = 0; i < parm_mvar; ++i) ndmin[i] = nmsites[i];
spacetime_predoption = 2;
Mvsrch.mvsrch_(0, 0., 0., dattmax / 2.);

// Gama3 setup.

nd = n;
mode = 1;
ndi = 1;
da = 90.0;
pas = 1.0;
tol = 0.5;
tolt = .001;
alp[0] = 0.0;
alp[1] = 90.0;

spacetime_tmin = dattmin;
spacetime_tmax = dattmax;
if (kmaxt == 0) past = 1.;
else past = (spacetime_tmax - spacetime_tmin) / ((double) kmaxt);

/* Compute spatial and temporal lags.  First spatial lag is 1/4 of the
   basic lag.  First temporal lag is zero. */

lags[0] = .25 * pas;
for (i = 1; i <= kmax; ++i) lags[i] = pas * (double) (i);
for (i = 0; i <= kmaxt; ++i) lagt[0][i] = past * (double) i; 
for (i = 0; i <= 2 * kmaxt; ++i) {
   lagt[1][i] = (past * (double) i) - lagt[0][kmaxt];
}

// Call gama3 and stop if zero variance is detected.

if (Gama3.gama3_(ndi, alp, da, mode, tolt, test, true) == 1) {
   varmod_ifail = 5;
   iderr_("cgramplt: zero variance from gama3");
}

if (!spatial) nmslags = 1;
else nmslags = kmax;

if (!temporal) tlags = 1;
else tlags = kmaxt;

// Plot sample covariograms.  First, open covariogram plotting file.

fleopen_(2, "cov.plt", 'w');
maxgamma = 0.;
for (j = 0; j < parm_mvar; ++j) {
   vnmbr = lomapnms[j];
   for (k = 0; k < nmslags; ++k) {
      for (i = 0; i < tlags; ++i) {
         sgam = gama_g[k][0][i][j];

         // For regularly space time series, set lag 0 variogram to 0.

         if (i == 0 && !spatial && temporal) sgam = 0.;

         fprintf_(2, "  " + vnmbr + "  " + lags[k] + " " + lagt[0][i] +
               "  " + sgam);
         if (maxgamma < sgam) maxgamma = sgam;
      }
   }
}
fclose_(2, 'w');
fprintf_(1, "cgramplt: maxgamma= " + maxgamma);
if (parm_mvar == 1) return;

// Find and store the largest cross-correlation for each pair of variables.

l = 0;
for (j = 1; j < parm_mvar; ++j) {
   for (k = 0; k < j; ++k) {
      s1 = Math.sqrt(varmod_smplvr[j]);
      s2 = Math.sqrt(varmod_smplvr[k]);
      cvstrct = crossmap[v1 - 1][v2 - 1];

      indx[l] = l;
      var1[l] = j;
      var2[l] = k;
      onemmaxcrss[l] = 0.;
      for (i = 5; i <= 2 * kmaxt - 5; ++i) { // Assumes kmaxt = 7
         scrss = gama_g[0][0][i][cvstrct - 1];
	 if (scrss == -1.e30) {
	    scrsscorr = -1.e30;

	 } else {
            scrsscorr = scrss / (s1 * s2);
	    if (Math.abs(scrsscorr) > onemmaxcrss[l]) {
	       onemmaxcrss[l] = Math.abs(scrsscorr);
	    }
	 }
      }
      onemmaxcrss[l] = 1. - onemmaxcrss[l];
      ++l;
   }
}

// Sort the maximum correlations.

Idsort.idsort_(onemmaxcrss, indx, 1, l);

// Write cross-covariograms that have the largest correlations.

fleopen_(2, "crsscov.plt", 'w');
for (j = 0; j < 32; ++j) {
   v1 = var1[indx[j]];
   v2 = var2[indx[j]];
   s1 = Math.sqrt(varmod_smplvr[v1]);
   s2 = Math.sqrt(varmod_smplvr[v2]);
   vars = fdble_(onemmaxcrss[j], 8, 5) + " " +
      nodelbls[idnmbrm1][lomapnms[v1] - 1][0] + "-" +
      nodelbls[idnmbrm1][lomapnms[v2] - 1][0];
   cvstrct = crossmap[v1 - 1][v2 - 1];
   for (i = 2; i <= 2 * kmaxt - 2; ++i) {
      scrss = gama_g[0][0][i][cvstrct - 1];
      scrsscorr = scrss / (s1 * s2);

      fprintf_(2, vars + " " + lagt[1][i] + " " + scrss + " " + scrsscorr);
   }
}
fclose_(2, 'w');
iderr_("in cgramplt");
}
}
