import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import norsys.netica.*;
import norsys.neticaEx.aliases.Node;

public class Decnet extends Frame {

// Class for the main frame window.

/* These static integers are needed in the Dimension statements in
   the window's constructor. */

boolean graphdrawn = false;
static final int TEXTROWS = 25, TEXTROWHGHT = 23;
static int mainwinhght = TEXTROWS * TEXTROWHGHT, mainwinwdth = 480;

final int NMTEXTROWS = TEXTROWS;

String textarray[] = new String[NMTEXTROWS];

String msg = " ", keymsg = "", mousemsg = "";

int mouseX = 30, mouseY = 30, textlinenm = 1;

CheckboxMenuItem debug, test;

// ---------------------------------------------------------------------

public Decnet() {
int i;
addKeyListener(new MyKeyAdapter(this));
addMouseListener(new MyMouseAdapter(this));
addWindowListener(new MyWindowAdapter());

// Create menu bar and add it to frame.

MenuBar mbar = new MenuBar();
setMenuBar(mbar);

// Create the menu items.

Menu file = new Menu("File");
MenuItem item1, item2, item3, item4, item5;
file.add(item1 = new MenuItem("New..."));
file.add(item2 = new MenuItem("Open a Netica network file"));
file.add(item3 = new MenuItem("Display network"));
file.add(item4 = new MenuItem("-"));
file.add(item5 = new MenuItem("Quit..."));
mbar.add(file);

// FVS data menu selections.

Menu data = new Menu("Data");
MenuItem item6, item7, item8;
data.add(item6 = new MenuItem("Create cases by reading FVS output"));
data.add(item7 = new MenuItem("Create cases by first creating FVS output"));
data.add(item8 = new MenuItem("Train the network from cases"));
mbar.add(data);

// Option assessment menu selections.

Menu assess = new Menu("Assess");
MenuItem item9;
assess.add(item9 = new MenuItem("Compute impacts of options"));

Menu sub = new Menu("Display impacts");
MenuItem item10, item11;
sub.add(item10 = new MenuItem("Single node"));
sub.add(item11 = new MenuItem("Multiple nodes"));

assess.add(sub);
mbar.add(assess);

// Help and About box.

Menu helpabout = new Menu("Help");
MenuItem item12, item13;
helpabout.add(item12 = new MenuItem("Help"));
helpabout.add(item13 = new MenuItem("About"));
mbar.add(helpabout);

// Create an object to handle action and item events.

MyMenuHandler handler = new MyMenuHandler(this);

// Register it to receive those events.

item1.addActionListener(handler);
item2.addActionListener(handler);
item3.addActionListener(handler);
item4.addActionListener(handler);
item5.addActionListener(handler);
item6.addActionListener(handler);
item7.addActionListener(handler);
item8.addActionListener(handler);
item9.addActionListener(handler);
item10.addActionListener(handler);
item11.addActionListener(handler);
item12.addActionListener(handler);
item13.addActionListener(handler);

// Create an object to handle window events.

MyWindowAdapter adapter = new MyWindowAdapter();

// Register it to receive those events.

addWindowListener(adapter);

// Set font, background and foreground colors.

Font f = new Font("SansSerif", Font.PLAIN, 14);
setFont(f);
setBackground(Color.white);
setForeground(Color.black);

// Initialize text array.

for (i = 0; i < NMTEXTROWS; ++i) {
   textarray[i] = " ";
}
}

// ----------------------------------------------------------------------

public void textline_(String line) {

// Load text array with the string "line."

int i;

if (textlinenm < NMTEXTROWS - 2) {
   ++textlinenm;
   textarray[textlinenm - 1] = line;

} else {

   // Ratchet lines in the text array.

   for (i = 0; i < NMTEXTROWS - 3; ++i) {
      textarray[i] = textarray[i + 1];
   }
   textarray[NMTEXTROWS - 3] = line;
}
}

// ----------------------------------------------------------------------

public void paint(Graphics g) {
int i, yinc = 20, ypos = 50;

// Write command message line.

g.drawString("Command message:", 5, mainwinhght - 2 * TEXTROWHGHT);
g.drawString(msg, 5, mainwinhght - TEXTROWHGHT);

// Write multi-line text output.

for (i = 0; i < NMTEXTROWS - 2; ++i){
   g.drawString(textarray[i], 6, ypos);
   ypos += yinc;
}
}

// -----------------------------------------------------------------------

public static void main(String args[]) {

// Create the window.

Decnet appwin = new Decnet();

appwin.setSize(new Dimension(mainwinwdth, mainwinhght));
appwin.setTitle("CRAFT's Decision Network Training and Options Assessment");

// Make main window visible.

appwin.setVisible(true);
}
}

// ***********************************************************************

class MyKeyAdapter extends KeyAdapter {
Decnet appWindow;
public MyKeyAdapter(Decnet appWindow) {
this.appWindow = appWindow;
}

public void keyTyped(KeyEvent ke) {
appWindow.keymsg += ke.getKeyChar();
appWindow.repaint();
};
}

// ***********************************************************************

class MyWindowAdapter extends WindowAdapter {
public void windowClosing(WindowEvent we) {
System.exit(0);
}
}

// **********************************************************************

class MyMouseAdapter extends MouseAdapter {
Decnet appWindow;
public MyMouseAdapter(Decnet appWindow) {
this.appWindow = appWindow;
}

public void mousePressed(MouseEvent me) {
appWindow.mouseX = me.getX();
appWindow.mouseY = me.getY();
appWindow.mousemsg = "Mouse Down at " + appWindow.mouseX +
   ", " + appWindow.mouseY;
appWindow.repaint();
}
}

// *********************************************************************

class MyMenuHandler extends Netcalcs implements ActionListener,
   ItemListener {
Decnet decnet;
Environ env;
Net net = null;
FVScalcs fvscalcs;
NodeList nodes, nodei;
Plotwindow plotwindow;
Pltgrphps pltgrphps;
Plotps plotps;

int condnode = 0;

// ---------------------------------------------------------------------

public MyMenuHandler(Decnet decnet) {
super(decnet, "menu handler");
this.decnet = decnet;

// Create a Netcalcs object.

Netcalcs netcalcs = new Netcalcs (decnet, "netcalcs");
}

// --------------------------------------------------------------------

public void actionPerformed (ActionEvent ae) {

// Handle action events.

boolean createfvs = false;

String arg = (String) ae.getActionCommand();
String givennetfile = "owlhab.dne", fvsfile = "fvsrun.out",
       keyfile = "fvsrun.key", strataagg = "average", prntname = " ",
       fvsdir = "F:\\polbio\\ncssf\\", printstrng = "none",
       optionstrng = "none", diststrng = "none";

int i, j, k, l, m, yinc = 20, ypos = 50, nodekind, plotnode = 0;

FileDialog fdnet, fdnettrain, fdfvs, fdcase;

Helpwindow helpwindow;

if (arg.equals("New...")) {

   decnet.msg = "You selected New.";

} else if (arg.equals("Open a Netica network file")) {

   // Open an existing Netica network file for reading.

   if (net == null) {
      decnet.msg = "Opening a Netica network file.";
      do {
         fdnet = new FileDialog(decnet, "Open a Netica Network File",
	    FileDialog.LOAD);
         fdnet.setVisible(true);
         givennetfile = fdnet.getDirectory() + fdnet.getFile();
      } while (givennetfile == null);

      /* Use the Netica API call to read this network into memory.
	 Either use the keyword   null   for the argument to Environ()
	 or your Netica license password. */

      try {
      env = new Environ("+HaasT/UWisconsin/120,310-3-A/51772");
      net = new Net(new Streamer(givennetfile));
      net.compile();
      } catch (Exception e) {
         e.printStackTrace();
      }
      decnet.msg = "Opened Netica network file " + givennetfile;

   } else {
      decnet.msg = "A Netica network file is already open.";
   }

   /* Now, create an FVScalcs object and a Netica NodeList object.
      Use these objects to load its network information arrays. */

   fvscalcs = new FVScalcs(decnet);
   try {
   nodes = net.getNodes();
   fvscalcs.nmnetnodes = nodes.size();
   if (fvscalcs.nmnetnodes <= 0) {
      iderr_("decnet: nmnetnodes= " + fvscalcs.nmnetnodes);

   } else {
      decnet.textline_("Number of network nodes= " + fvscalcs.nmnetnodes);
   }

   // Create a Pltgrphps object and load each node's name and kind.

   pltgrphps = new Pltgrphps(decnet);

   pltgrphps.nmnds = fvscalcs.nmnetnodes;
   for (i = 0; i < fvscalcs.nmnetnodes; ++i) {
      fvscalcs.nodename[i] = (nodes.getNode(i)).getName();
      decnet.textline_("Node " + i + "= " + fvscalcs.nodename[i]);
      pltgrphps.nodelbls[i][0] = fvscalcs.nodename[i];

      nodekind = (nodes.getNode(i)).getKind();
      if (nodekind == (nodes.getNode(i)).NATURE_NODE) {
         pltgrphps.varinfo_dist[i] = "Discrete";

      } else if (nodekind == (nodes.getNode(i)).DECISION_NODE) {
   
	 // Find decision option node.

         pltgrphps.varinfo_dist[i] = "Determ_Decision";
	 condnode = i + 1;

      } else if (nodekind == (nodes.getNode(i)).UTILITY_NODE) {
         pltgrphps.varinfo_dist[i] = "Utility";

      } else {
	 printf_("pltgrphps: node= " + i + " nodekind= " + nodekind);
         pltgrphps.varinfo_dist[i] = "Discrete";

      }
      fvscalcs.varinfo_dist[i] = pltgrphps.varinfo_dist[i];
   }

   // Get number of values and the parents of each node.

   for (i = 0; i < fvscalcs.nmnetnodes; ++i) {
      pltgrphps.nodenghs[i][0] = (nodes.getNode(i)).getNumStates();

      // Get node state names.

      for (j = 0; j < pltgrphps.nodenghs[i][0]; ++j) {
	 pltgrphps.nodelbls[i][j + 1] = (nodes.getNode(i)).state(j).getName();
      }

      nodei = (nodes.getNode(i)).getParents();
      pltgrphps.nodenghs[i][1] = nodei.size();
      for (j = 0; j < pltgrphps.nodenghs[i][1]; ++j) {

	 // Search for the parent's name.

	 prntname = (nodei.getNode(j)).getName();
	 for (k = 0; k < fvscalcs.nmnetnodes; ++k) {
	    if (prntname.equals(pltgrphps.nodelbls[k][0])) {
	       pltgrphps.nodenghs[i][j + 2] = k + 1;
	       break;
	    }
	 }
      }
   }
   } catch (Exception e) {
      e.printStackTrace();
      iderr_("decnet: getName failed");
   }

} else if (arg.equals("Display network")) {

   if (!decnet.graphdrawn) {

      // First, write the PostScript file of the graph.

      pltgrphps.pltgrph_();
      decnet.graphdrawn = true;
   } 

   // Now, draw the graph.

   plotwindow = new Plotwindow(decnet, Pltgrphps.filename,
      "Network Display");
   plotwindow.setVisible(true);

} else if (arg.equals("Quit...")) {
   decnet.msg = "You selected Quit.";
   System.exit(0);

} else if (arg.equals("Create cases by reading FVS output") ||
           arg.equals("Create cases by first creating FVS output")) {

   /* Read FVS output files -- one for each stand subjected to all
      proposed management plans.  Do this by either running FVS on the
      appropriate tree data files or by reading pre-existing FVS output
      files.  Then, collect the Structural statistics Table information
      from each run's output file to create the Netica case file.
      First, get the FVS keyword file name. */

   do {
      fdfvs = new FileDialog(decnet, "Open an Existing FVS Keyword File",
         FileDialog.LOAD);
      fdfvs.setVisible(true);
      keyfile = fdfvs.getDirectory() + fdfvs.getFile();
   } while (keyfile == null);
   decnet.msg = "Opened the existing FVS keyword file: " + keyfile;
   decnet.repaint();

   /* Fix the directory within which FVS will run and assign the
      dummy file name that FVS will write its output to. */

   fvsdir = fdfvs.getDirectory();
   fvsfile = fdfvs.getDirectory() + fvsfile;

   if (arg.equals("Create cases by first creating FVS output")) {

      /* Set switch to indicate FVS needs to be run to create the output
	 files. */

      createfvs = true;
   }

   /* Either read pre-existing FVS output files or run FVS over each
      stand to collect the results, and write the Netica case file. */

   decnet.msg = fvscalcs.runfvs_(fvsdir, keyfile, fvsfile, createfvs);
   decnet.repaint();

} else if (arg.equals("Train the network from cases")) {

   // Train the network on the case file(s).

   do {
      fdcase = new FileDialog(decnet,
	 "Open an Existing Netica Case File", FileDialog.LOAD);
      fdcase.setVisible(true);
      fvscalcs.casefile[0] = fdcase.getDirectory() + fdcase.getFile();
   } while (fvscalcs.casefile[0] == null);

   for (i = 0; i < fvscalcs.nmrepgrps; ++i) {
   
      // Echo case file name.

      decnet.msg = "Opened an existing case file " + fvscalcs.casefile[i];
      decnet.repaint();

      /* Always start with the given network file so as to avoid
	 "experience" problems. */

      try {
      net = new Net(new Streamer(givennetfile));
      if (net == null) {
	 iderr_("actionPerformed: net=null");
      }
      net.compile();
      } catch (Exception e) {
         e.printStackTrace();
      }

      try {

      // Read new cases and then train the network.

      Streamer caseFile = new Streamer(fvscalcs.casefile[i]);
      net.reviseCPTsByCaseFile(caseFile, nodes, 1.0);

      // Get a file name to save the trained network to.

      do {
         fdnettrain = new FileDialog(decnet, "Save Trained Network",
            FileDialog.SAVE);
         fdnettrain.setVisible(true);
         fvscalcs.netfile[i] = fdnettrain.getDirectory() +
            fdnettrain.getFile();
      } while (fvscalcs.netfile[i] == null);

      net.write(new Streamer(fvscalcs.netfile[i]));
      } catch (Exception e) {
         e.printStackTrace();
      }
      decnet.msg = "Network trained on case file: " +
         fvscalcs.casefile[i];
   }

} else if (arg.equals("Compute impacts of options")) {

   /* For each replication group, use Netica to find the network's
      solution under each value of the conditioning node. */

   fleopen_(3, fvsdir + "solution.dat", 'w');
   printstrng = "Rep_Group StandID Latitude Longitude Man_Option" +
      "Number_of_values" + " Node Distribution";
   fprintf_(3, printstrng);
   decnet.textline_(printstrng);

   // Loop over replication groups.

   for (l = 0; l < fvscalcs.nmrepgrps; ++l) {

      // Load the trained network for replication group (l + 1).

      try {
      net = new Net(new Streamer(fvscalcs.netfile[l]));
      if (net == null) {
	 iderr_("actionPerformed: net=null");
      }
      net.compile();

      // Loop over management options.

      for (i = 0; i < pltgrphps.nodenghs[condnode - 1][0]; ++i) {
         optionstrng = pltgrphps.nodelbls[condnode - 1][i + 1];
         (nodes.getNode(condnode - 1)).enterFinding(optionstrng);

	 // Loop over the network's nodes.

         for (j = 0; j < pltgrphps.nmnds; ++j) {
	    if (condnode - 1 != j) {
	 
	       // Loop over the values of the (j + 1)^th node.

	       diststrng = " ";
               for (k = 0; k < pltgrphps.nodenghs[j][0]; ++k) {
                  pltgrphps.solution[l][j][k][i] =
	             (nodes.getNode(j)).getBelief(
			pltgrphps.nodelbls[j][k + 1]);

                  /* Collect these probabilities into a single
		     string to form a space-separated list of the
		     probabilities on the values of the node. */

		  diststrng += " " +
		     fdble_(pltgrphps.solution[l][j][k][i], 5, 2);
               }

	       // Loop over stands.

	       for (m = 0; m < fvscalcs.nmstands; ++m) {

		  if (fvscalcs.stdrepgrp[m] == l + 1) {

	             /* For each stand in this replication group, create
		        a complete record and write it to the graphics
		        file. */

	             printstrng = " " + (m + 1) + fvscalcs.standid[m] +
			" " + fvscalcs.stdlat[m] +
			" " + fvscalcs.stdlong[m] +
			" " + optionstrng +
			" " + pltgrphps.nodelbls[j][0] +
			" " + pltgrphps.nodenghs[j][0] +
			" " + diststrng;
                     fprintf_(3, printstrng);
               
		     if (j < 2 || j > pltgrphps.nmnds - 3) {
	                decnet.textline_(printstrng);
	             }
		  }
	       }
	    }
         }
         (nodes.getNode(condnode - 1)).retractFindings();
      }
      } catch (Exception e) {
         e.printStackTrace();
      }
   }

   fclose_(3, 'w');
   decnet.msg = "Impacts plotting file: " + fvsdir + "solution.dat";

} else if (arg.equals("Single node")) {

   /* Get the node to be plotted.  Assume the conditioning node is
      decision option node and that the network's solution has already
      been found for each value of the decision option node. */

   Listwindow listwindow = new Listwindow(decnet,
      "Single Node Selection", fvscalcs.nmnetnodes, "none",
      fvscalcs.nodename);
   listwindow.setVisible(true);
   plotnode = listwindow.idx[0] + 1;

   // Create the Plot object.

   plotps = new Plotps(decnet);

   for (i = 0; i < fvscalcs.nmrepgrps; ++i) {

      /* For the (i + 1)th replication group, create the plot, and
	 then draw it. */
   
      plotps.pltdist_(i + 1, plotnode, condnode);
      plotwindow = new Plotwindow(decnet, Plotps.pspltfle,
         "Single Node Display");
      plotwindow.setVisible(true);
      decnet.msg = "Replication group= " + (i + 1);
   }
   decnet.msg = "Single node display completed";

} else if (arg.equals("Multiple nodes")) {
   decnet.msg = "multiple node display not implemented";

} else if (arg.equals("Help")) {
   helpwindow = new Helpwindow(this, "General decnet Help Message");
   helpwindow.setVisible(true);

} else if (arg.equals("About")) {
   helpwindow = new Helpwindow(this, "About decnet");
   helpwindow.setVisible(true);
}
decnet.repaint();

}

// ------------------------------------------------------------------

public void itemStateChanged(ItemEvent ie) {

// Item event handler.

decnet.repaint();
}
}
