class Densest extends Id {
static int ipvt[] = new int[WLSSZE];
static int index[] = new int[DATSZE];
static double dist[] = new double[DATSZE];
static double nghbrs[][] = new double[DATSZE][WLSSZE];
static double s[][] = new double[WLSSZE][WLSSZE];
static double z[] = new double[WLSSZE];
static double mean[] = new double[WLSSZE];
static double xcentr[] = new double[WLSSZE];
static double mcov[][] = new double[WLSSZE][WLSSZE];
static double val[] = new double[SIMSZE];

// ------------------------------------------------------------------------

static void densest1_(int n, int nmvar, double data[][], int nmpts,
   double xobs[][], double pdfests[]) {

/* Estimates the joint density function for each row in "xobs" using a
   local, gaussian kernel.  See Thompson and Tapia (1990, p. 180). */

boolean euclid = false;

int i, j, k, l, i1, m = 0;

double rm, sum, testval, diff, retval;

if (nmvar > WLSSZE) {
   iderr_("densest1: big nmvar= " + nmvar);
}

if (n > DATSZE) {
   iderr_("densest1: n= " + n + " > DATSZE");
}

/* Compute m, the number of nearest neighbors.  Thompson and Tapia
   recommend m = .02n when n is large. */

// m = n;
if (n > 20) {
   m = (int) (.02 * (double) n);
}

if (m < nmvar) {
   m = nmvar + 1;
}
rm = (double) m;

// Zero-out pdf array.

for (i = 0; i < nmpts; ++i) {
   pdfests[i] = 0.;
}

/* Input data check.
Matrix.mprint_(data, n, nmvar);
iderr_("in densest"); 
*/

// Compute and then decompose the sample covariance matrix.

if (nmvar > 1 && !euclid) {
   Dkernl.cdcmp_(n, nmvar, nmvar, data, ipvt, false);
}

// Compute the density estimate.

for (l = 0; l < nmpts; ++l) val[l] = 0.;
for (i = 0; i < n; ++i) {

   /* Find the closest m observations to x_i (this includes x_i).  Do this
      by first computing the statistical distance between x_i and x_j,
      and then sorting the n observations by this distance.  Finally,
      pick off the first m of these. */

   for (j = 0; j < nmvar; ++j) {
      nghbrs[0][j] = data[i][j];
   }

   k = 1;
   for (j = 0; j < n; ++j) {
      if (j != i) {
         if (nmvar == 1) {
            dist[k - 1] = Math.abs(data[i][0] - data[j][0]);
         
         } else if (nmvar > 1 && !euclid) {
            dist[k - 1] = Dkernl.dist_(nmvar, nmvar, data[i], data[j],
			     true, Dkernl.msdinv, Dkernl.mcorr, ipvt);

         } else if (euclid) {
            dist[k - 1] = 0.;
            for (i1 = 0; i1 < nmvar; ++i1) {
               diff = data[i][i1] - data[j][i1];
               dist[k - 1] += diff * diff;
            }
            dist[k - 1] = Math.sqrt(dist[k - 1]);
         }

         index[k - 1] = j;
         ++k;
      }
   }

   // Sort these distances.

   Idsort.idsort_(dist, index, 1, n - 1);
   for (j = 0; j < m - 1; ++j) {
      for (k = 0; k < nmvar; ++k) {
	 nghbrs[j + 1][k] = data[index[j]][k];
      }
   }

   /* Compute the sample covariance matrix of these closest m observations
      to x_i.  First, find the mean vector. */

   for (j = 0; j < nmvar; ++j) {
      mean[j] = 0.;
      for (k = 0; k < m; ++k) {
	 mean[j] += nghbrs[k][j];
      }
      mean[j] /= rm;
   }
   for (j = 0; j < nmvar; ++j) {
      for (k = 0; k <= j; ++k) {
         mcov[j][k] = 0.;
         for (i1 = 0; i1 < m; ++i1) {
            mcov[j][k] += (nghbrs[i1][j] - mean[j]) *
                          (nghbrs[i1][k] - mean[k]);
         }
         mcov[j][k] /= rm;
         mcov[k][j] = mcov[j][k];
      }

      /* If a variable has zero variance, artificially set it to a small
         number. */

      if (mcov[j][j] < 1.e-1) {
	 mcov[j][j] = 1.e-1;
      }
   }

   // Perform a Cholesky decomposition on this covariance matrix.

   retval = Choles.choles_(mcov, s, 1, nmvar, false);
   if (retval < 0.) {

      // Fix a failed Cholesky decomposition.

      for (j = 0; j < nmvar; ++j) {
         for (k = 0; k < nmvar; ++k) {
            if (k == j) {
	       s[j][j] = Math.sqrt(mcov[j][j]);
            
	    } else {
	       s[j][k] = 0.;
	    }
         }
      }
   }

   /* For each point in xobs, evaluate the multivariate normal density
      function at (xobs - x_i).  Do this by first standardizing xobs and
      then evaluating the standard normal density function. */

   for (l = 0; l < nmpts; ++l) {
      for (j = 0; j < nmvar; ++j) {
	 xcentr[j] = xobs[l][j] - data[i][j];
      }
      z[0] = xcentr[0] / s[0][0];
      for (j = 1; j < nmvar; ++j) {
         sum = 0.;
         for (k = 0; k < j; ++k) {
	    sum += s[j][k] * z[k];
	 }
         z[j] = (xcentr[j] - sum) / s[j][j];
      }
      sum = 0.;
      for (j = 0; j < nmvar; ++j) {
	 sum += z[j] * z[j];
      }

      /* Transform the sum-of-squares with the square root transform.  This
         root transform could be adaptive: if exp() = 0, decrease the root
         value. */

      val[l] += Math.exp(-.5 * Math.pow(sum, .2));
   }
}

for (l = 0; l < nmpts; ++l) {
   val[l] /= Math.pow(2. * PI, ((double) nmvar) / 2.);
   val[l] /= (double) n;

   if (!Double.isInfinite(val[l]) && !Double.isNaN(val[l])) {
      pdfests[l] = val[l];

   } else {
      printf_("densest: val(" + (l + 1) + ")= " + val[l]);
   }
}
}

// ---------------------------------------------------------------------

static void densest2_(int n, int nmvar, double data[][], int nmpts,
   double xobs[][], double pdfests[]) {

/* Estimates the joint density function for each row in "xobs" (which is
   a multivariate observation) using a local, m nearest neighbor volumetric
   nonparametric density estimator, see Thompson and Tapia (1990, p. 179).
*/

boolean retval, cityblock = true, zeroflag = true;

int i, j, m = 0;

double fraction = 0., radius, volume, factorial1 = 1., factorial2 = 1.;

if (nmvar == 0 || nmvar > WLSSZE) {
   iderr_("densest2: nmvar= " + nmvar + " WLSSZE= " + WLSSZE);
}
if (n == 0 || n > DATSZE) {
   iderr_("densest2: n= " + n + " DATSZE= " + DATSZE);
}

// Compute m, and the fraction m / n.

if (n > 50) {
   m = (int) (.25 * (double) n); // was .05

} else {
   m = 2;
}

// Zero-out pdf array.

for (i = 0; i < nmpts; ++i) {
   pdfests[i] = 0.;
}

fraction = ((double) m) / (double) n;

// Matrix.mprint_(data, n, nmvar);

if (!cityblock) {

   // Compute and then decompose the sample covariance matrix.

   retval = Dkernl.cdcmp_(n, nmvar, nmvar, data, ipvt, false);

   if (retval) {
      Dkernl.approxdist = true;
      Dkernl.cdcmp_(n, nmvar, nmvar, data, ipvt, false);
   }
}

for (i = 0; i < nmpts; ++i) {

   /* Find the closest m observations to xobs[i].  Do this by computing
      the statistical distance between xobs[i] and x_j, and then sorting
      these n distances.  Finally, pick off the first m of these. */

   for (j = 0; j < n; ++j) {
      if (!cityblock) {
         dist[j] = Dkernl.dist_(nmvar, nmvar, xobs[i], data[j],
			  true, Dkernl.msdinv, Dkernl.mcorr, ipvt);

      } else {
	 dist[j] = cityblock_(nmvar, xobs[i], data[j]);
      }
      index[j] = j;
   }

   // Sort these distances.

   Idsort.idsort_(dist, index, 1, n);

   /* Find the m^th nearest neighbor hypersphere radius, r_m(xobs[i])
      which is simply the distance from xobs[i] to the m^th closest
      point. */

   radius = dist[m - 1];

   // Compute the volume of this hypersphere.

   if ((nmvar / 2) * 2 == nmvar) {

      // nmvar is even.

      factorial1 = fctrl_(nmvar / 2);
      volume = Math.pow(PI, nmvar / 2) * Math.pow(radius, nmvar) /
	       factorial1;

   } else {
      
      // nmvar is odd.

      factorial1 = fctrl_((nmvar - 1) / 2);
      factorial2 = fctrl_(nmvar);
      volume = Math.pow(PI, (nmvar - 1) / 2) * factorial1 *
	 Math.pow(2. * radius, nmvar) / factorial2;
   }

   // Compute density estimate.

   if (volume <= 1.e-6) {
      pdfests[i] = 0.;

   } else {
      pdfests[i] = fraction / volume;
   }
}
Dkernl.approxdist = false;
}

// -----------------------------------------------------------------

static double fctrl_(int n) {

// Computes n! for small n.

int i;
double retval = 1.;

if (n < 2) {
   return retval;
}

for (i = 2; i <= n; ++i) {
   retval *= (double) i;
}

return retval;
}

// -----------------------------------------------------------------

static double cityblock_(int n, double xobs[], double x[]) {

/* Computes the City Block distance between "xobs" and "x."  An
   improvement would be to divide each difference by the range of
   that variable. */

int i;

double retval = 0.;

for (i = 0; i < n; ++i) {
   retval += Math.abs(xobs[i] - x[i]);
}

return retval;
}

// ---------------------------------------------------------------------

static void densest3_(int n, int nmvar, double data[][], int nmpts,
   double xobs[][], double pdfests[]) {

boolean same = true;

int i, j, k;

// Zero-out pdf array.

for (i = 0; i < nmpts; ++i) {
   pdfests[i] = 0.;
}

for (i = 0; i < nmpts; ++i) {

   // Find the relative frequency of this i^th "xobs."

   for (j = 0; j < n; ++j) {
      same = true;
      for (k = 0; k < nmvar; ++k) {
         if (Math.abs(xobs[i][k] - data[j][k]) > 1.e-6) {
	    same = false;
	    break;
         }
      }
      if (same) {
         pdfests[i] += 1.;
      }
   }
   pdfests[i] /= (double) n;
   /*
   printf_("densest3: ID= " + thisidname + " i= " + i +
      " pdfest= " + pdfests[i]);
   */
}
}

// ---------------------------------------------------------------------

static double densest4_(int n, int nmnodes, double degreesim[][],
   int groupsim[][], double degreeobs[], int groupobs[]) {

/* Estimates the density function of the graph having degree vector
   "degreeobs" based on the "n" simulated graphs having degree vectors
   "degreesim" using a local, m nearest neighbor volumetric
    nonparametric density estimator, see Thompson and Tapia (1990, p. 179).
*/

boolean retval;

int i, m = 0;

double fraction, radius, volume, pdfest = 0.;

if (n == 0 || n > DATSZE) {
   iderr_("densest4: n= " + n + " DATSZE= " + DATSZE);
}

// Compute m, and the fraction m / n.

if (n > 50) {
   m = (int) (.25 * (double) n);

} else {
   m = 2;
}

fraction = ((double) m) / (double) n;

/* Find the closest m simulated graphs to "graphobs."  Do this by
   first computing the graph distance between "degreeobs" and
   "degreesim_i.  And then sorting these n distances.  Finally,
   pick off the first "m" of these. */

for (i = 0; i < n; ++i) {
   dist[i] = SNA.grphdist_(false, nmnodes, degreeobs, groupobs, degreesim[i],
      groupsim[i]);
   index[i] = i;
}

// Sort these distances.

Idsort.idsort_(dist, index, 1, n);

/* Find the m^th nearest neighbor hypersphere radius, r_m(graphobs)
   which is simply the graph distance from "graphobs" to the
   m^th closest graph. */

radius = dist[m - 1];

/* The volume of this one-dimensional hypersphere is twice its
   radius. */

volume = 2. * radius;

// Compute density estimate.

if (volume <= 1.e-6) {
   pdfest = 0.;

} else {
   pdfest = fraction / volume;
}

return (pdfest);
}

// ---------------------------------------------------------------------

static double densest5_(int n, int nmsteps[], int animal,
   double simpath[][][][][], int nmobssteps, double obspath[][]) {

/* Estimates the density function of the observed path "obspath" of
   a particular animal based on the "n" simulated paths of this
   animal that are contained in "simpath" using a local, m nearest
   neighbor volumetric nonparametric density estimator, see
   Thompson and Tapia (1990, p. 179).
*/

boolean retval;

int i, j, k, nmthrdloops, m = 0;

double fraction, radius, volume, pdfest = 0.;

if (n == 0 || n > DATSZE) {
   iderr_("densest5: n= " + n + " DATSZE= " + DATSZE);
}

/* Compute m, and the fraction m / n.  Thompson and Tapia recommend
   m = .02n. */

if (n > 40) {
   m = (int) (.05 * (double) n);
   if (m < 2) {
      m = 2;
   }

} else {
   m = 2;
}

fraction = ((double) m) / (double) n;

/* Find the closest m simulated paths to "obspath."  Do this by
   first computing the path dissimilarity between "simpath_i" and
   "obspath" -- and then sorting these n distances.  Finally, pick
   off the first "m" of these. */

nmthrdloops = n / nmthreads;
k = 0;
for (i = 1; i <= nmthreads; ++i) {
   for (j = 0; j < nmthrdloops; ++j) {
      dist[k] = SMSutils.pathdissim_(nmsteps[i], simpath[i][j][animal],
		                     nmobssteps, obspath);
      index[k] = k;
      ++k;
      
      // printf_("densest5: k= " + k + " dist= " + dist[k-1]);
   }
}

// Sort these distances.

Idsort.idsort_(dist, index, 1, n);

/* Find the m^th nearest neighbor hypersphere radius, r_m(graphobs)
   which is simply the graph distance from "graphobs" to the
   m^th closest graph. */

radius = dist[m - 1];

/* The volume of this one-dimensional hypersphere is twice its
   radius. */

volume = 2. * radius;

// Compute density estimate.

if (volume <= 1.e-6) {
   pdfest = 0.;

} else {
   pdfest = fraction / volume;
}

return (pdfest);
}
}
