class Dipstat extends Id {

// -------------------------------------------------------------------------

static double dipstat_(int n, double x[]) {

/* Computes the Dip statistic, a measure of how close the empirical
   CDF is to the closest unimodal CDF.  Hence, this statistic is
   used to test for multmodality.  See Hartigan (1985), Applied Statistics,
   Algorithm AS 217. */

int i, ic, icva, icv, icx, icxa, igcm, igcm1, igcmx, ig, ih, ix, iv, j, jb,
   je, jr, jk, k, kb, ke, kr, lcmiv, lcmiv1, lcm1, low, high, mjk, mjmjk, mnj,
   mnmnj, na;
int index[] = new int[n];
int gcm[] = new int[n];
int lcm[] = new int[n];
int mj[] = new int[n];
int mn[] = new int[n];
double a, b, cnstnt, d, dx, dip, dipnew, dl, du, fn, t, temp, xl, xu;

if (n <= 1) iderr_("n=1 in dipstat_()");

// Sort the data.

for (i = 1; i <= n; ++i) index[i - 1] = i;
Idsort.idsort_(x, index, 1, n);

/* low contains the index of the current estimate of the lower end of the
   modal interval, high contains the index for the current upper end. */

fn = (double) n;
low = 1;
high = n;
dip = 1. / fn;
xl = x[low - 1];
xu = x[high - 1];

/* Establish the indices over which combination is necessary for the
   convex minorant fit. */

mn[0] = 1;
for (j = 2; j <= n; ++j) {
   mn[j - 1] = j - 1;
   for (;;) {
      mnj = mn[j - 1];
      mnmnj = mn[mnj - 1];
      a = (double) (mnj - mnmnj);
      b = (double) (j - mnj);
      if (mnj == 1 || (x[j - 1] - x[mnj - 1]) * a <
                      (x[mnj - 1] - x[mnmnj - 1]) * b) break;
      mn[j - 1] = mnmnj;
   }
}

/* Establish the indices over which combination is necessary for the
   concave majorant fit.

mj[n - 1] = n;
na = n - 1;
for (jk = 1; jk <= na; ++jk) {
   k = n - jk;
   mj[k - 1] = k + 1;
   for (;;) {
      mjk = mj[k - 1];
      mjmjk = mj[mjk - 1];
      a = (double) (mjk - mjmjk);
      b = (double) (k - mjk);
      if (mjk == n || (x[k - 1] - x[mjk - 1]) * a <
                      (x[mjk - 1] - x[mjmjk - 1] * b) break;
      mj[k - 1] = mjmjk;
   }
}

/* Start the cycling.  Collect the change points for the gcm from high to
   low. */

for (;;) {
   ic = 1;
   gcm[0] = high;
   for (;;) {
      igcm1 = gcm[ic - 1];
      ++ic;
      gcm[ic - 1] = mn[igcm1 - 1];
      if (gcm[ic - 1] <= low) break;
   }
   icx = ic;

   // Collect the change points for the lcm from low to high.

   ic = 1;
   lcm[0] = low;
   for (;;) {
      lcm1 = lcm[ic - 1];
      ++ic;
      lcm[ic - 1] = mj[lcm1 - 1];
      if (lcm[ic - 1] >= high) break;
   }
   icv = ic;

   /* icx, ix, ig are counters for the convex minorant.
      icv, iv, ih are conters for the concave majorant. */

   ig = icx;
   ih = icv;

   /* Find the largest distance greater than "dip" between the gcm and the
      lcm from low to high. */

   ix = icx - 1;
   iv = 2;
   d = 0.;
   if (icx == 2 && icv == 2) {
      for (;;) {
         igcmx = gcm[ix - 1];
         lcmiv = lcm[iv - 1];
         if (igcmx <= lcmiv) {
         
            /* If the next point of either the gcm or lcm is from the lcm then
               calculate distance here. */

            lcmiv1 = lcm[iv - 2];
            a = (double) (lcmiv - lcmiv1);
            b = (double) (igcmx - lcmiv1 - 1);
            dx = (x[igcmx - 1] - x[lcmiv1 - 1] * a) /
                 (fn * (x[lcmiv - 1] - x[lcmiv1 - 1])) - b / fn;
            --ix;
            if (dx >= d) {
               d = dx;
               ig = ix + 1;
               ih = iv;
            }

         } else {

            /* If the next point of either the gcm or lcm is from the gcm, then
               then calculate distance here. */

            lcmiv = lcm[iv - 1];
            igcm = gcm[ix - 1];
            igcm1 = gcm[ix];
            a = (double) (lcmiv - igcm1 + 1);
            b = (double) (igcm - igcm1);
            dx = a / fn - ((x[lcmiv - 1] - x[igcm1 - 1]) * b) /
                           (fn * (x[igcm - 1] - x[igcm1 - 1]));
            ++iv;
            if (dx >= d) {
               d = dx;
               ig = ix + 1;
               ih = iv - 1;
            }
         }

         if (ix < 1) ix = 1;
         if (iv > icv) iv = icv;
         if (gcm[ix - 1] == lcm[iv - 1]) break;
      }

   } else {
      d = 1. / fn;
   }

   if (d < dip) {
      dip *= .5;
      xl = x[low - 1];
      xu = x[high - 1];
      return dip;
   }

   /* Calculate the dips for the current low and high.
      First, the dip for the convex minorant. */

   dl = 0.;
   if (ig != icx) {
      icxa = icx - 1;
      for (j = ig; j <= icxa; ++j) {
         temp = 1. / fn;
         jb = gcm[j];
         je = gcm[j - 1];
         if (je - jb <= 1 || x[je - 1] == x[jb - 1]) {
            if (dl < temp) dl = temp;
            continue;
         }
         a = (double) (je - jb);
         cnstnt = a / (fn * (x[je - 1] - x[jb - 1]));
         for (jr = jb; jr <= je; ++jr) {
            b = (double) (jr - jb + 1);
            t = b / fn - (x[jr - 1] - x[jb - 1]) * cnstnt;
            if (t > temp) temp = t;
         }
      }
   }

   // The dip for the concave majorant.

   du = 0.;
   if (ih != icv) {
      icva = icv - 1;
      for (k = ih; k <= icva; ++k) {
         temp = 1. / fn;
         kb = lcm[k - 1];
         ke = lcm[k];
         if (ke - kb <= 1 || x[ke - 1] == x[kb - 1]) {
            if (du < temp) du = temp;
            continue;
         }
         a = (double) (ke - kb);
         cnstnt = a / (fn * (x[ke - 1] - x[kb - 1]));
         for (kr = kb; kr <= ke; ++kr) {
            b = (double) (kr - kb - 1);
            t = (x[kr - 1] - x[kb - 1]) * cnstnt - b / fn;
            if (t > temp) temp = t;
         }
      }
   }

   // Determine the current maximum.

   dipnew = dl;
   if (du > dl) dipnew = du;
   if (dip < dipnew) dip = dipnew;
   low = gcm[ig - 1];
   high = lcm[ih - 1];
}
}
} 
