import java.util.*;
class Displayactions extends CA {

static boolean ecoobstime[][] = new boolean[TNMVALS][MAXTIMES];
static boolean ecomdltime[][] = new boolean[TNMVALS][MAXTIMES];
static boolean matched[] = new boolean[NMACTNS];
static boolean impliedpentad[] = new boolean[NMACTNS];
static boolean pltdaction[] = new boolean[NMACTNS];
static boolean pltalone[] = new boolean[NMACTNS];
static boolean plotpentad[] = new boolean[NMACTNS];

static char pentadsymbol[] = new char[NMACTNS];
static char singsym[] = new char[NMACTNS];
static char symbol[][] = new char[NMACTTHRDS][NMTHRDPTS];

static String flename, plottype = "none", fleformat = "AHS"; // "SQL" or "AHS"

static String phenomenon[] = new String[6];
static String tetrad[] = new String[NMACTNS];
static String linelbl[] = new String[TNMVALS];
static String incomb[] = new String[NMACTNS];
static String outcomb[] = new String[NMACTNS];
static String actionactor[] = new String[NMACTNS];
static String action[] = new String[NMACTNS];
static String actiontrgt[] = new String[NMACTNS];
static String pentad[] = new String[NMACTNS];
static String nomlab[] = new String[NMACTNS];
static String plottitle[] = new String[3];
static String nomlab2[] = new String[NMACTNS];
static String carryvar[][] = new String[NMACTNS][4];

static int nmactions = 0, nmactiontimes = 0, nmtetrads, nmpentads,
   nmphenoms,
   minfreq; // Use 2 for krhino.id & habdes,  14 for eastaf.id

static int nmsequence[] = new int[TNMIDS];
static int nmsequencetype[][] = new int[TNMIDS][NMACTNS];
static int nmincombs[] = new int[TNMIDS];
static int nmincombtype[][] = new int[TNMIDS][NMACTNS];
static int nmoutcombs[] = new int[TNMIDS];
static int nmoutcombtype[][] = new int[TNMIDS][NMACTNS];
static int inoutfreq[][][] = new int[TNMIDS][TNMVALS][TNMVALS];
static int outfreq[][] = new int[TNMIDS][NMACTNS];
static int maxinoutfreq[][] = new int[TNMIDS][NMACTNS];
static int nmpts[] = new int[NMACTNS];
static int linetype[] = new int[NMACTNS];
static int outcombfreq[] = new int[NMACTNS];

static int actorcountry[] = new int[NMACTNS];
static int actionid[] = new int[NMACTNS];
static int inactid[] = new int[NMACTNS];
static int plttindex[] = new int[NMACTNS];

static float singleton[][] = new float[NMACTNS][2];
static float thread_pt[][][] = new float[NMACTTHRDS][NMTHRDPTS][2];
static float oldtonew[] = new float[NMACTNS];

static double endtime = 0.;

static double starttime[] = new double[3];
static double actiontime[] = new double[NMACTNS];
static double time[] = new double[NMACTNS];
static double pltpentadnm[] = new double[NMACTNS];
static double bar[] = new double[2];
static double pentadactor[] = new double[NMACTNS];
static double pentadcountry[] = new double[NMACTNS];
static double pentadphenomenon[] = new double[NMACTNS];
static double ecomin[] = new double[TNMNDS];
static double ecomax[] = new double[TNMNDS];
static double obsecograndave[][][] = new double[TNMVALS][MAXTIMES][MAXNMECO];

// ----------------------------------------------------------------------

static void displayactnshist_() {

// Initialize some arrays.

setup_();

// Create the actions history plot.

pltactnshist_(1., .75, .01, .258);

// Create an Encapsulated PostScript file of this plot.

if (plottype.equals("model")) {
   fprintf_(1,"\nModel-Generated Actions History Plot is at:" +
      "\n      <A HREF=\"" + flename + "\">" + flename + "</A>");

} else {
   fprintf_(1,"\nObserved Actions History Plot is at:" +
      "\n      <A HREF=\"" + flename + "\">" + flename + "</A>");
}

// Translate this portion of the plot to PostScript.

Pltpost.start = true;
Pltpost.stop = false;
Pltpost.ymin = .001;
Pltpost.pltpost_(flename, 1.0); 

// Create the ecosystem history plot.

printf_("\ndisplayactnshist: creating ecosystem plot.");
Displayeco.ploteco_(1., .25, .01, .001);

// Translate this final portion of the plot to PostScript.

Pltpost.start = false;
Pltpost.stop = true;
Pltpost.pltpost_(flename, 1.0); 

/* Now, compute action-sequence frequencies and from them, an
   entropy-based measure of variability. */

// Displayactions.plottype = "model";
//Actnseqfreqs.actnseqfreqs_(nmactions);
}

// ---------------------------------------------------------------------

static void pltactnshist_(double xscale, double yscale, double xshift,
   double yshift) {

/* Plots an observed or model-generated actions history file.  For
   model generated actions, this method assumes that the input file
   was created by the method "wrteacts_" during a model run.

   Action-reaction pentads are plotted at every other time point.
   A pentad consists of:

              actor--in-action--in-actor--out-action--target.

   Note that the actor is the target of the in-action.

   Pentads at time t and t+2 are connected by a solid line if the
   action--target of the time-t pentad is the
   actor--in-action of a pentad at time t+1 and this pentad's
   action-target is the actor--in-action of a pentad at t+2.  This is
   called a "three-pentad sequence."  Note
   that the pentad at time t+1 can be deduced by assembling the
   action--target of the time t pentad with the in-action--in-actor at
   time t+2.  This is why such three-pentad sequences are only plotted
   at every other time point.  Deduce-able pentads are indicated in
   the boolean array "impliedpentad."  A horizontal line indicates a
   target has reacted to an actor's action with a reaction directed
   back at this actor.

   Hence, an action-reaction pentad describes how a group (the actor)
   reacts to a particular in-action--in-actor combination directed
   against it.  There is no passage of time between the in-action and
   the out-action.  This plot has action-reaction pentad identifier
   values on its vertical axis and time points on its horizontal axis.

   This plot clearly displays "threads" of action-reaction sequences
   because there are no difficult-to-interpret arrows, and larger
   "chunks" of the actions history are plotted so that the plot is not
   so messy.

   Possible Alternatives To This Plot:
   1. One could plot tetrads and use a plotting symbol to indicate the
   actor.  Along this line, the plotting symbol could be a color as
   in the "evolustrips" for categorical time series plots as developed
   by Philippe Lemay (1999) in his doctoral dissertation (Lausanne)
   "The Statistical Analysis of Dynamics and Complexity in Psychology:
   A Configural Approach."
   
   2. Re-number pentads so that pentads with the same "actor" value
   are grouped together. */

boolean found_pentad = false, threadfound, plotij,
   kaction, matchval = false, sort_on_actions = false;

String rectype, actor, inaction, inactor, outaction, incombval, outcombval,
   this_pentad, strng2, trgtstrng, ematcode, matchstrng = "none", strchar;

int i = 0, j = 0, k, l, newnmpentads, nmthreads = 0, newnmthreads,
   threadnm = 0, pentadnm = 0, nmtrgts = 0, tindex = 1, actionidval,
   inactidval, nmpltd, nmalone, actornm, countrynm, phenomenonnm,
   strnglngth1, strnglngth2, maxnmpts = 0,
   pt1, pt2, nmtrgt = 0, nmtwo = 0, nmthree = 0, nmsingles = 0,
   newnmsingles, nmticlines = 2, actionend = 0, slngth = 0;

double timeval, lasttime = 0., time1 = 0., time2 = 0.;

// Read ID files.

Intridsetup.intridsetup_(false, true);

// Re-format an SQL output file.

if (fleformat.equals("SQL")) {
   Displayutils.fleformat_(actnshistfle);
}

// Sort actions history file by time.

if (plottype.equals("observations")) {
   Displayutils.ahsflesort_(actnshistfle);
}

// Read actions history file.

fleopen_(2, actnshistfle, 'r');
nmpentads = 0;
i = 0;
do {

   // Get record type.  Read only action-reaction pentads.

   rectype = fgetstrng_(2);

   if (rectype.equals("ecovals")) {
      fgetdble_(2);
      fgetint_(2);
      fgetint_(2);
      fgetdble_(2);
      fgetdble_(2);
      continue;
   
   } else if (!rectype.equals("pentad") &&
              !rectype.equals("action")) {
      iderr_("pltactnshist: rectype= " + rectype);
   }

   inactidval = 0;
   inaction = "unknown";
   inactor = "unknown";

   /* A pentad record is:

      actionidval inactionidval timeval in-action in-actor actor
      out-action target observed-action-match-status
   */

   if (rectype.equals("pentad")) {
      actionidval = fgetint_(2);
      inactidval = fgetint_(2);

   } else {
      actionidval = i + 1;
   }

   timeval = fgetdble_(2);

   if (i == 0) {
      if (timeval > starttime[0] && endtime > timeval) {
         time[tindex - 1] = timeval;
         actiontime[tindex - 1] = timeval;
         ++tindex;
         lasttime = timeval;
      }
   }

   if (rectype.equals("pentad")) {
      inaction = fgetstrng_(2);
      inactor = fgetstrng_(2);

   } else {
      inaction = "none";
      inactor = "none";
   }

   actor = fgetstrng_(2);

   // Get this actor's country and phenomenon class numbers.

   actornm = Displayutils.getactornm_(actor);
   countrynm = Displayutils.getcountrynm_(actor);
   phenomenonnm = Displayutils.getphenomenonnm_(actor);

   actor = Displayutils.getshort_(actor);
   
   // If action records are present, set the sort flag accordingly.

   if (rectype.equals("action")) {
      sort_on_actions = true;
   }

   incombval = inaction + "-" + actor;

   // Read action and target.
   
   outaction = fgetstrng_(2);
   trgtstrng = fgetstrng_(2);
 
   // Read string indicating whether the action is matched by the model.
   
   matchstrng = "not_matched";
   if (!rectype.equals("action")) {
      matchstrng = fgetstrng_(2);
   }

   if (matchstrng.equals("matched")) {
      matchval = true;

   } else {
      matchval = false;
   }

   // Now that the record has been read, check for time-window membership.
   
   if (timeval < starttime[0] || endtime < timeval) {
      continue;
   }

   /* Don't plot the ambiguous "verbal:" comments, nor the excessive
     "rob tourists" actions. */

   if (outaction.indexOf("verbal:", 0) >= 0 ||
       outaction.indexOf("rob_some", 0) >= 0) {
      continue;
   }

   // Kluge to replace president with NGO.

   if (outaction.indexOf("donate", 0) >= 0 && actor.indexOf("p", 0) >= 0) {
      actor = "ng";
   }

   // Create a pentad.

   // outcombval = outaction + "-" + trgtstrng;
   outcombval = outaction;
   this_pentad = actor + "-" + inaction + "-" + inactor + "-" +
      outcombval;

   // Assign an index value to each unique action-reaction pentad.

   found_pentad = false;
   for (k = 1; k <= nmpentads; ++k) {
      if (this_pentad.equals(pentad[k - 1])) {
         found_pentad = true;
         pentadnm = k;
         break;
      }
   }

   if (!found_pentad) {

      // Create a new, unique pentad.

      pentad[nmpentads] = this_pentad;
      pentadactor[nmpentads] = (double) actornm;
      pentadcountry[nmpentads] = (double) countrynm;
      pentadphenomenon[nmpentads] = (double) phenomenonnm;

      /* Find plotting symbol for this pentad.  If plotting observations,
         use the out-action's EMAT code. */

      if (plottype.equals("observations")) {
         k = Grouputils.getematcodeindex_(outaction, .8);
         pentadsymbol[nmpentads] = Storyparse.actorplotsymbol[k - 1];
      
      } else {
         pentadsymbol[nmpentads] = actor.charAt(0);
      }
      printf_("pltactnshist: pentadnm= " + (nmpentads + 1) + " actor= " +
         actor + " symbol= " + pentadsymbol[nmpentads] +
         "\n   inaction= " + inaction + " outaction= " + outaction);

      /* Fill the pentad label plotting array, "nomlab" (for
         "nominal labels"). */

      strnglngth1 = inaction.length();
      strnglngth2 = outaction.length();

      strnglngth1 = Math.min(6, strnglngth1);
      strnglngth2 = Math.min(6, strnglngth2);

      if (fleformat.equals("AHS")) {
         strng = actor + ":_" + outaction;

      } else {
         strng = outaction;
      }

      strng = strng.replaceAll("ing","-ing");
      strng = strng.replaceAll("pment","p-ment");
      strng = strng.replaceAll("ement","e-ment");
      strng = strng.replaceAll("tional","tion-al");
      strng = strng.replaceAll("infrast","infra-st");

      // Finally, assign this pentad's label.

      nomlab[nmpentads] = strng.substring(0,
         Math.min(26, strng.length()));


      // Fill the label's second line of text, if any.

      if (nmticlines == 2) {
         if (plottype.equals("model")) {
            nomlab2[nmpentads] = "[" +
               inaction.substring(0, Math.min(13, inaction.length())) + "]";

	 } else {
            actionend = 0;
            for (j = 20; j <= Math.min(26, strng.length()); ++j) {
               strchar = strng.substring(j - 1, j);
	       if (strchar.equals("-") || strchar.equals("_")) {
                  actionend = j;
                  nomlab[nmpentads] = strng.substring(0, actionend);
		  break;
               }
	    }
	    if (actionend == 0) {
               actionend = nomlab[nmpentads].length();
            }
            slngth = strng.length();
	    if (0 < actionend && actionend < slngth) {
               nomlab2[nmpentads] = strng.substring(actionend,
			               Math.min(actionend + 26, slngth));

	    } else {
               nomlab2[nmpentads] = "_";
	    }
	    nomlab2[nmpentads] = nomlab2[nmpentads].replaceAll(
               "-ing","ing");
	    nomlab2[nmpentads] = nomlab2[nmpentads].replaceAll(
               "p-ment","pment");
	    nomlab2[nmpentads] = nomlab2[nmpentads].replaceAll(
               "e-ment","ement");
	    nomlab2[nmpentads] = nomlab2[nmpentads].replaceAll(
               "tion-al","tional");
	    nomlab2[nmpentads] = nomlab2[nmpentads].replaceAll(
               "infra-st","infrast");
         }

      } else {
         nomlab2[nmpentads] = "none";
      }
      ++nmpentads;
      pentadnm = nmpentads;
   } // End of "not found pentad."

   /* Store these in-combinations, out-combinations, and
      (time, pentadnm) pairs. */

   actionid[i] = actionidval;
   inactid[i] = inactidval;
   incomb[i] = incombval;
   actionactor[i] = actor;
   actorcountry[i] = countrynm;
   actiontime[i] = timeval;
   action[i] = outaction;
   outcomb[i] = outcombval;
   actiontrgt[i] = trgtstrng;
   plttindex[i] = tindex;
   pltpentadnm[i] = (double) pentadnm;
   matched[i] = matchval;

   ++i;
   if (i == NMACTNS) {
      iderr_("pltactnshist: nmactions= " + i + " -- too big for NMACTNS");
   }

   /* Detect next time point.  Assumes the actions history file is sorted
      by time. */

   if (timeval > lasttime) {
      time[tindex - 1] = timeval;
      ++tindex;
   }
   lasttime = timeval;
} while (!checkeof_(2)); // End of actions history file read loop.
fclose_(2, 'r');

nmactions = i;
nmactiontimes = tindex - 1;

if (nmactiontimes > MAXTIMES) {
   iderr_("pltactnshist: nmactiontimes= " + nmactiontimes);
}

/* Verify that actions are sorted on "time" and "inactid" is less than
   "actionid." */

for (i = 0; i < nmactions - 1; ++i) {
   if (actiontime[i] > actiontime[i + 1]) {
      iderr_("pltactnshist: actions not sorted on time");
   }
   if (inactid[i] > actionid[i]) {
      iderr_("pltactnshist: i= " + i + " actionid= " + actionid[i] +
	 " inactid= " + inactid[i]);
   }
}

// Use the PPS algorithm to find all frequent action episodes.

//Episodes.episodes_(action, nmactions);

/* Draw threads of action-reaction-action sequences.  The first thread
   is always an unconnected plot of actions that are isolated (not part
   of Action-Reaction-Action sequences). */

nmpts[0] = 0;
linetype[0] = 0;

/* Draw lines that connect an action-reaction pentad at time "i" to an
   action-reaction pentad at time "j" if these pentads are connected
   by the following chain:

   out-combination--in-combination--out-combination--in-combination

/* Test case.
nmpentads = 6;
nmactiontimes = 3;
nmactions = 6;
inactid[0] = 0;
inactid[1] = 0;
inactid[2] = 1;
inactid[3] = 2;
inactid[4] = 4;
inactid[5] = 0;
actiontime[0] = 1.;
actiontime[1] = 1.;
actiontime[2] = 2.;
actiontime[3] = 2.;
actiontime[4] = 3.;
actiontime[5] = 3.;
pltpentadnm[0] = 5.;
pltpentadnm[1] = 1.;
pltpentadnm[2] = 4.;
pltpentadnm[3] = 3.;
pltpentadnm[4] = 2.;
pltpentadnm[5] = 4.;
nomlab[0] = "one";
nomlab[1] = "two";
nomlab[2] = "three";
nomlab[3] = "four";
nomlab[4] = "five";
*/

printf_("pltactnshist: nmactions= " + nmactions);

ILOOP: for (j = nmactions; j > 0; --j) {
   i = 0;
   k = 0;
   plotij = false;

   if (impliedpentad[j - 1]) {
      continue;
   }

   /* A 3-way pentad sequence consists of pentad i, pentad k, pentad j.
      A 2-way pentad sequence sets pentad k to pentad i to give
      pentad i, pentad j.  */

   k = inactid[j - 1];

   /* 3-way pentads are not plotted at this time since I think they
      are hard to read off of the plot.
   if (k > 0) {
      i = inactid[k - 1];
   }
   */

   // Detect 2- and 3-pentad sequences.

   if (i > 0) {
      
      // A 3-pentad sequence has been found.

      impliedpentad[k - 1] = true;
      pltdaction[j - 1] = true;
      pltdaction[k - 1] = true;
      pltdaction[i - 1] = true;
      plotij = true;
      ++nmthree;

   } else if (k > 0) {

      // A 2-pentad sequence has been found.

      for (i = 1; i <= nmactions; ++i) {
         if (actionid[i - 1] == k) {
            break;
	 }
      }
      plotij = true;
      ++nmtwo;
   }

   if (plotij) {

      /* Find the action-reaction-action thread (if any) that has
         this j^th pentad as its earliest-point.  Threads are
	 constructed backwards through time. */

      threadfound = false;
      for (l = 0; l < nmthreads; ++l) {
         if (Math.abs((double) thread_pt[l][nmpts[l] - 1][0] -
                      actiontime[j - 1]) < 1.e-6 &&
             Math.abs((double) thread_pt[l][nmpts[l] - 1][1] -
                      pltpentadnm[j - 1]) < 1.e-6) {

            threadnm = l + 1;
            threadfound = true;
            break;
	 }
      }

      if (!threadfound) {
	    
         /* Start a new thread with the j^th pentad in this ij-pentad
	    pair. */

         thread_pt[nmthreads][0][0] = (float) actiontime[j - 1];
         thread_pt[nmthreads][0][1] = (float) pltpentadnm[j - 1];

         if (matched[j - 1]) {
	    symbol[nmthreads][0] = 'X';

	 } else {
	    symbol[nmthreads][0] =
	       pentadsymbol[((int) pltpentadnm[j - 1]) - 1];
	 }
         nmpts[nmthreads] = 1;
         linetype[nmthreads] = 1;
         ++nmthreads;

         if (nmthreads == NMACTTHRDS) {

            printf_("pltactnshist: j= " + j + " actiontime= " + actiontime[j -1] +
               " pltpentadnm= " + pltpentadnm[j - 1]);

            iderr_("pltactnshist: nmthreads = NMACTTHRDS");
         }

	 threadnm = nmthreads;
      }

      /* Add the i^th pentad in this ij-pentad pair to the thread that
	 it extends backwards through time. */

      if (nmpts[threadnm - 1] >= NMTHRDPTS - 1) {
	 iderr_("pltactnshist: nmpts > NMTHRDPTS");
      }

      if (pltpentadnm[i - 1] > 0) {
         thread_pt[threadnm - 1][nmpts[threadnm - 1]][0] =
	    (float) actiontime[i - 1];
         thread_pt[threadnm - 1][nmpts[threadnm - 1]][1] =
	    (float) pltpentadnm[i - 1];

	 // Load the appropriate plotting symbol.

         if (matched[i - 1]) {
	    symbol[threadnm - 1][nmpts[threadnm - 1]] = 'X';

         } else {
            symbol[threadnm - 1][nmpts[threadnm - 1]] =
               pentadsymbol[((int) pltpentadnm[i - 1]) - 1];
	 }

      } else {
         --nmpts[threadnm - 1];
      }

      ++nmpts[threadnm - 1];

   } else {

      if (pltdaction[j - 1]) {
         continue;
      }

      /* Action j is not the last Action in an Action-Reaction-Action
	 sequence and is also not the Reaction in an Action-Reaction
	 sequence so plot action j as an unconnected point, i.e., a
	 "singleton." */

      pltalone[j - 1] = true;

      if (nmsingles >= NMACTNS - 1) {
	 iderr_("pltactnshist: nmsingles > NMACTNS");
      } 

      singleton[nmsingles][0] = (float) actiontime[j - 1]; 
      singleton[nmsingles][1] = (float) pltpentadnm[j - 1];
      pt1 = (int) pltpentadnm[j - 1];

      // Load the appropriate plotting symbol. */

      if (matched[j - 1]) {
         singsym[nmsingles] = 'X';

      } else {
         singsym[nmsingles] = pentadsymbol[pt1 - 1];
      }

      // Find singleton frequencies.

      ++outcombfreq[pt1 - 1];
      ++nmsingles;
   }
} // End of loop over actions.

nmpltd = 0;
nmalone = 0;
for (i = 0; i < nmactions; ++i) {
   if (pltdaction[i]) {
      ++nmpltd;
   }
   if (pltalone[i]) {
      ++nmalone;
   }
}
printf_("pltactnshist: nmalone= " + nmalone + " nmsingle= " + nmsingles +
   " nmtwo= " + nmtwo + " nmthree= " + nmthree);

for (i = 0; i < nmthreads; ++i) {
   if (nmpts[i] == 0) {
      iderr_("pltactnshist: i= " + i + " nmpts= 0");
   }
}

// Check for bad threads.

for (i = 0; i < nmthreads; ++i) {
   for (j = 0; j < nmpts[i] - 1; ++j) {
      if (Math.abs(thread_pt[i][j + 1][0] - thread_pt[i][j][0])
	 < 1.e-6) {
	 printf_("pltactnshist: thread= " + i + " threadpt= " + j +
	    " nmpts= " + nmpts[i] +
	    "\n   timej= " + thread_pt[i][j][0] +
	    " val= " + thread_pt[i][j][1] +
	    "\n   timej+1= " + thread_pt[i][j + 1][0] +
	    " val= " + thread_pt[i][j][1]);
      }
   }
   
   // Print pentads of length 2 (remember they are in reverse order).

   if (nmpts[i] == 2) {
      time1 = thread_pt[i][0][0];
      time2 = thread_pt[i][1][0];
      if ((time1 - time2) < 1.e-6) {
         printf_("pltactnshist: i= " + i + " time1=time2= " + time1);
      }
      pt1 = (int) thread_pt[i][0][1];
      pt2 = (int) thread_pt[i][1][1];
   
      // Find pentad value frequencies.

      ++outcombfreq[pt1 - 1];
      ++outcombfreq[pt2 - 1];
   }
} // End of loop over threads.

// Plot only those pentads occurring more than "minfreq" times.

newnmthreads = 0;
for (i = 0; i < nmthreads; ++i) {
   pt1 = (int) thread_pt[i][0][1];
   pt2 = (int) thread_pt[i][1][1];
   if (nmpts[i] == 2 && outcombfreq[pt1 - 1] > minfreq &&
       outcombfreq[pt2 - 1] > minfreq) {
      thread_pt[newnmthreads][0][0] = thread_pt[i][0][0];
      thread_pt[newnmthreads][1][0] = thread_pt[i][1][0];
      symbol[newnmthreads][0] = symbol[i][0];

      thread_pt[newnmthreads][0][1] = thread_pt[i][0][1];
      thread_pt[newnmthreads][1][1] = thread_pt[i][1][1];
      symbol[newnmthreads][1] = symbol[i][1];
      nmpts[newnmthreads] = nmpts[i];
      ++newnmthreads;
      plotpentad[pt1 - 1] = true;
      plotpentad[pt2 - 1] = true;
   }
}
nmthreads = newnmthreads;

// Plot only those singletons occurring more than "minfreq" times.

newnmsingles = 0;
for (i = 0; i < nmsingles; ++i) {
   pt1 = (int) singleton[i][1];
   if (outcombfreq[pt1 - 1] > minfreq) {
      singleton[newnmsingles][0] = singleton[i][0];
      singleton[newnmsingles][1] = singleton[i][1];
      singsym[newnmsingles] = singsym[i];
      ++newnmsingles;
      plotpentad[pt1 - 1] = true;
   }
}
nmsingles = newnmsingles;

// Renumber pentads.

newnmpentads = 0;
for (i = 1; i <= nmpentads; ++i) {
   if (plotpentad[i - 1]) {
      nomlab[newnmpentads] = nomlab[i - 1];
      nomlab2[newnmpentads] = nomlab2[i - 1];
      ++newnmpentads;
      oldtonew[i - 1] = (float) newnmpentads;
   }
}
nmpentads = newnmpentads;

for (i = 0; i < nmthreads; ++i) {
   for (j = 0; j < nmpts[i]; ++j) {
      if (thread_pt[i][j][1] < 1.e-6) {
         printf_("i= " + i + " j= " + j + " nmpts= " + nmpts[i] +
            " val= " + thread_pt[i][j][1]);
      }
      thread_pt[i][j][1] = oldtonew[((int) thread_pt[i][j][1]) - 1];
   }
}

for (i = 0; i < nmsingles; ++i) {
   singleton[i][1] = oldtonew[((int) singleton[i][1]) - 1];
}

/* Re-order pentad numbers in threads to minimize length of connecting
   lines. */

if (sort_on_actions) {
   Displayutils.sortpts_(nmsingles, singleton, nmpentads, nmthreads);

} else {
   Displayutils.reorderthrds_(nmsingles, singleton, nmpentads, nmthreads);
}

// Plot all of these action-reaction-action threads.

plottitle[0] = "Political_actions_history";
plottitle[1] = null;

fleopen_(3, "out.dig", 'w');
Plotutils.pltscat_(3, nmsingles, singleton, singsym, nmthreads, nmpts,
   thread_pt, symbol, plottitle, linelbl, "Time", "Pentad", true, nomlab,
   nmticlines, nomlab2, xscale, yscale, xshift, yshift, 0, bar, linetype,
   starttime[0], endtime);
fclose_(3, 'w');
}

// ----------------------------------------------------------------------

static void setup_() {

// Read group information from the file "grpinfofle."

int i;

Storyparse.nmvernacgrps = Storyutils.readgrpinfo_(3);

// Specify phenomenon classes and their orders.

phenomenon[0] = "president";
phenomenon[1] = "EPA";
phenomenon[2] = "RR";
phenomenon[3] = "pastoralists";
phenomenon[4] = "NGO";
phenomenon[5] = "econsystem";
nmphenoms = 6;
}
}
