class Dkernl extends Id {
static boolean approxdist = false;

static int nmcategories = 1; // Set number of categories to 1 for now.

static int cmpn[] = new int[nmcategories];

static double avedst, rnm, cond, nm1, ncnst;

static double mcov[][] = new double[TNMNDS][TNMNDS];
static double mcovs[][][] = new double[nmcategories][TNMNDS][TNMNDS];
static double mcovcpy[][] = new double[TNMNDS][TNMNDS];
static double msdinv[][] = new double[TNMNDS][TNMNDS];
static double work[] = new double[TNMNDS];
static double evec[] = new double[TNMNDS];
static double prdave[][] = new double[TNMNDS][nmcategories];
static double xi[] = new double[TNMNDS];
static double dists[] = new double[OPTSIZE];
static double rspdst[] = new double[nmcategories];
static double diff[] = new double[TNMNDS];
static double dsave[] = new double[TNMNDS];
static double mcorr[][] = new double[TNMNDS][TNMNDS];

// ------------------------------------------------------------------------

static int dkernl_(int n, int nmquan, int nmprd, double x0[],
   int rspns[], double prds[][], int ipvt[]) {

/* Returns the direct kernel estimate of the response distribution at
   the predictor location x0.  See Tutz (1990).  It is assumed that the
   predictor vectors are stored row-wise in the matrix "prds" and that
   all qualitative predictor components are stored in the columns
   AFTER the quantitative predictor component columns. */

int i1, i2, i3, nmnghbr, pred = 0;
int index[] = new int[n];
double rnm, maxp;

// Set constants.

nmnghbr = 1;
rnm = 1. / ((double) nmnghbr);

/* Compute n distances between x0 and each predictor vector in the data
   set. */

for (i1 = 0; i1 < n; ++i1) {
   index[i1] = i1 + 1;
   for (i3 = 0; i3 < nmprd; ++i3) {
      xi[i3] = prds[i1][i3];
   }
   dists[i1] = dist_(nmquan, nmprd, x0, xi, true, msdinv, mcorr, ipvt);
}

// Sort these distances.

Idsort.idsort_(dists, index, 1, n);

// Find smallest nmnghbr distances.
// ksmllst_(dists, index, n, nmnghbr);

/* Compute the direct kernel estimate of the response distribution and
   the average distance of observations used to compute this estimate. */

for (i1 = 0; i1 < nmcategories; ++i1) {
   rspdst[i1] = 0.;
}
avedst = 0.;
for (i1 = 0; i1 < nmnghbr; ++i1) {
   for (i2 = 0; i2 < nmcategories; ++i2) {
      if (rspns[index[i1] - 1] == i2 + 1) {
         rspdst[i2] += 1.;
         break;
      }
   }
   avedst += dists[i1];
}
for (i1 = 0; i1 < nmcategories; ++i1) {
   rspdst[i1] *= rnm;
}
avedst *= rnm;

// Compute the prediction: pred.

maxp = -1.;
for (i2 = 0; i2 < nmcategories; ++i2) {
   if (rspdst[i2] > maxp) {
      pred = i2 + 1;
      maxp = rspdst[i2];
   }
}

return pred;
}

// ------------------------------------------------------------------------

static double dist_(int nmquan, int nmprd, double x1[], double x2[],
   boolean stndrdz, double msdinv[][], double decompmat[][], int ipvt[]) {

/* Computes the statistical distance between the vectors x1 and x2.
   "nmquan" is the number of quantitative (continuous) predictor
   variables.  "nmprd" is the total number of predictor variables.

   "stndrdz" is set to true if the correlation matrix is being used
   instead of the covariance matrix. */

int i, ii, j, i1;

double retval = 0.;

// First, compute the difference vector.

for (i1 = 0; i1 < nmprd; ++i1) {
   diff[i1] = Math.abs(x1[i1] - x2[i1]);
   if (i1 > nmquan) {
      if (diff[i1] > 1.e-10) {
	 diff[i1] = 1.;
      
      } else {
	 diff[i1] = 0.;
      }
   }
   dsave[i1] = diff[i1];
}

if (nmprd == 1) {
   return Math.abs(diff[0]);
}

/* If the approximate statistical distance is to be computed, just
   find dist = sqrt(d' * V^-1 * d) and return. */

if (approxdist) {
   for (i1 = 0; i1 < nmprd; ++i1) {
      retval += diff[i1] * diff[i1] * msdinv[i1][i1];
   }
   return Math.sqrt(retval);
}

// Optionally, standardize the difference vector.

if (stndrdz) {
   Matrix.mxv_(msdinv, diff, dsave, nmprd, nmprd);
   for (i1 = 0; i1 < nmprd; ++i1) {
      if (Double.isNaN(dsave[i1])) {
         iderr_("dist: dsave= " + dsave[i1] + ", i1= " + i1 + " nmprd= "
            + nmprd);
      }
      diff[i1] = dsave[i1];
   }
}

// Compute the distance.

Eqslv.solve_(nmprd, decompmat, diff, ipvt);
for (i1 = 0; i1 < nmprd; ++i1) {
   if (Double.isNaN(diff[i1])) {
      diff[i1] = 0.;
   }
}
retval = Vectr.vtxv_(dsave, diff, nmprd);

return Math.sqrt(retval);
}

// -----------------------------------------------------------------------

static boolean cdcmp_(int n, int nmquan, int nmprd, double prds[][],
   int ipvt[], boolean updt) {

/* Computes the covariance matrix of the predictor vectors and decomposes
   this matrix.  If updt is true, removes the n^th observation from the
   existing sample covariance matrix.
   !!! Data set is assumed to have been sorted by rspns. !!!! */

int i, ii, j, i1, i2, i3, i5, strtn;
double minvar = 0.;

// Artificially set component count to n.

cmpn[0] = n;

if (!updt) {

   /* Compute the pooled covariance matrix.  Also, find the mean vectors of
      the quantitative covariates only.  Note that the full data set
      (either the actual data or the delete-d jackknife sample) is used
      to make this computation. */

   Matrix.mzro_(prdave, nmquan, nmcategories);
   Matrix.mzro_(mcov, nmprd, nmprd);
   strtn = 0;
   for (i3 = 0; i3 < nmcategories; ++i3) {
      for (i1 = 0; i1 < nmquan; ++i1) {
         for (i2 = strtn; i2 < strtn + cmpn[i3]; ++i2) {
            prdave[i1][i3] += prds[i2][i1];
         }
      }
      for (i1 = 0; i1 < nmquan; ++i1) {
	 prdave[i1][i3] /= cmpn[i3];
      }
      strtn += cmpn[i3];
   }

   // Compute each response level's covariance matrix.

   strtn = 0;
   for (i5 = 0; i5 < nmcategories; ++i5) {
      for (i1 = 0; i1 < nmquan; ++i1) {
         for (i2 = 0; i2 < nmquan; ++i2) {
            mcovs[i5][i1][i2] = 0.;
            for (i3 = strtn; i3 < strtn + cmpn[i5]; ++i3) {
               mcovs[i5][i1][i2] += (prds[i3][i1] - prdave[i1][i5]) *
                                    (prds[i3][i2] - prdave[i2][i5]);
            }
         }
      }
      strtn += cmpn[i5];
   }

   // Compute the pooled covariance matrix from the per-level matrices.

   minvar = 1.e30;
   rnm = (double) (n - nmcategories);
   for (i1 = 0; i1 < nmquan; ++i1) {
      for (i2 = 0; i2 < nmquan; ++i2) {
         mcov[i1][i2] = 0.;
         for (i5 = 0; i5 < nmcategories; ++i5) {
            mcov[i1][i2] += mcovs[i5][i1][i2];
         }
	 mcov[i1][i2] /= rnm;
      }

      // Find the smallest non-zero variance.

      if (1.e-6 < mcov[i1][i1] && mcov[i1][i1] < minvar) {
	 minvar = mcov[i1][i1];
      }
   }

   /* Check for a zero variance.  If found, try to fix it by
      re-setting it to a small value. */

   for (i1 = 0; i1 < nmquan; ++i1) {
      if (mcov[i1][i1] <= 1.e-6) {
         mcov[i1][i1] = .1 * minvar;
      }
   }

   // Add qualitative predictors.

   for (i1 = nmquan; i1 < nmprd; ++i1) {
      mcov[i1][i1] = 1.;
   }

   // Make a copy of mcov.

   Matrix.mcpy_(mcovcpy, mcov, nmprd, nmprd);

} else if (updt) {

   /* Remove the n^th observation from the quantiative covariate
      submatrix of the sample covariance matrix.  Note that n has
      already been decremented by 1 in the calling routine. */

   for (i1 = 0; i1 < nmquan; ++i1) {
      evec[i1] = prds[n][i1] - prdave[i1][rspns[n] - 1];
   }
   nm1 = (double) n;
   ncnst = (1. / nm1) * (1. + (nm1 - 1.) / (nm1 * nm1));
   for (i1 = 0; i1 < nmquan; ++i1) {
      for (i2 = 0; i2 < nmquan; ++i2) {
         mcov[i1][i2] = mcovcpy[i1][i2] - ncnst * evec[i1] * evec[i2];
      }
   }
}

// Find (standard deviation matrix)^-1.

Matrix.mzro_(msdinv, nmprd, nmprd);
for (i1 = 0; i1 < nmprd; ++i1) {
   if (mcov[i1][i1] > 0.) {
      
      if (1.e-1 < mcov[i1][i1] && mcov[i1][i1] < 1.e2) {
	 msdinv[i1][i1] = 1. / Math.sqrt(mcov[i1][i1]);

      } else {

	 /* If a variance is too extreme, re-set it to 1.0 and use
	    approximate distance computations. */

	 msdinv[i1][i1] = 1.;
	 approxdist = true;
      }

   } else {
      printf_("cdcmp: Variances");
      for (i = 0; i < nmprd; ++i) {
	 printf_("cdcmp: i= " + i + " variance= " + mcov[i][i]);
      }
      iderr_("cdcmp: i1= " + i1 + " zero variance");
   }
}

// Return if the approximate statistical distance is being used.

if (approxdist) {
   return false;
}

if (nmprd > 1) {

   // Compute the correlation matrix.

   Matrix.mxm_(msdinv, mcov, mcovcpy, nmprd, nmprd, nmprd);
   Matrix.mxm_(mcovcpy, msdinv, mcorr, nmprd, nmprd, nmprd);

   // Decompose the generalized correlation matrix.

   cond = Eqslv.decomp_(nmprd, mcorr, ipvt, work);

   if (cond > 1.e20) {
      return true;
   }
}
return false;
}
}
