class Eigenvec extends Matrix {

static double y[] = new double[Math.max(WLSSZE,TNMNDS)];

// ------------------------------------------------------------------------

static double det_(double mat[][], int p) {

// Computes the determinant of "mat."

int i, retval;

double eigval = 0., det = 1.;

double eigvecs[][] = new double[p][p];
double eigvals[] = new double[p];

// First, compute spectral decomposition of mat.

retval = Eigenvec.eigenvec_(p, mat, eigvals);
if (retval == 1) {
   printf_("det: eigenvec failed");
   return (1.e30);
}

for (i = 0; i < p; ++i) {
   if (Double.isNaN(eigvals[i]) || Double.isInfinite(eigvals[i])) {
      printf_("det: i= " + i + " eigval= " + eigvals[i]);
      det = 1.e30;
      break;
   }
   eigval = eigvals[i];
   det *= eigvals[i];


   if (Double.isInfinite(det)) {
      printf_("det: eigval(" + (i + 1) + ")= " + eigval +
         ", infinite det, breaking");
      det = 1.e30;
      break;
   }
}

return det;
}

// ------------------------------------------------------------------------

static int eigenvec_(int n, double a[][], double d[]) {

/* Returns the eigenvalues of the symmetric matrix, a in d and the
   corresponding eigenvectors in the columns of a. */

int i, j;
double e[] = new double[n];

/*
for(i=0;i<5;++i) {
   for (j = 0; j < 5; ++j) {
      printf(" %lf",a[i][j]);
   }
   printf("\n");
}
exit(0);
*/

// Use Householder and QL routines from Numerical Recipes.

tred2_(a, n, d, e);
if (tqli_(d, e, n, a) == 1) return 1; 

/* Sort the eigenvalues into descending order and the corresponding columns
   of a. */

eigsort_(n, d, a);

return 0;
}

// -----------------------------------------------------------------------

static void tred2_(double a[][], int n, double d[], double e[]) {

// Householder transformation of a, from Numerical Recipes, p. 373.

int l, k, j, i;
double scale, hh, h, g, f;

for (i = n; i >= 2; i--) {
   l = i - 1;
   h = scale = 0.;
   if (l > 1) {
      for (k = 1; k <= l; k++) scale += Math.abs(a[i-1][k-1]);
      if (scale == 0.) e[i-1] = a[i-1][l-1];
      else {
	 for (k = 1; k <= l; k++) {
	    a[i-1][k-1] /= scale;
	    h += a[i-1][k-1] * a[i-1][k-1];
	 }
	 f = a[i-1][l-1];
	 g = f > 0. ? -Math.sqrt(h) : Math.sqrt(h);
	 e[i-1] = scale * g;
	 h -= f* g;
	 a[i-1][l-1] = f - g;
	 f = 0.;
	 for (j = 1; j <= l; j++) {
	    a[j-1][i-1] = a[i-1][j-1] / h;
	    g = 0.;
	    for (k = 1; k <= j; k++) g += a[j-1][k-1] * a[i-1][k-1];
	    for (k = j+ 1; k <= l; k++) g += a[k-1][j-1] * a[i-1][k-1];
	    e[j-1] = g / h;
	    f += e[j-1] * a[i-1][j-1];
	 }
	 hh = f / (h + h);
	 for (j = 1; j <= l; j++) {
	    f = a[i-1][j-1];
	    e[j-1] = g = e[j-1] - hh * f;
	    for (k = 1; k <= j; k++) a[j-1][k-1] -=
	       (f * e[k-1] + g * a[i-1][k-1]);
	    }
	 }
      
      } else e[i-1] = a[i-1][l-1];
      d[i-1] = h;
   }
   d[0] = 0.;
   e[0] = 0.;

   for (i = 1; i <= n; i++) {
      l = i - 1;
      if (d[i-1] != 0.) {
	 for (j = 1; j <= l; j++) {
	    g = 0.;
	    for (k = 1; k <= l; k++) g += a[i-1][k-1] * a[k-1][j-1];
            for (k = 1; k <= l; k++) a[k-1][j-1] -= g * a[k-1][i-1];
	 }
      }
      d[i-1] = a[i-1][i-1];
      a[i-1][i-1] = 1.;
      for (j = 1; j <= l; j++) a[j-1][i-1] = a[i-1][j-1] = 0.;
   }
}

// ------------------------------------------------------------------------

static int tqli_(double d[], double e[], int n, double z[][]) {

// QL algorithm from Numerical Recipes, p. 380-381.

int m, l, iter, i, k, maxiter;
double s, r, p, g, f, dd, c, b;

maxiter = 0;
for (i = 2; i <= n; i++) e[i-2] = e[i-1];
e[n-1] = 0.;
for (l = 1; l <= n; l++) {
   iter = 0;
   do {
      for (m = l; m <= n-1; m++) {
	 dd = Math.abs(d[m-1]) + Math.abs(d[m]);
	 if (Math.abs(e[m-1]) + dd == dd) break;
	 /* if (Math.abs(e[m-1]) < 1.e-9) break; */
      }
      if (m != l) {
	 if (iter++ == 50) return 1;
	 g = (d[l] - d[l-1]) / (2. * e[l-1]);
	 r = Math.sqrt((g * g) + 1.);
	 g = d[m-1] - d[l-1] + e[l-1] / (g + sign_(r,g));
	 s = c = 1.;
	 p = 0.;
	 for (i = m - 1; i >= l; i--) {
	    f = s * e[i-1];
	    b = c * e[i-1];
	    if (Math.abs(f) >= Math.abs(g)) {
	       c = g / f;
	       r = Math.sqrt((c * c) + 1.);
	       e[i] = f * r;
	       c *= (s = 1. / r);

	    } else {
	       s = f / g;
	       r = Math.sqrt((s * s) + 1.);
	       e[i] = g * r;
	       s *= (c = 1. / r);
	    }
	    g = d[i] - p;
	    r = (d[i-1] - g) * s + 2. * c * b;
	    p = s * r;
	    d[i] = g + p;
            g = c * r - b;
	    for (k = 1; k <= n; k++) {
	       f = z[k-1][i];
	       z[k-1][i] = s * z[k-1][i-1] + c * f;
	       z[k-1][i-1] = c * z[k-1][i-1] - s * f;
	    }
	 }
	 d[l-1] = d[l-1] - p;
	 e[l-1] = g;
	 e[m-1] = 0.;
      }
   } while (m != l);

   // Keep track of maximum number of iterations.

   if (iter > maxiter) maxiter = iter;
}

// printf_("tqli: maxiter= " + maxiter);

return 0;
}

// --------------------------------------------------------------------

static void eigsort_(int n, double d[], double v[][]) {

int i, j, k;
double s;

/* Sorts the elements of d and corresponding columns of 
   v into descending order. */

for (i = 1; i <= n-1; ++i) {
    k = i;
    s = d[i-1];
    for (j = i + 1; j <= n; ++j) {
        if (d[j-1] > s) {
            k = j;
            s = d[j-1];
        }
    }
    if (k > i) {
        d[k-1] = d[i-1];
        d[i-1] = s;
        for (j = 1; j <= n; ++j) {
            s = v[j-1][i-1];
            v[j-1][i-1] = v[j-1][k-1];
            v[j-1][k-1] = s;
        }
    }
}
}

// ----------------------------------------------------------------------

/* Test for eigenvec_()
main() {
// Test for tred2_ and itql_, Hornbeck, p. 258.

double d[WLSSZE], e[WLSSZE], chkmat[WLSSZE][WLSSZE], h[WLSSZE][WLSSZE];
int i, j, j1, n;

n = 4;
h[0][0] = 4.; h[0][1] = 2.; h[0][2] = 3.; h[0][3] = 7.;
h[1][0] = 2.; h[1][1] = 8.; h[1][2] = 5.; h[1][3] = 1.;
h[2][0] = 3.; h[2][1] = 5.; h[2][2] = 12.; h[2][3] = 9.;
h[3][0] = 7.; h[3][1] = 1.; h[3][2] = 9.; h[3][3] = 7.;
// tred2_(a,n,d,e);
// for (i = 0; i < n; ++i)  printf("d= %lf e= %lf\n",d[i],e[i]);
// tqli_(d,e,n,a);
eigenvec_(n,h,d);
for (i = 0; i < n; ++i) {
   printf("eigenvalue %d= %lf\n",i+1,d[i]);
   for (j = 0; j < n; ++j) printf("  %lf",h[j][i]);
   printf("\n");
}
// Check Spectral Decomposition.
for (i = 0; i < n; ++i) {
   for (j = 0; j < n; ++j) {
      chkmat[i][j] = 0.;
      for (j1 = 0; j1 < n; ++j1) {
         chkmat[i][j] += d[j1] * h[i][j1] * h[j][j1];
      }
   }
}
printf("Rebuilt matrix:\n");
for (i = 0; i < n; ++i) {
   for (j = 0; j < n; ++j) printf("  %lf",chkmat[i][j]);
   printf("\n");
}
} */

// -------------------------------------------------------------------

static double powerm_(double a[][], double x[], double tol, int n, int m) {

/* Power method for finding the largest eigenvalue.  From Johnson, L. W.
   and Riess, R. D. (1977), Numerical Analysis, Reading, Mass.:
   Addison- Wesley, p. 78.  In addition, x[] is the associated eigenvector.
*/

int i, j, itr = 1;

double estold, estnew = 0., temp = 0., yscale = 0.;

/* Test matrix, from Johnson and Riess, pp. 77-79.

n = 3;
a[0][0] = 1.; a[0][1] = -1.; a[0][2] = 2.;
a[1][0] = -2.; a[1][1] = 0.; a[1][2] = 5.;
a[2][0] = 6.; a[2][1] = -3.; a[2][2] = 6.;
x[0] = 1. / Math.sqrt(3.); x[1] = x[0]; x[2] = x[1];
*/

for (i = 0; i < n; ++i) {
   y[i] = 0.;
   for (j = 0; j < n; ++j) {
      y[i] += a[i][j] * x[j];
      // printf_("i= " + i + " j= " + j + " a= " + a[i][j]);
   }
}
for (i = 0; i < n; ++i) {
   temp += y[i] * x[i];
   yscale += y[i] * y[i];
}
yscale = Math.sqrt(yscale);
estold = temp;

// Power method iteration with scaling.

for (;;) {
   ++itr;
   for (i = 0; i < n; ++i) {
      x[i] = y[i] / yscale;
   }
   for (i = 0; i < n; ++i) {
      y[i] = 0.;
      for (j = 0; j < n; ++j) {
         y[i] += a[i][j] * x[j];
      }
   }
   temp = 0.;
   yscale = 0.;
   for (i = 0; i < n; ++i) {
      temp += y[i] * x[i];
      yscale += y[i] * y[i];
   }
   yscale = Math.sqrt(yscale);
   estnew = temp;

   /*
   printf_("powerm: itr= " + itr + " yscale= " + yscale +
      " estnew= " + estnew);
   */

   // Tests for termination of the Power method iteration.

   if (Math.abs((estnew - estold) / estold) <= tol) {
      return estnew;
   }
   if (itr >= m) {
      printf_("powerm: hit max number of iterations, " + m);
      return estnew;
   }
   estold = estnew;
}
}
}
