public class Estnetwork extends SNA {

/* Statistically estimates the parameters of a stochastic blockmodel
   of the trafficking network and then reconstructs the network as
   its expected value given the observations. */

static int nmnodes;

// ------------------------------------------------------------------

public static void estnet_(int netindex) {

/* Estimates a social network from an incomplete set of link
   observations. */

boolean newnode = false, linkfound = false;

String nodelabel;

int i, j, k = 0, l, i1, i2, ibig, nmattributes = 2, nmnets = 1, nmread = 0,
   nmlinksassigned, node1 = 0, node2 = 0, node3 = 0, intval = 0, maxsze,
   nmcommon, maxnmcommon = 1;

double val, wght;

nmnodes = SNA.nmnodes[netindex];
printf_("estnet: nmnodes= " + nmnodes + " nmalllinks= " + nmalllinks[0]);

// Assign links to networks.

for (i = 0; i < nmalllinks[0]; ++i) {
   linkused[i] = false;
}

net[0][0] = alllink[0][0][0];
net[0][1] = alllink[0][0][1];
alllink[1][nmalllinks[1]][0] = alllink[0][0][0];
alllink[1][nmalllinks[1]][1] = alllink[0][0][1];
nmalllinks[1] = 1;
netsze[0] = 2;
linkused[0] = true;
nmlinksassigned = 1;
checklinks: do {
   for (j = 0; j < nmnets; ++j) {
      for (k = 0; k < netsze[j]; ++k) {
         for (i = 0; i < nmalllinks[0]; ++i) {
            if (linkused[i]) {
               continue;
	    }
            if (alllink[0][i][0] == net[j][k] ||
                alllink[0][i][1] == net[j][k]) {
               if (alllink[0][i][0] != net[j][k]) {

		  // Add this node if it is unique.

		  newnode = true;
		  for (l = 0; l < netsze[j]; ++l) {
		     if (alllink[0][i][0] == net[j][l]) {
                        newnode = false;
			break;
                     }
		  }
		  if (newnode) {
                     net[j][netsze[j]] = alllink[0][i][0];
                     ++netsze[j];
                  }

	       } else if (alllink[0][i][1] != net[j][k]) {
		   
		  // Add this node if it is unique.

		  newnode = true;
		  for (l = 0; l < netsze[j]; ++l) {
		     if (alllink[0][i][1] == net[j][l]) {
                        newnode = false;
			break;
                     }
		  }
		  if (newnode) {
                     net[j][netsze[j]] = alllink[0][i][1];
                     ++netsze[j];
                  }
	       }
               alllink[j + 1][nmalllinks[j + 1]][0] = alllink[0][i][0];
               alllink[j + 1][nmalllinks[j + 1]][1] = alllink[0][i][1];
               ++nmalllinks[j + 1];
	       linkused[i] = true;
	       ++nmlinksassigned;
	       continue checklinks;
	    }
	 }
      }
   }

   // Find first unassigned link and start a new network with it.

   for (i = 0; i < nmalllinks[0]; ++i) {
      if (!linkused[i]) {
         net[nmnets][0] = alllink[0][i][0];
         net[nmnets][1] = alllink[0][i][1];
         alllink[nmnets + 1][nmalllinks[nmnets + 1]][0] = alllink[0][i][0];
         alllink[nmnets + 1][nmalllinks[nmnets + 1]][1] = alllink[0][i][1];
         nmalllinks[nmnets + 1] = 1;
         netsze[nmnets] = 2;
	 linkused[i] = true;
         ++nmlinksassigned;
         ++nmnets;
	 break;
      }
   }
} while (nmlinksassigned < nmalllinks[0]);

// Retain only the largest network.

for (i = 0; i < nmnets; ++i) {
   printf_("estnet: network " + (i + 1) + " nmnodes= " + netsze[i] +
      " nmlinks= " + nmalllinks[i + 1]);
}

ibig = 0;
maxsze = 0;
for (i = 0; i < nmnets; ++i) {
   if (maxsze < netsze[i]) {
      ibig = i;
      maxsze = netsze[i];
   }
}
for (j = 0; j < netsze[ibig]; ++j) {
   playerID[j] = allid[net[ibig][j] - 1];
   nmphones[j] = allphones[net[ibig][j] - 1];
   nmvehicles[netindex][j] = allvehicles[net[ibig][j] - 1];
   nmfirearms[j] = allfirearms[net[ibig][j] - 1];
   newnm[net[ibig][j] - 1] = j + 1;
}
for (j = 0; j < nmalllinks[ibig + 1]; ++j) {
   obslink[j][0] = newnm[alllink[ibig + 1][j][0] - 1];
   obslink[j][1] = newnm[alllink[ibig + 1][j][1] - 1];
   predlink[j][0] = obslink[j][0];
   predlink[j][1] = obslink[j][1];
}
nmnodes = netsze[ibig];
nmobslinks = nmalllinks[ibig + 1];
prednmlinks = nmobslinks;

printf_("Retained network: nmnodes= " + nmnodes + " prednmlinks= " +
   prednmlinks);

/* Add links and link weights formed by the number of evidence
   reports that list a pair of players. */

for (j = 0; j < nmnodes; ++j) {
   for (k = 0; k < j; ++k) {
      nmcommon = 0;
      for (i1 = 0; i1 < nmrpts[net[ibig][j] - 1]; ++i1) {
         for (i2 = 0; i2 < nmrpts[net[ibig][k] - 1]; ++i2) {
            if (noderpts[net[ibig][j] - 1]
			[i1].equals(noderpts[net[ibig][k] - 1][i2])) {
               ++nmcommon;
	    }
	 }
      }
      if (nmcommon == 0) {
         continue;
      }
      predlink[prednmlinks][0] = j + 1;
      predlink[prednmlinks][1] = k + 1;
      ++prednmlinks;
      if (maxnmcommon < nmcommon) {
         maxnmcommon = nmcommon;
      }
      rptwght[j][k] = (double) nmcommon;
   }
}
for (j = 0; j < nmnodes; ++j) {
   for (k = 0; k < j; ++k) {
      rptwght[j][k] /= (double) maxnmcommon;
   }
}

// Verify network connectedness.

for (i = 1; i <= nmnodes; ++i) {
   linkfound = false;
   for (j = 0; j < prednmlinks; ++j) {
      if (i == predlink[j][0] || i == predlink[j][1]) {
         linkfound = true;
	 break;
      }
   }
   if (!linkfound) {
      iderr_("estnet: i= " + i + " not connected");
   }
}

/* Compute the potential number of patterns of group memberships, and
   the potential number of links. */

nmlevelpttrns = ipow_(nmlevels, nmnodes);
if (nmlevelpttrns == 0) {
   nmlevelpttrns = 1;
}
nmlinks = nmnodes * (nmnodes - 1) / 2;
printf_("estnet: nmlevels= " + nmlevels + " nmlevelpttrns= " +
   nmlevelpttrns + " nmlinks= " + nmlinks);

// Read node attributes.  First, initialize the receiving array.

for (i = 0; i < nmattributes; ++i) {
   attributemax[i] = 0.;
   for (j = 0; j < nmnodes; ++j) {
      nodeattribute[j][i] = 0.;
   }
}

if (linksfletype == 1) {
   fleopen_(4, "sanet.dat", 'r');
   fgetstrng_(4);
   do {
      nodelabel = fgetstrng_(4);
      for (i = 0; i < nmnodes; ++i) {
         if (playerID[i].equals(nodelabel)) {
            for (j = 0; j < nmattributes; ++j) {
               val = (double) fgetint_(4);
               if (val > attributemax[j]) {
                  attributemax[j] = val;
               }
               nodeattribute[i][j] = val;
	    }
         }
      }
   } while (!checkeof_(4));
   fclose_(4, 'r');

} else if (linksfletype == 4) {

   // MEMEX file type.

   nmattributes = 3;
   for (i = 0; i < nmnodes; ++i) {
      val = (double) nmphones[i];
      if (val > attributemax[0]) {
         attributemax[0] = val;
      }
      nodeattribute[i][0] = val;

      val = (double) nmvehicles[netindex][i];
      if (val > attributemax[1]) {
         attributemax[1] = val;
      }
      nodeattribute[i][1] = val;

      val = (double) nmfirearms[i];
      if (val > attributemax[2]) {
         attributemax[2] = val;
      }
      nodeattribute[i][2] = val;
   }
}

/* Load the adjacency matrix.  Incorporate weights based on node
   attributes and number of evidence reports in common. */

for (i = 0; i < prednmlinks; ++i) {

   // Compute the link's weight.

   wght = 2.;
   for (j = 0; j < nmattributes; ++j) {
      val = Math.abs(nodeattribute[predlink[i][0] - 1][j] -
                     nodeattribute[predlink[i][1] - 1][j]);
      val /= 2. * attributemax[j];
      wght -= val;
      wght = 1.;
   }
   
   // Weight from number of evidence reports in common.

   wght += rptwght[predlink[i][0] - 1][predlink[i][1] - 1];

   predadjmat[predlink[i][0] - 1][predlink[i][1] - 1] = wght;
   predadjmat[predlink[i][1] - 1][predlink[i][0] - 1] = wght;
   adjmat[predlink[i][0] - 1][predlink[i][1] - 1] = wght;
   adjmat[predlink[i][1] - 1][predlink[i][0] - 1] = wght;
}

// Compute the degree of each node based on just the observed links.

degree_(nmnodes, nmobslinks, obslink, obsdegree);
degreesort_(nmnodes, obsdegree, obsindex);

nmunobslinks = nmlinks - nmobslinks;
if (nmunobslinks > 15) {

   /* Just entertain a few unobserved links.  Eventually, use a
      heuristic based on observed path lengths to decide which
      links are unobserved.  For example:

         if (obspathlength < 3 && link != 1) unobslink = true.
   */

kloop: for (k = 0; k < nmnodes; ++k) {
      for (l = (k + 1); l < nmnodes; ++l) {
         if (adjmat[k][l] < 1.e-6) {
            unobsadjmat[k][l] = true;
	    break kloop;
	 }
      }
   }
   nmunobslinks = 1;
}
if (nmunobslinks > 15) {
   iderr_("estnet: nmunobslinks= " + nmunobslinks + "way too big.");
}
nmunobslinkpttrns = ipow_(2, nmunobslinks);

printf_("estnet: nmlevelpttrns= " + nmlevelpttrns + " nmlinks= " + nmlinks +
   " nmunobslinkpttrns= " + nmunobslinkpttrns);

// Initialize parameters.

k = 0;
for (i = 0; i < nmlevels; ++i) {
   thetak[i] = 1. / ((double) nmlevels);
   if (i < nmlevels - 1) {
      par[k] = thetak[i];
      ++k;
   }

   for (j = i; j < nmlevels; ++j) {
      etakl[i][j] = .5;
      par[k] = etakl[i][j];
      ++k;
   }
}
for (i = 0; i < k; ++i) {
   Rndmsrch.g[i] = 0.;
   Rndmsrch.h[i] = 1.;
}
Optimiz.gimplicit[0] = 0.;
Optimiz.himplicit[0] = 1.;

// Find parameter estimates by maximizing the likelihood function.

Optimiz.n = k;
Rndmsrch.rndmsrch_(2, par, .00001);

// Print parameter estimates.

printf_("\nestnet: Random Search Parameter Estimates");
for (i = 0; i < nmlevels; ++i) {
   printf_("estnet: theta" + (i + 1) + "= " + thetak[i]);

   for (j = 0; j <= i; ++j) {
      printf_("estnet:    etakl(" + (i + 1) + (j + 1) + ")= " + etakl[i][j]);
   }
}
}

// ------------------------------------------------------------------

public static double blckmdlobjf_(double par[]) {

int i, j, k = 0;

Optimiz.cnstrnt[0] = 0.;
for (i = 0; i < nmlevels; ++i) {
   if (i < nmlevels - 1) {
      thetak[i] = par[k];
      Optimiz.cnstrnt[0] += thetak[i];
      ++k;

   } else {
      thetak[i] = 1. - Optimiz.cnstrnt[0];
   }

   for (j = 0; j <= i; ++j) {
      etakl[i][j] = par[k];
      ++k;
   }
}
if (Optimiz.cnstrnt[0] <= Optimiz.gimplicit[0] ||
    Optimiz.himplicit[0] <= Optimiz.cnstrnt[0]) {
   return (-1.e-2);
}

return (lklhd_());
}

// ------------------------------------------------------------------

public static double lklhd_() {

/* Computes the exact likelihood for a stochastic blockmodel having
   20 or fewer nodes.  A simulated likelihood is used for graphs
   having greater than 20 nodes.
   Used with Rndmsrch.java, the exact algorithm converges in about 7
   seconds on a 15-node network. */

int i, i1, j, j1, k, l, m, nmkl, nmedgeskl, n = 10;

double lnprbcomp1 = 0., lnprbcomp2 = 0., parval, lklhd = 0.;

/* Because group membership is unobserved, sum the likelihood across
   group membership patterns. */

for (i = 0; i < nmlevelpttrns; ++i) {
   radixcon_(nmlevels, nmnodes, i, cnvrtdnmbr);
   for (j = 0; j < nmnodes; ++j) {
      nodelevel[j] = cnvrtdnmbr[j] + 1;
   }

   // Compute number of nodes in group k.
   
   for (k = 1; k <= nmlevels; ++k) {
      nmlevelk[k - 1] = 0;
      for (j = 0; j < nmnodes; ++j) {
         if (nodelevel[j] == k) {
            ++nmlevelk[k - 1];
         }
      }
   }

   /* Compute the first component of the log of the probability of
      seeing the observed edge pattern and this pattern of groups on
      the nodes. */

   lnprbcomp1 = 0.;
   for (k = 1; k <= nmlevels; ++k) {
      lnprbcomp1 += nmlevelk[k - 1] * Math.log(thetak[k - 1]);
   }

   for (j = 0; j < nmunobslinkpttrns; ++j) {
      radixcon_(2, nmunobslinks, j, cnvrtdnmbr);

      /* Finish loading the edge array with this pattern of
         unobserved links. */

      m = 0;
      for (k = 0; k < nmnodes; ++k) {
         for (l = (k + 1); l < nmnodes; ++l) {
            if (unobsadjmat[k][l]) {
               adjmat[k][l] = cnvrtdnmbr[m];
               ++m;
            }
         }
      }

      /* Compute the likelihood of this pattern of group membership
         and this pattern of links. */

      if (nmnodes < 19) {
         lnprbcomp2 = 0.;
         for (k = 1; k <= nmlevels; ++k) {
            for (l = k; l <= nmlevels; ++l) {
   
               /* Compute number of edges that connect group k with
		  group l, and combinatoric terms on the number of
		  nodes in group k. */

               nmedgeskl = 0;
               for (i1 = 0; i1 < nmnodes; ++i1) {
                  for (j1 = (i1 + 1); j1 < nmnodes; ++j1) {
                     if (adjmat[i1][j1] == 0 || nodelevel[i1] != k ||
                         nodelevel[j1] != l) {
                        continue;
	             }
	             ++nmedgeskl;
	          }
	       }
	       if (k == l) {
                  nmedgeskl /= 2;
	          nmkl = Minmax.nchsk_(nmlevelk[k - 1], 2);

	       } else {
                  nmkl = nmlevelk[k - 1] * nmlevelk[l - 1];
	       }
	 
               /* Compute the second component of the log of the
		  probability of seeing the observed edge pattern
		  and this pattern of groups on the nodes. */

	       parval = etakl[k - 1][l - 1];
	       lnprbcomp2 += nmedgeskl * Math.log(parval) +
		             (nmkl - nmedgeskl) * Math.log(1. - parval);
            }
         }

      } else {

         /* Use simulation and the approximate graph distance
	    algorithm to compute a simulated likelihood value.
	    First, find the degree vector of the observed graph. */

         nmlinks = 0;
         for (k = 0; k < nmnodes; ++k) {
            for (l = (k + 1); l < nmnodes; ++l) {
               if (adjmat[k][l] > 1.e-12) {
                  link[nmlinks][0] = k + 1;
                  link[nmlinks][1] = l + 1;
                  ++nmlinks;
               }
            }
         }

         degree_(nmnodes, nmlinks, link, degree);
         degreesort_(nmnodes, degree, index);

	 // Sort group membership on the sorted degree scores.

	 for (k = 0; k < nmnodes; ++k) {
            idumvec[k] = nodelevel[index[k] - 1];
         }
	 for (k = 0; k < nmnodes; ++k) {
            nodelevel[k] = idumvec[k];
         }

	 // Simulate "n" graphs. 

         for (k = 0; k < n; ++k) {
   
            // Simulate a group for each player.

            for (l = 0; l < nmnodes; ++l) {
               levelsim[k][l] = Rndm.discrte_(0, thetak);
            }

            // Now, simulate potential links.

            nmlinks = 0;
            for (l = 0; l < nmnodes; ++l) {
               for (i1 = (l + 1); i1 < nmnodes; ++i1) {
	          unif = Rndm.rndm1_(0, 0);
	          if (unif < etakl[levelsim[k][l] - 1]
				  [levelsim[k][i1] - 1]) {
                     link[nmlinks][0] = (l + 1);
                     link[nmlinks][1] = (i1 + 1);
	             ++nmlinks;
                  } 
               }
            }
            /* Compute and store the degree of each node in this
               simulated network. */

            degree_(nmnodes, nmlinks, link, degreesim[k]);
            degreesort_(nmnodes, degreesim[k], index);
	 
	    // Sort group membership on the degree sort.

	    for (l = 0; l < nmnodes; ++l) {
               idumvec[l] = levelsim[k][index[l] - 1];
            }
	    for (l = 0; l < nmnodes; ++l) {
               levelsim[k][l] = idumvec[l];
            }
         }   

         // Compute the approximate density for the observed graph.

         lnprbcomp2 = Densest.densest4_(n, nmnodes, degreesim, levelsim,
            degree, nodelevel);

	 if (lnprbcomp2 > 0.) {
	    lnprbcomp2 = Math.log(lnprbcomp2);
	 } 

      } // End of simulated likelihood condition.
   
      /* Now, compute the log-probability of this group pattern and
         add it to the log-likelihood. */
   
      lklhd += lnprbcomp1 + lnprbcomp2;
   } // End of loop over unobserved link patterns.
} // End of loop over group patterns.
// iderr_("in lklhd");
printf_("estnet: lklhd= " + lklhd);
return (lklhd);
}

// ------------------------------------------------------------------

public static void reconstructnetwork_(int netindex) {

String strng1, strng2;

int i, j, nmgrp1, nmgrp2;

if (nmnodes > 5) {

   // Use a graph-based method to reconstruct the network.

   friends_();

} else {

   /* Use simulation to approximate the network's expected value
      given the observed links. */

   condexpct_();
}

/* Construct the link array that some of the centrality measure
   methods need. */

prednmlinks = 0;
for (i = 0; i < nmnodes; ++i) {
   for (j = (i + 1); j < nmnodes; ++j) {
      if (predadjmat[i][j] > 1.e-12) {
         predlink[prednmlinks][0] = i + 1;
         predlink[prednmlinks][1] = j + 1;
         ++prednmlinks;
      }
   }
}

/* Print expected group membership of each player.  Also, write a
   Pajek-readable file of predicted group memberships.  File number
   5 was opened above. */

fleopen_(3, "estnet.clu", 'w');
fprintf_(3, "*Vertices " + nmnodes);

fleopen_(4, "estnet.net", 'w');
fprintf_(4, "*Vertices " + nmnodes);

strng1 = "Group 1: ";
strng2 = "\nGroup 2: ";
nmgrp1 = 0;
nmgrp2 = 0;
for (i = 0; i < nmnodes; ++i) {
   if (prednodelevel[i] == 1) {
      strng1 += " " + playerID[i];
      ++nmgrp1;
      if (nmgrp1 == 12) {
         strng1 += "\n";
	 nmgrp1 = 0;
      }

   } else {
      strng2 += " " + playerID[i];
      ++nmgrp2;
      if (nmgrp2 == 12) {
         strng2 += "\n";
	 nmgrp2 = 0;
      }
   }
   fprintf_(3, " " + prednodelevel[i]);
   fprintf_(4, (i + 1) + " \"" + playerID[i] + "\"");
}
fclose_(3, 'w');

/* Print observed and reconstructed links.
printf_("\nObserved Links (nmobslinks= " + nmobslinks + ")");
for (i = 0; i < nmobslinks; ++i) {
   printf_(" " + obslink[i][0] + " " + obslink[i][1]);
}
*/

// Also, write a Pajek-readable file of the reconstructed network.

fprintf_(4, "*Edges");

printf_("\nPredicted Links (prednmlinks= " + prednmlinks + ")");
for (i = 0; i < prednmlinks; ++i) {
   fprintf_(4, predlink[i][0] + " " + predlink[i][1]);
}
fclose_(4, 'w');
}

// ------------------------------------------------------------------

public static void condexpct_() {

/* Simulate m networks.  For those that contain the observed links,
   sum the realizations on each player's group and each link. */

int i, j, k, l, n, m = 100000, nmlinks, nmcondevents = 0;

double unifval = 0., grphdist = 0., val = 0.;

// Initialize predicted adjacency matrix.

for (i = 0; i < nmnodes; ++i) {
   for (j = 0; j < nmnodes; ++j) {
      predadjmat[i][j] = 0.;
   }
}

for (i = 0; i < m; ++i) {
   
   // Simulate a group for each player.

   for (j = 0; j < nmnodes; ++j) {
      nodelevel[j] = Rndm.discrte_(0, thetak);
   }

   // Now, simulate potential links.

   nmlinks = 0;
   for (j = 0; j < nmnodes; ++j) {
      for (k = (j + 1); k < nmnodes; ++k) {
	 unifval = Rndm.rndm1_(0, 0);
	 if (unifval < etakl[nodelevel[j] - 1][nodelevel[k] - 1]) {
            link[nmlinks][0] = (j + 1);
            link[nmlinks][1] = (k + 1);
	    ++nmlinks;
         } 
      }
   }

   // Compute the degree of each node in this simulated network.

   degree_(nmnodes, nmlinks, link, degree);
   degreesort_(nmnodes, degree, index);

   // Predict if the observed network is a subset of this network.

   grphdist = grphdist_(true, nmnodes, obsdegree, nodelevel, degree,
      nodelevel);

   if (grphdist > 0.) {
      continue;
   }

   // Now check if this network has all of the observed links.

   for (j = 0; j < nmobslinks; ++j) {
      grphdist = 1.;
      ORDERLOOP: for (l = 0; l < nmnodes; ++l) {
         for (n = (l + 1); n < nmnodes; ++n) {
            if (((obsindex[l] == obslink[j][0]) &&
                 (obsindex[n] == obslink[j][1])) ||
                ((obsindex[l] == obslink[j][1]) &&
                 (obsindex[n] == obslink[j][0]))) {
               for (k = 0; k < nmlinks; ++k) {
                  if (((index[l] == link[k][0]) &&
                       (index[n] == link[k][1])) ||
                      ((index[l] == link[k][1]) &&
                      (index[n] == link[k][0]))) {
                     grphdist = 0.;
                     break ORDERLOOP;
                  }
	       }
            }
	 }
      }
      if (grphdist > 0.) {
         break;
      }
   }
   if (grphdist > 0.) {
      continue;
   }
   ++nmcondevents;

   // Accumulate these simulated groups.

   for (j = 0; j < nmnodes; ++j) {
      prednodelevel[j] += nodelevel[index[j] - 1];
   }

   // Accumulate these simulated links.

   for (j = 0; j < nmnodes; ++j) {
      for (k = (j + 1); k < nmnodes; ++k) {
         for (l = 0; l < nmlinks; ++l) {
            if (((index[j] == link[l][0]) &&
                 (index[k] == link[l][1])) ||
                ((index[j] == link[l][1]) &&
                 (index[k] == link[l][0]))) {
               if (obsindex[j] < obsindex[k]) {
                  predadjmat[obsindex[j] - 1][obsindex[k] - 1] += 1.;

	       } else {
                  predadjmat[obsindex[k] - 1][obsindex[j] - 1] += 1.;
	       }
	    }
	 }
      }
   }
}
if (nmcondevents == 0) {
   iderr_("condexpt: nmcondevents=0");
}
printf_("\ncondexpt: Number of conditioning events= " + nmcondevents);

// Now, take averages to arrive at the reconstructed network.

for (i = 0; i < nmnodes; ++i) {
   val = ((double) prednodelevel[i]) / ((double) nmcondevents);
   prednodelevel[i] = (int) Math.round(val);
   for (j = (i + 1); j < nmnodes; ++j) {
      predadjmat[i][j] /= ((double) nmcondevents);

      /* printf_("condexpt: i= " + i +  " j= " + j + " pam= " +
            predadjmat[i][j]); */

      if (predadjmat[i][j] < .5) {
         predadjmat[i][j] = 0.;

      } else {
         predadjmat[i][j] = 1.;
      }

      // Make this a proper, symmetric adjacency matrix.
      
      predadjmat[j][i] = predadjmat[i][j];
   }
}
}

// ------------------------------------------------------------------

public static void friends_() {

/* Adds a link to a pair if their Total Friends or Common Friends
   count is high. */

int i, j, k, l, nodei, nodej, nmifriends, nmjfriends, cfscore, tfscore,
  nmlnkscrs = 0, nmnolnkscrs = 0;

double cfthrshld, tfthrshld;
   
for (i = 0; i < nmnodes; ++i) {
   nodei = i + 1;

   // Find "nodei"'s friends.
   
   nmifriends = 0;
   for (k = 0; k < nmobslinks; ++k) {
      if (obslink[k][0] == nodei) {
         friendi[nmifriends] = obslink[k][1];
         ++nmifriends;

      } else if (obslink[k][1] == nodei) {
         friendi[nmifriends] = obslink[k][0];
         ++nmifriends;
      }
   }
   for (j = 0; j < i; ++j) {
      nodej = j + 1;

   
      // Find "nodej"'s friends.

      nmjfriends = 0;
      for (k = 0; k < nmobslinks; ++k) {
         if (obslink[k][0] == nodej) {
            friendj[nmjfriends] = obslink[k][1];
            ++nmjfriends;

	 } else if (obslink[k][1] == nodej) {
            friendj[nmjfriends] = obslink[k][0];
            ++nmjfriends;
	 }
      }

      /* Compute Common Friends: the number of friends that nodei and
         nodej have in common.

         Compute Total Friends: the total number of players
         connected to each player minus the number of duplicates. */

      cfscore = 0;
      tfscore = nmifriends + nmjfriends;
      for (k = 0; k < nmifriends; ++k) {
         for (l = 0; l < nmjfriends; ++l) {
            if (friendi[k] == friendj[l]) {
               ++cfscore;
               --tfscore;
	       break;
	    }
	 }
      }	

      // Store separately the scores of the linked, and unlinked pairs.

      if (Math.abs(predadjmat[i][j]) > 1.e-12) {
         linkcfscr[nmlnkscrs] = (double) cfscore;
         linktfscr[nmlnkscrs] = (double) tfscore;
         ++nmlnkscrs;

      } else {
         nolinkcfscr[nmnolnkscrs] = (double) cfscore;
	 if (nolinkcfscr[nmnolnkscrs] > 1) {
	 }
         nolinktfscr[nmnolnkscrs] = (double) tfscore;
	 if (nolinktfscr[nmnolnkscrs] > 25.) {
	 }
         ++nmnolnkscrs;
      }
   }
}

/* Compute threshold values as particular percentiles of each type of
   score. */

cfthrshld = Summry.quantile_(nmlnkscrs, linkcfscr, .9); // was .8
tfthrshld = Summry.quantile_(nmlnkscrs, linktfscr, .9999); // was .9
tfthrshld = 100.;
/*
printf_("friends: cfthrshld= " + cfthrshld + " tfthrshld= " +
   tfthrshld);
*/

/* Predict a link for those pairs having either a high Common Friends
   score or a high Total Friends score. */

nmnewlinks = 0;
k = 0;
for (i = 0; i < nmnodes; ++i) {
   nodei = i + 1;
   for (j = 0; j < i; ++j) {
      nodej = j + 1;
      if (Math.abs(predadjmat[i][j]) <= 1.e-12) {
	 if (nolinkcfscr[k] > cfthrshld ||
             nolinktfscr[k] > tfthrshld) {
            predlink[prednmlinks][0] = nodei;
	    predlink[prednmlinks][1] = nodej;
	    ++prednmlinks;
	    predadjmat[i][j] = 1.;
	    predadjmat[j][i] = 1.;

            newlink[nmnewlinks][0] = nodei;
	    newlink[nmnewlinks][1] = nodej;
	    ++nmnewlinks;
	 }
         ++k;
      }
   }
}

/* Predict group membership based on the player's degree value.  First,
   compute the predicted network's degree centrality values. */

degree_(nmnodes, prednmlinks, predlink, preddegree);
degreesort_(nmnodes, preddegree, predindex);

for (i = 0; i < nmnodes; ++i) {
   if (preddegree[i] < 2.) {
      prednodelevel[predindex[i] - 1] = 1;

   } else {
      prednodelevel[predindex[i] - 1] = 2;
   }
}
}

// -----------------------------------------------------------------

static void degreesort_(int nmnodes, double degreecent[], int index[]) {

// Sort players on descending Degree score.

int i;

for (i = 0; i < nmnodes; ++i) {
   index[i] = i + 1;
   degreecent[i] *= -1;
}
Idsort.idsort_(degreecent, index, 1, nmnodes);
for (i = 0; i < nmnodes; ++i) {
   degreecent[i] *= -1;
}
}
}
