class Fitlogit extends Readnet {

static int nmtofit, node, nmvals, nmnghs;
static int fitnodes[] = new int[TNMNDS];
static int intprntvals[] = new int[6];

static double prntvals[] = new double[6];
static double continvals[][] = new double[TNMNDS][3];
static double x[] = new double[OPTSIZE];
static double g[] = new double[OPTSIZE];
static double h[] = new double[OPTSIZE];

// ---------------------------------------------------------------------

static void fitlogit_() {

/* Fits "node"'s logit parameters to the set of conditional
   probabilities read from the .par file.  Stores these fitted values
   in the array "logit_pars[idnmbrm1][node - 1][].".  The number of logit
   parameters is read-in from the "parameters" statement in the .id
   file (analyst is responsible for correctly counting the number of
   parameters for the specified Logit model).
   This number of parameters is stored in
   "varinfo_nmparms[idnmbrm1][node - 1]". */

int i, j, n;

double sum, probi, lhs, rhs;

fprintf_(1,"\n--------Logit Model Approximations---------" +
	   "\n Parameter       Estimate");

for (i = 0; i < nmtofit; ++i) {
   node = fitnodes[i];
   fprintf_(1, "Node: " + nodelbls[idnmbrm1][node - 1][0]);

   nmvals = nodenghs[idnmbrm1][node - 1][0];
   nmnghs = nodenghs[idnmbrm1][node - 1][1];
   n = varinfo_nmparms[idnmbrm1][node - 1];

   // Set initial solution and bounds.

   for (j = 0; j < n; ++j) {
      x[j] = logit_pars[idnmbrm1][node - 1][j];
      g[j] = -10.;
      h[j] = 10.;
   }

   // Minimize the objective function.

   Optimiz.optimiz_(n, 0, x, g, h, 5);

   // Place solution into "logit_pars."

   for (j = 0; j < n; ++j) {
      logit_pars[idnmbrm1][node - 1][j] = x[j];
      fprintf_(1, "  " + j + "    " + logit_pars[idnmbrm1][node - 1][j]);
   }
   fprintf_(1, "\n");
}

/* Check probability computation.
intprntvals[0] = 2;
intprntvals[1] = 3;
sum = 0.;
for (i = 1; i < nmvals; ++i) {
   rhs = Math.exp(Update.complogit_(node, i, prntvals));
   probi = logitprob_(i);
   sum += probi;
   lhs = sum / (1. - sum);
   printf_("P(" + (i) + ")= " + probi + " lhs= " + lhs + " rhs= " + rhs +
      " diff= " + (lhs - rhs));
}
printf_("P(" + (nmvals) + ")= " + (1. - sum));
*/

// Rewrite the .par file.

Writenet.writenet_(1, 1, false);
}

// ----------------------------------------------------------------------

static double objf_(int n, double x[]) {

// Logit-approximating objective function.

int i, j1, j2, j3, j4, j5, j6;

double prob, logitprob, sumdif = 0.;

// Load logit parameter array from optimization variable array.

for (i = 0; i < n; ++i) {
   logit_pars[idnmbrm1][node - 1][i] = x[i];
}

/* Loop over all parent value combinations and sum all relative
   differences between target probabilities and logit-computed
   probabilities. */

if (nmnghs == 1) {
   ngh1 = nodenghs[idnmbrm1][node - 1][2];
   nmvalngh1 = nodenghs[idnmbrm1][ngh1 - 1][0];

   // If the parent is continuous, reset its number of values to 3.

   if (nmvalngh1 == 1) {
      nmvalngh1 = 3;
   }

   for (j1 = 0; j1 < nmvalngh1; ++j1) {
      sumdif += reldif_(j1, 0, 0, 0, 0, 0);
   }

} else if (nmnghs == 2) {
   ngh1 = nodenghs[idnmbrm1][node - 1][2];
   ngh2 = nodenghs[idnmbrm1][node - 1][3];
   nmvalngh1 = nodenghs[idnmbrm1][ngh1 - 1][0];
   nmvalngh2 = nodenghs[idnmbrm1][ngh2 - 1][0];
   for (j1 = 0; j1 < nmvalngh1; ++j1){
      for (j2 = 0; j2 < nmvalngh2; ++j2){
         sumdif += reldif_(j1, j2, 0, 0, 0, 0);
      }
   }

} else if (nmnghs == 3) {
   ngh1 = nodenghs[idnmbrm1][node - 1][2];
   ngh2 = nodenghs[idnmbrm1][node - 1][3];
   ngh3 = nodenghs[idnmbrm1][node - 1][4];
   nmvalngh1 = nodenghs[idnmbrm1][ngh1 - 1][0];
   nmvalngh2 = nodenghs[idnmbrm1][ngh2 - 1][0];
   nmvalngh3 = nodenghs[idnmbrm1][ngh3 - 1][0];
   for (j1 = 0; j1 < nmvalngh1; ++j1){
      for (j2 = 0; j2 < nmvalngh2; ++j2){
         for (j3 = 0; j3 < nmvalngh3; ++j3){
            sumdif += reldif_(j1, j2, j3, 0, 0, 0);
         }
      }
   }

} else if (nmnghs == 4) {
   ngh1 = nodenghs[idnmbrm1][node - 1][2];
   ngh2 = nodenghs[idnmbrm1][node - 1][3];
   ngh3 = nodenghs[idnmbrm1][node - 1][4];
   ngh4 = nodenghs[idnmbrm1][node - 1][5];
   nmvalngh1 = nodenghs[idnmbrm1][ngh1 - 1][0];
   nmvalngh2 = nodenghs[idnmbrm1][ngh2 - 1][0];
   nmvalngh3 = nodenghs[idnmbrm1][ngh3 - 1][0];
   nmvalngh4 = nodenghs[idnmbrm1][ngh4 - 1][0];
   for (j1 = 0; j1 < nmvalngh1; ++j1){
      for (j2 = 0; j2 < nmvalngh2; ++j2){
         for (j3 = 0; j3 < nmvalngh3; ++j3){
            for (j4 = 0; j4 < nmvalngh4; ++j4){
               sumdif += reldif_(j1, j2, j3, j4, 0, 0);
            }
         }
      }
   }

} else if (nmnghs == 5) {
   ngh1 = nodenghs[idnmbrm1][node - 1][2];
   ngh2 = nodenghs[idnmbrm1][node - 1][3];
   ngh3 = nodenghs[idnmbrm1][node - 1][4];
   ngh4 = nodenghs[idnmbrm1][node - 1][5];
   ngh5 = nodenghs[idnmbrm1][node - 1][6];
   nmvalngh1 = nodenghs[idnmbrm1][ngh1 - 1][0];
   nmvalngh2 = nodenghs[idnmbrm1][ngh2 - 1][0];
   nmvalngh3 = nodenghs[idnmbrm1][ngh3 - 1][0];
   nmvalngh4 = nodenghs[idnmbrm1][ngh4 - 1][0];
   nmvalngh5 = nodenghs[idnmbrm1][ngh5 - 1][0];
   for (j1 = 0; j1 < nmvalngh1; ++j1){
      for (j2 = 0; j2 < nmvalngh2; ++j2){
         for (j3 = 0; j3 < nmvalngh3; ++j3){
            for (j4 = 0; j4 < nmvalngh4; ++j4){
               for (j5 = 0; j5 < nmvalngh5; ++j5){
                  sumdif += reldif_(j1, j2, j3, j4, j5, 0);
               }
            }
         }
      }
   }
 
} else if (nmnghs == 6) {
   ngh1 = nodenghs[idnmbrm1][node - 1][2];
   ngh2 = nodenghs[idnmbrm1][node - 1][3];
   ngh3 = nodenghs[idnmbrm1][node - 1][4];
   ngh4 = nodenghs[idnmbrm1][node - 1][5];
   ngh5 = nodenghs[idnmbrm1][node - 1][6];
   ngh6 = nodenghs[idnmbrm1][node - 1][7];
   nmvalngh1 = nodenghs[idnmbrm1][ngh1 - 1][0];
   nmvalngh2 = nodenghs[idnmbrm1][ngh2 - 1][0];
   nmvalngh3 = nodenghs[idnmbrm1][ngh3 - 1][0];
   nmvalngh4 = nodenghs[idnmbrm1][ngh4 - 1][0];
   nmvalngh5 = nodenghs[idnmbrm1][ngh5 - 1][0];
   nmvalngh6 = nodenghs[idnmbrm1][ngh5 - 1][0];
   for (j1 = 0; j1 < nmvalngh1; ++j1){
      for (j2 = 0; j2 < nmvalngh2; ++j2){
         for (j3 = 0; j3 < nmvalngh3; ++j3){
            for (j4 = 0; j4 < nmvalngh4; ++j4){
               for (j5 = 0; j5 < nmvalngh5; ++j5){
                  for (j6 = 0; j6 < nmvalngh6; ++j6){
                     sumdif += reldif_(j1, j2, j3, j4, j5, j6);
		  }
               }
            }
         }
      }
   }
}

return -sumdif;
}

// -----------------------------------------------------------------------

static double reldif_(int j1, int j2, int j3, int j4, int j5, int j6) {

// Computes the relative absolute difference.

int k;

double prob, logitprob, relabsdif = 0.;

// Load parent values.

intprntvals[0] = j1 + 1;
intprntvals[1] = j2 + 1;
intprntvals[2] = j3 + 1;
intprntvals[3] = j4 + 1;
intprntvals[4] = j5 + 1;
intprntvals[5] = j6 + 1;
for (k = 0; k < 6; ++k) {
   prntvals[k] = intprntvals[k];
}

if (nmnghs == 1 && nodenghs[idnmbrm1][ngh1 - 1][0] == 1) {

   // Load value of the single continuous predictor.

   prntvals[0] = continvals[ngh1 - 1][j1];
}

for (k = 1; k <= nmvals - 1; ++k){
   prob = condprb[idnmbrm1][node - 1][k - 1][j1][j2][j3][j4][j5][j6][0];
   relabsdif += Math.abs(prob - logitprob_(k)) / prob;
}

return relabsdif;
}

// ----------------------------------------------------------------------

static double logitprob_(int val) {

/* Computes a probability of one of the first nmvals - 1 values of a
   Logit random node. */

int i, k;

double explogit, prob = 0., prob1 = 0.;

double dumvals[][] = new double[1][6];

for (i = 0; i < 6; ++i) {
   dumvals[0][i] = prntvals[i];
}

if (nmvals == 2) {

   // Binary logit model.  First, compute logit.

   explogit = Math.exp(Update.complogit_(0, node, 1, dumvals));

   // Compute probability.

   prob = explogit / (1. + explogit);

} else if (nmvals == 3) {

   // Cumulative Logit model.  Currently, only the "nmvals=3" case is coded.

   prob1 = Math.exp(Update.complogit_(0, node, 1, dumvals));
   prob1 = prob1 / (1. + prob1);
   if (val == 1) {
      return prob1;
   }

   prob = Math.exp(Update.complogit_(0, node, 2, dumvals));
   prob = (prob - prob1 * (1. + prob)) / (1. + prob);

} else {
   iderr_("logitprob: nmvals= " + nmvals);
}

return prob;
}
}
