import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class GISutils extends GISwind {

static boolean iscoloc1[] = new boolean[MAXNMOBJCTS];
static boolean iscoloc2[] = new boolean[MAXNMOBJCTS];

static int nmrows = 0, nmcols = 0, nmflesperimage = 0, nmbands = 0;

static short pxlbandval[][][] = new short[MAXNMPXLS][MAXNMPXLS][MAXNMBANDS];
static short spctrlsignature[][] = new short[2][4];
static short p1colors[] = new short[4];
static short p2colors[] = new short[4];

static int object[][][] = new int[MAXNMOBJCTS][500][2];
static int objloc[][][] = new int[2][MAXNMOBJCTS][2];
static int coloc[][] = new int[MAXNMOBJCTS][2];
static int nmpxls[] = new int[MAXNMOBJCTS];
static int nmobjs[] = new int[2];
static int nmunique[] = new int[2];

static double tol = .015;
static double animalpredvar[][] = new double[MAXNMOBJCTS][3];

// ----------------------------------------------------------------------

static void abundest_(GISwind giswind, String animalfilename[][]) {

// Estimate animal abundance by finding objects in satellite raster images.

short val, minval = 0, maxval = 255;

int i, j, k, l, c = 0, o = 0, abundance = 0, inflenm = 9;

double mindist1 = 1.e6, mindist2 = 1.e6, minsep = 2., intrpxldist = 0., difx,
   dify, dist, maxlngth = 0., pa = 0., thrshld = .6, beta0 = -1., betaf = 3.,
   fval = 0.;

/* Specify the animal's spectral signature.  To discover this signature from
   an existing image, use Paint as follows:
   1. Load image into Paint.
   2. Click "Color Picker" in the Tools area of the toolbar.
   3. Click in the middle of an animal object.
   4. Click "Edit Colors" and read-off the RGB values.
*/

nmbands = 4;
spctrlsignature[0][0] = 145; // red
spctrlsignature[0][1] = 143; // green
spctrlsignature[0][2] = 131; // blue
spctrlsignature[0][3] = 0;

spctrlsignature[1][0] = 154; // red
spctrlsignature[1][1] = 136; // green
spctrlsignature[1][2] = 122; // blue
spctrlsignature[1][3] = 0;

// Read images and count objects.

for (i = 0; i < 2; ++i) {

   /* Open ENVI 4-band image file(s) and read one pixel at a time.  If the
      file is bigger than 2 GB, you may need to read it in chunks at a time.
      The DOS command "dir" will give the number of bytes in the file.
      This code assumes the ENVI image file is in Band Interleaved by Pixel
      (.bip) format.  The number of rows, columns, and bands are read from
      the associated header file (filename.hdr). */

   nmrows = 2773;
   nmcols = 3698;

   if (nmrows > MAXNMPXLS || nmcols > MAXNMPXLS) {
      Run_id.iderr_("abundest: nmrows= " + nmrows + " nmcols= " + nmcols);
   }

   // Set the maximum size of an animal (units = numbers-of-pixels).

   maxlngth = 8.;

   // Read images.
   
   if (nmflesperimage == 1) {
      Run_id.fleopen_(inflenm, animalfilename[i][0], 'r');
      for (j = 0; j < nmrows; ++j) {
         for (k = 0; k < nmcols; ++k) {
            for (l = 0; l < nmbands; ++l) {
               val = (short) Run_id.fgetunsigned8int_(inflenm);

               // Check for a valid spectral value.

               if (val < minval || maxval < val) {
                  Run_id.iderr_("abundest: j= " + j + " k= " + k +
                     " l= " + l + " val= " + val);
               }
	       pxlbandval[j][k][l] = val;
            }
         }
      }
      Run_id.fclose_(inflenm, 'r');

   } else if (nmflesperimage == 3 || nmflesperimage == 4) {
      for (l = 0; l < nmbands; ++l) {
         Run_id.fleopen_(inflenm, animalfilename[i][l], 'r');
         for (j = 0; j < nmrows; ++j) {
            for (k = 0; k < nmcols; ++k) {
               val = (short) Run_id.fgetunsigned8int_(inflenm);

               // Check for a valid spectral value.

               if (val < minval || maxval < val) {
                  Run_id.iderr_("abundest: j= " + j + " k= " + k +
                     " l= " + l + " val= " + val);
               }
	       pxlbandval[j][k][l] = val;
            }
         }
         Run_id.fclose_(inflenm, 'r');
      }
   }

   // Find all objects in this multispectral image.

   nmobjs[i] = tally_(spctrlsignature[i], maxlngth, objloc[i]);
   Run_id.printf_("abundest: i= " + i + " nmobjs= " + nmobjs[i]);
}

/* Identify all colocated objects between the two images and flag these
   in both images. */

for (i = 0; i < nmobjs[0]; ++i) {
   for (j = 0; j < nmobjs[1]; ++j) {
      if ((Math.abs(objloc[0][i][0] - objloc[1][j][0]) < minsep) &&
          (Math.abs(objloc[0][i][1] - objloc[1][j][1]) < minsep)) {
         coloc[c][0] = objloc[0][i][0];
         coloc[c][1] = objloc[0][i][1];
	 ++c;
	 iscoloc1[i] = true;
	 iscoloc2[j] = true;
      }
   }
}
Run_id.printf_("abundest: number of colocated objects= " + c);

/* Find the number of unique objects in each image by subtracting off
   the number of colocated objects from each image's number of objects. */

for (i = 0; i < 2; ++i) {
   nmunique[i] = nmobjs[i] - c;
   Run_id.printf_("abundest: i= " + i + " nmunique= " + nmunique[i]);
}

// If the images are identical, assume all objects are animals.
 
if (animalfilename[1][0].equals(animalfilename[0][0])) {
   Run_id.printf_("abundest: identical images, abundance= " + c);

   return;
}

// Set the inter-pixel distance (in meters).

intrpxldist = .7789;

// Estimate colocated objects that are animals.

for (i = 0; i < c; ++i) {

   /* Find the distance from this colocated object to the nearest animal
      in each image that is not a colocated object. */

   mindist1 = 1.e6;
   for (j = 0; j < nmobjs[0]; ++j) {
      if (iscoloc1[j]) {
         continue;
      }
      difx = Math.abs(coloc[i][0] - objloc[0][j][0]);
      dify = Math.abs(coloc[i][1] - objloc[0][j][1]);
      dist = Math.sqrt(difx * difx + dify * dify);
      if (dist < mindist1) {
         mindist1 = dist;
      }
   }
   mindist2 = 1.e6;
   for (j = 0; j < nmobjs[1]; ++j) {
      if (iscoloc2[j]) {
         continue;
      }
      difx = Math.abs(coloc[i][0] - objloc[1][j][0]);
      dify = Math.abs(coloc[i][1] - objloc[1][j][1]);
      dist = Math.sqrt(difx * difx + dify * dify);
      if (dist < mindist2) {
         mindist2 = dist;
      }
   }

   /* Use the maximum of these two distances for the distance (in meters)
      from the colocated object to the nearest animal. */

   fval = intrpxldist * Math.max(mindist1, mindist2);

   // Compute the probability that a colocated object is an animal.

   pa = beta0 + betaf * (1. / (1. + fval));
   pa = Math.exp(-pa);
   pa = 1. / (1. + pa);

   /* Decide that the object is an animal if its probability is above a
      threshold value. */

   if (pa > thrshld) {
      ++o;
   }
}

// Estimate abundance for the area covered by these two images.

abundance = (int) Math.round(.5 * ((double) (nmunique[0] + nmunique[1]))) + o;
Run_id.iderr_("abundest: abundance= " + abundance);

return;
}

// ----------------------------------------------------------------------

static int tally_(short spctrlsig[], double maxlngth, int objcenter[][]) {

/* Detects (and counts) objects in an image.  Objects have a pre-defined
   combination of red, green, and blue.  Also, objects hava pre-defined
   length.  This method is the first step toward estimating the number of
   large mammals in an image. */

int i, j, k, l, m, p1row, p1col, p1grey, p2row, p2col, p2grey, nmobjects = 0,
   p1object, nmsignaturebands = 3, rowstart = 0, rowend = 0, colstart = 0,
   colend = 0, cliprowstart = 0, cliprowend = 0, clipcolstart = 0,
   clipcolend = 0;

double rowsum = 0., colsum = 0., diffrow, diffcol, tlngth = 0., lngth = 0.,
   fracdiff = 0.;

// Initialize.

for (i = 0; i < MAXNMOBJCTS; ++i) {
   nmpxls[i] = 0;
}

// Process each pixel.

cliprowstart = 918;
cliprowend = 1253;
clipcolstart = 1466;
clipcolend = 1796;

for (i = cliprowstart; i < cliprowend; ++i) {
   MAINCOLLOOP: for (j = clipcolstart; j < clipcolend; ++j) {
      p1row = i + 1;
      p1col = j + 1;

      for (k = 0; k < nmsignaturebands; ++k) {
         p1colors[k] = pxlbandval[i][j][k];

         // Skip pixels that do not have the animal's spectral signature.

         fracdiff = (double) Math.abs(p1colors[k] - spctrlsig[k]);
         fracdiff = fracdiff / (spctrlsig[k] + 1.);
         if (fracdiff > tol) {
            continue MAINCOLLOOP;
         }
      }

      // Find the object that p1 belongs to.

      p1object = 0;
      rowstart = Math.max(p1row - 1, 1);
      rowend = Math.min(p1row + 1, nmrows);
      SCNDROWLP: for (p2row = rowstart; p2row <= rowend; ++p2row) {
         colstart = Math.max(p1col - 1, 1);
         colend = Math.min(p1col + 1, nmcols);
         SCNDCOLLP: for (p2col = colstart; p2col <= colend; ++p2col) {
            for (k = 0; k < nmsignaturebands; ++k) {
               p2colors[k] = pxlbandval[p2row - 1][p2col - 1][k];

	       // Check that p1 and p2 have a similar colors.

               fracdiff = (double) Math.abs(p1colors[k] - p2colors[k]);
               fracdiff = fracdiff / (p2colors[k] + 1.);
               if (fracdiff > tol) {
	          continue SCNDCOLLP;
	       }
            }

	    // Check if p2 is already in any object.

	    for (k = 0; k < nmobjects; ++k) {
               for (l = 0; l < nmpxls[k]; ++l) {
                  if (p2row == object[k][l][0] && p2col == object[k][l][1]) {
                     p1object = k + 1;
		     break SCNDROWLP;
		  }
               }
	    }
	 }
      }

      // Start a new object if none is found above.

      if (p1object == 0) {
         object[nmobjects][0][0] = p1row;
         object[nmobjects][0][1] = p1col;
         nmpxls[nmobjects] = 1;
	 ++nmobjects;

	 if (nmobjects == MAXNMOBJCTS) {
            Run_id.iderr_("tally: i= " + i + " j= " + j +
               " nmobjects=MAXNMOBJCTS");
	 }

	 p1object = nmobjects;
      }

      /* Check all pixels within one row and/or column of p1, i.e., check
         only those pixels that are touching p1. */

      for (p2row = rowstart; p2row <= rowend; ++p2row) {
         COLLP: for (p2col = colstart; p2col <= colend; ++p2col) {
            if (p2row == p1row && p2col == p1col) {
	       continue;
	    }
            for (k = 0; k < nmsignaturebands; ++k) {
               p2colors[k] = pxlbandval[p2row - 1][p2col - 1][k];

	       // Check p2 against the object's spectral signature.

               fracdiff = (double) Math.abs(p2colors[k] - spctrlsig[k]);
               fracdiff = fracdiff / (spctrlsig[k] + 1.);
               if (fracdiff > tol) {
	          continue COLLP;
	       }
            }

	    // Check if p2 is already in any object.

	    for (k = 0; k < nmobjects; ++k) {
               for (l = 0; l < nmpxls[k]; ++l) {
                  if (p2row == object[k][l][0] && p2col == object[k][l][1]) {
                     continue COLLP;
		  }
               }
	    }

	    // Check if p2 would make p1's object too big.
	    
	    for (k = 0; k < nmpxls[p1object - 1]; ++k) {
               diffrow = (double) (p2row - object[p1object - 1][k][0]);
               diffcol = (double) (p2col - object[p1object - 1][k][1]);
	       lngth = Math.sqrt(diffrow * diffrow + diffcol * diffcol);

	       if (lngth > maxlngth) {

		  // Remove this object.

		  --nmobjects;
		  for (l = p1object - 1; l < nmobjects; ++l) {
	             for (m = 0; m < nmpxls[l + 1]; ++m) {
		        object[l][m][0] = object[l + 1][m][0];
		        object[l][m][1] = object[l + 1][m][1];
		     }
                     nmpxls[l] = nmpxls[l + 1];
		  }
                  continue COLLP;
	       }
            }
	    
	    // Add this pixel to p1's object.

	    object[p1object - 1][nmpxls[p1object - 1]][0] = p2row;
	    object[p1object - 1][nmpxls[p1object - 1]][1] = p2col;
	    ++nmpxls[p1object - 1];
         }
      }
   }
}

// Remove objects that are too small and find the center of each object.

k = 0;
for (i = 0; i < nmobjects; ++i) {
   lngth = 0.;
   for (j = 0; j < nmpxls[i]; ++j) {
      for (l = 0; l < j; ++l) {
         diffrow = (double) (object[i][j][0] - object[i][l][0]);
         diffcol = (double) (object[i][j][1] - object[i][l][1]);
         tlngth = Math.sqrt(diffrow * diffrow + diffcol * diffcol);
	 if (tlngth > lngth) {
            lngth = tlngth;
         }
      }
   }
   if (lngth < .3 * maxlngth) {
      continue;
   }

   rowsum = 0.;
   colsum = 0.;
   for (j = 0; j < nmpxls[i]; ++j) {
      rowsum += (double) object[i][j][0];
      colsum += (double) object[i][j][1];
   }
   objcenter[k][0] = (int) Math.round(rowsum / ((double) nmpxls[i]));
   objcenter[k][1] = (int) Math.round(colsum / ((double) nmpxls[i]));

   Run_id.printf_("tally: objrow= " + objcenter[k][0] + " objcol= " +
      objcenter[k][1]);
   ++k;
}

return k;
}

// -----------------------------------------------------------------------

static void writebip_() {

// Writes a BIP file.

int i, j, k, flenm = 9;

Run_id.fleopen_(flenm, "multi4band.bip", 'w');
for (i = 0; i < nmrows; ++i) {
   for (j = 0; j < nmcols; ++j) {
      for (k = 0; k < 4; ++k) {
         Run_id.fwbinshrt_(flenm, pxlbandval[i][j][k]);
      }
   }
}
Run_id.fclose_(flenm, 'w');
}
   /*
   try {
   Readgeotiff.readgeotiff_(animalfilename);
   }
   catch (Exception e) {
   Run_id.iderr_("abundest: readgeotiff failed");
   }
   */
   /*
   byte[] bytes = new byte[nmrows * nmcols];
   try {
   bytes = Files.readAllBytes(Paths.get(animalfilename));
   } catch (Exception e) {
   Run_id.iderr_("readAllBytes failed");
   }
   Run_id.iderr_("length= " + bytes.length);
   */
}
