import java.rmi.RemoteException;

import net.jini.core.entry.*;
import net.jini.core.lease.Lease;
import net.jini.core.transaction.*;
import net.jini.space.JavaSpace;

public abstract class GenericMaster {
    private JavaSpace space;
    private Thread thread;

    public GenericMaster() {
        
        space = SpaceAccessor.getSpace();
    }

    public static void main(String[] args) {
        FibFactMaster f = new FibFactMaster();
	f.generateTasks();
        f.collectResults();
       System.out.println("Finished");
    }

    public void writeTask(TaskEntry task) {
        try {
            space.write(task, null, Lease.FOREVER);
        } catch (RemoteException e) {
            e.printStackTrace();
        } catch (TransactionException e) {
            e.printStackTrace();
        }
    }
        
    public ResultEntry takeResult(ResultEntry template) {
        try {
            ResultEntry result = (ResultEntry)
                space.take(template, null, Long.MAX_VALUE);
            return result;
        } catch (RemoteException e) {
            e.printStackTrace();
        } catch (TransactionException e) {
            e.printStackTrace();
        } catch (UnusableEntryException e) {
            e.printStackTrace();
        } catch (InterruptedException e) {
            System.out.println("Task cancelled");
        }
        return null;
    }       
}
