// package jsbook.chapter6.command;

// import jsbook.util.*;

import java.rmi.RemoteException;

import net.jini.core.entry.*;
import net.jini.core.lease.Lease;
import net.jini.core.transaction.*;
import net.jini.space.JavaSpace;

public class GenericWorker {
    JavaSpace space;
    private Thread thread;
    
    public static void main(String[] args) {
        GenericWorker worker = new GenericWorker();
        worker.startWork();
    }
    
    public GenericWorker() {
        space = SpaceAccessor.getSpace();
    }
    
    public void startWork() {
        TaskEntry taskTmpl = new TaskEntry();
        
        while (true) {
            System.out.println("getting task");
            try {
                TaskEntry task = (TaskEntry) 
                    space.take(taskTmpl, null, Lease.FOREVER);
                ResultEntry result = task.execute();
                if (result != null) {
                    space.write(result, null, Lease.FOREVER);
                }
            } catch (RemoteException e) {
                System.out.println(e);
            } catch (TransactionException e) {
                System.out.println(e);
            } catch (UnusableEntryException e) {
                System.out.println(e);
            } catch (InterruptedException e) {
                System.out.println("Task cancelled");
            }
        }
    }
}
