import java.util.*;
class Groupdata extends CA {

// Reads group actions data files.

static final int NMACTLOCS = 10;

static String grpinfofle, rgnsinfofle, checklevel = "lowcheck";

static String grpactnsfle[] = new String[10];
static String actors[][] = new String[NMACTNS][MAXNMSUBJ];
static String action[] = new String[NMACTNS];
static String unmatchedoutactn[][] = new String[NMACTNS][MAXTIMES];
static String unmatchedtarget[][] = new String[NMACTNS][MAXTIMES];
static String actioncode[] = new String[NMACTNS];
static String actractn[] = new String[NMACTNS];
static String countries[][] = new String[NMACTNS][MAXNMSUBJ];
static String subjects[][] = new String[NMACTNS][MAXNMSUBJ];
static String obsactloc[][] = new String[NMACTNS][NMACTLOCS];
static String alltargets[] = new String[TNMIDS];

static int monthdays[] = {31,28,31,30,31,30,31,31,30,31,30,31};
static int actionid[] = new int[NMACTNS];
static int index[] = new int[NMACTNS];
static int nmsubjects[] = new int[NMACTNS];
static int nmobsactlocs[] = new int[NMACTNS];

static double maxreadtime = 0.;

static double actiondate[] = new double[NMACTNS];

// -------------------------------------------------------------------

static void readrawgroup_() {

/* Reads the raw group actions data file and creates an actions history
   data file. */

boolean goodcode = false, skip = false, sourcefound, actorfound,
   subjectfound, newrgn = true;

String strng1, storysource, intids_action_label = " ", code, rawtargets,
   actractnpair, targetlabel, outaction = " ", bestmatch= "none";

int intval, i, j = 0, k, l, year, month, day, nmactors,
   nmrawacts = 0, matchactor, matchtarget, matchaction, nmtimes = 1,
   tindex = 0, actnnm = 0, trgtnm = 0, nmvernacgrps, ematactionindex = 0,
   actflenm = 7, nmactreact = 0, nmnoemat = 0, nmnoactor = 0,
   nmnotarget = 0, nmnooutact = 0, nmrgns = 0, nmdups = 0;

double yearbase, storydate, match, similarity, minmatchactor = .9,
   minmatchtarget = .9, latesttime = 0., sim1, sim2, sim3;

// Read group information from the file "grpinfofle."

nmvernacgrps = Storyutils.readgrpinfo_(3);

/* Read the raw actions data file from "grpactnsfle[0]."  If multiple group
   actions files need to be converted, "cat" them together as needed. */

fleopen_(2, grpactnsfle[0], 'r');

// Open a file to record matching failures.

fleopen_(3, "noemat.err", 'w');

fprintf_(1,
   "\n------------ Reading Raw Group Action Data ---------------");

strng1 = fgetline_(2);
if (strng1.equals("begincomment")) {
   do {
      strng1 = fgetline_(2);
   } while (!strng1.equals("endcomment") && fle_ready_(2));

} else {
   iderr_("readrawgroup: no header");
}

// Loop for reading raw action observations.

do {
   intval = fgetint_(2);
   if (intval == -1111111) {
      do {
         strng1 = fgetline_(2);
      } while (!strng1.equals("endcomment") && fle_ready_(2));
      intval = fgetint_(2);
   }

   /* Read Document Archive Number (actionid), action report date,
      story source, number of actors, actors, number of subjects,
      and subjects. */

   actionid[nmrawacts] = intval;

   goodcode = true;

   if (checklevel.equals("highcheck")) {
      fprintf_(1, "\nRaw Action read-attempt: actionid= " +
         actionid[nmrawacts] + " nmrawacts= " + nmrawacts);
   }

   // Read and throw away the "articleid" integer value.

   intval = fgetint_(2);

   // Read story date.

   month = fgetint_(2);
   month = Math.abs(month);

   day = fgetint_(2);
   day = Math.abs(day);

   year = fgetint_(2);
   year = Math.abs(year);

   /*
   printf_("readrawgroup: nmrawacts= " + nmrawacts + " actionid= " +
      actionid[nmrawacts] + " month= " + month + " day= " + day +
      " year= " + year);
   */

   if (year > 40) {
      yearbase = 1900.;

   } else {
      yearbase = 2000.;
   }

   storydate = (yearbase + (double) year) +
      Textutils.nmdays_(actionid[nmrawacts], year, month, day) / 365.;

   /* Read story's source.
   
   storysource = fgetstrng_(2);
   storysource = storysource.toLowerCase();

   // Print new story sources.

   sourcefound = false;
   for (j = 0; j < nmvernacgrps; ++j) {
      sim1 = Textutils.levenshtein_(storysource, Storyparse.vernacgrp[j]);
      sim2 = Textutils.levenshtein_(storysource, Storyparse.acronym[j]);
      if (Storyparse.grparchetype[j].equals("news_organization") &&
          (sim1 > .8 || sim2 > .8)) {
         sourcefound = true;
	 break;
      }
   }
   if (!sourcefound) {
      if (nmrawacts > 0) {
         printf_("readrawgroup: nmrawacts= " + nmrawacts + " actionid-1= " +
            actionid[nmrawacts - 1] + " actionid= " + actionid[nmrawacts] +
            " new source= " + storysource);
      
      } else {
         printf_("readrawgroup: nmrawacts= " + nmrawacts + " actionid= " +
            actionid[nmrawacts] + " new source= " + storysource);
      }
   }
   */

   // Get the number of actors and their names.
   
   nmactors = fgetint_(2);
   if (nmactors > MAXNMSUBJ) {
      iderr_("readrawgroup: actionid= " + actionid + " nmactors= " +
         nmactors);
   }

   for (i = 0; i < nmactors; ++i) {
      actors[nmrawacts][i] = fgetstrng_(2);

      // Trim front and back whitespace and convert to lowercase.

      strng1 = actors[nmrawacts][i].toLowerCase();
      actors[nmrawacts][i] = strng1.trim();

      actorfound = false;
      for (j = 0; j < nmvernacgrps; ++j) {
         sim1 = Textutils.levenshtein_(actors[nmrawacts][i],
	                 Storyparse.vernacgrp[j]);

         sim2 = Textutils.levenshtein_(actors[nmrawacts][i],
	                 Storyparse.acronym[j]);

         sim3 = Textutils.levenshtein_(actors[nmrawacts][i],
	                 Storyparse.modelname[j]);

	 if (sim1 > .8 || sim2 > .8 || sim3 > .8) {
	    actors[nmrawacts][i] = Storyparse.modelname[j];
	    actorfound = true;
	    break;
	 }
      }

      if (!actorfound) {
         printf_("readrawgroup: actionid= " + actionid[nmrawacts] +
            " unknown actor= " + actors[nmrawacts][i] + " skipping.");
         goodcode = false;
      }
   }
   
   // Get number of subjects (targets) and target names.

   nmsubjects[nmrawacts] = fgetint_(2);
   if (nmsubjects[nmrawacts] > MAXNMSUBJ) {
      iderr_("readrawgroup: actionid= " + actionid[nmrawacts] +
         " nmsubjects= " + nmsubjects[nmrawacts]);
   }

   for (i = 0; i < nmsubjects[nmrawacts]; ++i) {
      subjects[nmrawacts][i] = fgetstrng_(2);

      // Trim front and back whitespace and convert to lowercase.

      strng1 = subjects[nmrawacts][i].toLowerCase();
      subjects[nmrawacts][i] = strng1.trim();

      subjectfound = false;
      for (j = 0; j < nmvernacgrps; ++j) {
         sim1 = Textutils.levenshtein_(subjects[nmrawacts][i],
	                 Storyparse.vernacgrp[j]);

         sim2 = Textutils.levenshtein_(subjects[nmrawacts][i],
	                 Storyparse.acronym[j]);

         sim3 = Textutils.levenshtein_(subjects[nmrawacts][i],
	                 Storyparse.modelname[j]);
	 if (sim1 > .8 || sim2 > .8 || sim3 > .8) {
	    subjects[nmrawacts][i] = Storyparse.modelname[j];
	    subjectfound = true;
	    break;
	 }
      }
      if (!subjectfound) {
         printf_("readrawgroup: actionid= " + actionid[nmrawacts] +
            " unknown subject= " + subjects[nmrawacts][i] + " skipping.");
         goodcode = false;
      }
   }

   /* Read action and find the most similar EMAT action and store its
      associated EMAT code.  Otherwise, print a notice that the raw
      action does not have an EMAT code and skip this action. */

   action[nmrawacts] = fgetline_(2);
   if (action[nmrawacts].length() < 2) {
      action[nmrawacts] = fgetline_(2);
   }   

   ematactionindex = Grouputils.getematcodeindex_(action[nmrawacts], .8);
   if (ematactionindex == 0) {
      actioncode[nmrawacts] = "No EMAT code";
      goodcode = false;
      ++nmnoemat;
      fprintf_(3, actionid[nmrawacts] + "   " + action[nmrawacts]);

   } else {
      actioncode[nmrawacts] = Intridslve.ematcode[ematactionindex - 1];
      if (checklevel.equals("highcheck")) {
	 fprintf_(1, "Raw action= " + action[nmrawacts] +
            "\nMatched EMAT= " + Intridslve.emataction[ematactionindex - 1]
	    + "\n   actor= " + actors[nmrawacts][0]);
	 for (i = 0; i < nmsubjects[nmrawacts]; ++i) {
	    fprintf_(1, "   subject " + (i + 1) + "= " +
	       subjects[nmrawacts][i]);
	 }
      }

      /* Replace the action string with the corresponding first-occurring
	 EMAT action. */

      action[nmrawacts] = Grouputils.getemataction_(actioncode[nmrawacts]);
   
      /*
      printf_("Raw action= " + action[nmrawacts] +
         "\nMatched EMAT= " + Intridslve.emataction[ematactionindex - 1]
         + "\n   actor= " + actors[nmrawacts][0]);
      */
   }

   /* Read number of countries, country names, number of action locations,
      location names, and action date.  Note that location and region are
      the same. */

   nmcountries = fgetint_(2);
   if (nmcountries > MAXNMSUBJ) {
      iderr_("readrawgroup: actionid= " + actionid[nmrawacts] +
         " nmcountries= " + nmcountries + " MAXNMSUBJ= " + MAXNMSUBJ);
   }
   for (i = 0; i < nmcountries; ++i) {
      countries[nmrawacts][i] = fgetstrng_(2);
   }

   /* Rename Kenya or Tanzania legislature actors as presidents.
   if (actors[nmrawacts][0].equals("legislature") &&
       countries[0].equals("Kenya")) {
      actors[nmrawacts][0] = "kenpres";
      goodcode = true;

   } else if (actors[nmrawacts][0].equals("legislature") &&
      countries[0].equals("Tanzania")) {
      actors[nmrawacts][0] = "tanpres";
      goodcode = true;
   }
   */

   // Read action locations.

   nmobsactlocs[nmrawacts] = fgetint_(2);
   if (nmobsactlocs[nmrawacts] > NMACTLOCS) {
      iderr_("readrawgroup: actionid= " + actionid[nmrawacts] + " nmobsactlocs= " +
	 nmobsactlocs[nmrawacts]);
   }
   for (i = 0; i < nmobsactlocs[nmrawacts]; ++i) {
      obsactloc[nmrawacts][i] = fgetstrng_(2);
   }

   if (nmcountries == 1) {

      // If this is a new region, store it.

      for (i = 0; i < nmobsactlocs[nmrawacts]; ++i) {
	 strng = strngsub_(obsactloc[nmrawacts][i], "NP", "National_Park");
	 newrgn = true;
	 for (j = 0; j < nmrgns; ++j) {
            if (strng.equals(Storyparse.ctryrgn[j][1])) {
               newrgn = false;
	       break;
	    }
	 }
	 if (newrgn) {
            Storyparse.ctryrgn[nmrgns][0] = countries[nmrawacts][0];
            Storyparse.ctryrgn[nmrgns][1] = strng;
	    ++nmrgns;
	 }
      }
   }

   // Read action date.

   month = fgetint_(2);
   month = Math.abs(month);

   day = fgetint_(2);
   day = Math.abs(day);

   year = fgetint_(2);
   year = Math.abs(year);

   if (year > 40) {
      yearbase = 1900.;

   } else {
      yearbase = 2000.;
   }

   actiondate[nmrawacts] = (yearbase + (double) year) +
      Textutils.nmdays_(actionid[nmrawacts], year, month, day) / 365.;

   if (storydate < actiondate[nmrawacts]) {
      iderr_("readrawgroup: actionid= " + actionid[nmrawacts] +
         " but the storydate= " + storydate +
         "\n   actiondate= " + actiondate[nmrawacts] + " action= " +
         action[nmrawacts]);
   }

   // Reject this action if it is a duplicate.

   for (i = 0; i < nmrawacts; ++i) {
      if (Math.abs(actiondate[i] - actiondate[nmrawacts]) < 1.e-6 &&
          nmsubjects[i] == nmsubjects[nmrawacts] &&
	  actioncode[i].equals(actioncode[nmrawacts]) &&
          actors[i][0].equals(actors[nmrawacts][0]) &&
          subjects[i][0].equals(subjects[nmrawacts][0]) &&
          obsactloc[i][0].equals(obsactloc[nmrawacts][0]) &&
          countries[i][0].equals(countries[nmrawacts][0])) {

         goodcode = false;
	 ++nmdups;
         break;
      }
   }

   if (goodcode) {
      ++nmrawacts;
   }
} while (!checkbuffeof_(2));
fclose_(2, 'r');
fclose_(3, 'w');

printf_("readrawgroup: nmrawacts= " + nmrawacts + " nmdups= " + nmdups);
fprintf_(1, "----------- End of Raw Group Actions Data -----------");

// *************************************************************************

// Write a new, trial regions-by-country file.

fleopen_(2, "rgnsupdt.dat", 'w');
for (i = 0; i < nmrgns; ++i) {
   fprintf_(2, Storyparse.ctryrgn[i][0] + " " +
               Storyparse.ctryrgn[i][1]);
}
fclose_(2, 'w');

// Sort the actions by action date.

for (i = 0; i < nmrawacts; ++i) {
   index[i] = i;
}
Idsort.idsort_(actiondate, index, 1, nmrawacts);

/* Find the number of unique time points (unique action dates).  Also
   find the maximum (latest) time. */

actnshstry_obsactntime[0] = actiondate[0];
latesttime = 0.;
for (i = 0; i < nmrawacts - 1; ++i) {
   if (actiondate[i + 1] - actiondate[i] > 1.e-6) {
      if (nmtimes < MAXTIMES) {
         actnshstry_obsactntime[nmtimes] = actiondate[i + 1];
      }
      ++nmtimes;
   }
   if (latesttime < actiondate[i]) {
      latesttime = actiondate[i];
   }
}
if (nmtimes > MAXTIMES) {
   iderr_("readrawgroup: nmtimes= " + nmtimes + " > MAXTIMES= " + MAXTIMES);
}
fprintf_(1, "Number of time points= " + nmtimes);

/* Now, match each actor-action pair to one such pair in the IntIDs model.
   Do this by differentiating between matchable actors and actions and
   those that are not matchable.  Print out the unmatchable values so that
   the analyst can either correct the match, add actions to the IntIDs
   model, or decide which observations to ignore when constructing the
   actions history data file that is the ultimate product of this method.

   The steps for accomplishing the above are:
   1) Print all actor-action pairs of the IntIDs model.  This was done in
      the setup call to "intridslve_()" in "report_()."

   2) For each observed action (i = 1, ..., nmrawacts):
      a) Find and print the most similar IntIDs model actor.
      b) Find and print the most similar IntIDs model target(s).
      c) Find and print the most similar IntIDs model action.

   3) By examining the report file, the analyst pursues one of the
      following options for each raw action:
      a) does nothing -- either the matches are satisfactory or an
	 observation is to be ignored due to an unmatchable actor
	 (no associated group ID)
      b) changes the IntIDs model actor that was matched to the raw actor
      c) changes the IntIDs model action that was matched to the raw action
      d) changes the IntIDs model target that was matched to the first raw
         target
      e) assigns a new IntIDs model action to one of the IntIDs model's
	 group IDs. */

fprintf_(1, "\n---------- Begin Similarity-Matching Step -----------" +
            "\nMinimum match value for actors= " + minmatchactor +
            "\nMinimum match value for targets= " + minmatchtarget);

fleopen_(2, "noactor.err", 'w');
fprintf_(2, "0 A          Un-recognized Observed Actors" +
            "\n0 AA actionid    Observed_Actor     Match        Best-Match");

fleopen_(3, "notarget.err", 'w');
fprintf_(3, "0 A Observed Targets That Are Not Recognized by ID" +
            "\n 0 AA actionid    ID    Raw-Target   Match    Best-Match");

fleopen_(7, "nooutact.err", 'w');
fprintf_(7, "0 A Observed Out-Actions That Are Not Recognized by ID" +
            "\n 0 AA actionid    ID    Action-Code     Out-Action");

for (i = 0; i < nmrawacts; ++i) {
   if (checklevel.equals("highcheck")) {
      fprintf_(1, "\n actionid= " + actionid[index[i]]);
   }

   /* Find "tindex" for this raw observation and initialize the observed
      action and observed target indices. */

   for (j = 1; j <= nmtimes; ++j) {
      if (Math.abs(actiondate[i] - actnshstry_obsactntime[j - 1]) < 1.e-6) {
         tindex = j;
	 break;
      }
   }
   for (j = 0; j < nmids; ++j) {
      actnshstry_obsactn[j][tindex - 1][0] = 0;
      actnshstry_obstrgts[j][tindex - 1][0] = 0;
   }

   // Find actor match.

   matchactor = 0;
   match = 0.;
   for (j = 0; j < nmids; ++j) {
      similarity = Textutils.levenshtein_(actors[index[i]][0], idname[j]);
      if (similarity > match) {
	 match = similarity;
	 matchactor = j + 1;
      }
   }

   /* Declare a match if "match" is > "minmatchactor."  If no match, skip
      the target matching, and action matching efforts. */

   if (match < minmatchactor) {
      ++nmnoactor;
      if (matchactor > 0) {
	 bestmatch = idname[matchactor - 1];

      } else {
	 bestmatch = "none";
      }

      fprintf_(2, actionid[index[i]] + "   " +
	 fstrng_(actors[index[i]][0], 15) + "   " + fdble_(match, 5, 2) +
	 " " + fstrng_(bestmatch, 8));

      continue;

   } else {
      if (!checklevel.equals("lowcheck")) {
	 fprintf_(1, "raw actor= " + actors[index[i]][0] +
	    "    matched to idname= " + idname[matchactor - 1] +
            "    match= " + fdble_(match, 5, 2));
      }
   }

   /* Find target(s) match(es).  First, glue all targets together into
      one string. */

   rawtargets = subjects[index[i]][0];
   for (k = 1; k < nmsubjects[index[i]]; ++k) {
      rawtargets += "," + subjects[index[i]][k];
   }
   matchtarget = 0;
   match = 0.;
   for (j = 0; j < Intridslve.nmtrgtlbls[matchactor - 1]; ++j) {

      // Get target label.

      targetlabel = Intridslve.target_labels[matchactor - 1][j];

      // Check for "rawtargets" being a substring of this target label.

      if (targetlabel.indexOf(rawtargets, 0) >= 0) {
         match = 1.0;
	 matchtarget = j + 1;
	 break;
      }

      // Check for a similar string.

      similarity = Textutils.levenshtein_(rawtargets, targetlabel);
      if (similarity > match) {
         match = similarity;
	 matchtarget = j + 1;
      }
   }

   if (match < minmatchtarget) {
      ++nmnotarget;
      if (matchactor > 0 && matchtarget > 0) {
         bestmatch = Intridslve.target_labels[matchactor - 1]
					     [matchtarget - 1];

      } else {
	 bestmatch = "none";
      }

      fprintf_(3, actionid[index[i]] + " " +
	 fstrng_(idname[matchactor - 1], 8) + " " +
	 fstrng_(rawtargets, 15) + "  " + fdble_(match, 5, 2) + " " +
	 fstrng_(bestmatch, 15));

      if (cacalc) {
         continue;

      } else {
         unmatchedtarget[matchactor - 1][tindex - 1] = rawtargets;
      }

   } else {

      /* Note that "matchtarget" is the target node value within the
         matchactor ID so to print the target name, the target labels
         array must be used instead of the "idname" array. */

      if (!checklevel.equals("lowcheck")) {
         fprintf_(1, "raw target(s)= " + rawtargets +
            "  matched to target label:  " +
            Intridslve.target_labels[matchactor - 1][matchtarget - 1] +
            "   match= " + fdble_(match, 5, 2));
      }
   }

   /* By comparing EMAT codes, check if this EMAT action is within the
      repertoire of this actor.  Do this by first finding the EMAT code
      index of a group ID action with the method "getematcodeindex_." */

   matchaction = 0;
   for (j = 0; j < Intridslve.nmoutacts[matchactor - 1]; ++j) {
      ematactionindex =
	 Grouputils.getematcodeindex_(Intridslve.action_labels
			              [matchactor - 1][j], .8);

      // Major problem if a group ID action does not have an EMAT code.

      if (ematactionindex == 0) {
         iderr_("readrawgroup: no EMAT code for: " +
	    Intridslve.action_labels[matchactor - 1][j]);
      }

      if (actioncode[index[i]].equals(
	  Intridslve.ematcode[ematactionindex - 1])) {
	 matchaction = j + 1;
	 intids_action_label = Intridslve.action_labels[matchactor - 1]
						       [matchaction - 1];
	 break;
      }
   }

   if (matchaction == 0) {
      ++nmnooutact;
      outaction = Grouputils.getemataction_(actioncode[index[i]]);
      fprintf_(7, actionid[index[i]] + " " +
	 fstrng_(idname[matchactor - 1], 8) + "   " +
	 fstrng_(actioncode[index[i]], 10) + " " +
	 outaction.substring(0, Math.min(outaction.length(), 50)));
      unmatchedoutactn[matchactor - 1][tindex - 1] = outaction;

   } else {
      if (!checklevel.equals("lowcheck")) {
	 fprintf_(1, "IntIDs action= " + intids_action_label +
	    "\nEMAT action= " +
	    Intridslve.emataction[ematactionindex - 1]);
      }

      // Add this action and target to the actions history.

      actnshstry_obsactn[matchactor - 1][tindex - 1][0] = matchaction;
      actnshstry_obstrgts[matchactor - 1][tindex - 1][0] = matchtarget;
   }

   // Add action locations.

   actnshstry_nmobsactlocs[matchactor - 1][tindex - 1] = nmobsactlocs[index[i]];
   for (j = 0; j < nmobsactlocs[index[i]]; ++j) {
      actnshstry_obsactloc[matchactor - 1][tindex - 1][j] = obsactloc[index[i]][j];
   }
} // End of "for" loop over the raw actions.
fclose_(2, 'w');
fclose_(3, 'w');
fclose_(7, 'w');

fprintf_(1, "Number of raw actions= " + nmrawacts +
	    "\nNumber of actions with no EMAT code= " +
	    nmnoemat +
            "\nNumber of actions with an unrecognized actor= " +
            nmnoactor + 
            "\nNumber of actions with an unrecognized target= " +
	    nmnotarget + 
            "\nNumber of actions with an unrecognized out-action= " +
            nmnooutact);
fprintf_(1, " In Unix, run the provided shell script, sorterrs.shl" +
	    "\n and then print the files noemat.err, noactor.err," +
	    "\n notarget.err, and nooutact.err");
fprintf_(1, " tfinal= " + Intridslve.tfinal);

// **********************************************************************

// Write the observed actions history to output and to a file.

fleopen_(2, Displayactions.actnshistfle, 'w');


for (i = 0; i < nmtimes; ++i) {
   for (j = 0; j < nmids; ++j) {
      strng = "action" + " " +
         fdble_(actnshstry_obsactntime[i], 8, 2) + " " + idname[j];

      /* An action by the (j + 1)th ID at the (i + 1)th time point has
         been detected.  Or, an out-action that is not in this ID's
	 repertoire has been detected. */

      if (actnshstry_obsactn[j][i][0] > 0) {
	 actnnm = actnshstry_obsactn[j][i][0];
         strng += " " + Intridslve.action_labels[j][actnnm - 1];
      
      } else if (!cacalc && unmatchedoutactn[j][i] != null) {
         strng += " " + unmatchedoutactn[j][i];

      } else {
         continue;
      }

      // Add targets.

      if (actnshstry_obstrgts[j][i][0] > 0) {
	 trgtnm = actnshstry_obstrgts[j][i][0];
         strng += " " + Intridslve.target_labels[j][trgtnm - 1];

      } else if (!cacalc && unmatchedtarget[j][i] != null) {
         strng += " " + unmatchedtarget[j][i];
      
      } else {
	 continue;
      }

      // Add action locations.

      strng += " " + actnshstry_nmobsactlocs[j][i];
      for (k = 0; k < actnshstry_nmobsactlocs[j][i]; ++k) {
         strng += " " + actnshstry_obsactloc[j][i][k];
      }

      // Write this action to both output and to the actions history file.

      fprintf_(1, strng);
      fprintf_(2, strng);
      
      // Store the string form of the actor, action, and target(s).

      if (actnshstry_obsactn[j][i][0] > 0 &&
          actnshstry_obstrgts[j][i][0] > 0) {
         actnshstry_obsactor[nmobsactns] = idname[j];

         actnshstry_obsactnstrng[nmobsactns] =
            Intridslve.action_labels[j][actnnm - 1];

         actnshstry_obstrgtsstrng[nmobsactns] =
            Intridslve.target_labels[j][trgtnm - 1];
      }

      // Increment the number of actions within the history.

      ++nmobsactns;
   }
}
fclose_(2, 'w');
fprintf_(1, "\nNumber of actions in the actions history file= " +
   nmobsactns +
   "\n\n-------------- End of Similarity-Matching Step ----------------\n");

if (nmobsactns < 2) {
   iderr_("readrawgroup: Number of actions-history actions= " + nmobsactns);
}

if (!cacalc) {
   return;
}

/* Write the observed action-reaction file for each group ID.  This is a
   separate set of DO-loops from the above because the order of the loops
   above would have been a hassle to reverse. */

for (i = 0; i < nmids; ++i) {

   if (Intridslve.utlnode[i] == 0) {

      // Skip non-group IDs.

      continue;
   }

   fleopen_(actflenm, (idname[i] + ".act"), 'w');
   nmactreact = 0;
   for (j = 0; j < nmobsactns; ++j) {
   
      /* Search for actions that a) list this ID as one of the targets,
         and b) following such an action, this ID executes a subsequent
         action.  First, search for the ID's name in the list of targets
	 of this action. */

      if (actnshstry_obstrgtsstrng[j].indexOf(idname[i], 0) >= 0) {

         /* An action that has this ID as its target has been found.
            Now, look ahead for a reaction from this ID. */

         for (k = j + 1; k < nmobsactns; ++k) {

            if (actnshstry_obsactor[k].equals(idname[i])) {
	    
	       /* Check for a previous occurrence of this input actor-
		  input action pair.  If found, skip it. */

	       skip = false;
	       for (l = 0; l < nmactreact; ++l) {
		  actractnpair = actnshstry_obsactor[j] +
				 actnshstry_obsactnstrng[j];
		  if (actractnpair.equals(actractn[l])) {
		     skip = true;
		     break;
		  }
	       }
    
	       if (!skip) {

	          /* A reaction by this ID has been found.  An
		     action-reaction pair can be written to the
		     action-reaction file for this ID.
		     First line: input actor, input action, input subject.
	             Second line: action, target. */

                  fprintf_(actflenm, actnshstry_obsactor[j] + " " +
	             actnshstry_obsactnstrng[j] + " " + idname[i] + " " +
	             actnshstry_obsactnstrng[k] + " " +
	             actnshstry_obstrgtsstrng[k]);

	          // Store this input actor -- input action pair.

	          actractn[nmactreact] = actnshstry_obsactor[j] +
				         actnshstry_obsactnstrng[j];
	          ++nmactreact; 
	          break;
	       }
	    }
	 }
      }
   }
   fclose_(actflenm, 'w');
   fprintf_(1, "Number of action-reaction pairs for " + idname[i] +
      "= " + nmactreact);
}

// Find and print action-sequence frequencies.

Displayactions.plottype = "observations";
Actnseqfreqs.actnseqfreqs_(nmobsactns);
}
}
