public class HIBMcalcs extends Ecosyscalcs {

// Herbivore Individual-Based Model (HIBM).

static boolean knponly = true, readibmfles = false;

static boolean individual_dead[][][][] =
   new boolean[NMTHRDS][ISIMSZE][NMINDIV][2];
static boolean patch_denschange[][][][] =
   new boolean[NMTHRDS][ISIMSZE][NMPTCHS][2];
static boolean patch_foodchange[][][][] =
   new boolean[NMTHRDS][ISIMSZE][NMPTCHS][2];

public static String availvegflename = "none";

static String ranchname[] = new String[10];
static String individual_gender[][][][] =
   new String[NMTHRDS][ISIMSZE][NMINDIV][2];
static String individual_movestatus[][][][] = 
   new String[NMTHRDS][ISIMSZE][NMINDIV][2];

static int ttlnmpatches, nmvegtimes, printcounter = 0, flenm = 4,
   nmremovalevents = 0,
   nmranches = 0; // there are about 350 large private rhino ranches in SA.

static int nmsteps[][][] = new int[NMTHRDS][ISIMSZE][2];
static int le[] = new int[2];
static int intercalv[][][][] = new int[NMTHRDS][ISIMSZE][NMPTCHS][2];
static int ma[][][][] = new int[NMTHRDS][ISIMSZE][NMPTCHS][2];
static int n[][][] = new int[NMTHRDS][ISIMSZE][2];
static int totalkilled[][][] = new int[NMTHRDS][ISIMSZE][2];
static int totaldied[][][] = new int[NMTHRDS][ISIMSZE][2];
static int totalborn[][][] = new int[NMTHRDS][ISIMSZE][2];
static int rchpopsze[][][][] = new int[NMTHRDS][ISIMSZE][NMPTCHS][2];
static int individual_patchident[][][][] =
   new int[NMTHRDS][ISIMSZE][NMINDIV][2];
static int individual_age[][][][] =
   new int[NMTHRDS][ISIMSZE][NMINDIV][2];
static int individual_lastpreg[][][][] =
   new int[NMTHRDS][ISIMSZE][NMINDIV][2];
static int subgroupid[][][] = new int[NMTHRDS][ISIMSZE][NMINDIV];
static int oldmaleid[][][] = new int[NMTHRDS][ISIMSZE][NMINDIV];
static int index[][][] = new int[NMTHRDS][ISIMSZE][NMINDIV];

static int nmpatches[] = new int[10];
static int patch_ranchid[] = new int[NMPTCHS];
static int patch_nmindiv[][][] = new int[NMTHRDS][ISIMSZE][NMPTCHS];
static int patch_nmmales[][][] = new int[NMTHRDS][ISIMSZE][NMPTCHS];
static int patch_nmfemales[][][] = new int[NMTHRDS][ISIMSZE][NMPTCHS];
static int patch_nmstress[][][] = new int[NMTHRDS][ISIMSZE][NMPTCHS];
static int patch_nmadjacent[] = new int[NMPTCHS];
static int patch_adjptch[][] = new int[NMPTCHS][10];
static int nmremoved[] = new int[20];

static double pimport, lasttme = 0., constveg = 0., totalarea = 0.;

static double meb[] = new double[2];
static double jeb[] = new double[2];
static double meaneb[] = new double[2];
static double wfi[] = new double[2];
static double vegtime[] = new double[2500];
static double rawveg[] = new double[2500];
static double sortvec[] = new double[2500];
static double availveg[][] = new double[2500][2];
static double maxveg[] = new double[2];

static int nranch[][][][] = new int[NMTHRDS][ISIMSZE][2][2];
static double individual_energy[][][][] =
   new double[NMTHRDS][ISIMSZE][NMINDIV][2];

static double patch_area[] = new double[NMPTCHS];
static double rancharea[] = new double[10];
static double patch_density[][][] =
   new double[NMTHRDS][ISIMSZE][NMPTCHS];
static double patch_vegleftover[][][][][] =
   new double[NMTHRDS][ISIMSZE][NMPTCHS][36][2];
static double patch_netveg[][][][] =
   new double[NMTHRDS][ISIMSZE][NMPTCHS][2];
static double patch_vegchg[][][][] =
   new double[NMTHRDS][ISIMSZE][NMPTCHS][2];

static double negmaleage[][][] = new double[NMTHRDS][ISIMSZE][NMINDIV];
static double meansze[] = new double[NMPTCHS];
static double removaldate[] = new double[20];

// -------------------------------------------------------------------

public static void step_(int thrd, double nodevals[][][],
   double yn[][], int dst) {

/* Steps an individual-based population of herbivores forward one time
   step.  This method is called at time intervals equal to the HIBM's
   step size.  For the rhino model, this time interval is one week.
   Calling this method at intervals other than the HIBM's interval makes
   no sense. */

boolean p1flag = true, notfound = false;

String manoption = "none";

int i, j, k, patchid, nmtrys, nmadjacent, ar = 0, rgn = 0,
   pth, indivnm, oldn, nmnewborns = 0, newn, nmconditions, nold = 0,
   nprivate, nmstressed = 0, maxstressed = 0, nmtooyoung = 0,
   nmnonres = 0, nmnomales = 0, nmnoenergy = 0, nmnotready = 0,
   ranchtoraid = 0, nmwksleftover = 36, nkill = 0, realizid, dstm1 = dst - 1;

double unif, vegt, vegtminus1, vegsum, r, dum, meanenergy = 0.,
   meannetveg = 0., meanconsumed = 0., maxvegleftover = 0., deathprb = 0.,
   probknp = .999, vratio = 0., echange = 0.,
   stresseffect1 = 1.5,
   stresseffect2 = 1.5;

// Get sample path.

pth = idenom[thrd];

if (knponly) {
   probknp = .999;

} else {
   probknp = .667;
}

// Get region value, if any.

if (!regionnode.equals("none")) {
   rgn = Getmodlutils.getndnm_(regionnode);
   if (rgn < 1) {
      iderr_("step: no region node.");
   }
   rgnval[thrd] = (int) nodevals[thrd][0][rgn - 1];

} else {
   rgnval[thrd] = 1;
}

// At the first time point only, initialize the model.

if (firsttimepoint[thrd] && initialIntridsTime) {
   initialibm_(thrd, pth, nodevals, dst);
   return;
}

// Get management option.

i = Getmodlutils.getndnm_("ManOp");
manoption = nodelbls[idnmbrm1][i - 1][(int) condvals[1]];

// Delete dead individuals from the individual objects list.

i = 0;
while (i < n[thrd][pth][dstm1]) {
   if (individual_dead[thrd][pth][i][dstm1]) {

      if (n[thrd][pth][dstm1] > 0) {
         --n[thrd][pth][dstm1];

      } else {
	 break;
      }

      // Ratchet all objects up one array position.

      for (j = i; j < n[thrd][pth][dstm1]; ++j) {
         individual_patchident[thrd][pth][j][dstm1] =
	    individual_patchident[thrd][pth][j + 1][dstm1];
	 individual_gender[thrd][pth][j][dstm1] =
	    individual_gender[thrd][pth][j + 1][dstm1];
	 individual_age[thrd][pth][j][dstm1] =
	    individual_age[thrd][pth][j + 1][dstm1];
	 individual_lastpreg[thrd][pth][j][dstm1] =
	    individual_lastpreg[thrd][pth][j + 1][dstm1];
	 individual_movestatus[thrd][pth][j][dstm1] =
	    individual_movestatus[thrd][pth][j + 1][dstm1];
	 individual_energy[thrd][pth][j][dstm1] =
	    individual_energy[thrd][pth][j + 1][dstm1];
	 individual_dead[thrd][pth][j][dstm1] =
	    individual_dead[thrd][pth][j + 1][dstm1];
      }

   } else {
      ++i;
   }
}

/*
if (thrd == 1) {
   ++printcounter;
}
if (thrd == 1 && printcounter == 10) {
   printf_("step: manoption= " + manoption + " beltmept= " +
      beltmept[thrd] + " yn= " + yn[thrd][0]);
   printcounter = 0;
}
*/

/* Find the number of individuals, adult males, and adult females in
   each patch. */

for (i = 0; i < ttlnmpatches; ++i) {
   patch_nmstress[thrd][pth][i] = 0;
   patch_nmindiv[thrd][pth][i] = 0;
   patch_nmmales[thrd][pth][i] = 0;
   patch_nmfemales[thrd][pth][i] = 0;
   for (j = 0; j < n[thrd][pth][dstm1]; ++j) {
      if (individual_patchident[thrd][pth][j][dstm1] == i + 1) {
         ++patch_nmindiv[thrd][pth][i];
	 if (individual_gender[thrd][pth]
			      [j][dstm1].equals("male") &&
             individual_age[thrd][pth][j][dstm1] >=
	     ma[thrd][pth][i][dstm1]) {
            ++patch_nmmales[thrd][pth][i];
	 
	 } else if (individual_gender[thrd][pth]
			             [j][dstm1].equals("female") &&
             individual_age[thrd][pth][j][dstm1] >=
	     ma[thrd][pth][i][dstm1]) {
            ++patch_nmfemales[thrd][pth][i];
         }
      }
   }
   patch_density[thrd][pth][i] =
      ((double) patch_nmindiv[thrd][pth][i]) / patch_area[i];

   /* If a patch has no females, kill-off all individuals younger than
      one year. */

   if (patch_nmfemales[thrd][pth][i] == 0) {
      for (j = 0; j < n[thrd][pth][dstm1]; ++j) {
         if (individual_patchident[thrd][pth][j][dstm1] == i + 1 &&
            individual_age[thrd][pth][j][dstm1] < 52.) {
            individual_dead[thrd][pth][j][dstm1] = true;
	 }
      }
   }

   /* High density increases female maturation age and inter-calving
      interval.  Because these parameters may be different across
      realizations AND persist across time, they are indexed by "thrd"
      and "pth" just like other population-realization variables such
      as "individual_age." */

   if (!patch_denschange[thrd][pth][i][dstm1] &&
       patch_density[thrd][pth][i] > 3.2) {
      ma[thrd][pth][i][dstm1] *= stresseffect1;
      intercalv[thrd][pth][i][dstm1] *= stresseffect1;
      patch_denschange[thrd][pth][i][dstm1] = true;
   
      /*
      if (thrd == 1 && pth == 1) {
         printf_("step: beltmept= " + beltmept[thrd] +
            " density stress effect in patch= " + (i + 1));
      }
      */

   } else if (patch_denschange[thrd][pth][i][dstm1] &&
       patch_density[thrd][pth][i] <= 3.2) {
      ma[thrd][pth][i][dstm1] /= stresseffect1;
      intercalv[thrd][pth][i][dstm1] /= stresseffect1;
      patch_denschange[thrd][pth][i][dstm1] = false;
   }
}

// Increment age of each individual.

for (i = 0; i < n[thrd][pth][dstm1]; ++i) {
   ++individual_age[thrd][pth][i][dstm1];
}

/* Update individual energy budgets and death events.  Ranch 2 provides
   supplementary feed so individuals are never food-stressed. */

nranch[thrd][pth][0][dstm1] = 0;
nranch[thrd][pth][1][dstm1] = 0;
for (i = 0; i < n[thrd][pth][dstm1]; ++i) {
   patchid = individual_patchident[thrd][pth][i][dstm1];
   if (patchid == 0) {
      printf_("step: thrd= " + thrd + " pth= " + pth);
      iderr_("step: patchid=0, i= " + i + " dst= " + dst);
   }
   ++nranch[thrd][pth][patch_ranchid[patchid - 1] - 1][dstm1];
   vratio = patch_netveg[thrd][pth][patchid - 1][dstm1] /
       (wfi[dstm1] * patch_nmindiv[thrd][pth][patchid - 1] + 1.) - 1.;
   vratio *= .01; // was .9, then .01
   echange = 1. / (1. + Math.exp(-vratio));
   echange = 2. * echange - 1.;
   if (patch_netveg[thrd][pth][patchid - 1][dstm1] <
       wfi[dstm1] * patch_nmindiv[thrd][pth][patchid - 1]) {

      if (patch_ranchid[patchid - 1] != 2) {
	 unif = Rndm.rndm1_(thrd, 0);
	 if (unif < .4) { // was .4
            individual_energy[thrd][pth][i][dstm1] += echange;
         }

         if (individual_energy[thrd][pth][i][dstm1] < 0.) {
            individual_energy[thrd][pth][i][dstm1] = 0.;
         }

	 /* Count the number of mature females that experience food
	    stress. */

	 if (individual_gender[thrd][pth]
	                      [i][dstm1].equals("female") &&
             individual_age[thrd][pth][i][dstm1] >
	       ma[thrd][pth][patchid - 1][dstm1]) {
            ++patch_nmstress[thrd][pth][patchid - 1];
         }

         if (thrd == 1 && pth == 1) {
            ++nmstressed;
         }
      }

   } else if ((individual_age[thrd][pth][i][dstm1] >
	       ma[thrd][pth][patchid - 1][dstm1] &&
               individual_energy[thrd][pth][i][dstm1] < meb[dstm1]) ||
              (individual_age[thrd][pth][i][dstm1] <
	       ma[thrd][pth][patchid - 1][dstm1] &&
               individual_energy[thrd][pth][i][dstm1] < jeb[dstm1])) {
      individual_energy[thrd][pth][i][dstm1] += echange;
   }

   // Update old-age, and starvation death events.

   if (individual_age[thrd][pth][i][dstm1] >= le[dstm1]) {
      individual_dead[thrd][pth][i][dstm1] = true;
      ++totaldied[thrd][pth][dstm1];

   } else if (individual_energy[thrd][pth][i][dstm1] <= 0.) {

      // Set probability of death due to zero energy.

      if (individual_age[thrd][pth][i][dstm1] <
          ma[thrd][pth][patchid - 1][dstm1]) {
      
         deathprb = .5; // juveniles starve to death more easily, was .4.

      } else if (individual_gender[thrd][pth]
		                  [i][dstm1].equals("female")) {
	 /*
         deathprb = Math.abs(individual_lastpreg[thrd][pth][i][dstm1]
                       - intercalv[thrd][pth][patchid - 1][dstm1]) /
                    intercalv[thrd][pth][patchid - 1][dstm1];
	 deathprb = .1 * Math.pow(deathprb, 2.);
	 */

	 deathprb = .05; // was .1

      } else {
         deathprb = .15; // was .1
      }

      unif = Rndm.rndm1_(thrd, 0);

      if (unif < deathprb) {
         individual_dead[thrd][pth][i][dstm1] = true;
         ++totaldied[thrd][pth][dstm1];
      }

   } else {
      individual_dead[thrd][pth][i][dstm1] = false;
   }

   // Summary statistics.

   if (thrd == 1 && pth == 1 && patch_ranchid[patchid - 1] != 2) {
      meanenergy += individual_energy[thrd][pth][i][dstm1];
      if (i == 0) {
         meannetveg += patch_netveg[thrd][pth][patchid - 1][dstm1];
         meanconsumed +=
            wfi[dstm1] * patch_nmindiv[thrd][pth][patchid - 1];
      }
   }
}

if (thrd == 1 && pth == 1) {
   meanenergy /= ((double) (nranch[thrd][pth][0][dstm1] + 1));
   meannetveg /= ((double) nmpatches[0]);
   meanconsumed /= ((double) nmpatches[0]);
   
   /*
   printf_("step: beltmept= " + fdble_(beltmept[thrd], 8, 2) +
      " nranch1= " + nranch[thrd][pth][0][dstm1] + " meanenergy= " +
      meanenergy + "\n   nmstressed= " + nmstressed + " mncnsmd= " +
      meanconsumed + " mnntvg= " + meannetveg);
   */
}

/* Increase maturation age and intercalving interval in a patch if the
   proportion of mature females experiencing food stress exceeds 50%. */

for (i = 0; i < ttlnmpatches; ++i) {
   if (patch_nmfemales[thrd][pth][i] > 0) {
      dum = ((double) patch_nmstress[thrd][pth][i]) /
	    ((double) patch_nmfemales[thrd][pth][i]);
   
   } else {
      dum = 0.;
   }

   if (!patch_foodchange[thrd][pth][i][dstm1] && dum > .5) {
      ma[thrd][pth][i][dstm1] *= stresseffect2;
      intercalv[thrd][pth][i][dstm1] *= stresseffect2;
      patch_foodchange[thrd][pth][i][dstm1] = true;

   } else if (patch_foodchange[thrd][pth][i][dstm1] && dum <= .5) {
      ma[thrd][pth][i][dstm1] /= stresseffect2;
      intercalv[thrd][pth][i][dstm1] /= stresseffect2;
      patch_foodchange[thrd][pth][i][dstm1] = false;
   }
}

/* Implement ranch-level management actions.
   1. Process any poaching actions. */

if (manoption.equals("sell_a_few_rhino_horns") ||
    manoption.equals("sell_several_rhino_horns") ||
    manoption.equals("sell_many_rhino_horns")) {

   nkill = (int) Intridslve.actions_ecoinput[0];
   
   /*
   if (thrd == 1) {
      printf_("step: manoption= " + manoption + " beltmept= " +
         beltmept[thrd] + " ecoinput= " + Intridslve.actions_ecoinput[0]);
   }
   */

   /* If only KNP is being modeled, reduce the number to poach to
      represent typical poaching pressure on KNP alone. */

   if (knponly) {
      //nkill = (int) Math.round(((double) nkill) * .66);
   }

} else {
   nkill = 0;
}

// There was no real poaching activity prior to 2007.

if (beltmept[thrd] < 2007.) {
   nkill = 0;
}

if (nkill > 0 && n[thrd][pth][dstm1] > 0) {
   if (nkill > n[thrd][pth][dstm1]) {
      nkill = n[thrd][pth][dstm1];
   }

   /* Randomly select "nkill" live and mature individuals and kill
      them.  Ranch 1 (KNP) experiences twice the poaching that the
      private ranches (ranch 2) experience.  First select a ranch
      on which to kill a rhino. */

   if (nranch[thrd][pth][1][dstm1] == 0) {
      ranchtoraid = 1;

   } else {
      unif = Rndm.rndm1_(thrd, 0);
      if (unif < probknp) {
         ranchtoraid = 1;

      } else {
         ranchtoraid = 2;
      }
   }

   i = 0;
   k = 0;
   for (j = 0; j < nkill; ++j) {
      do {
         patchid = individual_patchident[thrd][pth][k][dstm1];
         if (patch_ranchid[patchid - 1] == ranchtoraid &&
             !individual_dead[thrd][pth][k][dstm1] &&
             individual_age[thrd][pth][k][dstm1] >=
	     ma[thrd][pth][patchid - 1][dstm1]) {
            individual_dead[thrd][pth][k][dstm1] = true;
	    ++k;
	    ++i;
	    break;
	 }
	 ++k;
      } while (k < n[thrd][pth][dstm1]);
   }

   // Poach animals on other ranch if necessary.
   
   if (i < nkill) {
      if (ranchtoraid == 1) {
         ranchtoraid = 2;

      } else {
         ranchtoraid = 1;
      }
      k = 0;
      for (j = i; j < nkill; ++j) {
         do {
            patchid = individual_patchident[thrd][pth][k][dstm1];
            if (patch_ranchid[patchid - 1] == ranchtoraid &&
                !individual_dead[thrd][pth][k][dstm1] &&
                individual_age[thrd][pth][k][dstm1] >=
	        ma[thrd][pth][patchid - 1][dstm1]) {
               individual_dead[thrd][pth][k][dstm1] = true;
	       ++k;
	       ++i;
	       break;
	    }
	    ++k;
         } while (k < n[thrd][pth][dstm1]);
      }
   }

   /*
   if (thrd == 1 && pth == 1) {
      printf_("step: beltmept= " + beltmept[thrd] + " dstm1= " + dstm1);
   }
   */

   totalkilled[thrd][pth][dstm1] += i;
}

/* 2. Legal hunting on private ranches.  The hunting off-take from
      ranch 2 is 50% of the oldest males annually.  An "old male"
      is defined to be a male older than the 90th percentile of male
      ages on the ranch.  Find these individuals as follows.
      a. Sort all male ages, and then locate the 90th percentile age.
      b. Form a group of males older than this threshold age.  Say
         there are "nold" individuals in this group.
      c. Compute nkill = nold x .5 / 52.  This is the number of
         individuals to kill each week.  If "nkill" is zero, set it
	 to 1.
      c. Randomly select "nkill" individuals from the old male group
         and kill them. */

j = 0;
for (i = 0; i < n[thrd][pth][dstm1]; ++i) {
   patchid = individual_patchident[thrd][pth][i][dstm1];
   if (patch_ranchid[patchid - 1] == 2 &&
       individual_gender[thrd][pth][i][dstm1].equals("male")) {
      negmaleage[thrd][pth][j] =
         -individual_age[thrd][pth][i][dstm1];
      subgroupid[thrd][pth][j] = i;
      index[thrd][pth][j] = j;
      ++j;
   }
}

Idsort.shellsort_(negmaleage[thrd][pth], index[thrd][pth], j);

nold = (int) (((double) j) * .1);
for (i = 0; i < nold; ++i) {
   oldmaleid[thrd][pth][i] = subgroupid[thrd][pth][index[thrd][pth][i]];
}
nkill = (int) (((double) nold) * .5 / 52.);

if (nkill > 0) {

   /* Randomly select "nkill" individuals from the old-male group and
      kill them. */

   i = 0;
   nmtrys = 0;
   do {
      j = Rndm.unifint_(thrd, nold);
      if (!individual_dead[thrd][pth][oldmaleid[thrd][pth][j]][dstm1]) {
         individual_dead[thrd][pth][oldmaleid[thrd][pth][j]][dstm1] = true;
         ++i;
      }
      ++nmtrys;
   } while (i < nkill && nmtrys < 1000);
}

/* 3. Selling of rhinos by private ranches.  This off-take is from
      all age classes and both genders.  Each year, one-fourth of
      the exponential growth rate is removed from private ranches.
      The exponential growth population model is N_t = N_0 exp(rt)
      where N_t is abundance at the end of the time interval, t
      (measured in years), N_0 is the initial population size, and
      r is the exponential growth rate.

      Then, for a given r, the selling off-take each week on ranch
      2 is nkill = .25 x r / 52. */

r = .09 * 4500; // r is about 9%.
nkill = (int) (((double) r) * .25 / 52.);

// Collect ids of all individuals on private ranches.

j = 0;
for (i = 0; i < n[thrd][pth][dstm1]; ++i) {
   patchid = individual_patchident[thrd][pth][i][dstm1];
   if (patch_ranchid[patchid - 1] == 2) {
      subgroupid[thrd][pth][j] = i;
      ++j;
   }
}
nprivate = j;

if (nkill > 0 && nprivate > nkill) {

   // Remove these individuals by "killing" them.

   i = 0;
   nmtrys = 0;
   do {
      j = Rndm.unifint_(thrd, nprivate);
      if (!individual_dead[thrd][pth][subgroupid[thrd][pth][j]][dstm1]) {
         individual_dead[thrd][pth][subgroupid[thrd][pth][j]][dstm1] = true;
         ++i;
      }
      ++nmtrys;
   } while (i < nkill && nmtrys < 10000);
}

/* 4. Auctioning of KNP rhinos by SANParks.  This is a management-set
      number of rhinos removed from KNP each year. */

nkill = 0;
for (i = 0; i < nmremovalevents; ++i) {
   if (beltmept[thrd] < removaldate[i] &&
       removaldate[i] <= beltmept[thrd] + delta) {
      nkill = nmremoved[i];
      break;
   }
}

if (nkill > 0) {
   i = 0;
   nmtrys = 0;
   do {
      j = Rndm.unifint_(thrd, nprivate);
      if (!individual_dead[thrd][pth][subgroupid[thrd][pth][j]][dstm1]) {
         individual_dead[thrd][pth][subgroupid[thrd][pth][j]][dstm1] = true;
         ++i;
      }
      ++nmtrys;
   } while (i < nkill && nmtrys < 1000);
}

// Process any individual relocation actions.

if (manoption.equals("buy_one_rhino")) {
   
   /* Randomly select a rhino to purchase from either outside the
      system (an import) or from another ranch. */

   unif = Rndm.rndm1_(thrd, 0);
         
   printf_("step: beltmept= " + fdble_(beltmept[thrd], 8, 2) +
      " thrd= " + thrd + " pth= " + pth + " buy unif= " + unif);

   if (unif < pimport) {

      /* Simulate an imported individual by adding a clone of a
         randomly selected individual to the meta-population. */

      indivnm = Rndm.unifint_(thrd, n[thrd][pth][dstm1]);
      oldn = n[thrd][pth][dstm1];
      individual_age[thrd][pth][oldn][dstm1]
         = individual_age[thrd][pth][indivnm][dstm1];
      individual_patchident[thrd][pth][oldn][dstm1]
         = individual_patchident[thrd][pth][indivnm][dstm1];
      individual_gender[thrd][pth][oldn][dstm1]
         = individual_gender[thrd][pth][indivnm][dstm1];
      individual_energy[thrd][pth][oldn][dstm1]
         = individual_energy[thrd][pth][indivnm][dstm1];
      individual_movestatus[thrd][pth][oldn][dstm1]
         = individual_movestatus[thrd][pth][indivnm][dstm1];
      individual_lastpreg[thrd][pth][oldn][dstm1]
         = individual_lastpreg[thrd][pth][indivnm][dstm1];
      individual_dead[thrd][pth][oldn][dstm1]
         = individual_dead[thrd][pth][indivnm][dstm1];
      ++n[thrd][pth][dstm1];

   } else {

      // Randomly select a ranch that will sell one individual.
      
      i = (int) (unif * n[thrd][pth][dstm1]);
      patchid = individual_patchident[thrd][pth][i][dstm1];
      j = patch_ranchid[patchid - 1];

      // Randomly select a ranch that is to purchase this individual.

      nmtrys = 0;
      do {
	 k = Rndm.unifint_(thrd, ttlnmpatches);
         ++nmtrys;
      } while (j == patch_ranchid[k] && nmtrys < 100);
      if (nmtrys == 100) {
         iderr_("step: relocation loop, nmtrys= " + nmtrys);
      }

      // Transfer this (i+1)^th rhino to this (k+1)^th patch.

      individual_patchident[thrd][pth][i][dstm1] = k + 1;
   }
}

// Update each individual's move status.

for (i = 0; i < n[thrd][pth][dstm1]; ++i) {
   patchid = individual_patchident[thrd][pth][i][dstm1];

   if (individual_age[thrd][pth][i][dstm1] <
       ma[thrd][pth][patchid - 1][dstm1]) {
      individual_movestatus[thrd][pth][i][dstm1] = "resident";

   } else if (individual_age[thrd][pth][i][dstm1] ==
              ma[thrd][pth][patchid - 1][dstm1]) {
      individual_movestatus[thrd][pth][i][dstm1] = "wanderer";

   } else if ((individual_movestatus[thrd][pth]
			            [i][dstm1].equals("wanderer") &&
	       individual_gender[thrd][pth][i][dstm1].equals("female") &&
	       patch_nmfemales[thrd][pth][patchid - 1] <= 1) ||
              (individual_movestatus[thrd][pth]
	                            [i][dstm1].equals("wanderer") &&
	       individual_gender[thrd][pth][i][dstm1].equals("male") &&
	       patch_nmmales[thrd][pth][patchid - 1] <= 1) ||
              (individual_movestatus[thrd][pth]
	                            [i][dstm1].equals("resident") &&
	       patch_netveg[thrd][pth][patchid - 1][dstm1] > 1.)) {
      individual_movestatus[thrd][pth][i][dstm1] = "resident";
   
   } else if ((individual_movestatus[thrd][pth]
			            [i][dstm1].equals("wanderer") &&
	       individual_gender[thrd][pth][i][dstm1].equals("female") &&
	       patch_nmfemales[thrd][pth][patchid - 1] > 0) ||
              (individual_movestatus[thrd][pth]
	                            [i][dstm1].equals("wanderer") &&
	       individual_gender[thrd][pth][i][dstm1].equals("male") &&
	       patch_nmmales[thrd][pth][patchid - 1] > 0) ||
              (individual_movestatus[thrd][pth]
	                            [i][dstm1].equals("resident") &&
	       patch_netveg[thrd][pth][patchid - 1][dstm1] == 0.)) {
      individual_movestatus[thrd][pth][i][dstm1] = "wanderer";
   }
}

// Update birth events.

for (i = 0; i < n[thrd][pth][dstm1]; ++i) {
   patchid = individual_patchident[thrd][pth][i][dstm1];
   if (patchid == 0) {
      iderr_("step: patchid=0");
   }
   if (individual_gender[thrd][pth][i][dstm1].equals("male")) {
      continue;
   }

   nmconditions = 0;
   if (individual_age[thrd][pth][i][dstm1] >
       ma[thrd][pth][patchid - 1][dstm1]) {
      ++nmconditions;

   } else if (p1flag && thrd == 1 && pth == 1) {
      ++nmtooyoung;
   }

   if (individual_movestatus[thrd][pth][i][dstm1].equals("resident") ||
       individual_movestatus[thrd][pth][i][dstm1].equals("wanderer")) {
      ++nmconditions;

   } else if (p1flag && thrd == 1 && pth == 1) {
      ++nmnonres;
   }

   if (patch_nmmales[thrd][pth][patchid - 1] >= 1) {
      ++nmconditions;

   } else if (p1flag && thrd == 1 && pth == 1) {
      ++nmnomales;
   }

   if (individual_energy[thrd][pth][i][dstm1] > meaneb[dstm1]) {
      ++nmconditions;

   } else if (p1flag && thrd == 1 && pth == 1) {
      ++nmnoenergy;
   }

   if (individual_lastpreg[thrd][pth][i][dstm1] >
      intercalv[thrd][pth][patchid - 1][dstm1]) {
      ++nmconditions;

   } else if (p1flag && thrd == 1 && pth == 1) {
      ++nmnotready;
   }

   if (nmconditions == 5) {
      individual_lastpreg[thrd][pth][i][dstm1] = 0;

      // Create a new individual.

      ++nmnewborns;
      newn = n[thrd][pth][dstm1] + nmnewborns;
      if (newn > NMINDIV) {
         iderr_("step: newn= " + newn + " >NMINDIV");
      }
      individual_age[thrd][pth][newn - 1][dstm1] = 0;
      individual_patchident[thrd][pth][newn - 1][dstm1] = patchid;

      unif = Rndm.rndm1_(thrd, 0);
      if (unif < .5) {
         individual_gender[thrd][pth][newn - 1][dstm1] = "female";

      } else {
         individual_gender[thrd][pth][newn - 1][dstm1] = "male";
      }

      individual_energy[thrd][pth][newn - 1][dstm1] = jeb[dstm1];
      individual_movestatus[thrd][pth][newn - 1][dstm1] = "resident";
      individual_lastpreg[thrd][pth][newn - 1][dstm1] = 0;
      individual_dead[thrd][pth][newn - 1][dstm1] = false;
      ++totalborn[thrd][pth][dstm1];

   } else {
      
      /* All females who have not just given birth, regardless of
         their age, have their "time since last pregnancy" value
	 incremented by one time unit. */

      ++individual_lastpreg[thrd][pth][i][dstm1];
   }
} // End of loop over all individuals.
n[thrd][pth][dstm1] += nmnewborns;

/*
if (thrd == 1) {
   printf_("step: beltmept= " + beltmept[thrd] + " pth= " + pth +
      " nmnewborns= " + nmnewborns + " n= " + n[thrd][pth][dstm1]);
}
*/

// Find number of ranches with nonsustainable populations.

if (Math.abs(beltmept[thrd] - Intridslve.tfinal) < delta) {
   for (i = 1; i <= nmranches; ++i) {
      rchpopsze[thrd][pth][i - 1][dstm1] = 0;
      for (j = 0; j < ttlnmpatches; ++j) {
         if (patch_ranchid[j] == i) {
            rchpopsze[thrd][pth][i - 1][dstm1] += patch_nmindiv[thrd][pth][j];
         }
      }
   }
}

if (thrd == 1 && pth == 1) {
   if (Math.abs(beltmept[thrd] - Intridslve.tfinal) < .15) {
      fleopen_(11, "finalpop.dat", 'w');

      for (i = 0; i < n[thrd][pth][dstm1]; ++i) {
         if (!individual_dead[thrd][pth][i][dstm1]) {
            fprintf_(11, individual_gender[thrd][pth][i][dstm1] + " " +
               individual_age[thrd][pth][i][dstm1] + " " +
               individual_energy[thrd][pth][i][dstm1] + " " +
               individual_lastpreg[thrd][pth][i][dstm1]);
	 }
      }
      fclose_(11, 'w');
   }
}

/* Update each individual's patch membership.  Note that the algorithm
   assumes at least one adjacent patch has vegetation there. */

for (i = 0; i < n[thrd][pth][dstm1]; ++i) {

   // Sum the net vegetation values of adjacent patches.
   
   patchid = individual_patchident[thrd][pth][i][dstm1];
   nmadjacent = patch_nmadjacent[patchid - 1];
   if (nmadjacent == 0) {
      iderr_("step: nmadjacent=0");
   }
   vegsum = 0.;
   for (j = 0; j < nmadjacent; ++j) {
      k = patch_adjptch[patchid - 1][j];
      vegsum += patch_netveg[thrd][pth][k - 1][dstm1];
   }
   if (vegsum < 1.e-6) {
      continue;
   }

   // Randomly select an adjacent patch with nonzero net vegetation.
   
   for (j = 0; j < 10; ++j) {
      k = Rndm.unifint_(thrd, nmadjacent);
      ar = patch_adjptch[patchid - 1][k];
      if (ar == 0) {
         continue;
      }
      if (patch_netveg[thrd][pth][ar - 1][dstm1] > 0.) {
         break;
      }
      ar = 0;
   }
   if (ar == 0) {
      for (j = 0; j < nmadjacent; ++j) {
         ar = patch_adjptch[patchid - 1][j];
         if (patch_netveg[thrd][pth][ar - 1][dstm1] > 0.) {
            break;
         }
      }
   }
   individual_patchident[thrd][pth][i][dstm1] = ar;
}

// Update ranch abundances.

nranch[thrd][pth][0][dstm1] = 0;
nranch[thrd][pth][1][dstm1] = 0;
for (i = 0; i < n[thrd][pth][dstm1]; ++i) {
   patchid = individual_patchident[thrd][pth][i][dstm1];
   if (patchid == 0) {
      printf_("step: thrd= " + thrd + " pth= " + pth);
      iderr_("step: final update: patchid=0, i= " + i + " dst= " + dst);
   }
   ++nranch[thrd][pth][patch_ranchid[patchid - 1] - 1][dstm1];
}

/* Update patch net vegetation.  First, find the amount of vegetation
   that is available at this time point.
   Note: "availveg[i][dstm1]" is assumed here to be NEW vegetation at
         time point i so that there is no reason to subtract off the
	 amount of vegetation at time point i-1 to obtain the amount
	 of new vegetation as is done in Kostova et al. */

vegt = 0.;
vegtminus1 = 0.;
notfound = true;
for (i = 1; i < nmvegtimes; ++i) {
   if ((i == 1 && Math.abs(vegtime[i - 1] - beltmept[thrd]) < .05) ||
       (vegtime[i - 1] < beltmept[thrd] && beltmept[thrd] <= vegtime[i])) {
      vegt = availveg[i][dstm1];
      vegtminus1 = availveg[i - 1][dstm1];
      notfound = false;
      break;
   }
}
if (notfound) {
   printf_("step: vegtime0= " + vegtime[0] + " vegtimeend= " +
      vegtime[nmvegtimes - 1]);
   iderr_("step: beltmept= " + beltmept[thrd] + " vegtime not found");
}

for (i = 0; i < ttlnmpatches; ++i) {

   // Ratchet left-over-vegetation array.

   for (j = 1; j < nmwksleftover; ++j) {
      patch_vegleftover[thrd][pth][i][j - 1][dstm1] =
         patch_vegleftover[thrd][pth][i][j][dstm1];
   }

   patch_vegleftover[thrd][pth][i][nmwksleftover - 1][dstm1] =
      patch_vegchg[thrd][pth][i][dstm1] -
      patch_nmindiv[thrd][pth][i] * wfi[dstm1];

   /*
   patch_netveg[thrd][pth][i][dstm1] += patch_vegchg[thrd][pth][i][dstm1] -
      patch_nmindiv[thrd][pth][i] * wfi[dstm1];
   maxvegleftover = maxveg[dstm1] * patch_area[i];
   if (patch_netveg[thrd][pth][i][dstm1] > maxvegleftover) {
      patch_netveg[thrd][pth][i][dstm1] = maxvegleftover;
   }
   */

   if (nmwksleftover < nmsteps[thrd][pth][dstm1]) {
      patch_netveg[thrd][pth][i][dstm1] = 0.;
   }
   ++nmsteps[thrd][pth][dstm1];
   for (j = 0; j < nmwksleftover; ++j) {
      patch_netveg[thrd][pth][i][dstm1] +=
         patch_vegleftover[thrd][pth][i][j][dstm1];
   }

   if (patch_netveg[thrd][pth][i][dstm1] < 0.) {
      patch_netveg[thrd][pth][i][dstm1] = 0.;
   }

   /*
   patch_vegchg[thrd][pth][i][dstm1] = patch_area[i] * (vegt - vegtminus1);
   */

   patch_vegchg[thrd][pth][i][dstm1] = patch_area[i] * vegt;
}

// Update individual abundance to current time point.

yn[thrd][0] = n[thrd][pth][dstm1];

// Write this abundance realization to a plotting file.

if (!cacalc) {
   realizid = ((Beliefs.nmloops / nmthreads) + 1) * thrd + pth;
   fprintf_(ecorlztnsflenm, fdble_(beltmept[thrd], 8, 3) + " " +
      realizid + " " + nranch[thrd][pth][0][dstm1] + " " +
      nranch[thrd][pth][1][dstm1]);
}

/*
if (thrd == 1 && pth == 1) {
   printf_("step: t= " + beltmept[thrd] + " nmstressed= " + nmstressed);
   if (maxstressed < nmstressed) {
      maxstressed = nmstressed;
   }
   if (outflag[thrd]) {
      if (n[thrd][pth][dstm1] > 0) {
         printf_("step: tme= " + fdble_(beltmept[thrd], 7, 2) +
            " n= " + n[thrd][pth][dstm1] +
            " prntstressed= " + fdble_((((double) maxstressed) /
	    ((double) n[thrd][pth][dstm1])), 5, 2));

      } else {
         printf_("step: n=0");
      }
   }
}
*/

/*
if (thrd == 1 && dst == 1 && pth == 1) {
   printf_("step: beltmept= " + beltmept[thrd] + " yn= " + yn[thrd][0]);
}

printf_("step: thrd= " + thrd + " pth= " + pth + " dst= " + dst +
   " beltmept= " + beltmept[thrd] + " yn= " + yn[thrd][0]);
*/

}

// -----------------------------------------------------------------

public static void initialibm_(int thrd, int pth,
   double nodevals[][][], int dst) {

/* Initialize.  Note that the parameters of an IBM are not functions
   of the first parent, Time.  Also, parent values are found explicitly. */

int i, k, dstm1 = dst - 1;

double vegt = 0., vegtminus1 = 0., dum;

nmsteps[thrd][pth][dstm1] = 0;

// Zero arrays.

for (i = 0; i < NMINDIV; ++i) {
   individual_dead[thrd][pth][i][dstm1] = true;
   individual_patchident[thrd][pth][i][dstm1] = 0;
   individual_age[thrd][pth][i][dstm1] = 0;
   individual_gender[thrd][pth][i][dstm1] = "none";
   individual_movestatus[thrd][pth][i][dstm1] = "none";
   individual_energy[thrd][pth][i][dstm1] = 0.;
   individual_lastpreg[thrd][pth][i][dstm1] = 0;
   negmaleage[thrd][pth][i] = 0.;
   subgroupid[thrd][pth][i] = 0;
   oldmaleid[thrd][pth][i] = 0;
}

// Load initial population array.

for (i = 0; i < n[0][0][dstm1]; ++i) {
   individual_dead[thrd][pth][i][dstm1] = individual_dead[0][0][i][dstm1];
   individual_patchident[thrd][pth][i][dstm1] =
      individual_patchident[0][0][i][dstm1];
   individual_age[thrd][pth][i][dstm1] = individual_age[0][0][i][dstm1];
   individual_gender[thrd][pth][i][dstm1] =
      individual_gender[0][0][i][dstm1];
   individual_movestatus[thrd][pth][i][dstm1] =
      individual_movestatus[0][0][i][dstm1];
   individual_energy[thrd][pth][i][dstm1] = individual_energy[0][0][i][dstm1];
   individual_lastpreg[thrd][pth][i][dstm1] =
      individual_lastpreg[0][0][i][dstm1];
}
n[thrd][pth][dstm1] = n[0][0][dstm1];

/*
if (thrd == 1 && pth == 1) {
   printf_("initialibm: n= " + n[thrd][pth][dstm1]);
}
*/

totalkilled[thrd][pth][dstm1] = 0;
totaldied[thrd][pth][dstm1] = 0;
totalborn[thrd][pth][dstm1] = 0;

/* Initialize patch net vegetation.  First, find the amount of vegetation
   that is available at this time point. */

for (i = 1; i < nmvegtimes; ++i) {
   if (vegtime[i - 1] < beltmept[thrd] && beltmept[thrd] <= vegtime[i]) {
      vegt = availveg[i][dstm1];
      vegtminus1 = availveg[i - 1][dstm1];
      break;
   }
}

for (i = 0; i < ttlnmpatches; ++i) {
   patch_denschange[thrd][pth][i][dstm1] = false;
   patch_foodchange[thrd][pth][i][dstm1] = false;
   patch_density[thrd][pth][i] = 0.;
   ma[thrd][pth][i][dstm1] = ma[0][0][i][dstm1];
   intercalv[thrd][pth][i][dstm1] = intercalv[0][0][i][dstm1];

   /* Set the initial amount of net vegetation.  The early behavior
      of the model is very dependent on this value being large
      enough. */

   patch_netveg[thrd][pth][i][dstm1] = .9 * maxveg[dstm1] * patch_area[i];

   /*
   patch_vegchg[thrd][pth][i][dstm1] = patch_area[i] * (vegt - vegtminus1);
   */

   patch_vegchg[thrd][pth][i][dstm1] = patch_area[i] * vegt;
}
}

// ------------------------------------------------------------------------

public static void ibmreadfles_() {

/* Read-in amount of available vegetation per week (expressed as a
   fraction of a year). */

int i = 0, j, k = 0, l, nmobsm1;

double year = 0., dumtime = 0., dumveg = 0., maxtime = 0.;

nmobsm1 = Math.max(0, nmecoobsttl - 1);
maxtime = Math.max(Intridslve.tfinal, dat2_t[nmobsm1]);
maxtime += 2.;

fleopen_(flenm, "allknpveg.dat", 'r'); // All values.
// fleopen_(flenm, "availvegknp.dat", 'r'); // for 2014-2033
// fleopen_(flenm, "knpp98-12.dat", 'r'); // for 1998-2012

j = 0;
while (!checkbuffeof_(flenm)) {
   if (i == 0) {
      year = fgetdble_(flenm);

   } else {
      fgetdble_(flenm);
   }
   fgetdble_(flenm);

   dumtime = year + ((double) i) / 52.;
   dumveg = fgetdble_(flenm);

   if (Intridslve.t0 - 1. < dumtime && dumtime < maxtime) {
      vegtime[j] = dumtime;
      rawveg[j] = dumveg;
      ++j;
   }
   ++i;
}
fclose_(flenm, 'r');
nmvegtimes = j;

if (nmvegtimes < 2) {
   iderr_("ibmreadfles: t0= " + Intridslve.t0 + " nmvegtimes= " + nmvegtimes +
      " tfinal= " + Intridslve.tfinal);
}

/* Read-in patch characteristics.  Area is assumed to be kilometers^2
   as animal density is assumed to be in number of animals per km2. */

fleopen_(flenm, "patches.dat", 'r');
fgetline_(flenm);
fgetline_(flenm);
fgetstrng_(flenm);
nmranches = fgetint_(flenm);
for (i = 0; i < nmranches; ++i) {
   ranchname[i] = fgetstrng_(flenm);
   nmpatches[i] = fgetint_(flenm);
   for (j = 0; j < nmpatches[i]; ++j) {
      fgetint_(flenm);
      patch_ranchid[k] = i + 1;
      patch_area[k] = fgetdble_(flenm);
      rancharea[i] += patch_area[k];

      if (i == 0) {
         totalarea += patch_area[k];
      }

      patch_nmadjacent[k] = fgetint_(flenm);
      for (l = 0; l < patch_nmadjacent[k]; ++l) {
         patch_adjptch[k][l] = (fgetint_(flenm)) + ttlnmpatches;
	 if (patch_adjptch[k][l] <= 0) {
            iderr_("ibmreadfles: adjptch= " + patch_adjptch[k][l]);
	 }
      }
      ++k;
   }
   ttlnmpatches += nmpatches[i];
}
fclose_(flenm, 'r');

// Read-in the schedule of SANParks-specified rhino removals from KNP.

fleopen_(flenm, "knpremoved.dat", 'r');
fgetline_(flenm);
i = 0;
do {
   fgetstrng_(flenm);
   removaldate[i] = fgetdble_(flenm);
   nmremoved[i] = fgetint_(flenm);
   ++i;
} while (!checkeof_(flenm));
fclose_(flenm, 'r');
nmremovalevents = i;
}

// --------------------------------------------------------------

public static void ibmsetup_(int dst) {

// Initializes patch and individual characteristics in an IBM.

int i = 0, j, k = 0, l, i1, patchid, val, dstm1 = dst - 1;

double dum, c, rval, meanage = 0.;

// Initialize arrays.

for (i = 0; i < NMINDIV; ++i) {
   individual_dead[0][0][i][dstm1] = true;
   individual_patchident[0][0][i][dstm1] = 0;
   individual_age[0][0][i][dstm1] = 0;
   individual_gender[0][0][i][dstm1] = "none";
   individual_movestatus[0][0][i][dstm1] = "none";
   individual_energy[0][0][i][dstm1] = 0.;
   individual_lastpreg[0][0][i][dstm1] = 0;
   negmaleage[0][0][i] = 0.;
   subgroupid[0][0][i] = 0;
   oldmaleid[0][0][i] = 0;
}

// Read supporting files for IBM node.

if (!readibmfles) {
   ibmreadfles_();
   readibmfles = true;
}

/* Load parameter values and initialize population demographics parameters.

   Parameter                          Units
   ----------------------------------------
   le: life expectancy                years
   ma: maturation age                 years
   intercalv: intercalving interval   years
   wfi: weekly food intake            grams
   meb: maximum energy budget         weeks
   meaneb: mean energy budget         weeks
   jeb: juvenile energy budget        weeks

   Note: energy budget values indicate the number of weeks before an
   animal starves to death.  But in reality, animals are eating -- they
   just aren't eating enough.  Therefore, meb, meaneb, jeb should be
   interpreted as the number of weeks of food stress that an individual
   can endure before (s)he dies. */

k = Getmodlutils.getndnm_("RhinoIBM");
dum = 52. * condprb[idnmbrm1][k - 1][0][0][0][0][0][0][0][dstm1];
le[dstm1] = (int) Math.round(dum);

dum = 52. * condprb[idnmbrm1][k - 1][1][0][0][0][0][0][0][dstm1];
for (i = 0; i < ttlnmpatches; ++i) {
   ma[0][0][i][dstm1] = (int) Math.round(dum);
}

dum = 52. * condprb[idnmbrm1][k - 1][2][0][0][0][0][0][0][dstm1];
for (i = 0; i < ttlnmpatches; ++i) {
   intercalv[0][0][i][dstm1] = (int) Math.round(dum);
}

wfi[dstm1] = condprb[idnmbrm1][k - 1][3][0][0][0][0][0][0][dstm1];
wfi[dstm1] *= 1000.;

meb[dstm1] = condprb[idnmbrm1][k - 1][4][0][0][0][0][0][0][dstm1];
meaneb[dstm1] = condprb[idnmbrm1][k - 1][5][0][0][0][0][0][0][dstm1];
jeb[dstm1] = condprb[idnmbrm1][k - 1][6][0][0][0][0][0][0][dstm1];

// Reset parameter value during a sensitivity analysis run.

if (ssensanalysis) {
   Ssens.resetparm_();
}

// meaneb cannot be close to or larger than meb.

if (meaneb[dstm1] >= meb[dstm1]) {
   iderr_("ibmsetup: meaneb= " + meaneb[dstm1] + " meb= " + meb[dstm1]);
}

/* Create the initial population by generating it randomly across all
   ranches.  Kruger: 10500 for 2014-2033, 2700 for 1998-2012. */

if (Intridslve.t0 > 1997. && Intridslve.t0 < 2007.) {
   nranch[0][0][0][dstm1] = 1000; // reality: 2700, testing: 1000

} else if (Intridslve.t0 < 2015.) {
   nranch[0][0][0][dstm1] = 10000; // reality: 10000, testing: 1000

} else if (2015. <= Intridslve.t0 && Intridslve.t0 < 2017.) {
   nranch[0][0][0][dstm1] = 10000; // reality: 10000, testing 10000
}

if (knponly) {
   nranch[0][0][1][dstm1] = 0;

} else {
   nranch[0][0][1][dstm1] = 4500; // reality: 4500
}
n[0][0][dstm1] = 0;
meanage = 0.;
i = 0;
for (j = 1; j <= nmranches; ++j) {
   n[0][0][dstm1] += nranch[0][0][j - 1][dstm1];
   for (k = 0; k < nranch[0][0][j - 1][dstm1]; ++k) {

      if (i >= NMINDIV) {
         iderr_("ibmsetup: i= " + i + " = NMINDIV");
      }

      individual_dead[0][0][i][dstm1] = false;
      individual_lastpreg[0][0][i][dstm1] = 0;
      do {
	 val = 1 + Rndm.unifint_(0, ttlnmpatches);
      } while (patch_ranchid[val - 1] != j);
      individual_patchident[0][0][i][dstm1] = val;

      /* Initial age distribution.  Should be right-skewed and have
         high variance, see "finalpop.dat." */

      val = 1 + Rndm.unifint_(0, le[dstm1]);
      individual_age[0][0][i][dstm1] = val;
      meanage += ((double) val);

      unif = Rndm.rndm1_(0, 0);
      if (unif < .5) {
         individual_gender[0][0][i][dstm1] = "female";

      } else {
         individual_gender[0][0][i][dstm1] = "male";
      }
      
      unif = Rndm.rndm1_(0, 0);
      if (unif < .5 && individual_age[0][0][i][dstm1] > ma[0][0][0][dstm1]) {
         individual_movestatus[0][0][i][dstm1] = "wanderer";

      } else {
         individual_movestatus[0][0][i][dstm1] = "resident";
      }

      /* Initial energy levels.  Should have high variance -- actually,
         the distribution in "finalpop.dat" has all the juveniles with
	 energy=jeb, and all mature individuals with energy=meb. */
      
      if (individual_age[0][0][i][dstm1] > ma[0][0][0][dstm1]) {
         individual_energy[0][0][i][dstm1] =
            (int) (meb[dstm1] * Rndm.rndm1_(0, 0));

      } else {
         individual_energy[0][0][i][dstm1] =
            (int) (jeb[dstm1] * Rndm.rndm1_(0, 0));
      }

      if (individual_age[0][0][i][dstm1] > ma[0][0][0][dstm1] &&
          individual_energy[0][0][i][dstm1] > meb[dstm1]) {
         individual_energy[0][0][i][dstm1] = meb[dstm1];
      }
      if (individual_age[0][0][i][dstm1] < ma[0][0][0][dstm1] &&
          individual_energy[0][0][i][dstm1] > jeb[dstm1]) {
         individual_energy[0][0][i][dstm1] = jeb[dstm1];
      }
      if (individual_energy[0][0][i][dstm1] < 0.) {
         individual_energy[0][0][i][dstm1] = 0.;
      }
      
      // Initial time-since-last-pregnancy.
      
      if (individual_gender[0][0][i][dstm1].equals("female") &&
          individual_age[0][0][i][dstm1] > ma[0][0][0][dstm1]) {
	 val = Rndm.unifint_(0, intercalv[0][0][0][dstm1]);
         individual_lastpreg[0][0][i][dstm1] = val;
      }
      ++i;
   }
}

// Stop if the initial population is tiny.

if (n[0][0][dstm1] < 5) {
   iderr_("ibmsetup: initial n= " + n[0][0][dstm1]);
}

// Stop if patch identifiers are wrong.

for (i = 0; i < n[0][0][dstm1]; ++i) {
   if (individual_patchident[0][0][i][dstm1] == 0) {
      iderr_("ibmsetup: i= " + i + " zero patchid");
   }
}

/* Scale the available vegetation so that 75% of a 12000-rhino
   population of ranch 1 has enough to eat over the entire simulation
   interval.  Also, find the maximum amount of available vegetation
   that can exist at any one point in time. */

for (i = 0; i < nmvegtimes; ++i) {
   sortvec[i] = rawveg[i];
}
if (Intridslve.tfinal < 2013.) {
   // constveg = Summry.quantile_(nmvegtimes, sortvec, .30);
   constveg = 17.0;

} else {
   constveg = 17.0;
}
c = .75 * 12000. * wfi[dstm1] / (constveg * totalarea);
for (i = 0; i < nmvegtimes; ++i) {
   availveg[i][dstm1] = c * rawveg[i];
   sortvec[i] = availveg[i][dstm1];
}

/* Four months worth of the xx\% quantile of the scaled vegetation
   values. */

if (Intridslve.tfinal < 2013.) {
   // maxveg[dstm1] = 16. * Summry.quantile_(nmvegtimes, sortvec, .5);
   maxveg[dstm1] = 50000000.; // 3841322.3141;

} else {

   /*
   for (i = 1; i < 10; ++i) {
      maxveg[dstm1] = 16. * Summry.quantile_(nmvegtimes, sortvec,
		      (.9 + .01 * ((double) i)));
      printf_("i= " + i + " maxveg= " + maxveg[dstm1]);
   }
   iderr_("in ibmsetup");
   maxveg[dstm1] = 50000000.; // 3841322.3141;
   */

   maxveg[dstm1] = 16. * Summry.quantile_(nmvegtimes, sortvec, .99);
}

meanage /= ((double) n[0][0][dstm1]);

// Open abundance realization file.

if (!cacalc) {
   fleopen_(ecorlztnsflenm, ecorlztnsfle, 'w');
}
}

// ---------------------------------------------------------------------

public static void ranchsmmry_(int dst) {

// Computes summary statistics.

int i, j, k, l, dstm1 = dst - 1;

double fracunsus = 0.;

// Find the mean total killed.

CA.actnshstry_mdlecoave[0][Intridslve.tindex - 1][1] = 0.;
l = 0;
for (j = 0; j < nmthreads; ++j) {
   for (k = 0; k < idenom[j + 1]; ++k) {
      CA.actnshstry_mdlecoave[0][Intridslve.tindex - 1][1] +=
         (double) totalkilled[j][k][dstm1];
      ++l;
   }
}
CA.actnshstry_mdlecoave[0][Intridslve.tindex - 1][1] /= (double) l;

// Find the number of ranches with nonsustainable populations.

for (i = 0; i < nmranches; ++i) {
   l = 0;
   meansze[i] = 0;
   for (j = 0; j < nmthreads; ++j) {
      for (k = 0; k < idenom[j + 1]; ++k) {
         meansze[i] += rchpopsze[j][k][i][dstm1];
	 ++l;
      }
   }
   meansze[i] /= (double) l;
   if (meansze[i] < 3) {
      fracunsus += 1.;
   }
}
fracunsus /= (double) nmranches;
//printf_("ranchsmmry: fraction that are unsustainable= " + fracunsus);
}
}
