import java.rmi.RemoteException;
import java.util.*;
import java.util.concurrent.TimeUnit;

import org.openspaces.core.GigaSpace;
import org.openspaces.core.GigaSpaceConfigurer;
import org.openspaces.core.space.EmbeddedSpaceConfigurer;
import org.openspaces.core.space.SpaceProxyConfigurer;

import java.util.Arrays;
import java.util.Properties;

class Hooke extends Optimiz {

// Adapted from the C program of Mark G. Johnson, 1994 (see hooke_c.txt).

// Global variables.

static boolean highprint = false, parallel_algorithm = true;

static int vrble = 0, nmdimahead = 3;

static int loopstart[] = new int[2];
static int loopend[] = new int[2];

static long begintime = 0, soltime = 0;

static double objfsigma = 0., sigmaconst = 0.50, initialf;

static double z[] = new double[OPTSIZE];
static double zback[] = new double[OPTSIZE];
static double delta[] = new double[OPTSIZE];
static double xbefore[] = new double[OPTSIZE];
static double newx[] = new double[OPTSIZE];
static double fval[] = new double[27];
static double zstore[][] = new double[27][OPTSIZE];

// --------------------------------------------------------------------

static int hooke_(double startpt[], double xbest[], double rho,
   double epsilon, int itermax, boolean killclients) {

// Routine searches for the point that minimizes f().

int i, j, nvars, keep, iters, k1, retval, nmfutile = 0, futilemax = 50,
   nmtrys = 2;

double newf, fbefore, steplength, tmp, ftmp, oldx = 0.;

nvars = n;
endopt = false;

if (space_in_use && gspace == null) {

   // Get a new Space object.

   gspace = new GigaSpaceConfigurer(new SpaceProxyConfigurer(
      spacename)).defaultTakeTimeout(spacetakewaittime).gigaSpace(); 

   if (gspace == null ) {
      iderr_("Hooke: gspace=null");
   }

   try {
   TimeUnit.SECONDS.sleep(shortwaittime);
   } catch (java.lang.InterruptedException ie) {
   System.out.println(ie);
   } 

   for (i = 0; i < nmtrys; ++i) {
      MsgEntry msgTmpl = new MsgEntry();
      MsgEntry msg = new MsgEntry();

      msg = (MsgEntry) gspace.take(msgTmpl);

      if (msg != null) {
         printf_("Hooke: leftover Space terminate message, i= " + i);

      } else {
         printf_("Hooke: null Space message, i= " + i);
      }
   }
}

// Setup parallel version looping configuration.

if (parallel_algorithm) {
   if (nmdimahead == 1) {
      loopstart[0] = 0;
      loopend[0] = 1;
      loopstart[1] = 0;
      loopend[1] = 1;

   } else if (nmdimahead == 2) {
      loopstart[0] = -1;
      loopend[0] = 2;
      loopstart[1] = 0;
      loopend[1] = 1;

   } else if (nmdimahead == 3) {
      loopstart[0] = -1;
      loopend[0] = 2;
      loopstart[1] = -1;
      loopend[1] = 2;
   }
}

// Set "delta" for each variable.

for (i = 0; i < nvars; ++i) {
   xbest[i] = newx[i] = xbefore[i] = startpt[i];
   if (Pxp.vartype[i].equals("Determ_Discrete") || Pxp.prntssum) {
      delta[i] = 1.;
   
   } else {
      if (fnm == 11) {
         delta[i] = Math.abs(startpt[i] * rho);

      } else {

	 /* Set this to a big value and let the algorithm step down to
	    a workable value. */

         if (Math.abs(startpt[i]) < 10.) {
            if (Pxp.vartype[i].equals("Discrete")) {
	       delta[i] = Math.abs(.05); // was .2 * rho

	    } else {
	       delta[i] = .1 * (h[i] - g[i]); // was .2
            }

	    if (highprint) {
               printf_("hooke: var= " + (i + 1) + " startpt= " +
                  startpt[i] + " rho= " + rho + " delta= " + delta[i]); 
            }

         } else {
            delta[i] = Math.abs(startpt[i] * .7); // was pt*rho, .1

	    if (highprint) {
               printf_("hooke: stpt*rho, var= " + (i + 1) +
                  " startpt= " + startpt[i] + " delta= " + delta[i]); 
            }
         }
      }

      if (delta[i] == 0.0) {
         delta[i] = rho;
         printf_("hooke: original delta=0, var= " + (i + 1) +
            " new delta= " + delta[i]); 
      }
   }
}

steplength = rho;
iters = 0;
begintime = System.currentTimeMillis();
fbefore = f(newx);
initialf = fbefore;

// Find objective function evaluation wall clock time.

soltime = System.currentTimeMillis();
soltime = (soltime - begintime) / 1000;
printf_("hooke: initialf= " + initialf + " soltime= " + soltime + " seconds.");

newf = fbefore;

// Main loop.

while ((iters < itermax) && (steplength > epsilon) &&
   nmfutile < futilemax) {
   iters++;

   if (highprint) {
      printf_("hooke: funevals= " + funevals + " f(x)= " + fbefore + " at:");
      for (j = 0; j < nvars; j++) {
         printf_(" x(" + j + ")= " + xbefore[j]);
      }
   }
   printf_("\nhooke: beginning iters= " + iters + ", itermax= " +
      itermax + " steplength= " + fdble_(steplength, 9, 6));

   /* Future work: Update Optimiz.stochsamplesize for this iteration in a
      manner similar to that done in SimAnnealContin.simAnnealContin_().
      Currently, this value is whatever whatever is set in Optimiz.java and
      computed on its last iteration when Optimiz.optmethod=SA-MDAS. */
   
   // ??
   
   // Find best new point, one coord at a time.

   for (i = 0; i < nvars; ++i) {
      newx[i] = xbefore[i];
   }
   newf = best_nearby(gspace, delta, newx, fbefore, nvars);
   if (endopt) {
      printf_("hooke: endopt=true location 1 funevals= " + funevals);
      break;
   }

   // If we made some improvements, pursue that direction.

   keep = 1;
   while ((newf < fbefore) && (keep == 1)) {
      for (i = 0; i < nvars; ++i) {

         // Firstly, arrange the sign of delta[].

         if (newx[i] <= xbefore[i]) {
	    delta[i] = 0.0 - Math.abs(delta[i]);
         
	 } else {
	    delta[i] = Math.abs(delta[i]);
         }

         // Now, move further in this direction.
       
         tmp = xbefore[i];
         xbefore[i] = newx[i];
         if (!(Pxp.vartype[i].equals("Determ_Discrete") ||
               Pxp.prntssum)) {
            
            /* Original algorithm uses 1.0 to make this so-called
	       "optimistic" move. */
	    
            oldx = newx[i];
            newx[i] = newx[i] + .01 * (newx[i] - tmp);
            if (checkcnstrnts_(newx) != 0) {
               newx[i] = oldx;
            }

	 } else {
            oldx = newx[i];
	    newx[i] += sign_(1., (newx[i] - tmp));
            if (checkcnstrnts_(newx) != 0) {
               newx[i] = oldx;
            }
	 }
      }
      fbefore = newf;

      if (highprint) {
         printf_("\nhooke: calling second best_nearby with fbefore= " +
            fbefore);
      }
      newf = best_nearby(gspace, delta, newx, fbefore, nvars);

      if (endopt) {
         printf_("hooke: endopt=true location 2 funevals= " + funevals);
      }

      if (endopt) {
         fbefore = newf;
         for (i = 0; i < nvars; ++i) {
            xbefore[i] = newx[i];
         }
	 printf_("impresario (hooke): setting iters=itermax to exit main loop.");
         iters = itermax; // Causes a break out of the main loop.
	 break;
      }

      if (highprint) {
         printf_("hooke: after second best_nearby, newf= " + newf);
      }

      // If the further (optimistic) move was bad.... 
      
      if (newf >= fbefore) {
	 break;
      }

      /* make sure that the differences between the new
         and the old points are due to actual
         displacements; beware of roundoff errors that
         might cause newf < fbefore. */

      keep = 0;
      for (i = 0; i < nvars; ++i) {
         keep = 1;
         if (Math.abs(newx[i] - xbefore[i]) >
	     (0.5 * Math.abs(delta[i]))) {
	    break;
         
	 } else {
	    keep = 0;
	 }
      }
   } // End of "while" loop.

   if ((steplength >= epsilon) && (newf >= fbefore)) {
      steplength = steplength * rho;
      ++nmfutile;

      if (highprint) {
         printf_("impresario (hooke): impresario is shortening step size on" +
            " continuously-valued variables");
      }

      for (i = 0; i < nvars; ++i) {
         if (!(Pxp.vartype[i].equals("Determ_Discrete") ||
               Pxp.prntssum)) {
            delta[i] *= rho;
         }
      }
   }
}

printf_("\nhooke: steplength= " + fdble_(steplength, 9, 6) +
   " epsilon= " + epsilon + " iters= " + iters + " itermax= " + itermax +
   "\n   nmfutile= " + nmfutile + " futilemax= " + futilemax);
   
// Check for convergence.

if (steplength <= epsilon) {
   printf_("hooke: ******* Converged, funevals= " + funevals + "*******");

} else if (iters >= itermax) {
   printf_("hooke: Hit maximum number of iterations, returning.");

} else if (nmfutile >= futilemax) {
   printf_("hooke: Hit maximum number of futile iterations, returning.");
}

/* Return the best solution.  Note, in sequential Hooke-Jeeves
   (where !space_in_use and !parallel_algorithm), xbest is
   not continually updated as it is in the parallel version. */

if (!space_in_use && !parallel_algorithm) { // Sequential Hooke-Jeeves.
   for (i = 0; i < nvars; ++i) {
      xbest[i] = xbefore[i];
   }
}

return (iters);
}

// ----------------------------------------------------------------------

static double best_nearby(GigaSpace gspace, double delta[],
   double point[], double prevbest, int nvars) {

// given a point, look for a better one nearby, one coord at a time.

boolean prevflag = false, solimproved = false, flag = false,
   sigmatest = false;

int i, i1, i2, i3, j, k1, retval = 0, dummynm = 0, nmtasks = 0,
   nmattempts = 0, attemptlimit = 2, n = 0, m = 0, nmcompleted = 0,
   iplus1 = 0, iplus2 = 0;

long solwaittime;

double minf, ftmp, fdum, diff = 0., coefvar = 0., starttime = 0.,
   endtime = 0.;

Opttask task[] = new Opttask[50];

minf = prevbest;
for (i = 0; i < nvars; ++i) {
   z[i] = point[i];
}

if (sigmatest) {
   printf_("best_nearby: beginning loop over variables");
}

VARLOOP: for (i = 0; i < nvars; ++i) {
   vrble = i + 1;
      
   // Sequential Hooke-Jeeves coordinate search.

   if (!space_in_use && !parallel_algorithm) {
      z[i] = point[i] + delta[i];

      if (checkcnstrnts_(z) != 0) {
         z[i] = point[i];
      }
      ftmp = f(z);

      if (ftmp < minf - sigmaconst * objfsigma) {
         minf = ftmp;
	 if (sigmatest) {
            printf_("best_nearby: var(" + (i + 1) + ")= " + z[i] +
               " position 1 new minf= " + minf);
         }

      } else {
         delta[i] = 0.0 - delta[i];
         z[i] = point[i] + delta[i];
   
         // Check constraints.

         if (checkcnstrnts_(z) != 0) {
            z[i] = point[i];
         }
         ftmp = f(z);

         if (ftmp < minf - sigmaconst * objfsigma) {
	    minf = ftmp;
	    if (sigmatest) {
               printf_("best_nearby: var(" + (i + 1) + ")= " + z[i] +
                  " position 2 new minf= " + minf);
            } 

         } else {
	    z[i] = point[i];
         }
      }

   } else {

      /* Parallel version: exhaustively search this dimension and the
	 next two.  Do this by first computing and checking all of these
	 locations, and then computing the objective function values of
	 the feasible locations.  Finally, find the location having the
	 smallest objective function value.  For further details of this
	 algoritm, see "parhooke.tex."

	 If "space_in_use" is false and "parallel_algorithm" is true, this
         parallel search algorithm will execute on a standalone
         (single node) machine. */

      nmtasks = 0;
      iplus1 = 0;
      iplus2 = 0;
      for (j = i + 1; j < nvars; ++j) {
         iplus1 = j;
         break;
      }
      if (iplus1 > 0) {
         for (j = iplus1 + 1; j < nvars; ++j) {
            iplus2 = j;
            break;
         }
      }

      for (i1 = -1; i1 < 2; ++i1) {
	 z[i] = point[i] + i1 * delta[i];
         if (checkcnstrnts_(z) != 0) {
            z[i] = point[i];
	 }
	 Intridslve.nminoutpairs[Pxp.idownerm1[i]] = 0;

	 for (i2 = loopstart[0]; i2 < loopend[0]; ++i2) {
            if (nmdimahead > 1 && iplus1 > 0) {
	       z[iplus1] = point[iplus1] + i2 * delta[iplus1];
               if (checkcnstrnts_(z) != 0) {
                  z[iplus1] = point[iplus1];
	       }
	       Intridslve.nminoutpairs[Pxp.idownerm1[iplus1]] = 0;
            }

	    for (i3 = loopstart[1]; i3 < loopend[1]; ++i3) {
	       if (i1 == 0 && i2 == 0 && i3 == 0) {
		  continue;
	       }
	       if (nmdimahead > 2 && iplus2 > 0) {
	          z[iplus2] = point[iplus2] + i3 * delta[iplus2];
                  if (checkcnstrnts_(z) != 0) {
                     z[iplus2] = point[iplus2];
		  }
	          Intridslve.nminoutpairs[Pxp.idownerm1[iplus2]] = 0;
               }

	       // Store this location.

	       for (k1 = 0; k1 < nvars; ++k1) {
		  zstore[nmtasks][k1] = z[k1];
	       }
               
	       /* Compute and store the objective function value at this
                  location.  Do this by entering this function-evaluation
	          task into the JavaSpace.  Specifically, this task will
	          execute: fval[nmtasks] = f(z); */

	       fval[nmtasks] = 1.e20;
	       ++nmtasks;

	       if (space_in_use) {
	          task[nmtasks - 1] = new Opttask(nmtasks, nvars, nmids,
                     Optimiz.phasetwo, Optimiz.stochsamplesize, z, CA.nmobsactns,
		     CA.jackknifedeleted, Intridslve.nminoutpairs);

	          if (task[nmtasks - 1] == null) {
                     iderr_("best_nearby: task=null");
                  }

                  gspace.write(task[nmtasks - 1]);

               } else {
                  fval[nmtasks - 1] = f(z);
               }

	       if (iplus2 == 0) {
                  break;
               }

	    } // End i3 loop.

            if (iplus1 == 0) {
               break;
            }

	 } // End i2 loop.
      } // End i1 loop.
      
      if (space_in_use) {
         ResultEntry template = new ResultEntry();
         nmcompleted = 0;
   
         /* Wait for tasks to finish.
	 solwaittime = (long) (1.2 * (((double) (nmtasks * soltime)) /
			       ((double) nmperformers)));
         try {
         TimeUnit.SECONDS.sleep(solwaittime);
         } catch (java.lang.InterruptedException ie) {
         System.out.println(ie);
         } 
         // Loop until all task-results have been entered into the Space.
         // Now, collect task results from the Space.
         for (i1 = 0; i1 < nmtasks; ++i1) {
            ResultEntry result = new ResultEntry();
	    result = gspace.take(template, spacetakewaittime);
            if (result != null) {
               if (Optresult.class.isInstance(result)) {
                  Optresult hj = (Optresult) result;

                  i2 = hj.i.intValue();

                  // Get the objective function value computed by this task.

                  fval[i2 - 1] = hj.retfval.doubleValue();
                  ++nmcompleted;
               }
            }
         }
         */
         while (true) {
            ResultEntry result = new ResultEntry();
	    result = gspace.take(template, spacetakewaittime);
            if (result != null) {
               if (Optresult.class.isInstance(result)) {
                  Optresult hj = (Optresult) result;

                  i2 = hj.i.intValue();

                  // Get the objective function value computed by this task.

                  fval[i2 - 1] = hj.retfval.doubleValue();
                  ++nmcompleted;
	       }
	    }
	    if (nmcompleted == nmtasks) {
               break;
	    }
	 }

	 // Keep track of the total number of function evaluations.

         funevals += (stochsamplesize * nmcompleted);
         printf_("impresario (hooke): parallel funevals= " + funevals);
      }

      /* Find the location having the smallest objective function value
         and possibly replace "minf" with this value. */

      solimproved = false;
      for (k1 = 0; k1 < nmtasks; ++k1) {
         if (fval[k1] < minf - sigmaconst * objfsigma &&
             checkcnstrnts_(zstore[k1]) == 0) {

            printf_("impresario (hooke): i= " + i + " fval= " + fval[k1] +
               " < minf, task= " + (k1 + 1));

            solimproved = true;
            minf = fval[k1];
            for (i1 = 0; i1 < nvars; ++i1) {
               z[i1] = zstore[k1][i1];
               xbest[i1] = z[i1];
	    }
	 }
      } // End of loop over completed tasks.

      if (!solimproved) {

	 // No improvement: reset just these look-ahead dimensions.

         z[i] = point[i];
	 if (nmdimahead == 2 && iplus1 > 0) {
            z[iplus1] = point[iplus1];
         
	 } else if (nmdimahead == 3 && iplus2 > 0) {
            z[iplus1] = point[iplus1];
            z[iplus2] = point[iplus2];
         }
      }
   
      /* Increment the variable index up to the next set of
         "nmdimahead" variables. !! Note that "i" will be increased
         by an additional 1 unit at the top of its "for" loop, above. */

      if (nmdimahead == 2 && iplus1 > 0) {
         i = iplus1;

      } else if (nmdimahead == 3 && iplus2 > 0) {
         i = iplus2;
      }
   } // End of parallel version.

   // Terminate if maximum number of function evaluations is hit.

   if (funevals > maxnmf) {
      printf_("f: funevals= " + funevals + " > maxnmf terminating search.");
      endopt = true;
      break;
   }
} // End of loop over variables.

// Load this newly-found best-nearby point into the "point" array.

for (i = 0; i < nvars; ++i) {
   point[i] = z[i];
}
return (minf);
}

// --------------------------------------------------------------------

static double f(double x[]) {

// Evaluates the objective function.

int i;

double retval = 0.;

++funevals;

for (i = 0; i < stochsamplesize; ++i) {
   retval += -objf_(x);
}
retval /= ((double) stochsamplesize);

return retval;
}

// ---------------------------------------------------------------------

static void terminateClients_(GigaSpace gspace) {

// Cleans up before terminating.

if (gspace != null) {

   // Terminate clients.

   printf_("Terminating Gigaspace clients");

   MsgEntry msg = new MsgEntry();
   msg.message = "terminate";
   gspace.write(msg);
 
   /* Wait 10 seconds to give the clients time to read this message before the
      JavaSpace disappears following the termination of the impresario script. */

   try {
   TimeUnit.SECONDS.sleep(60L);
   } catch (java.lang.InterruptedException ie) {
   System.out.println(ie);
   } 
}
}
}
