class IBMutils extends IBMcalcs {

static String riskfle;

// -------------------------------------------------------------

static double computerisk_(double extnctyear) {

// Compute extinction risk.

int n = 0;

double t = 0., lastt = 0., sum1 = 0., sum2 = 0., drate = .035,
   risk1 = 0., risk2 = 0., abund = 0., extinctionprob = -1.;

fleopen_(ecorlztnsflenm, ecorlztnsfle, 'r');
fleopen_(5, riskfle, 'w');

do {
   t = fgetdble_(ecorlztnsflenm);

   // Input file needs to have been sorted by time.

   if (t < lastt) {
      iderr_("computerisk: input file not sorted by time");
   }

   // Throw away quantity 18*threadnm+pathnm.

   fgetint_(ecorlztnsflenm);

   if ((t > lastt && n > 0) || (checkeof_(ecorlztnsflenm) && n > 0)) {
      sum1 /= (double) n;
      risk1 = sum1 * Math.pow((1. - drate), (t - 2014.));
      sum2 /= (double) n;
      risk2 = sum2 * Math.pow((1. - drate), (t - 2014.));
      fprintf_(5, fdble_(lastt, 8, 3) + " " + fdble_(sum1, 5, 3) + " " +
         fdble_(risk1, 5, 3) + " " + fdble_(sum2, 5, 3) + " " +
	 fdble_(risk2, 5, 3));

      /* Compute the largest extinction probability in requested year. */

      if (Math.abs(lastt - extnctyear) < .1) {
         extinctionprob = Math.max(sum1, sum2);
      }

      // Re-initialize counters.

      sum1 = 0.;
      sum2 = 0.;
      n = 0;
   }

   /* Less than 3 individuals is not a viable population because in
      the best scenario of 2 individuals, all offspring, if any, would
      be genetically compromised. */

   abund = (double) fgetint_(ecorlztnsflenm);
   if (abund <= 2) {
      sum1 += 1.;
   }
   abund = (double) fgetint_(ecorlztnsflenm);
   if (abund <= 2) {
      sum2 += 1.;
   }
   ++n;
   lastt = t;
} while (!checkeof_(ecorlztnsflenm));

fclose_(ecorlztnsflenm, 'r');
fclose_(5, 'w');
return extinctionprob;
}
}
