/* program id

   Builds Influence Diagrams, simulates the marginal
   distributions, writes output reports, and performs Consistency
   Analysis.

   Some limits:
     1) maximum of TNMNDS nodes
     2) maximum of TNMVALS levels for a node (variable).  NOTE: Often,
        the limiting node is Region in an ecosystem ID.  All of these
	regions, however, are needed because they are needed when an
	actions history file is read.
     3) maximum of TNMPRTS conditioning nodes for any node.

   Global arrays:
     nodelbls . . . Dimensions are: ID number, node number, labels
                      (position 0: node name,
                       positions 1 through 4: node value labels)

     parmlbls . . . Dimensions are: ID number, node number, lables
                      (0 through TNMVALS: node parameter labels)

     nodenghs . . . Dimensions are: ID number, node number, labels
                      (0: number of node values,
                       1: number of node neighbors (parents),
                       2 through 7: neighbor node numbers)

     condprb  . . . Dimensions are: ID number, node number, node value,
                    neighbor 1 value, neighbor 2 value, ... ,
                    neighbor 6 value, distribution index
                    (1= Theoretical, 2= Consistent).

     If varinfo_dist[][] is "Lognormal," "Gamma," LOMAP, "SDE," "HIBM", or
     "PIBM" the number of node values = number of parameters and
     these parameters are stored in condprb[][][1,2,...][neighbors].
*/

import java.io.*;

class Id extends Run_id {

// Set constants.

static final int NMTHRDS = 12; // Maximum number of processors (threads).
static final int TNMIDS = 10; // Maximum number of IDs, was 20 or 7.
static final int TNMNDS = 50; // Maximum number of nodes, was 1800
static final int TNMNDSSQRD = TNMNDS * TNMNDS;
static final int TNMPRTS = 6; // Maximum number of parents.
static final int NMPRBDIM = 6; // Number of condprb array parent dims.
static final int TNMVALS = 35; // Maximum number of values per variable,
                               // was 35, 85, 12, then 22.

// Set the number of actions to 20000 if reading a large raw actions file.

static final int NMACTNS = 50000; // Maximum number of actions. was 4000

static final int NMPOSTACTS = 10; // Number of actions to be posted, was 5.
static final int NMEPISODES = 10000; // Maximum number of episodes in Episodes.
static final int NMACTTHRDS = 6000; // Max # of action threads, use 3600.
static final int NMTHRDPTS = 10000; // Max # of action thread points, was 200
static final int MAXNMSUBJ = 7; // Maximum number of subjects.
static final int MAXNMECO = 2; // Maximum number of ecosystem output nodes.
static final int MAXNMGRPS = 600; // Max. number of named groups.
static final int NMRGNS = 600;
static final int MAXNMEMAT = 700;
static final int NMEMATOBJS = 100;
static final int NMSENS = 200; // was 500
static final int NMWRDS = 3000;
static final int MAXNMSTRD = 20; // Number of stored sentence components.

// Maximum number of social network links.

static final int TNMLINKS = 5 * TNMNDS * TNMNDS / 2;
static final int NMSNETS = 5; // was 100

static final int STRNGLTH = 50; // Maximum string length in Pltgrph.
static final int LBLLTH = 200; // Maximum node label length in Pltgrph.
static final int NMDUMNDS = 300;  // Dummy nodes for Pltgrph.
static final int NMPROWS = 50;    // Max. # of rows in Pltgrph.
static final int NMPCOLS = 40;    // Max. # of columns in Pltgrph.
static final int NMPLTCOLS = 100; // Max. # of columns in Pltsurf.

/* Constrained optimization routine, Optimiz.java:
   OPTSIZE: Number of independent variables,
   SIMSZE:  Simulated data set size, and
   MAXBOXK: Maximum number of search points. */

static final int OPTSIZE = 2000; // was 150

/* Simulation size for influence diagrams.  Was 10000.  Set <= 100 for
   SMScalcs runs. */

static final int SIMSZE = 2000;

static final int SDESIMSZE = 200; // Simulation size for SDEs.
static final int ISIMSZE = 30; // Simulation size for IBMs: >= 2NMTHRDS.
static final int ASIMSZE = 15; // Simulation size for ABMs.  was 21
static final int MAXBOXK = 5;

// SDE, IBM, SMS, and ABM constants.

static final int MAXNMSDE = 4;       // Max. # of time-stepping functions.
static final int NMINDIV = 30000;    // Max. # of IBM individuals, was 30000.
static final int NMSMSINDIV = 50;    // Max. # of individuals in an SMS.
static final int NMPTCHS = TNMVALS;  // Max. # of patches in an IBM, was 8.
static final int NMSTEPS = 175;      // Max. # of steps an animal can take.

static final int NMAGNTS = 400;      // Max. # of agents, was 200 then 400.

static final int TNMRULES = 2;       // Max.# of CPT rules.

// Maximum number of parameters per node.

static final int MAXNMNDEPAR = 750; // was 1100

// Number of LOMAP variables, covariogram models, and GLOMAP centers.

static final int NUMVAR = 2; // was 4
static final int NUMMDLS = NUMVAR + NUMVAR * (NUMVAR - 1) / 2;
static final int NUMCNTR = 1;

// Number of trend parameters and total number of parameters.

static final int NMWRPAR = 12; // was 35
static final int NMTTLPAR = NUMVAR * NMWRPAR + 2 * NUMVAR + NUMMDLS * 5;

// Maximum number of input-output pairs that can be stored.

static final int NMINOUTPAIRS = 10000; // was 300

// Array size in the Simulated Annealing routine.

static final int SIMASZE = 2500; // was 12000 then 3200

// Max # of observations.

static final int DATSZE = 1000; // was 8000

// Used in Densest, elsewhere.

static final int WLSSZE = 60; // was 150 then 450
static final int WLSSZE2 = 60; // 2 for species.id

// Size of arrays in the class Idsort.

// static final int SORTSZE = Math.max(SIMSZE, WLSSZE);
static final int SORTSZE = 1000000; // was 90000

/* Maximum number rows, columns, time points, and user-defined spatial
   locations. */

static final int ROWLIM = 10; // 51 for maps
static final int COLLIM = ROWLIM;

// Maximum number of grayscale or contour levels.

static final int MAXNMLV = 10;

/* Maximum number of time points.  Was 450 for Saki mud, 20 for U.S. dep.
   then 255. */

static final int MAXTIMES = 2700; // was 500

static final int MAXLOCS = 2;

static final int MAXNMBD = 300; // Max # of boundaries, was 300
static final int MAXNMBPT = 1700; // Max # of points in 1 boundary: was 280

static final int NMQUANT = 3; // Max # of covariates in "trendfcn_."
static final int NMQUAL = 3;    // Max # of qual. vars in "trendfcn_."

static final int LGDIM = 7; // Max # of variogram lags, was 50.

static final int NMSSTP = 128; // Max # of spatial FFT points., was 64
static final int NMTSTP = 32; // Max # of temporal FFT points. was 512

static final int MMXN = 100; // Used in "minmax_."
static final int MMXM = 50;  // Used in "minmax_."

// MOC and Tutor related constants.

static final int NMSTDNTS = 10;
static final int BIGNMWRDBINS = 10000;
static final int NMWRDBINS = 100;
static final int NMCLSTRS = 10;
static final int NMDOCS = 40;

// Interdiction patrol route constants.

static final int NMTYPES = 20; // Number of attacker types.
static final int NMRTES = 500; // Number of defender or attacker routes.
static final int NMRTEPTS = 100; // Number of points per route.
static final int MAXCLS = 20; // Number of clusters.
static final int MAXN = 1000; // Cluster analysis data set size.
static final int MAXMBRS = 100; // Cluster size.

static final double PI = Math.PI;
static final double PIT2 = 2. * Math.PI;
static final double SQRTTWO = Math.sqrt(2);

// ---------------- Declare global variables. -----------------------

static boolean idinfo_hashibm[] = new boolean[TNMIDS];
static boolean idinfo_haspibm[] = new boolean[TNMIDS];
static boolean idinfo_hasabm[] = new boolean[TNMIDS];

static String name, phenom_class, reportqualifier, disply, rptfle, estfle,
   datafle, thisidname = "not_known", regionnode = "none",
   initial_ecosystem_action = "beginning_state", impresarioip,
   spacename = "space671";

static String idfle[] = new String[TNMIDS];
static String idname[] = new String[TNMIDS];
static String idsymb[] = new String[TNMIDS];
static String idcountry[] = new String[TNMIDS];
static String idPlayerID[] = new String[TNMIDS];
static String countrymap[] = new String[TNMIDS];
static String phenomenon_class[] = new String[TNMIDS];
static String nodelbls[][][] = new String[TNMIDS][NMDUMNDS][TNMVALS + 1];
static String parmlbls[][][] = new String[TNMIDS][TNMNDS][TNMVALS];
static String dstfle[][] = new String[TNMIDS][4];
static String gphtitl[] = new String[2];
static String grph_label[][] = new String[TNMIDS][TNMNDS];
static String graphcmds[] = new String[2];
static String condvaltype[] = new String[10];

static boolean isString = false, seasclc = false, client = false,
   optimal_decision = false, predskill = false, cacalc = false,
   dsensanalysis = false, ssensanalysis = false, psensanalysis = false,
   findmpemp = false, hassituation = false, interdict = false,
   deduplicateplayers = false, estimatesocialnetwork = false,
   evaluatesocialnetwork = false, tutor = false, pursuit = false,
   space_in_use = false, readrawgroup = false;

static int nmthreads, nmcondnds, nmnds, nmecoobsttl, nmestndes,
   nmevalndes, map = 0, nmcmprgns = 0, nmdattimes = 0, nmids = 1,
   idnmbrm1 = 0, nmcountries = 1, nmgisfles = 0;

static int idinfo_nmsdes[] = new int[TNMIDS];
static int nodenghs[][][] = new int[TNMIDS][TNMNDS][2 + 6]; // Always use max # of parents.
static int nmobs[][] = new int[TNMIDS][TNMNDS];
static int rspns[] = new int[DATSZE];
static int condnodes[][] = new int[TNMIDS][TNMNDS];
static int marg_ndnm[] = new int[OPTSIZE];
static int marg_valnm[] = new int[OPTSIZE];
static int countrynm[] = new int[TNMIDS];

static long runtime;
static long spacetakewaittime = 5000; // 5 seconds (units are milliseconds).
static long spacewaittime = 3000; // 3 seconds (units are milliseconds).
static long shortwaittime = 2; // One second (units are seconds).

static double abeta, bbeta, unif, datxmin = 1.e10, datxmax = -1.e10,
   datymin = 1.e10, datymax = -1.e10, dattmin = 1.e10, dattmax = -1.e10,
   datmin = 1.e10, datmax = -1.e10;

static double condvals[] = new double[TNMNDS];
static double sigma[] = new double[OPTSIZE];
static double theta[] = new double[OPTSIZE];
static double dattimes[] = new double[MAXTIMES];
static double marg_consis[] = new double[OPTSIZE];
static double marg_obsvd[] = new double[OPTSIZE];

// Space-time constants.

static String spacetime_outfle, spacetime_bdrysfle, spacetime_datfle,
   spacetime_labelfle, spacetime_xyptsfle, spacetime_psfle;

static String spacetime_infle[] = new String[3];
static String spacetime_surffle[] = new String[3];

static int spacetime_nmrows, spacetime_nmcols, spacetime_option = 6,
   spacetime_ntimes, spacetime_grdtyp = 1, spacetime_predoption,
   spacetime_nmmc, spacetime_surfvar, spacetime_nminfles;

static double spacetime_lngmn, spacetime_lngmx, spacetime_latmn,
   spacetime_latmx, spacetime_xmin, spacetime_xmax, spacetime_ymin,
   spacetime_ymax, spacetime_tmin = -1.e30, spacetime_tmax = 1.e30,
   spacetime_xdim, spacetime_estmin, spacetime_estmax,
   spacetime_begintime, spacetime_endtime;

// Global LOMAP variable parameters.

static boolean mdfit, trnsfrm, spatial = false, temporal = false;

static int parm_mvar, kmax, kmaxt, itrend;

static int lomapnms[] = new int[NUMVAR];
static int idtostnm[] = new int[TNMNDS];

static int dat2_vrble[][] = new int[2][DATSZE];
static int dat2_qualval[][] = new int[DATSZE][NMQUAL];
static int dat2_loc3d[] = new int[DATSZE];

static double dat2_x[] = new double[DATSZE];
static double dat2_y[] = new double[DATSZE];
static double dat2_z[] = new double[DATSZE];
static double dat2_t[] = new double[DATSZE];
static double dat2_dat[] = new double[DATSZE];
static double dat2_quantval[][] = new double[DATSZE][NMQUANT];
static double dat2_stddev[] = new double[DATSZE];

static String  varinfo_dist[][] = new String[TNMIDS][TNMNDS];
static String  varinfo_memnde[][] = new String[TNMIDS][TNMNDS];
static String regionname[] = new String[TNMVALS];

static boolean varinfo_eval[][] = new boolean[TNMIDS][TNMNDS];
static boolean varinfo_parest[][] = new boolean[TNMIDS][TNMNDS];
static boolean varinfo_temporal[][] = new boolean[TNMIDS][TNMNDS];

static int     varinfo_nmparms[][] = new int[TNMIDS][TNMNDS];

static double  varinfo_bounds[][][][] = new double[TNMIDS][TNMNDS]
						  [MAXNMNDEPAR][2];
static double  varinfo_range[][][] = new double[TNMIDS][TNMNDS][2];

static String bdry_reglabel[] = new String[MAXNMBD];
static int    bdry_countrynm[] = new int[MAXNMBD];

static int    bdry_nmbdrys;
static int    bdry_nmbdpts[] = new int[MAXNMBD];

static double bdry_xbdry[][] = new double[MAXNMBD][MAXNMBPT];
static double bdry_ybdry[][] = new double[MAXNMBD][MAXNMBPT];
static double bdry_xmin[] = new double[MAXNMBD];
static double bdry_xmax[] = new double[MAXNMBD];
static double bdry_ymin[] = new double[MAXNMBD];
static double bdry_ymax[] = new double[MAXNMBD];
static double bdry_minrad[] = new double[MAXNMBD];
static double bdry_maxrad[] = new double[MAXNMBD];
static double bdry_meanrad[] = new double[MAXNMBD];
static double bdry_predmin[] = new double[MAXNMBD];
static double bdry_predmax[] = new double[MAXNMBD];
static double bdry_kvarmin[] = new double[MAXNMBD];
static double bdry_kvarmax[] = new double[MAXNMBD];
static double bdry_cvmin[] = new double[MAXNMBD];
static double bdry_cvmax[] = new double[MAXNMBD];
static double bdry_cimin[] = new double[MAXNMBD];
static double bdry_cimax[] = new double[MAXNMBD];
static double bdry_nugmin[] = new double[MAXNMBD];
static double bdry_nugmax[] = new double[MAXNMBD];
static double bdry_sillmin[] = new double[MAXNMBD];
static double bdry_sillmax[] = new double[MAXNMBD];

// --------------------- Main program. ------------------------------

void id_(String cmdlnearg1, String cmdlnearg2, String cmdlnearg3) {

boolean windowopen = false;

String idflenme;

int i, rspnse;

// Load command line argument string into id language file name.

idflenme = cmdlnearg1;

// Set client status and the Space-use state.

if (cmdlnearg2.equals("worker") || cmdlnearg2.equals("client")) {
   client = true;

} else if (cmdlnearg2.equals("impresario")) {
   client = false;

} else {
   client = false;
}

// Create an input stream reader and from that, a buffered reader

try {
isr = new InputStreamReader(System.in);
br = new BufferedReader(isr);
}
catch (Exception e) {
iderr_("console io initialization failed");
}

// Write banner to screen.

if (!client) {
   printf_("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n"
      + "                                     id\n"
      + "                        Influence Diagram Construction,\n"
      + "                       Estimation, and Evaluation System\n"
      + "                          written by Timothy C. Haas\n"
      + "                      Sheldon B. Lubar College of Business\n"
      + "                       University of Wisconsin-Milwaukee\n"
      + "                       P.O. Box 742, Milwaukee, WI 53201\n"
      + "                                 haas@uwm.edu\n"
      + "                                November 2025.\n\n\n");
}

/* Discover the number of available processors and from that, the
   number of threads that can be run.  Or, hand-code the number of
   threads.  !!Note, nmthreads > 0 and is used in several places.
   Also, there needs to be nmthreads + 1 physical processors available
   because conddist_() uses the main thread (threadnm = 0) to monitor
   the simulation workers running on threads 1, ..., nmthreads.
   So, set the number of physical processors to 1 + nmthreads in any
   shellscript that runs ID.  But if processors are expensive as on
   the TSCC, set the number of processors to nmthreads. */

nmthreads = Runtime.getRuntime().availableProcessors() - 1;
nmthreads = 10; // was 5
if (nmthreads >= NMTHRDS) {
   iderr_("id: nmthreads= " + nmthreads);
}

// Initialize the ID name array "createarray," and the idPlayerID arrays.

for (i = 0; i < TNMIDS; ++i) {
   idname[i] = "not_known";
   Readnet.createarray[i] = false;
   idPlayerID[i] = "none";
}

// Read id input file.

Getmodl.getmodl_(1, idflenme);

if (client && tutor) {
   return;
}

// Start timer.

runtime = -System.currentTimeMillis();

// Write report file.

Report rpt = new Report();
windowopen = rpt.report_();

/* If this is the impresario invocation of id, terminate id_() by
   running iderr_().  This termination routine closes various files.
   But if this is a client run, just exit id_() without closing anything
   and then return to Workerg.startWork() where this client will enter
   an endless loop waiting for tasks. */

if (!windowopen && !client) {
   iderr_("Normal termination of id");
}
}
}
