import java.util.*;
public class Idsolve extends Intridslve {

static boolean randomchoice = false, parameterlearning = false;

static int trgts[] = new int[TNMVALS];
static int intgrdev[] = new int[5];

static double choicedst[] = new double[TNMVALS];
static double expctutil[] = new double[TNMVALS];
static double expctutilh[] = new double[TNMVALS];
static double eutilsum[] = new double [TNMIDS];

// -------------------------------------------------------------------

static double idsolve_(int tindex) {

/* Solves an ID.  By coding, this is done in two ways.
   1. Finding the expected value of the Utility node under each Output
      Action and Targets node value combination and then returning the
      output action and target(s) list that maximizes this expected
      value.
   2. Randomly sampling once from the discrete distribution formed by
      the normalized expected utilities across the decision options. */

String strng1;

int i, j, k, l, m, intval, nodenm, nmtargets, optactnh, nmdevs = 5;

double maxexpcth, maxexpct, val, askpricestddev = 0., bidpricestddev = 0.,
   std = 0.;

/* Add the Output Action and Targets nodes to the conditioning node set.
   to avoid over-writing, always list the action and target nodes last
   in the "inputs" relation in the .id file. */

if (hassituation) {
   nmcondnds = nmcondndes[idnmbrm1];
   condnodes[idnmbrm1][nmcondnds - 2] = decnode[idnmbrm1];
   condnodes[idnmbrm1][nmcondnds - 1] = trgtsnode[idnmbrm1];
   nminputnodes = nmcondnds - 2;

} else {
   nmcondnds = 1;
   condnodes[idnmbrm1][0] = decnode[idnmbrm1];
   nminputnodes = 0;
}

if (ipflag) {

   // Open a throw-away file for the beliefs output.

   fleopen_(3, "dum.bel", 'w');
   fprintf_(3, "\n                        BELIEFS");
}

// Acquire the number of actions and the number of targets.

if (!phenomenon_class[idnmbrm1].equals("econsystem")) {
   nmoptions = nodenghs[idnmbrm1][decnode[idnmbrm1] - 1][0];

} else {
   nmoptions = 1;
}

// Initialize things.

maxexpcth = 0.;
maxexpct = 0.;
eutilsum[idnmbrm1] = 0.;

optactnh = 1;
optactn = 1;
opttrgts = 1;

for (i = 0; i < nmoptions; ++i) {
   trgts[i] = 0;
}

if (hassituation && ctrgtnode[idnmbrm1] == 0 && !isabm) {
   nmtargets = nodenghs[idnmbrm1][trgtsnode[idnmbrm1] - 1][0];

} else {
   nmtargets = 1;
}

// Perform any learning modifications to the CPTs.

if (parameterlearning) {
   Parlearn.parlearn_();
}

// Loop over all combinations of the action and targets nodes.

CA.nm_grp_condsets[idnmbrm1] = (double) (nmoptions * nmtargets);
for (i = 1; i <= nmoptions; ++i) {
   for (j = 1; j <= nmtargets; ++j) {
   
      /* Set values for the Decision and Target node.  Note that
	 even though Target=1 is set, the action dictates the
	 Chosen_Target value so all conditional distributions are
	 correct in the simulation. */

      if (hassituation) {
         condvals[nmcondnds - 2] = i;
         condvals[nmcondnds - 1] = j;

      } else {
	 condvals[0] = i;
      }

      // Find all marginal distributions and sum the g_H value.

      beliefs_(3, CA.ch);
      CA.gh_group[idnmbrm1] += gh_measure;

      // Get Target under this outaction combination.

      if (ctrgtnode[idnmbrm1] > 0) {

         /* The Chosen_Target is a child of the Action node so the
            mode of this conditional distribution is the optimal target. */

         if (!loadconsdst) {
	    trgts[i - 1] = Summry.mode_(
	       nodenghs[idnmbrm1][ctrgtnode[idnmbrm1] - 1][0],
	       beliefh[0][0][ctrgtnode[idnmbrm1] - 1]);

         } else {
            trgts[i - 1] = Summry.mode_(
               nodenghs[idnmbrm1][ctrgtnode[idnmbrm1] - 1][0],
	       beliefc[0][0][ctrgtnode[idnmbrm1] - 1]);
         }

      } else {
         trgts[i - 1] = j;
      }
      
      // An ABM's decision is inevitable based on its input action.
      
      if (thisidname.equals("traders")) {

         /* Get the trader-requested number of animals to poach and
            place it in the order array, "actions_econinput." */

         actions_econinput[0][0][0] = 10;

	 /* Acquire the mean and standard deviation of the trafficked
	    product's price that the trader is willing to pay the
            middleman for rhino horn. */

         k = Getmodlutils.getndnm_("BPRICE");
         if (!loadconsdst) {
            val = beliefh[0][0][k - 1][0];
            std = beliefh[0][0][k - 1][1];

         } else {
            val = beliefc[0][0][k - 1][0];
            std = beliefc[0][0][k - 1][1];
         }
         currbidprice[idnmbrm1] = val;
         bidpricestddev = std;

         break;
      
      } else if (thisidname.equals("mntwrk")) {
         k = Getmodlutils.getndnm_("AVEWAGE");
         if (!loadconsdst) {
            currwage[idnmbrm1] = beliefh[0][0][k - 1][0];

         } else {
            currwage[idnmbrm1] = beliefc[0][0][k - 1][0];
         }

         k = Getmodlutils.getndnm_("ICOPROFIT");
         if (!loadconsdst) {
            aveprofit = beliefh[0][0][k - 1][0];

         } else {
            aveprofit = beliefc[0][0][k - 1][0];
         }
         break;
      }

      // Load approximated expected utilities from the utility node.

      if (!loadconsdst) {
         expctutil[i - 1] = beliefh[0][0][utlnode[idnmbrm1] - 1][0];
      
         /*
         if (nmids >= 1) {
            printf_("idsolve: i= " + i + " expctutil= " + expctutil[i - 1]);
         }
         */

      } else {
         expctutil[i - 1] = beliefc[0][0][utlnode[idnmbrm1] - 1][0];
         expctutilh[i - 1] = beliefh[0][0][utlnode[idnmbrm1] - 1][0];
      }

      eutilsum[idnmbrm1] += expctutil[i - 1];

      /* Keep track of the maximum expected utility, its associated
	 action-target pair, and associated continuous values. */

      if (maxexpct < expctutil[i - 1]) {
         maxexpct = expctutil[i - 1];
         optactn = i;
         opttrgts = trgts[i - 1];
      
	 /* Because this might be the optimal out-combination, update
	    external carrier variables with this ID's values under this
	    decision option. */

         if (thisidname.equals("middlemen")) {

            /* Update the middleman ID's asking and bid prices for wildlife
	       products. */

            k = Getmodlutils.getndnm_("APRICE");
            if (!loadconsdst) {
               curraskprice[idnmbrm1] = beliefh[0][0][k - 1][0];

            } else {
               curraskprice[idnmbrm1] = beliefc[0][0][k - 1][0];
            }

            k = Getmodlutils.getndnm_("BPRICE");
            if (!loadconsdst) {
               currbidprice[idnmbrm1] = beliefh[0][0][k - 1][0];

            } else {
               currbidprice[idnmbrm1] = beliefc[0][0][k - 1][0];
            }

         } else if (thisidname.equals("poachers")) {

            /* Update the poacher ID's asking price for wildlife products and
	       the number of wildlife to be poached by them. */

            k = Getmodlutils.getndnm_("APRICE");
            if (!loadconsdst) {
               curraskprice[idnmbrm1] = beliefh[0][0][k - 1][0];

            } else {
               curraskprice[idnmbrm1] = beliefc[0][0][k - 1][0];
            }

            k = Getmodlutils.getndnm_("NMPOACHED");
            if (!loadconsdst) {
               actions_econoutput[0][0][idnmbrm1] = (int) beliefh[0][0][k - 1][0];

            } else {
               actions_econoutput[0][0][idnmbrm1] = (int) beliefc[0][0][k - 1][0];
            }
   
	 /*
	 } else if (thisidname.indexOf("rr", 0) >= 0 ||
              thisidname.indexOf("pas", 0) >= 0) {
         */

	 } else if (thisidname.indexOf("rr", 0) >= 0) {

            /* Update number of wildlife to poach by a rural residents or
	       a pastoralist (to be added later). */

            k = Getmodlutils.getndnm_("NMPOACHED");
            if (!loadconsdst) {
               actions_econoutput[0][0][idnmbrm1] = beliefh[0][0][k - 1][0];

            } else {
               actions_econoutput[0][0][idnmbrm1] = beliefc[0][0][k - 1][0];
            }
         } // End of "rr" condition.
      } // End of maxexpct-check condition.
         
      /*
      printf_("idsolve: t= " + t + " actorID= " + thisidname +
         " optimal action= " + nodelbls[idnmbrm1][decnode[idnmbrm1] - 1]
                                       [optactn]);
      */

      // Find the optimal action under the hypothesis distribution.

      if (maxexpcth < expctutilh[i - 1]) {
         maxexpcth = expctutilh[i - 1];
         optactnh = i;
      }
   }
}

if (thisidname.equals("poachers")) {
   strng1 = thisidname + " " + fdble_(t, 8, 3);
   strng1 += " " + fdble_(Parlearn.l, 5, 3);
   strng1 += " " + Intridslve.actions_econoutput[0][0][0] + " 0.0";
   fprintf_(xyptsflenm, strng1);
}

/* Select the optimal output action randomly.  Do this by first finding
   the expected OGA value under each option, say these are
   $eoga_1,\ldots,eoga_m$.  Then, form a discrete PMF with probabilities,
   $eoga_i/sumeoga$, $i=1,\ldots,m$ where $sumeoga = \sum_{i=1}^m eoga_i$.
   Then, sample from this distribution to select an option. */

if (randomchoice) {
   for (i = 0; i < nmoptions; ++i) {
      choicedst[i] = expctutil[i] / eutilsum[idnmbrm1];
   }

   /* Sample once from "choicedist," and then get the associated optimal
      target. */

   for (i = 0; i < nmdevs; ++i) {
      intgrdev[i] = Rndm.discrte_(0, choicedst);
   }
   optactn = Summry.smplmode_(nmdevs, intgrdev);
   opttrgts = trgts[optactn - 1];
}

// Error check.

if (optactn == 0 || opttrgts == 0) {
   iderr_("idsolve: ID= " + thisidname + " optactn= " + optactn +
      " opttrgts= " + opttrgts);
}

// Re-load conditioning values under the optimal decision.

if (hassituation) {
   condvals[nmcondnds - 2] = optactn;
   condvals[nmcondnds - 1] = opttrgts;

   if (condvals[nmcondnds - 2] == 0) {
      iderr_("idsolve: optimal decision=0");

   } else if (condvals[nmcondnds - 1] == 0) {
      iderr_("idsolve: optimal target=0");
   }

} else {
   condvals[0] = optactn;
}

if (ipflag) {
   fclose_(3, 'w');

   // Write the standard deviations of the trafficked product's prices.

   if (nmids > 1 && !findmpemp && (thisidname.equals("middlemen") ||
       thisidname.equals("poachers"))) {
      writeprices_(askpricestddev, bidpricestddev);
   }
}
return maxexpct;
}

// ------------------------------------------------------------------

static void writeprices_(double askpricestddev, double bidpricestddev) {

// Write prices to a plotting file.

String strng1 = "none";

int i;

double askprice = 0., bidprice = 0.;

strng1 = fstrng_(thisidname, 9) + " " + fdble_(outputtime[0], 8, 3) + " ";

askprice = curraskprice[idnmbrm1];
bidprice = currbidprice[idnmbrm1];

if (Double.isNaN(askpricestddev)) {
   askpricestddev = 0.;
}

if (Double.isNaN(bidpricestddev)) {
   bidpricestddev = 0.;
}

strng1 += fdble_(askprice, 8, 3) + " " + fdble_(askpricestddev, 8, 3);
strng1 += " ";
strng1 += fdble_(bidprice, 8, 3) + " " + fdble_(bidpricestddev, 8, 3);

fprintf_(8, strng1);
}
}
