import java.util.*;
class Intridsetup extends Intridslve {

static boolean acquiredids = false;

// ----------------------------------------------------------------------

static void intridsetup_(boolean plots, boolean postprocess) {

// Set up an Interacting IDs run.

String dumstrng, strng1, oneematcode;

int i, j, k, l, ematcodeindex;

// Read-in all EMAT actions and their associated EMAT codes.

Storyutils.readematfle_();

/* Loop over all IDs to first load them into arrays and then to find
   the Input action, Output action, and Utility node numbers for
   each group ID -- and to discover the ecosystem ID and find its output
   nodes.  Finally, write these nodes to the report file.

   First, verify that ecosystem state nodes have been read from the
   global .id file. 
      
   Note that because "idnmbrm1" is used to index the "condprb" array,
   it is always 1 less than "idnm." */

if (nmecosysnds == 0 && nmids > 1) {
   iderr_("intridsetup: findmpemp= " + findmpemp + " nmecosysnds= 0");
}

for (idnmbrm1 = 0; idnmbrm1 < nmids; ++idnmbrm1) {
   nminoutpairs[idnmbrm1] = 0;

   if (acquiredids) {
      continue;
   }

   thisidname = idname[idnmbrm1];
   if (nmids > 1) {

      // Load this ID.

      Getmodl.getmodl_(6, idfle[idnmbrm1]);
   }

   nmndes[idnmbrm1] = nmnds;
   nmcondndes[idnmbrm1] = nmcondnds;
   phenomenon_class[idnmbrm1] = phenom_class;

   xtitle[idnmbrm1] = "Time_in_months";

   // Assign price and wage relationships.

   if (thisidname.equals("traders")) {
      tradersidnm = idnmbrm1 + 1;

   } else if (thisidname.equals("middlemen")) {
      middleidnm = idnmbrm1 + 1;

   } else if (thisidname.equals("poachers")) {
      poachersidnm = idnmbrm1 + 1;

   } else if (thisidname.equals("mntwrk")) {
      mntwrkidnm = idnmbrm1 + 1;
   }

   if (!phenomenon_class[idnmbrm1].equals("ecosystem")) {
      
      // Group ID setup processing.

      nmincontinnodes[idnmbrm1] = 0;
      for (i = 1; i <= nmnds; ++i) {
         if (nodelbls[idnmbrm1][i - 1][0].equals("Time")) {
            timenode[idnmbrm1] = i;

         } else if (nodelbls[idnmbrm1][i - 1][0].equals("Input_Actor") ||
                    nodelbls[idnmbrm1][i - 1][0].equals("Input__Actor")) {
            inactrnode[idnmbrm1] = i;

         } else if (nodelbls[idnmbrm1][i - 1][0].equals("Input_Action") ||
                    nodelbls[idnmbrm1][i - 1][0].equals("Input__Action")) {
            inactnnode[idnmbrm1] = i;

         } else if (nodelbls[idnmbrm1][i - 1][0].equals("Input_Subject") ||
                    nodelbls[idnmbrm1][i - 1][0].equals("Input__Subject")) {
            insubjnode[idnmbrm1] = i;

         } else if (nodenghs[idnmbrm1][i - 1][0] == 1 &&
             nodenghs[idnmbrm1][i - 1][1] == 0 &&
             varinfo_dist[idnmbrm1][i - 1].equals("Determ_Root")) {
            incontinnode[idnmbrm1][nmincontinnodes[idnmbrm1]] = i;
            ++nmincontinnodes[idnmbrm1];

         } else if (nodelbls[idnmbrm1][i - 1][0].equals("Action")) {
            decnode[idnmbrm1] = i;
            ytitle[idnmbrm1] = "Action";

            // Store the number of output actions and their labels.

            nmoutacts[idnmbrm1] = nodenghs[idnmbrm1][i - 1][0];

            legend[idnmbrm1] = "one:_";
            for (k = 0; k < nmoutacts[idnmbrm1]; ++k) {
               action_labels[idnmbrm1][k] =
                  nodelbls[idnmbrm1][i - 1][k + 1];

               /* Replace this action with the corresponding
	          first-occurring EMAT action. */

               ematcodeindex =
	          Grouputils.getematcodeindex_(action_labels[idnmbrm1][k],
				              .8);
	       if (ematcodeindex == 0) {
		  printf_("intridsetup: idnmbrm1= " + idnmbrm1 +
                     " ID= " + thisidname);
	          iderr_("intridsetup: can't find EMAT action for: " +
                     action_labels[idnmbrm1][k]);
               }
               oneematcode = ematcode[ematcodeindex - 1];
               action_labels[idnmbrm1][k] =
	          Grouputils.getemataction_(oneematcode);
	       
               // Fill plotting-legend array.

	       if (k == 1) {
		  legend[idnmbrm1] += "__two:_";
	       
	       } else if (k == 2) {
		  legend[idnmbrm1] += "__three:_";
	       
	       } else if (k == 3) {
		  legend[idnmbrm1] += "__four:_";
	       
	       } else if (k == 4) {
		  legend[idnmbrm1] += "__five:_";
	       
	       } else if (k == 5) {
		  legend[idnmbrm1] += "__six:_";
	       
	       } else if (k == 6) {
		  legend[idnmbrm1] += "__seven:_";
	       
	       } else if (k == 7) {
		  legend[idnmbrm1] += "__eight:_";
               }
	       legend[idnmbrm1] += action_labels[idnmbrm1][k];
            }

         } else if (nodelbls[idnmbrm1][i - 1][0].equals("Targets")) {
            trgtsnode[idnmbrm1] = i;
	    nmtrgtlbls[idnmbrm1] = nodenghs[idnmbrm1][i - 1][0];
	    for (k = 0; k < nmtrgtlbls[idnmbrm1]; ++k) {
	       target_labels[idnmbrm1][k] =
                  nodelbls[idnmbrm1][i - 1][k + 1];
            }

         } else if (
            nodelbls[idnmbrm1][i - 1][0].equals("Chosen_Target") ||
            nodelbls[idnmbrm1][i - 1][0].equals("Chosen__Target")) {
            ctrgtnode[idnmbrm1] = i;

         } else if (varinfo_dist[idnmbrm1][i - 1].equals("Determ_Loss") ||
            nodelbls[idnmbrm1][i - 1][0].equals("Utility") ||
            nodelbls[idnmbrm1][i - 1][0].equals(
               "Overall_Goal_Attainment") ||
            nodelbls[idnmbrm1][i - 1][0].equals(
               "Overall_Goal__Attainment")) {
            utlnode[idnmbrm1] = i;

         }

         /* Check if this node is one of the ecosystem state nodes
            that is recognized by this group.  If so, read it. */

         for (j = 0; j < nmecosysnds; ++j) {
            if (nodelbls[idnmbrm1][i - 1][0].equals(econdelbls[j])) {
               ecoinnodes[idnmbrm1][nmecoinnodes[idnmbrm1]] = i;
               ++nmecoinnodes[idnmbrm1];
               break;
            }
         }
      } // End of loop over nodes.

      // Check for failure to detect these nodes.

      if (decnode[idnmbrm1] == 0) {
         iderr_("intridsetup: ID= " + idname[idnmbrm1] +
            " decision node number not found");
      
      } else if (!isbusinessabm && utlnode[idnmbrm1] == 0) {
         iderr_("intridsetup: ID= " + idname[idnmbrm1] +
            " utility node number not found");
      }

      if (hassituation && nmids > 1) {
         if (trgtsnode[idnmbrm1] == 0) {
            iderr_("intridsetup: ID= " + idname[idnmbrm1] +
               " target(s) node number not found");
      
         } else if (timenode[idnmbrm1] == 0) {
            iderr_("intridsetup: ID= " + idname[idnmbrm1] +
               " Time node number not found");

         } else if (inactrnode[idnmbrm1] == 0) {
            iderr_("intridsetup: ID= " + idname[idnmbrm1] +
               " input actor node number not found");

         } else if (inactnnode[idnmbrm1] == 0) {
            iderr_("intridsetup: ID= " + idname[idnmbrm1] +
               " input action node number not found");

         } else if (insubjnode[idnmbrm1] == 0) {
            iderr_("intridsetup: ID= " + idname[idnmbrm1] +
               " subject node number not found");
	 }
      }

      // Print a summary of this group ID.

      fprintf_(1, "\n----------------------Group ID= " +
         idname[idnmbrm1] +
         "----------------------\r\n\n graph file= " + "<A HREF=\"" +
      Pltgrph.flename + "\">" + Pltgrph.flename + "</A>" +
         "\r\n report fle= " + "<A HREF=\"" +
         rptfle + "\">" + rptfle + "</A>");

      // Print input action options.

      fprintf_(1, "\n---Input Actions---");
      for (i = 1; i <= nodenghs[idnmbrm1][inactnnode[idnmbrm1] - 1][0];
         ++i) {
         fprintf_(1, " " + i + " " +
            nodelbls[idnmbrm1][inactnnode[idnmbrm1] - 1][i]);
      }

      // Print input actors.

      fprintf_(1, "\n---Recognized Input Actors---");
      for (i = 1; i <= nodenghs[idnmbrm1][inactrnode[idnmbrm1] - 1][0];
         ++i) {
         fprintf_(1, " " + i + " " +
            nodelbls[idnmbrm1][inactrnode[idnmbrm1] - 1][i]);
      }

      // Print output action options.

      fprintf_(1,
         "\n---------Output Action                 Archetypal Target---");
      for (i = 1; i <= nodenghs[idnmbrm1][decnode[idnmbrm1] - 1][0]; ++i) {
         dumstrng = nodelbls[idnmbrm1][decnode[idnmbrm1] - 1][i];
         j = Grouputils.getematcodeindex_(dumstrng, .8);
         fprintf_(1, " " + i + " " + fstrng_(dumstrng, 30) + "      " +
            fstrng_(Intridslve.archetypal_subject[j - 1][0], 30));
      }

      // Print potential targets.

      if (trgtsnode[idnmbrm1] > 0) {
         fprintf_(1, "\n---Potential Targets---");
         for (i = 1; i <= nodenghs[idnmbrm1][trgtsnode[idnmbrm1] - 1][0];
            ++i) {
            fprintf_(1, " " + i + " " +
               nodelbls[idnmbrm1][trgtsnode[idnmbrm1] - 1][i]);
	 }
      }

   } else {

      /* Because the ecosystem ID must be the last ID updated per time
         point, check that this is the last ID. */

      if (idnmbrm1 + 1 != nmids) {
         iderr_("intridsetup: ecosystem ID must be last");
      }

      /* Find the ecosystem ID's time, region, input action, and state
         nodes.  Also, assign interacting IDs y-axis title. */

      ecosysidnm = idnmbrm1 + 1;
      fprintf_(1,
         "\r\n----------------Ecosystem ID number= " + ecosysidnm +
         "-------------------------" +
         "\r\n Ecosystem ID graph file= " + "<A HREF=\"" +
         Pltgrph.flename + "\">" + Pltgrph.flename + "</A>" +
         "\r\n Ecosystem ID report file= " + "<A HREF=\"" +
         rptfle + "\">" + rptfle + "</A>");
 
      fprintf_(1, "\n--------------------------------------------------" +
         "\n             Ecosystem State Nodes");
      for (i = 1; i <= nmnds; ++i) {
         if (nodelbls[idnmbrm1][i - 1][0].equals("Time")) {

            // Read time node number.

            timenode[idnmbrm1] = i;
            continue;

         } else if (nodelbls[idnmbrm1][i - 1][0].equals(regionnode)) {

            // Read ecosystem ID region index node number.

            ecorgnnode = i;
            nmregions = nodenghs[idnmbrm1][ecorgnnode - 1][0];
            continue;

         } else if (nodelbls[idnmbrm1][i - 1][0].equals(
            "Management_Option") || nodelbls[idnmbrm1][i - 1][0].equals(
            "Management__Option")) {

            // Read ecosystem ID input action node number.

            ecoinactnnode = i;
            continue;
         }

         // See if this node is an ecosystem state node.

         for (j = 0; j < nmecosysnds; ++j) {
            if (nodelbls[idnmbrm1][i - 1][0].equals(econdelbls[j])) {
               ecosysnodes[j] = i;

               fprintf_(1, "Ecosystem ID state node label and number= " +
                  nodelbls[idnmbrm1][i - 1][0] + " " + ecosysnodes[j]);

               ytitle[idnmbrm1] = econdelbls[j];
               legend[idnmbrm1] = ytitle[idnmbrm1];

	       break;
            }
         }
      } // End of loop over ecosystem ID nodes.
         
      // Check for ecosystem node detection failures.

      if (timenode[idnmbrm1] == 0) {
         iderr_("intridsetup: ID= " + idname[idnmbrm1] +
            " Time node number not found");

      } else if (ecorgnnode == 0) {
         iderr_("intridsetup: ID= " + idname[idnmbrm1] +
            " Region node number not found");

      } else if (ecoinactnnode == 0) {
         iderr_("intridsetup: ID= " + idname[idnmbrm1] +
            " Ecosystem Input Action node number not found");
      }
      for (j = 0; j < nmecosysnds; ++j) {
         if (ecosysnodes[j] == 0) {
            iderr_("intridsetup: ecosysnodes(" + j + ")= 0");
         }
      }
   } // End of ecosystem ID setup processing.
} // End of loop over IDs.
acquiredids = true;

idnmbrm1 = 0;

// For the remainder of the run, initialize the printing flag.

if ((cacalc && !CA.runtype.equals("plots_only")) || findmpemp) { 
   ipflag = false;

} else if (plots) {
   ipflag = true;

} else {
   ipflag = true;
}

// Zero-out the expected utility array.

for (i = 0; i < TNMIDS; ++i) {
   for (j = 0; j < MAXTIMES; ++j) {
      for (k = 0; k < NMPOSTACTS; ++k) {
         CA.optutil[i][j][k] = 0.;
      }
   }
}

// Turn off the jackknife deletion array.

for (i = 0; i < NMACTNS; ++i) {
   CA.jackknifedeleted[i] = false;
}

/* Return if only a single non-ecosystem ID is being processed or if only
   post-processing is being performed. */

if ((nmids == 1 && !phenomenon_class[0].equals("ecosystem")) ||
   postprocess) {
   printf_("intridsetup: postprocessing, returning.");

   return;
}

// Map regions to countries.

for (i = 1; i <= nmregions; ++i) {
   regcountrynm[i - 1] = 1; // All countries.
   if (nodelbls[ecosysidnm - 1][ecorgnnode - 1][i].indexOf(
      "k_") >= 0) {
      regcountrynm[i - 1] = 2; // Kenya.
   
   } else if (nodelbls[ecosysidnm - 1][ecorgnnode - 1][i].indexOf(
      "t_") >= 0) {
      regcountrynm[i - 1] = 3; // Tanzania.

   } else if (nodelbls[ecosysidnm - 1][ecorgnnode - 1][i].indexOf(
      "u_") >= 0) {
      regcountrynm[i - 1] = 4; // Uganda.
   }

   /* In an "evaluate" run, find the region that is to have its
      ecosystem updated.  Otherwise, read this region in "caSetup_()." */

   if (!cacalc) {
      for (j = 0; j < nmcmprgns; ++j) {
         if (nodelbls[ecosysidnm - 1][ecorgnnode - 1]
                     [i].equals(regionname[j])) {
            Ecosyscalcs.computeregion[i - 1] = true;
         }
      }
   }
}

if (readrawgroup) {
   return;
}

// Time step length default value.  Time is assumed to be in years.

if (idinfo_hashibm[nmids - 1] || idinfo_haspibm[nmids - 1]) {
   tstep = 1. / 52.; // one week (see HIBMcalcs.java or PIBMcalcs.java).

} else {
   tstep = 12. / 52.; // quarterly.
}

if (nmids > 1 && !dsensanalysis && !findmpemp &&
   CA.caftest == 0) {

   /* Read the observed actions history file.  Note that the array
      "obsactntime" is loaded within this method. */

   Grouputils.getobsactnshist_(CA.actnshistfle);

   if (CA.nmobsactns > 0) {
      fprintf_(1,
         "\n---- CA Actions History Fitting Procedure ----" +
         "\n Number of Actions= " + CA.nmobsactns);

      /* t0 and tfinal are read in getmodl_.  Only actions in the interval
         (t0, tfinal) were read in getobsactnhist_. */

      tfinal = Math.max(tfinal,
		        CA.actnshstry_obsactntime[CA.nmobsactntimes - 1]);

   } else {
      fprintf_(1, "*** No actions history observations  ***");
   }

   tstep = Math.min((1.1 * (tfinal - t0) / ((double) CA.nmobsactntimes)),
	            tstep);
}
printf_("intridsetup: tstep= " + tstep);

if (tstep < 1.e-6) {
   iderr_("intridsetup: tstep= " + tstep);
}

nmmdltimes = 1 + (int) ((tfinal - t0) / tstep);
spacetime_tmin = t0;
spacetime_tmax = tfinal;

/* For a deterministic sensitivity analysis or finding the MPEMP, use the
   "nmmdltimes" times to load the array "obsactntime."  A sensitivity
   analysis or MPEMP computation is always run over a future time
   interval because the intent is to discover how the fitted simulator
   will behave under different combinations of conditions and responses.
   Therefore, there isn't any set of observed actions at observed action
   times. */

if (dsensanalysis || findmpemp) {
   CA.nmobsactntimes = nmmdltimes;
   for (i = 0; i < CA.nmobsactntimes; ++i) {
      CA.actnshstry_obsactntime[i] = t0 + ((double) i) * tstep;
   }
}

printf_("\nintridsetup: tmin= " + spacetime_tmin + " tmax= " +
   spacetime_tmax + " nmobsactns= " + CA.nmobsactns +
   " nmobsactntimes= " + CA.nmobsactntimes +
   "\n   nmmdltimes= " + nmmdltimes);

// For a stand-alone ecosystem ID Consistency Analysis.

if (cacalc && nmids == 1 && phenomenon_class[0].equals("ecosystem")) {
         
   // Stand-alone ecosystem ID.

   if (Beliefs.issms) {
      nmregions = 1;
   }
   for (i = 0; i < nmecoobsttl; ++i) {
      CA.actnshstry_obsactntime[i] = dat2_t[i];
   }
}

if (nmmdltimes == 0) {
   iderr_("intridsetup: cacalc= " + cacalc + " tstep= " + tstep +
      " nmmdltimes= " + nmmdltimes);

} else if (nmmdltimes > MAXTIMES) {
   iderr_("intridsetup: cacalc= " + cacalc + " tstep= " + tstep +
      "\n   nmmdltimes= " + nmmdltimes + " > MAXTIMES= " + MAXTIMES);
}

fprintf_(1, "\n----------- IntIDs Solution Setup Values --------------" +
   "\n   t0= " + t0 + " tfinal= " + tfinal + " tstep= " + tstep);

// Compute and store time point values.

t = t0;
tmept[0] = t;
for (i = 1; i < nmmdltimes; ++i) {

   // Increment time.

   t += tstep;
   tmept[i] = t;
}

if (ipflag && nmids > 1) {

   // Open node plotting file.
   
   fleopen_(xyptsflenm, spacetime_xyptsfle, 'w');
   
   // Open the prices output file.

   fleopen_(8, "prices.plt", 'w');
   strng = "ID   Time   Ask_Price   STDDEV   Bid_Price   STDDEV";
   fprintf_(8, strng);
}
}
}
