import java.util.*;
class Intridutils extends Intridslve {

static boolean wrteactstest = false, spclflag = false,
   reportactions = true, headflag = false, volunteeraction = true;

static String inaction, inactor, subject, ecosysinactor = "not_known";

static String target[] = new String[TNMIDS];
static String alltargets[] = new String[TNMIDS];

static int identnm = 0, defaultecoactn = 0, ecoactn = 0;

static int indx[] = new int[30];
static int shuffledvec[] = new int[100];

// -------------------------------------------------------------------

static boolean readactions_() {

/* Checks the bulletin board for actions with time value equal to some
   value between "t - tstep" and "maxmemory."  The attributes of each
   such action are loaded into the ID's input action nodes.  If no such
   actions are found, "false" is returned.  Note that in addition to
   group IDs, the ecosystem ID is also treated as an input actor to those
   IDs that are directly affected by the ecosystem, i.e., the ecosystem
   is one of their input actors.  If an action by the ecosystem at an
   acceptable time is found, update the group's ecosystem input nodes,
   if any. */

int i, iorg, j, k, inactrnde = 0, inactnnde = 0, insubjnde = 0, ineconde = 0,
   nodeval, nmtocheck = 0, obsactornm = 0, ecoactornm = 0, regionnodenumber;

double tdist = 1.e6, mintdist = 1.e6;

inactor = "none";
subject = "none";

if (!phenomenon_class[idnmbrm1].equals("ecosystem")) {
   
   /* For a group ID, set the input action, input actor, and subject
      node values. */

   inactnnde = inactnnode[idnmbrm1];
   inactrnde = inactrnode[idnmbrm1];
   insubjnde = insubjnode[idnmbrm1];
   
} else {

   // Set default ecosystem input action.

   condnodes[idnmbrm1][1] = ecoinactnnode;

   if (tindex <= 1) {
      inaction = initial_ecosystem_action;
      defaultecoactn = Getmodlutils.getndval_(ecoinactnnode, inaction,
                                           false);
      inactionident[0] = 0;
      inactor = "not_known";
      
   }
}

/* Loop over the most recent actions on the bulletin board.  Note that
   there can be multiple actions at a particular time point. */

nmtocheck = Math.min((3 * nmids), NMACTNS);

// Randomly permute or shuffle the actions to be read.

shuffledvec = Rndm.shuffle_(0, nmtocheck - 1, 0);

ACTLOOP: for (iorg = 0; iorg < nmtocheck; ++iorg) {
   i = shuffledvec[iorg];

   // The Time node is always the first conditioning node.

   nminputnodes = 1;
   inactor = "none";
   subject = "none";

   // Something is wrong if actions_time[i] > t.

   if (tmept[tindex - 1] < actions_time[i]) {
      iderr_("readactions: i= " + i + " tindex= " + tindex + " t= " +
         tmept[tindex - 1] + " actions_time= " + actions_time[i] +
	 " nmtocheck= " + nmtocheck);
   }

   /* Skip this action if it occurred at the present time
      (tmept[tindex - 1]) or occurred earlier than the immediately
      previous time point (tmept[tindex - 2).  In other words, accept an
      action only if it occurred in the immediately preceeding time point.
      That way, all IDs see exactly the same set of actions. */

   if (tindex == 1) {
      if (actions_time[i] + 1.e-6 < tmept[0]) {
         continue;
      }

   } else if (Math.abs(actions_time[i] - tmept[tindex - 1]) < 1.e-6 ||
       actions_time[i] + 1.e-6 < tmept[tindex - 2]) {
      continue;
   }

   // Skip this action if this ID has already reacted to this action.

   for (j = 0; j < nmreactedto; ++j) {
      if (actions_ident[i] == actionreactedto[j]) {
	 continue ACTLOOP;
      }
   }

   // Process the action.

   if (!phenomenon_class[idnmbrm1].equals("ecosystem")) {
      
      /* A group ID.  First, set the input actor and check for
	 recognizability. */

      nodeval = Getmodlutils.getndval_(inactrnde, actions_actor[i], false);

      //printf_("readactions: ID= " + idname[idnmbrm1] + " nodeval= " + nodeval);

      if (nodeval == 0) {
	 continue ACTLOOP;
      }
      condnodes[idnmbrm1][2] = inactrnde;
      condvaltype[2] = "discrete";
      condvals[2] = nodeval;
      ++nminputnodes;
      inactor = nodelbls[idnmbrm1][inactrnode[idnmbrm1] - 1][nodeval];

      /* Get subject number, translate a subject that is this group
	 ID to the ID value in the variable "idname[idnmbrm1]"  In addition,
	 if this group ID recognizes the ecosystem as an input actor
	 (a group ID that is directly affected by the ecosystem) then
	 also set the input action subject to the value in "idname[idnmbrm1]."
	 This is okay because having gotten this far means that "ecosys"
	 has already been recognized as an input actor.
	
         Note that each ID only examines this action once because
         ID checking is nested inside the time loop and once time
	 increments, a processed action moves outside the acceptable
	 time window (one time step back). */
	 
      nodeval = 0;
      for (j = 0; j < actions_nmsubj[i]; ++j) {
         subject = actions_subjects[i][j];

         // Check if this subject concerns this ID.

         if (subject.equals(idname[idnmbrm1]) ||
	     actions_actor[i].equals("ecosys")) {
            subject = idname[idnmbrm1];
         }

         nodeval = Getmodlutils.getndval_(insubjnde, subject, false);
         if (nodeval > 0) {
            break;
	 }
      }

      // Check for recognized subject.

      if (nodeval == 0) {
	 continue ACTLOOP;
      }

      condnodes[idnmbrm1][3] = insubjnde;
      condvaltype[3] = "discrete";
      condvals[3] = nodeval;
      ++nminputnodes;

      // Check for recognized input action and skip otherwise.

      nodeval = Getmodlutils.getndval_(inactnnde, actions_action[i], false);
      if (nodeval == 0 || actions_action[i].equals("ecosystem_state")) {
         continue ACTLOOP;

      } else if (nodeval > 0) {
       
         // Add this action to the conditioning set.

         condnodes[idnmbrm1][1] = inactnnde;
         condvaltype[1] = "discrete";
         condvals[1] = nodeval;
         ++nminputnodes;
         inaction = nodelbls[idnmbrm1][inactnnode[idnmbrm1] - 1][nodeval];
      }

      // Load the inaction's associated continuous values, if any.

      loadcontin_();

      /* Next, load into this ID's set of conditioning values, those values
         on ecosystem state nodes that are attached to this action. */

      loadeco_(i);

      /* Having reached this point means that an action has been
	 recognized by this group ID and loaded into the conditioning
	 set.  Indicate this in-action's identification number,
	 increment the number of subjects of this action, and return
	 the value "true." */

      inactident = actions_ident[i];
      ++nmactionsubj[idnmbrm1];

      if (inactor.equals("none") || subject.equals("none")) {
	 iderr_("in readactions 1");
      }

      /* Add this inaction's identification number to the array
         "actionreactedto" to indicate that this ID has reacted to this
         input action so that this ID does not react to it again. */

      actionreactedto[nmreactedto] = actions_ident[i];
      ++nmreactedto;

      /*
      printf_("readactions: ID= " + idname[idnmbrm1] + " nmreactedto= " +
         nmreactedto);
      */

      return (true);

   } else {

      /* Ecosystem ID processing.  If an action directed towards the
	 ecosystem is not found, the default value for the ecosystem's
	 input action is used. */

      ecoactn = defaultecoactn;
      ecosysinactor = "not_known";
      nodeval = 0;
      for (j = 0; j < actions_nmsubj[i]; ++j) {
         if (actions_subjects[i][j].indexOf(idname[nmids - 1], 0) >= 0) {
            nodeval = Getmodlutils.getndval_(ecoinactnnode,
	       actions_action[i], false);
	    break;
	 }
      }

      if (nodeval > 0) {

         /* An action directed towards the ecosystem has been found at
	    an acceptable time point.  Load this action and any
	    attendant continuously-valued quantity.
	   
	    Note: "actions_econoutput" (for ECONomic OUTPUT) was previously
	    loaded and stored in idsolve_(). */
	   
	 inaction = actions_action[i];

	 // Get the group ID that is acting on the ecosystem.

         ecosysinactor = actions_actor[i];
	 ecoactornm = Getmodlutils.getidnmbrm1_(ecosysinactor);

	 /* Load the "ecoinput" value found when idsolve_() ran on this
	    group ID. */
	
         inactionident[0] = actions_ident[i];

	 ecoactn = nodeval;
	 actions_ecoinput[ecoactornm - 1] =
	    actions_econoutput[0][0][ecoactornm];

         /* Assuming an actions history has been read, estimate the region
	    where this poaching event happened by finding the temporally
	    closest observed region that experienced a poaching event by
	    this ID.  Do this even if the run is over a future time
	    interval. */

	 if (CA.nmobsactntimes == 0) {
            iderr_("readactions: nmobsactntimes=0");
	 }
	 k = -1;
	 mintdist = 1.e6;
         for (j = 0; j < CA.nmobsactntimes; ++j) {
            obsactornm = CA.actnshstry_obsactornm[j];
	    if (obsactornm <= 0) {
               continue;
	    }

	    /*
            printf_("readactions: j+1= " + (j + 1) +
	       " obsactornm= " + obsactornm + " region0= " +
               CA.actnshstry_obsactloc[obsactornm - 1][j][0] +
               " action= " + CA.actnshstry_obsactnstrng[j] +
               "\n   ecoactornm= " + ecoactornm + " idname= " +
	       idname[ecoactornm]);
            */

	    if (ecoactornm == obsactornm &&
                CA.actnshstry_obsactnstrng[j].indexOf("poach_for", 0) >= 0 &&
	        CA.actnshstry_obsactloc[obsactornm - 1][j][0] != null) {
               tdist = Math.abs(t - CA.actnshstry_obsactnnmtime[j]);
	       if (tdist < mintdist) {
                  mintdist = tdist;
	          k = j;
               }
	    }
	 } 
        
	 if (k == -1) {
            printf_("readactions: ecoactn= " + ecoactn +
               " nmobsactntimes= " + CA.nmobsactntimes);
	    iderr_("readactions: temporally closest region not found.");
	 }
         
         /* Deprecated: Use the ecosystem ID's first region.
         regionnodenumber = Getmodlutils.getndnm_(regionnode);
         actions_econoutputregion[0][0][ecoactornm - 1][0]  =
            nodelbls[idnmbrm1][regionnodenumber - 1][1];
         */

	 // Assign estimated region from that observed.

	 if (CA.nmobsactntimes > 0) {
            for (j = 0; j < CA.actnshstry_nmobsactlocs[ecoactornm - 1][k];
               ++j) {
               actions_econoutputregion[0][0][ecoactornm - 1][j] =
	          CA.actnshstry_obsactloc[ecoactornm - 1][k][j];
            }
         }
     
	 /*
	 printf_("readactions: t= " + t + " ecoactor= " + idname[ecoactornm - 1] +
            " obstime= " + CA.actnshstry_obsactnnmtime[k] +
            " econoutput= " + actions_econoutput[0][0][ecoactornm - 1] +
            " region0= " + actions_econoutputregion[0][0][ecoactornm - 1][0]);
         */

	 // Only the first region is given to the ecosystem.

         actions_ecoinputregion[0] =
               actions_econoutputregion[0][0][ecoactornm - 1][0];

	 /* Returning "false" because the action is not directed towards a
	    group ID. */

         return (false);
      } // End of "nodeval > 0" condition.     
   } // End of "ecosystem" condition.
} // End of loop over bulletin board actions.

if (phenomenon_class[idnmbrm1].equals("ecosystem")) {

   return (false);
}

/* A group ID reaching this point means that no recognized input action
   was found. */

//printf_("readactions: no input action, ID= " + idname[idnmbrm1]);

if (!volunteeraction) {
   return (false);
}

/* Optional: load the input vector with:
                     input_action = "no_input_action"
                     input_actor = "no_group1"
                     input_subject = "no_group1" */

// Input Action.

inaction = "no_input_action";
nodeval = Getmodlutils.getndval_(inactnnde, inaction, false);
if (nodeval == 0) {
   nodeval = 1;
}
condnodes[idnmbrm1][1] = inactnnde;
condvaltype[1] = "discrete";
condvals[1] = nodeval;
nminputnodes = 2;

// Input Actor.

if (thisidname.equals("traders")) {
   inactor = "middlemen";

} else {
   inactor = "no_group1";
}
nodeval = Getmodlutils.getndval_(inactrnde, inactor, false);
if (nodeval == 0) {
   nodeval = 1;
}
condnodes[idnmbrm1][2] = inactrnde;
condvaltype[2] = "discrete";
condvals[2] = nodeval;
++nminputnodes;

// Subject.

subject = "no_group1";
nodeval = Getmodlutils.getndval_(insubjnde, subject, false);
if (nodeval == 0) {
   nodeval = 1;
}
condnodes[idnmbrm1][3] = insubjnde;
condvaltype[3] = "discrete";
condvals[3] = nodeval;
++nminputnodes;

// Load the inaction's associated continuous values, if any.

loadcontin_();

// Load input action identifier.

inactident = 0;

// Load any ecosystem node values.

loadeco_(0);

++nmactionsubj[idnmbrm1];

return (true);
}

// -------------------------------------------------------------------

static void postaction_(int initialactnm) {

/* Write either the group's output action or the mean of ecosystem's output
   node to the bulletin board.  Ecosystem state node values are ALWAYS
   part of an action.  If the action is not by the ecosystem, then the
   values on these nodes from the most recent "ecosystem_state" action
   are used as default values. */

String strng1, strng2;

int i, j, k, l, actionnm, targetnm, nmgroupacts = 0;

if (!phenomenon_class[idnmbrm1].equals("ecosystem")) {

   /* For a group ID, post the output_action, subject, and ecosystem state
      node values. */
      
   if (initialactnm > 0) {

      /* Initial group action.  Place these actions in the second row
         and further of the bulletin board because the initial ecosystem
         state is in the first row of the bulletin board. */
      
      nmgroupacts = 1;

      ++identnm;
      actions_ident[initialactnm] = identnm;
      inaction = "none";
      inactor = "none";
      actions_actor[initialactnm] = initial_actor[initialactnm - 1];
      actions_action[initialactnm] = initial_action[initialactnm - 1];
      actions_nmsubj[initialactnm] = initial_nmsubj[initialactnm - 1];

      if (actions_nmsubj[initialactnm] == 1) {
         actions_targets[initialactnm] = "one," +
            initial_subj[initialactnm - 1][0];

      } else if (actions_nmsubj[initialactnm] == 2) {
         actions_targets[initialactnm] = "two," +
            initial_subj[initialactnm - 1][0] + "," +
            initial_subj[initialactnm - 1][1];
   
      } else if (actions_nmsubj[initialactnm] == 3) {
         actions_targets[0] = "three," +
	    initial_subj[initialactnm - 1][0] + "," +
            initial_subj[initialactnm - 1][1] + "," +
            initial_subj[initialactnm - 1][2];
      }

      for (i = 0; i < actions_nmsubj[0]; ++i) {
         actions_subjects[initialactnm][i] =
            initial_subj[initialactnm - 1][i];
      }
      strng1 = "none";
      return;

   } else {

      // Search for actions to react to.

      nmgroupacts = selectactions_();
   }

   CA.actnshstry_mdlnmacts[idnmbrm1][tindex - 1] = nmgroupacts;

   for (i = 0; i < nmgroupacts; ++i) {
      ++nmmdlactions;

      // Ratchet "actions" array to make room for this action.

      for (j = NMACTNS - 2; j >= 0; --j) {
         actions_ident[j + 1] = actions_ident[j];
         actions_inactid[j + 1] = actions_inactid[j];
         actions_time[j + 1] = actions_time[j];
         actions_action[j + 1] = actions_action[j];
         actions_actor[j + 1] = actions_actor[j];
         actions_targets[j + 1] = actions_targets[j];
         actions_nmsubj[j + 1] = actions_nmsubj[j];
         for (k = 0; k < actions_nmsubj[j]; ++k) {
            actions_subjects[j + 1][k] = actions_subjects[j][k];
         }
         for (k = 0; k <= nmcountries; ++k) {
            for (l = 0; l < nmecosysnds; ++l) {
               actions_ecoval[j + 1][k][l] = actions_ecoval[j][k][l];
               actions_ecostd[j + 1][k][l] = actions_ecostd[j][k][l];
            }
         }
      }

      // Assign identifier value.

      ++identnm;
      actions_ident[0] = identnm;

      // Load the in-action's identification number.

      actions_inactid[0] = inactionident[i];

      // Load actor name and time.

      actions_actor[0] = idname[idnmbrm1];
      actions_time[0] = t;

      // Load the in-out pair.  First, load input action and input actor.

      inaction = CA.actnshstry_mdlinactn[idnmbrm1][i];
      inactor = CA.actnshstry_mdlinactr[idnmbrm1][i];

      // Get and load the output action.

      actionnm = CA.actnshstry_mdlactn[idnmbrm1][tindex - 1][i];
      if (actionnm == 0) {
         iderr_("postaction: actionnm=0");
      }
      actions_action[0] = 
         nodelbls[idnmbrm1][decnode[idnmbrm1] - 1][actionnm];

      /* Get subject(s) (target(s)).  Use lower case words for
         1, 2, 3 so that upper-to-lower case converter doesn't
         have a problem. */

      targetnm = CA.actnshstry_mdltrgts[idnmbrm1][tindex - 1][i];
      if (targetnm == 0) {
         iderr_("postaction: targetnm=0");
      }
        
      actions_targets[0] =
         nodelbls[idnmbrm1][trgtsnode[idnmbrm1] - 1][targetnm];

      strng1 = actions_targets[0];
         actions_nmsubj[0] = Displayutils.gettargets_(strng1, alltargets);

      for (j = 0; j < actions_nmsubj[0]; ++j) {
         actions_subjects[0][j] = alltargets[j];
      }
      CA.actnshstry_mdlnmtrgts[idnmbrm1][tindex - 1][i] =
         actions_nmsubj[0];

      // Attach most recent ecosystem state node values to this action.

      for (j = 0; j <= nmcountries; ++j) {
         for (k = 0; k < nmecosysnds; ++k) {
            actions_ecoval[0][j][k] = wghtdave[j][k];
            actions_ecostd[0][j][k] = wghtdstd[j][k];
         }
      }
	 
      /* Write this action to the Report file and the action history
         plotting arrays. */

      Wrteacts.wrteacts_(i, inaction, inactor);
   } // End of loop over the group's actions.

} else {

   // Ecosystem action processing.

   ++nmmdlactions;

   // Ratchet "actions" array to make room for this action.

   for (j = NMACTNS - 2; j >= 0; --j) {
      actions_ident[j + 1] = actions_ident[j];
      actions_inactid[j + 1] = actions_inactid[j];
      actions_time[j + 1] = actions_time[j];
      actions_action[j + 1] = actions_action[j];
      actions_actor[j + 1] = actions_actor[j];
      actions_targets[j + 1] = actions_targets[j];
      actions_nmsubj[j + 1] = actions_nmsubj[j];
      for (k = 0; k < actions_nmsubj[j]; ++k) {
         actions_subjects[j + 1][k] = actions_subjects[j][k];
      }
      for (k = 0; k <= nmcountries; ++k) {
         for (l = 0; l < nmecosysnds; ++l) {
            actions_ecoval[j + 1][k][l] = actions_ecoval[j][k][l];
            actions_ecostd[j + 1][k][l] = actions_ecostd[j][k][l];
         }
      }
   }

   // Assign identifier value.

   ++identnm;
   actions_ident[0] = identnm;

   // Load the in-action's identification number.

   actions_inactid[0] = inactionident[0];

   // Load ecosystem name and time.

   actions_actor[0] = idname[idnmbrm1];
   actions_time[0] = t;

   /* Post Ecosystem state node values.  These values will be interpreted
      in potentially different ways by each group ID. */

   actions_action[0] = "ecosystem_state";
   actions_targets[0] = "none";
   actions_nmsubj[0] = 1;
   actions_subjects[0][0] = "none";

   for (i = 0; i <= nmcountries; ++i) {
      for (j = 0; j < nmecosysnds; ++j) {
         actions_ecoval[0][i][j] = wghtdave[i][j];
         actions_ecostd[0][i][j] = wghtdstd[i][j];
      }
   }

   // Write this ecosystem action.

   Wrteacts.wrteacts_(0, inaction, inactor);
}
}

// ---------------------------------------------------------------------

static int selectactions_() {

/* Selects actions for posting.

   inoutpair: 0 = input action identity number
	      1-3 = inaction, inactor, insubject
	      4-5 = outaction, target
*/

boolean actnmatch = false, trgtsmatch = false;

int i, j, k = -1, nmactsposted = 0, previndex, obsactnnm, obstrgtsnm;

// Load model decision array with these selected actions.

k = -1;
POSTLP: for (i = 0; i < nmmdlactionsubj; ++i) {

   /* Post only one action per target.  In other words, post only
      the first action directed towards ID "idnmbrm1" from a
      particular input actor.  Note that this still allows multiple
      input actors to post actions against ID "idnmbrm1." */

   ++k;
   if (i > 0) {
      for (;;) {
         if (!CA.actnshstry_mdlinactr[idnmbrm1][i - 1].equals(
                nodelbls[idnmbrm1][inactrnode[idnmbrm1] - 1]
		        [inoutpair[k][2]])) {
	    break;

	 } else { 
             ++k;
            if ( k >= nmmdlactionsubj - 1) {
	       break POSTLP;
	    }
         }
      }
   }

   // Load input action identifier.
   
   inactionident[i] = inoutpair[k][0];

   // Load input-action and input-actor.

   CA.actnshstry_mdlinactn[idnmbrm1][i] = 
      nodelbls[idnmbrm1][inactnnode[idnmbrm1] - 1][inoutpair[k][1]];
   CA.actnshstry_mdlinactr[idnmbrm1][i] = 
      nodelbls[idnmbrm1][inactrnode[idnmbrm1] - 1][inoutpair[k][2]];

   // Load input conditioning integer values.

   for (j = 1; j <= 3; ++j) {
      CA.actnshstry_mdlinputval[idnmbrm1][tindex - 1][i][j - 1] =
         inoutpair[k][j];
   }

   // Load output action, associated continuous value (if any), and target(s).

   CA.actnshstry_mdlactn[idnmbrm1][tindex - 1][i] = inoutpair[k][4];
   CA.actnshstry_mdltrgts[idnmbrm1][tindex - 1][i] = inoutpair[k][5];

   // Load optimal decision utility.

   CA.optutil[idnmbrm1][tindex - 1][i] = inoutpairutil[k];

   /* Check if an observed out-combination has been matched.  First,
      see if there is an observed action by this ID within this time
      interval. */

   previndex = Math.max(tindex - 2, 0);
   obsactnnm = -1;
   obstrgtsnm = -1;
   for (j = 0; j < CA.nmobsactns; ++j) {
      if ((tmept[previndex] <= CA.actnshstry_obsactnnmtime[j] &&
           CA.actnshstry_obsactnnmtime[j] < tmept[tindex - 1]) &&
           thisidname.equals(CA.actnshstry_obsactor[j])) {
         obsactnnm = CA.actnshstry_obsactnraw[j];
         obstrgtsnm = CA.actnshstry_obstrgtnm[j];
         break;
      }
   }

   if (CA.actnshstry_mdlactn[idnmbrm1][tindex - 1][i] == obsactnnm) {

      /*
      printf_("selectactions: i= " + i + " tindex= " + tindex +
         " matchedaction= " + obsactnnm);
      */

      actnmatch = true;

   } else {
      actnmatch = false;
   }
   if (CA.actnshstry_mdltrgts[idnmbrm1][tindex - 1][i] == obstrgtsnm) {

      /*
      printf_("selectactions: i= " + i + " tindex= " + tindex +
         " matchedtarget= " + obstrgtsnm);
      */

      trgtsmatch = true;

   } else {
      trgtsmatch = false;
   }

   if (actnmatch && trgtsmatch) {

      /*
      printf_("selectactions: idnmbrm1= " + idnmbrm1 + " tindex= " + tindex +
         " groupactnm= " + i + " matched obsactnnm, obstrgtsnm= " + obsactnnm +
	 ", " + obstrgtsnm);
      */

      CA.actnshstry_matchedoutcomb[idnmbrm1][tindex - 1][i] = true;

   } else {
      CA.actnshstry_matchedoutcomb[idnmbrm1][tindex - 1][i] = false;
   }

   ++nmactsposted;
   if (nmactsposted == NMPOSTACTS) {
      break;
   }
}
return nmactsposted;
}

// -----------------------------------------------------------------------

static void loadeco_(int actionnm) {

// Loads ecosystem state variable values into the group ID.

int j, k, l, ineconde;

for (k = 0; k < nmecosysnds; ++k) {
   for (l = 0; l < nmecoinnodes[idnmbrm1]; ++l) {
      ineconde = ecoinnodes[idnmbrm1][l];
      if (nodelbls[idnmbrm1][ineconde - 1][0].equals(econdelbls[k])) {
         ++nminputnodes;
         condnodes[idnmbrm1][nminputnodes - 1] = ineconde;

         // Load ecosystem values from the associated country.

         if (nodenghs[idnmbrm1][ineconde - 1][0] == 1) {

            // Use the value of a continuous ecosystem node directly.

            condvals[nminputnodes - 1] = actions_ecoval[actionnm]
		                                       [countrynm[idnmbrm1]][k];
            condvaltype[nminputnodes - 1] = "continuous";

         } else {
            
            // Otherwise, find its value label number.

            condvals[nminputnodes - 1] = Getmodlutils.getndval_(ineconde,
               fdble_(actions_ecoval[actionnm][countrynm[idnmbrm1]][k], 6, 4),
	       true);

            condvaltype[nminputnodes - 1] = "discrete";

            if (condvals[nminputnodes - 1] == 0) {
               iderr_("readactions: first ecosystem node" +
	          " read failure");
            }
            iderr_("loadeco: potential error -- verify this" +
                " value= " + condvals[nminputnodes - 1]);
         }
      }
   }
}
}

// -----------------------------------------------------------------------

static void loadcontin_() {

/* Load continuously-valued node values.  Currently, these are ordersize,
   price, and wage values. */

int i, j, nodeinquestion = 0;

if (!thisidname.equals("traders") && !thisidname.equals("middlemen") &&
    !thisidname.equals("poachers")) {
   return;
}

CONTINLOOP: for (i = 0; i < nmincontinnodes[idnmbrm1]; ++i) {

   // Don't confuse ecosystem nodes with these economic nodes.

   for (j = 0; j < nmecosysnds; ++j) {
      nodeinquestion = incontinnode[idnmbrm1][i];
      if (nodelbls[idnmbrm1][nodeinquestion - 1][0].equals(econdelbls[j])) {
         continue CONTINLOOP;
      }
   }

   condnodes[idnmbrm1][nminputnodes] = incontinnode[idnmbrm1][i];
   condvaltype[nminputnodes] = "continuous";

   // Trader gets asking price from middleman.
      
   if (thisidname.equals("traders")) {
       condvals[nminputnodes] = curraskprice[middleidnm - 1];
      ++nminputnodes;
      
      /* Middleman gets asking price from poachers -- and bid price from
         traders.  A trader's bid price is what they are willing to
         pay the middleman for rhino horn.  This price is far smaller
         than what they are charging Asian consumers for rhino horn.
         This latter price is their "Illegal_Price"*/

   } else if (thisidname.equals("middlemen")) {
      if (i == 0) {
         condvals[nminputnodes] = curraskprice[poachersidnm - 1];
         
      } else if (i == 1) {
         //condvals[nminputnodes] = currbidprice[tradersidnm - 1];
         condvals[nminputnodes] = 1.0;
         //printf_("loadcontin: traders bid price= " + condvals[nminputnodes]);
      }
      ++nminputnodes;

   // Poachers get bid price from middlemen -- and wage from mnetwork.

   } else if (thisidname.equals("poachers")) {
      if (i == 0) {
         condvals[nminputnodes] = actions_econinput[0][0][0];

      } else if (i == 1) {
         condvals[nminputnodes] = currbidprice[middleidnm - 1];
         //printf_("loadcontin: middleman bid price= " +
         //   condvals[nminputnodes]);

      } else if (i == 2) {
         condvals[nminputnodes] = currwage[mntwrkidnm - 1];
      }
      ++nminputnodes;
   }
}
}
}
