class Krg extends Predict {

// -------------------------------------------------------------------

static int krgsys_(double xcord, double ycord, double tmecord) {

/*
nd = 4;
nmcylobs[0] = 2;
nmcylobs[1] = 2;
vardat[0].vrble = 1;
vardat[0].x = xcord + .1 * varmod_range[0][0][0];
vardat[0].y = 0.;
vardat[0].t = tmecord - .5;
vardat[1].vrble = 1;
vardat[1].x = xcord - 1.1 * varmod_range[0][0][0];
vardat[1].y = ycord - .5 * varmod_range[0][0][0];
vardat[1].t = tmecord - 1.5;
vardat[2].vrble = 2;
vardat[2].x = xcord + .2 * varmod_range[0][0][0];
vardat[2].y = 0.;
vardat[2].t = tmecord - .5;
vardat[3].vrble = 2;
vardat[3].x = xcord - 1.0 * varmod_range[0][0][0];
vardat[3].y = ycord + .6 * varmod_range[0][0][0];
vardat[3].t = tmecord - 1.5;
varmod_nugget[0][0] = 0.;
varmod_nugget[0][1] = varmod_nugget[0][0];
varmod_sill[0][0] = 2.3;
varmod_sill[0][1] = varmod_sill[0][0];
varmod_range[0][0][1] = varmod_range[0][0][0];
varmod_range[0][1][1] = varmod_range[0][1][0];
*/

// Forms the kriging system matrix.

if (parm_mvar > 1) {
   parm_mtot = nd + parm_mvar;
   if (parm_mtot > WLSSZE2) iderr_("mtot too big in krgsys.");
   ktrend = 1;
   return aformck_(xcord, ycord, tmecord);

} else if (itrend == 0 || itrend == 3) {

   // Ordinary kriging.

   parm_mrow = nd + 1;
   parm_mcol = parm_mrow;
   parm_mtot = parm_mcol;
   ktrend = 1;

} else if (itrend == 1) {
   parm_mrow = nd + 3;
   parm_mcol = parm_mrow;
   parm_mtot = parm_mcol;
   ktrend = 3;

} else if (itrend == 2) {
   parm_mrow = nd + 6;
   parm_mcol = parm_mrow;
   ktrend = 6;

} else if (itrend >= 4) {

   // Univariate residual kriging.

   parm_mrow = nd + 1;
   parm_mcol = parm_mrow;
   parm_mtot = parm_mcol;
   ktrend = 1;

/*
   // Universal kriging with given design matrix.

   parm_mrow = nd + nmpars[0];
   parm_mcol = parm_mrow;
   parm_mtot = parm_mcol;
   ktrend = -1;
*/
}

if (parm_mtot > WLSSZE2) {
   iderr_("mtot too big in krgsys.");
}
return aformu_(xcord, ycord, tmecord); 
}

// ----------------------------------------------------------------------

static int aformck_(double xcord, double ycord, double tmecord) {
 
/* Forms the A matrix for the cokriging system. !!!! Note, uses covariance
   form of kriging system, see pp. 306-307 of Journal and Huijbregts. */
 
int i, j, k, n = 0, nold = 0, mtotu, cvstrct = 1, stnmi, stnmj;

mtotu = parm_mtot - parm_mvar;
for (k = 0; k < 10; ++k) {

   // Form covariance matrix.

   for (i = 0; i < mtotu; ++i) {
      for (j = 0; j <= i; ++j) {

         // Find covariance structure.

	 stnmi = idtostnm[vardat_vrble[i] - 1];
	 stnmj = idtostnm[vardat_vrble[j] - 1];
         if (stnmi == stnmj) {
            cvstrct = stnmi;
	    
         } else {
            cvstrct = crossmap[stnmi - 1][stnmj - 1];
         }

         // Assign covariance and fill in upper half.

         form_a[i][j] = Covmodl.covmodl_(i, j, vardat_x[i], vardat_y[i],
	    vardat_t[i], vardat_x[j], vardat_y[j], vardat_t[j], cvstrct);
         if (i != j) form_a[j][i] = form_a[i][j];
      }

      // Check for singularity.

      if (i > 0) exactsg_(form_a, i, "aformck");
   }
 
   // Check positive definiteness of form_a.

   if (Choles.choles_(form_a, s, 1, mtotu, false) >= 0.) {
      break;

   } else {
      varmod_sill[0][2] *= .9;
      varmod_sill[0][3] *= .9;
      for (i = 0; i < parm_mvar; ++i) varmod_lma[i] = 0.;
   }

   if (k > 8) {
      varmod_sill[0][2] = 0.;
      varmod_sill[0][3] = 0.;
   }
}

// Write last parm_mvar rows and columns of A.

for (i = mtotu; i < parm_mtot; ++i) {
   n += nmcylobs[i - mtotu];
   for (j = 1; j <= mtotu; ++j) {

      if (j <= nold || n < j) form_a[j - 1][i] = 0.;
      else form_a[j - 1][i] = 1.;

      form_a[i][j - 1] = form_a[j - 1][i];
   }
   nold = n;
   for (j = mtotu; j < parm_mtot; ++j) form_a[j][i] = 0.;
}
 
// Write first mtotu values of the rhs vector(s) (the b vectors).

for (j = 1; j <= parm_mvar; ++j) {
   for (i = 0; i < mtotu; ++i) {

      // Find covariance structure.

      stnmi = idtostnm[vardat_vrble[i] - 1];
      if (stnmi == j) {
         cvstrct = j;
      
      } else {
         cvstrct = crossmap[stnmi - 1][j - 1];
      }
 
      // Assign covariance.

      form_xmeas[i][j] = Covmodl.covmodl_(1, 2, vardat_x[i], vardat_y[i],
         vardat_t[i], xcord, ycord, tmecord, cvstrct);
   }
}

// Write last parm_mvar rows and columns of b.

for (i = mtotu; i < parm_mtot; ++i) {
   for (j = mtotu; j < parm_mtot; ++j) {
      if (i == j) {
         form_xmeas[i][j - mtotu] = 1.;
      
      } else {
         form_xmeas[i][j - mtotu] = 0.;
      }
   }
}
return 0;
}

// ------------------------------------------------------------------

static int aformu_(double xcord, double ycord, double tmecord) {
 
/* Forms the A matrix for the Universal Kriging system. !!!! Note,
   uses covariance form of kriging system, see pp. 306-307 of
   Journal and Huijbregts. */
 
boolean first = true;

int i, j, m, mtotu, cvstrct, retval, nmunbs, stnmi, stnmj;

double xi, yi, xnew, ynew, dcos, dsin, dumx, dumy;

double atemp[] = new double[WLSSZE2];
double psmtrx[][] = new double[WLSSZE2][10];

// Set number of unbiasedness constraints.

if (ktrend > 0) {
   nmunbs = ktrend;

} else {
   nmunbs = nmpars[0];
}

mtotu = parm_mtot - nmunbs;
 
// LOAD:

// Form covariance matrix.
 
for (i = 0; i < mtotu; ++i) {
   for (j = 0; j <= i; ++j) {

      // Find covariance structure.

      stnmi = idtostnm[vardat_vrble[i] - 1];
      stnmj = idtostnm[vardat_vrble[j] - 1];
      if (stnmi == stnmj) {
         cvstrct = stnmi;
    
      } else {
         cvstrct = crossmap[stnmi - 1][stnmj - 1];
      }

      // Assign covariance and fill in upper half.

      form_a[i][j] = Covmodl.covmodl_(i, j, vardat_x[i], vardat_y[i],
	 vardat_t[i], vardat_x[j], vardat_y[j], vardat_t[j], cvstrct);
      if (i != j) form_a[j][i] = form_a[i][j];
   }
   
   // Check for exact singularity.

   if (i > 0) exactsg_(form_a, i, "aformu");
}

// Check that form_a is positive definite, if not, return.

if (Choles.choles_(form_a, s, 1, mtotu, false) < 0.) {
   iderr_("aformu: matrix form_a not positive definite");
}

// Unbiasedness constraint(s).
 
if (ktrend == 1) {
   for (i = 0; i < mtotu; ++i) psmtrx[i][0] = 1.;

} else if (ktrend == 3) {

   // Form matrix of position point functions linear trend.
 
   for (i = 0; i < mtotu; ++i) {
      xi = vardat_x[i] - xmean;
      yi = vardat_y[i] - ymean;
      psmtrx[i][0] = 1.;
      psmtrx[i][1] = xi;
      psmtrx[i][2] = yi;
   }

} else if (ktrend == 6) {

   // Quadratic trend.
 
   for (i = 0; i < mtotu; ++i) {
      xi = vardat_x[i] - xmean;
      yi = vardat_y[i] - ymean;
      psmtrx[i][0] = 1.;
      psmtrx[i][1] = xi;
      psmtrx[i][2] = yi;
      psmtrx[i][3] = xi * xi;
      psmtrx[i][4] = yi * yi;
      psmtrx[i][5] = xi * yi;
   }

} else if (ktrend == -1) {

   // Design-based constraints.

   for (i = 0; i < mtotu; ++i) {
      for (j = 0; j < nmpars[0]; ++j) psmtrx[i][j] = cstore[i][j];
   }
}

// Write first mtotu rows of A.

for (i = 0; i < mtotu; ++i) {
   for (j = 0; j < nmunbs; ++j) atemp[mtotu+j] = psmtrx[i][j];
   for (m = mtotu; m < parm_mtot; ++m) form_a[i][m] = atemp[m];
}
 
// Write last nmunbs rows of A.
 
for (i=0; i < nmunbs; ++i) {
   for (j=0; j < mtotu; ++j) atemp[j] = psmtrx[j][i];
   for (j=0; j < nmunbs; ++j) atemp[mtotu+j] = 0.;
   for (m=0; m < parm_mtot; ++m) form_a[mtotu+i][m] = atemp[m];
}
 
/* Write first mtotu values of the rhs vector (b).  It is assumed that
   variable 1 is always being estimated. */
 
for (i = 0; i < mtotu; ++i) {

   // Find covariance structure.

   cvstrct = idtostnm[vardat_vrble[i] - 1];

   // Assign covariance.

   form_xmeas[i][0] = Covmodl.covmodl_(1, 2, xcord, ycord, tmecord,
      vardat_x[i], vardat_y[i], vardat_t[i], cvstrct);
}
 
/* Write unbiasedness constraint(s) values of b, first case is ordinary
   kriging. */ 
 
if (ktrend == 1) {
   form_xmeas[mtotu][0] = 1.;

} else if (ktrend == 3) {

   // Linear trend.

   form_xmeas[mtotu][0] = 1.;
   form_xmeas[mtotu+1][0] = xcord - xmean;
   form_xmeas[mtotu+2][0] = ycord - ymean;

} else if (ktrend == 6) {

   // Quadratic trend.

   form_xmeas[mtotu][0] = 1.;
   xnew = xcord - xmean;
   ynew = ycord - ymean;
   form_xmeas[mtotu+1][0] = xnew;
   form_xmeas[mtotu+2][0] = ynew;
   form_xmeas[mtotu+3][0] = xnew * xnew;
   form_xmeas[mtotu+4][0] = ynew * ynew;
   form_xmeas[mtotu+5][0] = xnew * ynew;

} else if (ktrend == -1) {

   // Design matrix previously defined.

   for (i = 0; i < nmunbs; ++i) {
      form_xmeas[mtotu + i][0] = cstore[nd][i];
   }
}
return 0;
}

// --------------------------------------------------------------------

static int krgest_(int threadnm, double xcord, double ycord,
   double tmecord) {

/* Computes kriging and cokriging estimate, kriging variance, or 95% C.I.
   width.  !!! Assumes covariance form of kriging equations, see pp. 306-307
   of Journel and Huibregts (1978).

   mtotu is the number of data points,
   parm_mtot is the size of the kriging system.

   krgvcalc=true: only calculate the kriging variance.
   krgvcalc=false: calculate the estimate and the kriging variance. */

int i, j, mtotu, k, i1, cvstrct, vrble;

double alphaz, gamsum, logdat, covparm, bend;

/* Find the number of data points, for kriging:
   ktrend>0:  mtotu = mtot - ktrend,
   ktrend=-1: mtotu = mtot - nmpars[lomapnms[0] - 1],
   cokriging: mtotu = mtot - parm_mvar. */

mtotu = nd;
if (parm_mvar == 1) {
   if (ktrend > 0) {
      mtotu = parm_mtot - ktrend;
   
   } else {
      mtotu = parm_mtot - nmpars[0];
   }

} else if (parm_mvar > 1) {
   mtotu = parm_mtot - parm_mvar;
}

/* Zero-out the prediction and kriging variance vectors and
   set normal quantile for C.I. */

for (i = 0; i < parm_mvar; ++i) {
   prdest[i] = 0.;
   krgvar[i] = 0.;
}
alphaz = 1.96;

if (itrend <= 2) {

   /* Ordinary kriging, cokriging. */

   for (j = 0; j < parm_mvar; ++j) {
      if (!krgvcalc) {
         for (i = 0; i < mtotu; ++i) {
	    prdest[j] += xtemp[i][j] * vardat_dat[i];
	 }
      }

      // Compute kriging, cokriging variance.

      for (i = 0; i < parm_mtot; ++i) {
	 krgvar[j] += form_xmeas[i][j] * xtemp[i][j];
      }

      // Find covariance structure.

      cvstrct = j + 1;

      krgvar[j] = Covmodl.covmodl_(1, 1, xcord, ycord, tmecord,
         xcord, ycord, tmecord, cvstrct) - krgvar[j];

      if (krgvar[j] < 0.) {
	 printf_("krgest: negative kriging variance");
         krgvar[j] = 1.e-6;
      }

      // Compute upper and lower confidence interval bounds.

      lower[j] = prdest[j] - alphaz * Math.sqrt(krgvar[j]);
      upper[j] = prdest[j] + alphaz * Math.sqrt(krgvar[j]);
   }

} else if (itrend == 3) {

   // Lognormal kriging.

   if (ktrend != 1) {
      iderr_("krgest: incorrect ktrend");
   }

   if (!krgvcalc) {
      for (i = 0; i < parm_mtot - 1; ++i) {
         if (vardat_dat[i] == 0.) {
	    logdat = 0.;
         
	 } else {
	    logdat = Math.log(vardat_dat[i]);
	 }
         prdest[0] += xtemp[i][0] * logdat;
      }
   }

   /* Compute kriging variance.  First, find covariance structure. */

   cvstrct = 1;

   for (i = 0; i < parm_mtot; ++i) {
      krgvar[0] += form_xmeas[i][0] * xtemp[i][0];
   }
   krgvar[0] =
      Covmodl.covmodl_(1, 1, xcord, ycord, tmecord, xcord, ycord,
                       tmecord, cvstrct) - krgvar[0];

   if (krgvar[0] < 0.) {
      iderr_("krgest: negative kriging variance");
   }

   // Compute log scale upper and lower C.I. bounds.

   lower[0] = prdest[0] - alphaz * Math.sqrt(krgvar[0]);
   upper[0] = prdest[0] + alphaz * Math.sqrt(krgvar[0]);

   if (!krgvcalc) {
      gamsum = 0.;
      for (i = 0; i < parm_mtot - 1; ++i) {
         gamsum += xtemp[i][0] * form_xmeas[i][0];
      }
      prdest[0] = Math.exp(prdest[0] + .5 * gamsum +
	 .5 * xtemp[parm_mtot - 1][0]);
   }

} else if (itrend >= 4) {

   /* Residual kriging, residual cokriging, universal kriging after
      regression-determined semivariogram.  First, find all residual
      predictions and kriging variances. */

   for (j = parm_mvar - 1; j >= 0; --j) {
      vrble = lomapnms[j];

      /* If needed, find the quantitative and qualitative node values at
         (xcord, ycord). */

      if (icrval == 0 || icrval == 2) {
         Trendeval.quantqual_(xcord, ycord, tmecord, quantval, qualval);
           
      } else if (icrval == 1) {
         for (k = 0; k < nmquantvar; ++k) {
            quantval[k] = dat2_quantval[idatcr - 1][k];
         }
         for (k = 0; k < nmqualvar; ++k) {
            qualval[k] = dat2_qualval[idatcr - 1][k];
         }
      }

      // Compute the trend value at the point and for this variable.

      if (nmstmixcntr == 0) {
         trend[j] = Trendeval.trendfcn_(0, true, 0, xcord, ycord,
            tmecord, quantval, qualval, j + 1);
      
      } else {
         Trendeval.mixtrend_(true, 0, xcord, ycord, tmecord, quantval,
	    qualval, j + 1, trend);
      } 

      if (!krgvcalc) {
         if (ktrend == -1) {
            for (i = 0; i < mtotu; ++i) {
               prdest[j] += xtemp[i][j] * vardat_obs[i];
            }

         } else if (ktrend > 0) {
            for (i = 0; i < mtotu; ++i) {
               prdest[j] += xtemp[i][j] * vardat_dat[i];
            }
         }
      }

      /* Compute kriging variance and 95% C.I.  First, find covariance
         structure. */

      cvstrct = j + 1;

      for (i = 0; i < parm_mtot; ++i) {
         krgvar[j] += form_xmeas[i][j] * xtemp[i][j];
      }

      krgvar[j] = Covmodl.covmodl_(1, 1, xcord, ycord, tmecord,
	 xcord, ycord, tmecord, cvstrct) - krgvar[j];

      if (krgvar[j] < 0.) {
	 printf_("krgest: negative kriging variance, variable= " + (j + 1));
	 krgvar[j] = 1.e-6;
      }

      // Skip prediction if just calculating the kriging variance.

      if (krgvcalc) {
	 continue;
      }

      /* For residual kriging, store variable j's trend at (xcord, ycord),
         and compute the prediction. */

      if (ktrend > 0) {
         grdvar_trend[grow - 1][gcol - 1][jtime - 1][j] = trend[j];
         prdest[j] += trend[j];
      }

      // Fail if NaN.

      if (Double.isNaN(prdest[j])) {
         prdest[j] = 0.;
         printf_("krgest: est(" + (j + 1) + ") is NaN");
         return 4;
      }

      // Compute upper and lower confidence interval bounds.

      lower[j] = prdest[j] - alphaz * Math.sqrt(krgvar[j]);
      upper[j] = prdest[j] + alphaz * Math.sqrt(krgvar[j]);

      /* negest = true means allow negative estimates.  If negative estimate
         is not allowed, use zero. */

      if (prdest[j] < 0. && !negest) {
         printf_("krgest: est(" + (j + 1) + ") < 0, resetting to zero.");
         prdest[j] = 0.;
      }

      /* Check for very small kriging variance, if so, reset to sample
         variance or 1.0 if fitting a global model. */

      if (krgvar[j] < 1.e-10) {
         if (itrend < 10) {
            printf_("kriging variance= " + krgvar[j]);
            printf_("small kriging variance, resetting to local variance");
            krgvar[j] = grdvar_datssy;

         } else {
            printf_("Very small kriging variance, resetting to 1.0");
            krgvar[j] = 1.0;
         }
      }
   } // End of descending loop over the variables.
} // End of itrend >= 4 condition.

/* Return at this point -- integrating these predictions with a larger
   ID is future work. */

if (true) {
   return 0;
}

/* Place predicted LOMAP node values into the ID node value array and
   update all other ID nodes conditional on these predicted values.
   Values are placed in threadnm = 0 for now. */

for (k = 0; k < parm_mvar; ++k) {
   Beliefs.nodevalsh[0][1][lomapnms[k] - 1] = prdest[k];
}
for (k = 1; k <= nmnds; ++k) {
   Update.update_(threadnm, Beliefs.nodevalsh, k, 1);
}

// Copy all ID node values back to prdest[].

for (k = 0; k < nmnds; ++k) {
   prdest[k] = Beliefs.nodevalsh[0][1][k];
}
return 0;
}
}
