class Matrix extends Id {
static int i, ii, j, k, i1, i2, j1;

// ------------------------------------------------------------------------

static void mxm_(double a[][], double b[][], double c[][], int n,
   int k, int m) {

for (i = 0; i < n; ++i) { 
   for (j = 0; j < m; ++j) { 
      c[i][j] = 0.; 
      for (ii = 0; ii < k; ++ii) c[i][j] += a[i][ii] * b[ii][j]; 
   } 
}
}

// ------------------------------------------------------------------------

static void mzro_(double mtrx[][], int n, int m) {

for (i = 0; i < n; ++i) { 
   for (j = 0; j < m; ++j) mtrx[i][j] = 0.; 
}
}

// -----------------------------------------------------------------------

static void sxm_(double scalar, double mtrx[][], int n, int m) {

for (i = 0; i < n; ++i) { 
   for (j = 0; j < m; ++j) mtrx[i][j] *= scalar; 
}
}

// -----------------------------------------------------------------------

static void vxm_(double vctr[], double mtrx[][], double vval[],
   int n, int m) {

for (i = 0; i < n; ++i) { 
   vval[i] = 0.; 
   for (j = 0; j < m; ++j) vval[i] += vctr[j] * mtrx[j][i]; 
}
}

// -----------------------------------------------------------------------

static void mxv_(double mtrx[][], double vctr[], double vval[],
   int n, int m) {

for (i = 0; i < n; ++i) { 
   vval[i] = 0.; 
   for (j = 0; j < m; ++j) vval[i] += mtrx[i][j] * vctr[j]; 
}
}

// -----------------------------------------------------------------------

static void iden_(double mat[][], int n) {

for (i = 0; i < n; ++i) { 
   for (j = 0; j < n; ++j) { 
      if (i == j) mat[i][j] = 1.0; 
      else mat[i][j] = 0.; 
   } 
}
}

// -----------------------------------------------------------------------

static void diag_(double vec[], double mat[][], int n) {

for (i = 0; i < n; ++i) { 
   for (j = 0; j < n; ++j) { 
      if (i == j) mat[i][j] = vec[i]; 
      else mat[i][j] = 0.; 
   } 
}
}

// -----------------------------------------------------------------------

static void vxvt_(double vec[], double mat[][], int n) {

for (i = 0; i < n; ++i) { 
   for (j = 0; j < n; ++j) mat[i][j] = vec[i] * vec[j]; 
}
}

// -----------------------------------------------------------------------

static void mmm_(double mat1[][], double mat2[][], double mat3[][],
   int n, int m) {

for (i = 0; i < n; ++i) { 
   for (j = 0; j < m; ++j) mat3[i][j] = mat1[i][j] - mat2[i][j]; 
}
}

// -----------------------------------------------------------------------

static void trsp_(double mat1[][], double mat2[][], int n, int m) {

for (i = 0; i < n; ++i) { 
   for (j = 0; j < m; ++j) mat2[j][i] = mat1[i][j]; 
}
}

// -----------------------------------------------------------------------

static void mupdt_(double mat1[][], double mat2[][], int n, int m) {

for (i = 0; i < n; ++i) { 
   for (j = 0; j < m; ++j) mat1[i][j] += mat2[i][j]; 
}
}

// -----------------------------------------------------------------------

static void mcpy_(double mat1[][], double mat2[][], int n, int m) {

for (i = 0; i < n; ++i) { 
   for (j = 0; j < m; ++j) mat1[i][j] = mat2[i][j]; 
}
}

// ----------------------------------------------------------------------

static void mprint_(double mat[][], int n, int m) {

// Prints a matrix.

for (i = 0; i < n; ++i) {
   strng = " ";
   for (j = 0; j < m; ++j) strng += fdble_(mat[i][j], 5, 3) + " ";
   printf_(strng);
}
}

// ----------------------------------------------------------------------

static void slvl_(double mat[][], double vsol[], double vrhs[],
   int n) {

// Solves the system mat * vsol = vrhs.

int ipvt[] = new int[n];
double cond;
double work[] = new double[n];
double mstore[][] = new double[n][n];

// Store mat.

for (i1 = 0; i1 < n; ++i1) {
   for (i2 = 0; i2 < n; ++i2) mstore[i1][i2] = mat[i1][i2];
}
for (i1 = 0; i1 < n; ++i1) vsol[i1] = vrhs[i1];

cond = Eqslv.decomp_(n, mat, ipvt, work);
if (cond > 1.e32) {
   iderr_("cond= " + cond + " in slvl2");
}
Eqslv.solve_(n, mat, vsol, ipvt);

// Restore mat.

for (i1 = 0; i1 < n; ++i1) {
   for (i2 = 0; i2 < n; ++i2) mat[i1][i2] = mstore[i1][i2];
}

/* Check on solution correctness.
mxv_(mpin1,vsol,vpin1,n,n);
printf("slvl2 check:");
vprint_(vpin1,n);
vprint_(vrhs,n); */
}

// -----------------------------------------------------------------------

static void invl_(double mat1[][], double mat2[][], int n) {

// Finds mat2 = inv(mat1).

int ipvt[] = new int[n];
double cond;
double work[] = new double[n];
double b[] = new double[n];
double check[][] = new double[n][n];
double result[][] = new double[n][n];

// Store mat1 for error checking.

for (i1 = 0; i1 < n; ++i1) {
   for (j1 = 0; j1 < n; ++j1) check[i1][j1] = mat1[i1][j1];
}
cond = Eqslv.decomp_(n, mat1, ipvt, work);
if (cond > 1.e30) return;
for (i1 = 0; i1 < n; ++i1) {
   Vectr.vzro_(b, n);
   b[i1] = 1.;
   Eqslv.solve_(n, mat1, b, ipvt);
   for (j1 = 0; j1 < n; ++j1) mat2[j1][i1] = b[j1];
}

/* Inverse check.
mxm_(check,mat2,result,n,n,n);
printf("inverse check:");
mprn1_(result,n,n); */
}

// ------------------------------------------------------------------------

static void matprt_(double f[][], int n, int rownme[], int name) {

// Repartitions f so that variable "name" is in the last row.

double var;
double covlow[] = new double[n];
double covhgh[] = new double[n];

for (i = 1; i <= name - 1; ++i) covlow[i - 1] = f[name - 1][i - 1];
var = f[name - 1][name - 1];
for (i = name + 1; i <= n; ++i) covhgh[i - name - 1] = f[name - 1][i - 1];

for (i = name + 1; i <= n; ++i) {
   for (j = name + 1; j <= n; ++j) {
      f[i - 2][j - 2] = f[i - 1][j - 1];
   }
}

for (i = name + 1; i <= n; ++i) {
   for (j = 1; j <= name - 1; ++j) {
      f[i - 2][j - 1] = f[i - 1][j - 1];
   }
}

for (i = 1; i <= name - 1; ++i) {
   for (j = name + 1; j <= n; ++j) {
      f[i - 1][j - 2] = f[i - 1][j - 1];
   }
}

for (i = 1; i <= name - 1; ++i) f[n - 1][i - 1] = covlow[i - 1];
for (i = name; i <= n - 1; ++i) f[n - 1][i - 1] = covhgh[i - name];
for (i = 1; i <= n - 1; ++i) f[i - 1][n - 1] = f[n - 1][i - 1];
f[n - 1][n - 1] = var;

for (i = name + 1; i <= n; ++i) rownme[i - 2] = rownme[i - 1];
rownme[n - 1] = name;
}

// ----------------------------------------------------------------------

static void ginv_(double a[][], double b[][], int n) {

double eigvecs[][] = new double[n][n];
double eigvals[] = new double[n];
double valvec[] = new double[n];

// Computes the generalized inverse of a.

// Compute the spectral decomposition of a. First, make a copy of a.

mcpy_(eigvecs, a, n, n);
Eigenvec.eigenvec_(n, eigvecs, eigvals);
printf_("largest eigenvalue= " + eigvals[0] + ", smallest= " +
    eigvals[n - 1]);

// Form the generalized inverse.

mzro_(b, n, n);
printf_("Negative eigenvalues of given matrix");
printf_(" Rank     Eigenvalue");
for (k = 0; k < n; ++k) {
   if (eigvals[k] > 1.e-20) {
      for (i = 0; i < n; ++i) {
         valvec[i] = eigvecs[i][k] / eigvals[k];
      }
      for (i = 0; i < n; ++i) {
         for (j = 0; j < n; ++j) {
            b[i][j] += valvec[i] * eigvecs[j][k];
         }
      }

   } else {
      printf_((k + 1) + " " + eigvals[k]);
   }
}
}
}
