public class Mchtsts extends Surf {

static int nmdat[] = new int[NUMVAR];
static double trimfrac[] = new double[NUMVAR];
static double slags[][] = new double[DATSZE][DATSZE];
static double tlags[][] = new double[DATSZE][DATSZE];
static double glblcov[][] = new double[DATSZE][DATSZE];
static double sqmat[][] = new double[DATSZE][DATSZE];
static double sqrtvs[][] = new double[DATSZE][DATSZE];
static double sqrtv[][] = new double[DATSZE][DATSZE];
static double obstrend[] = new double[DATSZE];
static double stdnrms[] = new double[DATSZE];
static double strtau1[] = new double[NUMVAR];
static double strtau2[] = new double[NUMVAR];

// ------------------------------------------------------------------------

public static void mcvolci_(int m) {

// Monte Carlo confidence interval of a volume.

boolean test = true;

int i, j, i1, nfrac;

int ndminsv[] = new int[NUMVAR];
int index[] = new int[DATSZE];

double obsvol, cilength, minlength = 1.e30, cilevel = .68, cilow = 0.,
   cihigh = 0.;

double vol[] = new double[DATSZE];
double dat[][] = new double[DATSZE][1];
double meanvec[] = new double[NUMVAR];
double stdvec[] = new double[NUMVAR];
double maxvec[] = new double[NUMVAR];

// Predict and print the volume using the actual data.

obsvol = Surfcalcs.volume_(true, 1);
fprintf_(1, "Volume predicted from the data= " + obsvol);

// Print the mean surface value(s).

for (i = 0; i < 3; ++i) {
   nmdat[i] = Multint.ptnm;
   trimfrac[i] = 0.;
}
Summry.summry_(false, 1, nmdat, 3, trimfrac, Multint.surfvals,
   meanvec, stdvec, maxvec);
for (i = 0; i < 3; ++i) fprintf_(1,"Surface " + (i + 1) + " mean= " +
   meanvec[i]);

/* Monte Carlo standard error of volume calculation.  First, compute a
   surface so that a grid of covariogram parameter values are stored.
   From these stored local covariogram matrix models, find the global
   covariance matrix and its square root. */

printf_("\nStarting surface computation to support global covariance" +
  " matrix estimation");
Surfcalcs.surface_();
glblcov_(true);

// Compute trend values at each observation location.

printf_("\nStarting cross-validation to obtain trend estimates at all" +
   "\nobservation locations");
gvargrm_(obstrend, true, false);

/* Monte Carlo sample generation and test statistic computation loop.  First,
   set number of Monte Carlo samples. */

printf_("\nStarting " + m + " Monte Carlo-generated volume predictions");
fprintf_(1, "Number of Monte Carlo-generated volumes= " + m);

for (i = 0; i < m; ++i) {
   index[i] = i + 1;

   // Generate i.i.d. standard normals.

   for (j = 0; j < nmecoobsttl; ++j) {
      stdnrms[j] = Rndm.stdnrm_(0);
   }

   // Generate a MVN(mu,Sigma) realization.

   for (j = 0; j < nmecoobsttl; ++j) {
      dat2_dat[j] = 0.;
      for (i1 = 0; i1 < nmecoobsttl; ++i1) {
	 dat2_dat[j] += sqmat[j][i1] * stdnrms[i1];
      }
      dat2_dat[j] += obstrend[j];
      if (dat2_dat[j] < 0.) dat2_dat[j] = 0.;
   }

   /* Predict the volume from this Monte Carlo sample.  Use values
      estimated from the actual data for any nuisance parameters.  Here,
      the nuisance parameters are mu and Sigma. */
 
   vol[i] = Surfcalcs.volume_(false, 1);
   dat[i][0] = vol[i];
   fprintf_(1, "Monte Carlo volume realization i= " + i + " vol= " + vol[i]);
}

// Find minimum length volume C.I..

Idsort.idsort_(vol, index, 1, m);
nfrac = (int) Math.round(cilevel * (double) m);
for (i = 0; i < m - nfrac; ++i) {
   if (i + nfrac > m) break;
   cilength = vol[i + nfrac] - vol[i];
   if (cilength < minlength) {
      minlength = cilength;
      cilow = vol[i];
      cihigh = vol[i + nfrac];
   }
}

// Print C.I.

fprintf_(1, "Volume " + fdble_(100. * cilevel, 5, 1) + "% C.I.= ("
   + fdble_(cilow, 9, 3) + ", " + fdble_(cihigh, 9, 3) + ")");

// Compute summary statistics.

nmdat[0] = m;
Summry.summry_(true, 1, nmdat, 1, trimfrac, dat, meanvec, stdvec, maxvec);

return;
}

// ----------------------------------------------------------------------

public static void glblcov_(boolean wflag) {

// Builds an estimate of the global covariance matrix.

int i, j, i1, j1, k1, i2, retval, ier, cvstrct, stnmi, stnmj;

double xm, ym, xdif, ydif, tdif, tdist1, tdist2, sdist1, sdist2, sqeig,
   rhop, rhosig, scldiff, sdstmin, tdstmin, tm, hlfcyl, ptlim, ftlim, infin,
   mcondtn, eigval, genvar;

double eigvals[] = new double[DATSZE];
double valvec[] = new double[DATSZE];
double sqvalvec[] = new double[DATSZE];

// Check bounds.

if (nmecoobsttl > DATSZE) iderr_("glblcov: nmecoobsttl > DATSZE");

// Specify the condition number of the global covariance matrix.

mcondtn = 1.e6;

// Find half of the allowable temporal lag and define infinity.

hlfcyl = .5 * ((double) kmaxt);
infin = 1.e10;

for (i = 0; i < nmecoobsttl; ++i) {
   for (j = 0; j <= i; ++j) {
      sqrtvs[i][j] = 0.;

      // Find spatial and temporal lags.

      if (i != j) {
         xdif = dat2_x[i] - dat2_x[j];
         ydif = dat2_y[i] - dat2_y[j];
	 tdif = Math.abs(dat2_t[i] - dat2_t[j]);
         slags[i][j] = Math.sqrt(xdif * xdif + ydif * ydif);
         tlags[i][j] = tdif;

      } else if (i == j) {
         slags[i][j] = 0.;
	 tlags[i][j] = 0.;
      }

      // Find covariance structure.

      stnmi = dat2_vrble[1][i];
      stnmj = dat2_vrble[1][j];
      if (dat2_vrble[1][i] == dat2_vrble[1][j]) {
         cvstrct = stnmi;

      } else {
         cvstrct = crossmap[stnmi - 1][stnmj - 1];
      }
 
      /* Find center point of line connecting location i with location j
         in space and time separately. */

      xm = .5 * (dat2_x[i] + dat2_x[j]);
      ym = .5 * (dat2_y[i] + dat2_y[j]);
      tm = .5 * (dat2_t[i] + dat2_t[j]);

      sdstmin = infin;
      tdstmin = infin;
      for (k1 = 0; k1 < spacetime_ntimes; ++k1) {
         for (i1 = 0; i1 < spacetime_nmrows; ++i1) {
            for (j1 = 0; j1 < spacetime_nmcols; ++j1) {
	       if (grdvar_iblank[i1][j1][k1] == 0) {

		  /* If this cylinder is closer to (xm,ym) and tm than the
		     current closest cylinder, update the pairwise
		     covariance. */

		  xdif = grdvar_x[i1][j1][k1] - xm;
		  ydif = grdvar_y[i1][j1][k1] - ym;
		  sdist1 = Math.sqrt(xdif * xdif + ydif * ydif);
		  tdist1 = Math.abs(grdvar_t[i1][j1][k1] - tm);
		  if (sdist1 <= sdstmin && tdist1 <= tdstmin) {
                     sdstmin = sdist1;
		     tdstmin = tdist1;

                     for (i2 = 0; i2 < nmmdls; ++i2) {
                        varmod_nugget[0][i2] = grdvar_nug[i1][j1][k1][i2];
                        varmod_sill[0][i2] = grdvar_sill[i1][j1][k1][i2];
                        varmod_range[0][0][i2] =
			   grdvar_rnge[i1][j1][k1][0][i2];
                        varmod_range[0][1][i2] =
			   grdvar_rnge[i1][j1][k1][1][i2];
                     }
		     sqrtvs[i][j] = Covmodl.covmodl_(i, j, dat2_x[i],
                        dat2_y[i], dat2_t[i], dat2_x[j], dat2_y[j],
                        dat2_t[j], cvstrct);
		  }
	       }
	    }
	 }
      }

      // If no valid cylinder has been found, quit.

      if (sdstmin == infin || tdstmin == infin) iderr_("prob 1 in glblcov");

      // Fill in upper triangle.

      sqrtvs[j][i] = sqrtvs[i][j];

      // Make a copy of this matrix.

      sqrtv[i][j] = sqrtvs[i][j];
      sqrtv[j][i] = sqrtv[i][j];
   }
}

// Compute spectral decomposition of sqrtvs.

retval = Eigenvec.eigenvec_(nmecoobsttl, sqrtv, eigvals);
if (retval == 1) iderr_("glblcov: eigenvec failed");
if (wflag) {
   if (eigvals[nmecoobsttl - 1] > 0.) {
      fprintf_(1, "P itself is positive definite.");

   } else {
      fprintf_(1, "Negative eigenvalues of P");
      fprintf_(1, " Rank     Eigenvalue");
   }
}

// Write the scree plot file.

fleopen_(8, "scree.dat", 'w');
for (i = 0; i < nmecoobsttl; ++i) fprintf_(2, (i + 1) + " " + eigvals[i]);
fclose_(8,'w');

/* Form the global covariance matrix that is based on the positive
   approximant. */

for (i = 0; i < nmecoobsttl; ++i) {
   for (j = 0; j < nmecoobsttl; ++j) {
      glblcov[i][j] = 0.;
      sqmat[i][j] = 0.;
   }
}

/* Form the global covariance matrix and the square root matrix.  Compute
   the generalized variance (determinant) of the global covariance matrix. */

genvar = 1.;
for (j1 = 0; j1 < nmecoobsttl; ++j1) {
   if (Double.isNaN(eigvals[j1]) || Double.isInfinite(eigvals[j1])) {
      iderr_("glblcov: j1= " + j1 + " eigval= " + eigvals[j1]);
   }

   if (eigvals[j1] > 0.) {
      eigval = eigvals[j1];
      genvar *= eigvals[j1];

      printf_("glblcov: eigval(" + (j1 + 1) + ")= " + eigval);

      if (Double.isInfinite(genvar)) {
         printf_("glblcov: infinite genvar, breaking");
         genvar = 1.e30;
         break;
      }

   } else {
      if (wflag) fprintf_(1, (j1 + 1) + " " + eigvals[j1]);
      eigval = eigvals[0] / mcondtn;
   }

   sqeig = Math.sqrt(eigval);
   for (i = 0; i < nmecoobsttl; ++i) {
      valvec[i] = sqrtv[i][j1] * eigval;
      sqvalvec[i] = sqrtv[i][j1] * sqeig;
   }

   for (i = 0; i < nmecoobsttl; ++i) {
      for (j = 0; j < nmecoobsttl; ++j) {
         glblcov[i][j] += valvec[i] * sqrtv[j][j1];
         sqmat[i][j] += sqvalvec[i] * sqrtv[j][j1];
      }
   }
}
fprintf_(1,
   "Generalized Variance (determinant) of global covariance matrix= " +
   genvar);

/* Write h, pair-wise value, and global matrix value.  Also write pair-wise
   correlation differences file. */

if (!temporal) {
   fleopen_(2, "hcov.dat", 'w');
   fleopen_(3, "gdiffs.dat", 'w');
   for (i = 0; i < nmecoobsttl; ++i) {
      for (j = 0; j <= i; ++j) {
         xm = .5 * (dat2_x[i] + dat2_x[j]);
         ym = .5 * (dat2_y[i] + dat2_y[j]);
	 tm = .5 * (dat2_t[i] + dat2_t[j]);
	 if (sqrtvs[i][i] < 1.e-6 || sqrtvs[j][j] < 1.e-6) rhop = 0.;
	 else rhop = sqrtvs[i][j] /
	       (Math.sqrt(sqrtvs[i][i]) * Math.sqrt(sqrtvs[j][j]));
	 if (glblcov[i][i] < 1.e-6 || glblcov[j][j] < 1.e-6) rhosig = 0.;
         else rhosig = glblcov[i][j] /
	       (Math.sqrt(glblcov[i][i]) * Math.sqrt(glblcov[j][j]));

	 // else scldiff = (sqrtvs[i][j] - glblcov[i][j]) /
	 //                (sqrtvs[i][j] + fabs(glblcov[i][j]));

	 scldiff = rhop - rhosig;
         fprintf_(2, xm + " " + ym + " " + tm + " " + slags[i][j] + " " +
            tlags[i][j] + " " + sqrtvs[i][j] + " " + glblcov[i][j] + " " +
	    scldiff);
	 if (Math.abs(scldiff) > .1) {
	    fprintf_(3, xm + " " + ym + " " + 1.0 + " " + scldiff);
	 }
      }
   }
   fclose_(2, 'w');
   fclose_(3, 'w');
}

return;
}

// --------------------------------------------------------------------

public static void gvargrm_(double obstrend[], boolean actual,
   boolean gvarg) {

/* Estimates the global semivariogram and/or trend at each observation
   location. */

int i, j, i1, j1, nrowsv, ncolsv, ntimesv, cvrow, cvcol, crvlsve, vrble;
int ndminsv[] = new int[NUMVAR];

/* Using the data, find trend estimates at the observation locations.
   If computing a global semivariogram (gvarg=true), replace the data
   with the residuals. */

nrowsv = spacetime_nmrows;
ncolsv = spacetime_nmcols;
ntimesv = spacetime_ntimes;
crvlsve = icrval;

Surf.krgset_(0);
Surfcalcs.crossval_(true, 0, 1);
cvrow = spacetime_nmrows;
cvcol = spacetime_nmcols;

icrval = crvlsve;
spacetime_nmrows = nrowsv;
spacetime_nmcols = ncolsv;
spacetime_ntimes = ntimesv;

i1 = 0;
tmeloop: for (j1 = 0; j1 < spacetime_ntimes; ++j1) {
   for (i = 0; i < cvrow; ++i) {
      for (j = 0; j < cvcol; ++j) {
	 ++i1;
         // if (temporal && (dat2_t[i1] < crvall ||
	 //                  crvalu < dat2_t[i1]   )  ) continue;

         if (dat2_x[i1 - 1] != grdvar_x[i][j][j1] ||
	     dat2_y[i1 - 1] != grdvar_y[i][j][j1] ||
	     dat2_t[i1 - 1] != grdvar_t[i][j][j1]) {
	    printf_("i1= " + i1 + " i= " + i + " j= " + j + " j1= " + j1 +
	      " cvrow= " + cvrow + " cvcol= " + cvcol);
	    printf_("dat2x= " + dat2_x[i1 - 1] + " grdvarx= " +
	        grdvar_x[i][j][j1]);
	    printf_("dat2y= " + dat2_y[i1 - 1] + " grdvary= " +
	        grdvar_y[i][j][j1]);
	    printf_("dat2t= " + dat2_t[i1 - 1] + " grdvart= " +
	        grdvar_t[i][j][j1]);
	    iderr_("gvargrm: mismatch");
         }

         // Store these trend values only if working with the actual data.

         vrble = dat2_vrble[1][i1 - 1];
         if (actual) {
	    obstrend[i1 - 1] = grdvar_trend[i][j][j1][vrble - 1];
         }

         if (gvarg) {
	    dat2_dat[i1 - 1] = dat2_dat[i1 - 1] -
	       grdvar_trend[i][j][j1][vrble - 1];
         }

         if (i1 == nmecoobsttl) {
	    break tmeloop;
	 }
      }
   }
}

if (i1 != nmecoobsttl) {
   // printf("crvall=%lf crvalu=%lf i1=%d\n",crvall, crvalu, i1);
   iderr_("gvargrm: wrong i1");
}
if (!gvarg) return;

// Fit a global, spherical semivariogram model using all residuals.

for (i = 0; i < parm_mvar; ++i) ndminsv[i] = ndmin[i];
// ndmin[0] = icount1;
// ndmin[1] = icount2;
// mvsrch_(0, 0., 0., 0.);
// vargrm_(2, true, 0., 0., 0., a, g, h);
for (i = 0; i < parm_mvar; ++i) ndmin[i] = ndminsv[i];

return;
}

// --------------------------------------------------------------------

public static void simdat_() {

// Generates a spatial data set from a given distribution.

boolean badflag = false;

int i, i1, j, k, l, cvstrct, nmobs1, stnmi, stnmj;

double x = 0., y = 0., time = 0., xdif, ydif, retval, dist, difx, dify,
   z, r;

double trend[] = new double[TNMNDS];
double stdnrms[] = new double[DATSZE];

// Specify new data set sizes and time.

nmobs[idnmbrm1][lomapnms[0] - 1] = 40;
nmobs[idnmbrm1][lomapnms[1] - 1] = 160;
nmobs1 = nmobs[idnmbrm1][lomapnms[0] - 1];
nmecoobsttl = nmobs[idnmbrm1][lomapnms[0] - 1] + nmobs[idnmbrm1][lomapnms[1] - 1];
nmsites[0] = nmobs[idnmbrm1][lomapnms[0] - 1];
nmsites[1] = nmobs[idnmbrm1][lomapnms[1] - 1];
time = 86.;

// Randomly generate monitoring sites.

xdif = bdry_xmax[0] - bdry_xmin[0];
ydif = bdry_ymax[0] - bdry_ymin[0];

/* Randomly locate sites and randomly generate observations. */

for (i = 0; i < nmobs[idnmbrm1][lomapnms[0] - 1]; ++i) {
   dat2_vrble[1][i] = 1;

   /* Use rejection sampling to find a random point that is both
      within the boundary and not too close to other points. */

   for (k = 0; k < 5000; ++k) {
      for (j = 0; j < 5000; ++j) {
         x = bdry_xmin[0] + Rndm.rndm1_(0, 0) * xdif;
         y = bdry_ymin[0] + Rndm.rndm1_(0, 0) * ydif;
         if (bdry_(bdry_nmbdpts[0], bdry_xbdry[0], bdry_ybdry[0],
             x, y) > 0.) break;
      }
      if (j > 4990) iderr_("simdat: j>900");

      // Check for point being too close to other points.

      if (i == 0) break;
      badflag = false;
      for (l = 0; l <= i; ++l) {
         difx = dat2_x[l] - x;
         dify = dat2_y[l] - y;
         if (Math.sqrt(difx * difx + dify * dify) < .01) {
            badflag = true;
            break;
         }
      }
      if (!badflag) break;
   }
   if (k > 4990) iderr_("simdat: k > 900");

   dat2_x[i] = x;
   dat2_y[i] = y;
   xvals[0][i] = x;
   yvals[0][i] = y;

   dat2_t[i] = time;
}

l = nmobs1;
for (i = 0; i < nmobs1; ++i) {
   x = dat2_x[i] + .02;
   y = dat2_y[i];
   dat2_x[l] = x;
   dat2_y[l] = y;
   xvals[1][l - nmobs1] = x;
   yvals[1][l - nmobs1] = y;
   dat2_t[l] = time;
   dat2_vrble[1][l] = 2;
   ++l;

   x = dat2_x[i] - .02;
   y = dat2_y[i];
   dat2_x[l] = x;
   dat2_y[l] = y;
   xvals[1][l - nmobs1] = x;
   yvals[1][l - nmobs1] = y;
   dat2_t[l] = time;
   dat2_vrble[1][l] = 2;
   ++l;

   x = dat2_x[i];
   y = dat2_y[i] + .02;
   dat2_x[l] = x;
   dat2_y[l] = y;
   xvals[1][l - nmobs1] = x;
   yvals[1][l - nmobs1] = y;
   dat2_t[l] = time;
   dat2_vrble[1][l] = 2;
   ++l;

   x = dat2_x[i];
   y = dat2_y[i] - .02;
   dat2_x[l] = x;
   dat2_y[l] = y;
   xvals[1][l - nmobs1] = x;
   yvals[1][l - nmobs1] = y;
   dat2_t[l] = time;
   dat2_vrble[1][l] = 2;
   ++l;
}

varmod_epsln = 1.e30;
for (i = 1; i < nmecoobsttl; ++i) {
   for (j = 0; j < i; ++j) {
      xdif = dat2_x[i] - dat2_y[j];
      ydif = dat2_y[i] - dat2_y[j];
      dist = Math.sqrt(xdif * xdif + ydif * ydif);
      if (dist < varmod_epsln) varmod_epsln = dist;
   }
}

// Specify trend values.

trend[lomapnms[0] - 1] = 1.;
trend[lomapnms[1] - 1] = 1.;

// Specify covariogram matrix parameters. 

// Variable 1

varmod_nugget[0][0] = 0.0001;
varmod_sill[0][0] = 1.;
varmod_range[0][0][0] = 1.0; // was 1.5
varmod_range[0][1][0] = 0.;
varmod_model[0] = 1;

// Variable 2

varmod_nugget[0][1] = 0.0001;
varmod_sill[0][1] = 1.;
varmod_range[0][0][1] = 1.0;
varmod_range[0][1][1] = 0.;
varmod_model[1] = 1;

// Cross

varmod_nugget[0][2] = 0.00001;
varmod_sill[0][2] = .7;
varmod_range[0][0][2] = .9;
varmod_range[0][1][2] = 0.;
varmod_model[2] = 1;

// Specify transformation parameter values.

trnsfrm_tau1[0] = 1.;
trnsfrm_tau2[0] = 1.;
trnsfrm_invtau1[0] = 1.;
trnsfrm_invtau2[0] = 1.;

trnsfrm_tau1[1] = 1.0;
trnsfrm_tau2[1] = 1.;
trnsfrm_invtau1[1] = 1.;
trnsfrm_invtau2[1] = 1.;

// Zero-out covariance matrices.

for (i = 0; i < nmecoobsttl; ++i) {
   for (j = 0; j < nmecoobsttl; ++j) {
      glblcov[i][j] = 0.;
      sqmat[i][j] = 0.;
   }
}

/* Build covariance matrix, and then find its Cholesky decomposition.
   First, form correlated error covariance matrix in glblcov. */

for (i = 0; i < nmecoobsttl; ++i) {
   for (j = 0; j <= i; ++j) {

      // Find covariance structure to be used.

      stnmi = dat2_vrble[1][i];
      stnmj = dat2_vrble[1][j];
      if (dat2_vrble[1][i] == dat2_vrble[1][j]) {
         cvstrct = stnmi;

      } else {
         cvstrct = crossmap[stnmi - 1][stnmj - 1];
      }

      // Compute (possibly nonstationary) covariance and fill in upper half.

      glblcov[i][j] = Covmodl.covmodl_(i, j, dat2_x[i], dat2_y[i],
         dat2_t[i], dat2_x[j], dat2_y[j], dat2_t[j], cvstrct);
      if (i != j) glblcov[j][i] = glblcov[i][j];
   }

   // Check for exact singularity.

   if (i > 0) exactsg_(glblcov, i, "simdat");
}

// Find Cholesky decomposition.

retval = Choles.choles_(glblcov, sqmat, 1, nmecoobsttl, true);
if (retval < 0.) {
   iderr_("simdat: retval= " + retval + " Cholesky failed");
}

// Do a univariate analysis.

/*
parm_mvar = 1;
nmecoobsttl = nmobs[idnmbrm1][lomapnms[0] - 1];
*/

// Generate i.i.d. standard normals.

for (j = 0; j < nmecoobsttl; ++j) {
   stdnrms[j] = Rndm.stdnrm_(0);
}

/* Generate a MVN(mu,Sigma) realization. */

for (j = 0; j < nmecoobsttl; ++j) {
   dat2_dat[j] = 0.;
   for (i1 = 0; i1 < nmecoobsttl; ++i1) {
      dat2_dat[j] += sqmat[j][i1] * stdnrms[i1];
   }
}

for (j = 0; j < nmecoobsttl; ++j) {

   /* Apply back transformation and then add trend component to
      create "observed" values. */

   stnmj = dat2_vrble[1][j];
   dat2_dat[j] = Trnsfrm.invgaus_(stnmj, dat2_dat[j]);
   dat2_dat[j] += trend[stnmj - 1];
}

}
}
