class Minmax extends Surf {

// ---------------------------------------------------------------------

/*
Test case.
define MMXN 8
define MMXM 10
double infnrm_(), pol_();
main() {
int i;
double y[MMXM + 1], fy[MMXM + 1], co[MMXN + 2], em[4], ychk, fychk;
for (i = 0; i <= MMXM ; ++i) {
   y[i] = ((double) (i + 1)) / 11.;
   fy[i] = 1. / sqrt(y[i]);
}
em[2] = 10. * (10.) + 5.;
minmax_(MMXN, MMXM, y, fy, co, em);
for (i = 0; i <= MMXN; ++i) printf("co(%d)=%lf\n",i,co[i]);
printf("error at i=0: %lf\n",em[0]);
printf("infnorm=%lf\n",em[1]);
printf("no. of iterations=%lf\n",em[3]);
for (i = 0; i <= 200; ++i) {
   ychk = ((double) (i + 1)) / 201.;
   fychk = 1. / sqrt(ychk);
   printf("y=%lf fy=%lf pol=%lf err=%lf\n",
      ychk, fychk, pol_(MMXN,ychk,co), fychk - pol_(MMXN, ychk, co));
}
exit(0);
}
*/

static int minmax_(int n, int m, double y[], double fy[], double co[],
   double em[]) {

// Min-max polynomial approximate from Lau (1995, p. 608).

int np1, k, pomk, count, cnt, j, mi, sjm1, sj = 0, s0, up;
int s[] = new int[MMXN + 2];
double e, abse, abseh;
double x[] = new double[MMXN + 2];
double b[] = new double[MMXN + 2];
double coef[] = new double[MMXN + 2];
double g[] = new double[MMXM + 1];

if (n > MMXN) iderr_("n= " + n + ", > MMXN in minmax_()");
if (m > MMXM) iderr_("m= " + m + ", > MMXM in minmax_()");

np1 = n + 1;
ini_(np1, m, s);
mi = (int) em[2];
abse = 0.;
count = 1;
do {
   pomk = 1;
   for (k = 0; k <= np1; k++) {
      x[k] = y[s[k]];
      coef[k] = fy[s[k]];
      b[k] = pomk;
      pomk = -pomk;
   }
   newton_(np1, x, coef);
   newton_(np1, x, b);
   em[0] = e = coef[np1] / b[np1];
   elmvec_(0, n, 0, coef, b, -e);
   newgrn_(n, x, coef);
   s0 = sjm1 = s[0];
   g[s0] = e;
   for (j =1; j <= np1; j++) {
      sj = s[j];
      up = sj - 1;
      for (k = sjm1 + 1; k <= up; k++) {
	 g[k] = fy[k] - pol_(n, y[k], coef);
      }
      g[sj] = e = -e;
      sjm1 = sj;
   }
   for (k = s0 - 1; k >= 0; k--) {
      g[k] = fy[k] - pol_(n, y[k], coef);
   }
   for (k = sj + 1; k <= m; k++) {
      g[k] = fy[k] - pol_(n, y[k], coef);
   }
   sndrem_(np1, m, s, g, em);
   abseh = abse;
   abse = Math.abs(e);
   cnt = count;
   count++;
} while (count <= mi && abse > abseh);
em[2] = mi;
em[3] = cnt;
dupvec_(0, n, 0, co, coef);

return 0;
}

// --------------------------------------------------------------------

static int sndrem_(int n, int m, int s[], double g[], double em[]) {

int s0, sn, sjp1, i, j, k, up, low, nm1;
int dumint[] = new int[1];
double max, msjp1, hi, hj, he, abse, h, temp1, temp2;

s0 = sjp1 = s[0];
he = em[0];
low = s0 + 1;
max = msjp1 = abse = Math.abs(he);
nm1 = n - 1;
for (j = 0; j <= nm1; j++) {
   up = s[j + 1] - 1;
   h = infnrm_(low, up, dumint, g);
   i = dumint[0];
   if (h > max) max = h;
   if (h > abse) {
      if (he * g[i] > 0.) {
	 s[j] = (msjp1 < h) ? i : sjp1;
	 sjp1 = s[j + 1];
	 msjp1 = abse;
      
      } else {
	 s[j] = sjp1;
	 sjp1 = i;
	 msjp1 = h;
      }

   } else {
      s[j] = sjp1;
      sjp1 = s[j + 1];
      msjp1 = abse;
   }
   he = -he;
   low = up + 2;
}
sn = s[n];
s[n] = sjp1;
hi = infnrm_(0, s0 - 1, dumint, g);
i = dumint[0];
hj = infnrm_(sn + 1, m, dumint, g);
j = dumint[0];
if (j > m) j = m;
if (hi > hj) {
   if (hi > max) max = hi;
   temp1 = (g[i] == 0.) ? 0. : ((g[i] > 0.) ? 1. : -1.);
   temp2 = (g[s[0]] == 0.0) ? 0. : ((g[s[0]] > 0.) ? 1. : -1.);
   if (temp1 == temp2) {
      if (hi > Math.abs(g[s[0]])) {
	 s[0] = i;
	 if (g[j] / g[s[n]] > 1.) s[n] = j;
      }

   } else {
      if (hi > Math.abs(g[s[n]])) {
	 s[n] = (g[j] / g[s[nm1]] > 1.) ? j : s[nm1];
	 for (k = nm1; k >= 1; k--) s[k] = s[k - 1];
	 s[0] = i;
      }
   }

} else {
   if (hj > max) max = hj;
   temp1 = (g[j] == 0.) ? 0. : ((g[j] > 0.) ? 1. : -1.);
   temp2 = (g[s[n]] == 0.) ? 0. : ((g[s[n]] > 0.) ? 1. : -1.);
   if (temp1 == temp2) {
      if (hj > Math.abs(g[s[n]])) {
	 s[n] = j;
	 if (g[i] / g[s[0]] > 1.) s[0] = i;
      }

   } else {
      if (hj > Math.abs(g[s[0]])) {
	 s[0] = (g[i] / g[s[1]] > 1.) ? i : s[1];
	 for (k = 1; k <= nm1; k++) s[k] = s[k + 1];
	 s[n] = j;
      }
   }
}
em[1] = max;

return 0;
}

// -------------------------------------------------------------------

static int ini_(int n, int m, int s[]) {

int i, j, k, l;
double pin2, temp;

pin2 = Math.atan(1.) * 2. / n;
k = 1;
l = n - 1;
j = s[0] = 0;
s[n] = m;
while (k < l) {
   temp = Math.sin(k * pin2);
   i = (int) (temp * temp * (double) m);
   j = s[k] = ((i <= j) ? j + 1 : i);
   s[l] = m - j;
   l--;
   k++;
}
if (l * 2 == n) s[l] = m / 2;

return 0;
}

// --------------------------------------------------------------------

static int newton_(int n, double x[], double f[]) {

int k, i, im1;
double xim1, fim1;

im1 = 0;
for (i = 1; i <= n; i++) {
   fim1 = f[im1];
   xim1 = x[im1];
   for (k = i; k <= n; k++) f[k] = (f[k] - fim1) / (x[k] - xim1);
   im1 = i;
}

return 0;
}

// --------------------------------------------------------------------

static double infnrm_(int l, int u, int k[], double a[]) {

double r, max;

max = 0.;
k[0] = l;
for (; l <= u; l++) {
   r = Math.abs(a[l]);
   if (r > max) {
      max = r;
      k[0] = l;
   }
}

return (max);
}

// --------------------------------------------------------------------

static int elmvec_(int l, int u, int shift, double a[], double b[],
   double x) {

for (; l <= u; l++) a[l] += b[l + shift] * x;

return 0;
}

// --------------------------------------------------------------------

static int dupvec_(int l, int u, int shift, double a[], double b[]) {

for (; l <= u; l++) a[l] = b[l + shift];

return 0;
}

// --------------------------------------------------------------------

static double pol_(int n, double x, double a[]) {

double r;

r = 0.;
for (; n >= 0; n--) r = r * x + a[n];

return (r);
}

// --------------------------------------------------------------------

static int newgrn_(int n, double x[], double a[]) {

int k;

for (k = n - 1; k >= 0; k--) elmvec_(k, n - 1, 1, a, a, -x[k]);

return 0;
}

// ---------------------------------------------------------------------

static int nchsk_(int n, int k) {

/* Compute the number of ways of choosing k things from n things.
   If n > 50, use Stirling's formula as an approximation. */

double rn, rk, ri, nmer, denom, dif;
int i;

nmer = 1.;
denom = 1.;

if (n <= 50) {
   if (k >= n - k) {
      for (i = k + 1; i <= n; ++i) {
         ri = (double) i;
         nmer *= ri;
      }
      for (i = 2; i <= n - k; ++i) {
         ri = (double) i;
         denom *= ri;
      }

   } else {
      for (i = n - k + 1; i <= n; ++i) {
         ri = (double) i;
         nmer *= ri;
      }
      for (i = 2; i <= k; ++i) {
         ri = (double) i;
         denom *= ri;
      }
   }
   return ((int) (nmer / denom));

} else if (n > 50 && n < 200) {

   /* Stirling's formula approximation to nCk, see p. 58 of 210 Lecture
      notes. */

   rn = (double) n;
   rk = (double) k;
   dif = rn - rk;
   nmer = rn * Math.log(rn / dif) - rk * Math.log(rk / dif);
   nmer = Math.sqrt(rn) * Math.exp(nmer);
   nmer /= Math.sqrt(2. * Math.PI * rk * dif);
   return (int) nmer;

} else {
   iderr_("Minmax.nchsk: n > 200");
}

return 0;
}
}
