public class Modnn extends Id {

static final int MAXK = 10;
static final int MAXHID = 10;
static final int MAXP = 10;
static final int MAXN = 10;
static final int NMPAR = 10;

boolean omegflg[][][] = new boolean[MAXK][MAXHID][MAXP + 1];
boolean missdat[] = new boolean[MAXN];

int k, q, p, pin, nin, nmhid, nmnetp, nmf = 0;
int rspns[] = new int[MAXN];

double cmpn[] = new double[MAXK];
double optx[] = new double[NMPAR];
double errs[] = new double[MAXK];
double rawerrs[] = new double[MAXK];
double y[][] = new double[MAXK][MAXHID + 1];
double z[] = new double[MAXK];
double nu[][] = new double[MAXK][MAXHID + 1];
double omega[][][] = new double[MAXK][MAXHID][MAXP + 1];

// ------------------------------------------------------------------

public int modnet_(double x[], double znorm[]) {

/* Predicts a category (returned in "choice") at the input vector x.
   ***Note: This routine assumes that the input vector values are always
            between 0 and 1. *** */

int i, j, i1, choice = 0;

double sum, max, zsum;

// Add the dummy node to the input layer.

x[nmnetp] = 1.;

// Compute hidden layer output values.

for (i = 0; i < k; ++i) {
   for (j = 0; j < nmhid; ++j) {
      sum = 0.;
      for (i1 = 0; i1 <= nmnetp; ++i1) {
	 sum += x[i1] * omega[i][j][i1];
      }
      if (sum > 50.) {
	 sum = 50.;
      }

      // Compute the sigmoidal function value.

      y[i][j] = Math.exp(sum);
      y[i][j] = y[i][j] / (1. + y[i][j]);
   }
   y[i][nmhid] = 1.;
}

// Compute output layer values.

zsum = 0.;
for (i = 0; i < k; ++i) {
   sum = 0.;
   for (j = 0; j <= nmhid; ++j) {
      sum += y[i][j] * nu[i][j];
   }
   if (sum > 50.) {
      sum = 50.;
   }

   // Compute the sigmoidal function value.

   z[i] = Math.exp(sum);
   z[i] = z[i] / (1. + z[i]);
   zsum += z[i];
}

/* Regard the output node with the largest value as the choice, and
   normalize the outputs. */

max = 0.;
choice = 0;
for (i = 0; i < k; ++i) {
   if (z[i] > max) {
      max = z[i];
      choice = i + 1;
   }
   znorm[i] = z[i] / zsum;
}

return choice;
}

// --------------------------------------------------------------------

public boolean netfit_(boolean first, double prds[][], int rspns[], int n) {

// Estimates a modular neural network.

int i, j, nmpars, ier = 0, retval = 0, m;

if (first) {

   // Compute count per response category.

   for (i = 0; i < n; ++i) {
      cmpn[rspns[i] - 1] += 1.;
   }

   printf_("netfit: nmnetp= " + nmnetp + " nmhid= " + nmhid);
}

/* Upon the first call to netfit, perform m optimizations each time
   with a randomly chosen data point temporarily held out of the
   data set. */

if (first) {
   m = 2;

} else {
   m = 1;
}

for (i = 1; i <= m; ++i) {

   for (j = 0; j < n; ++j) {
      missdat[j] = false;
   }

   if (i < m) {

      // For i < m, Randomly set one observation to missing.

      printf_("netfit: Random start= " + i);
      j = (int) (((double) n) * Rndm.rndm1_(0, 0));
      missdat[j] = true;

   } else {
      printf_("netfit: nonrandom start");
   }

   // Define initial values of all link weights and load parameter vector.

   nmpars = xwghtx_(optx, 0, first);

   // Call BFGS optimzation routine.

   // retval = dfpmin_(prds, rspns, nmpars, optx, ier, 1, 1, n);
   // ier = Dfpmin.ier;

   if (retval == 1 || ier == 1) {
      printf_("netfit: dfpmin failed.");
   }
   if (first) {
      first = false;
   }
}

return first;
}

// --------------------------------------------------------------------

public int xwghtx_(double x[], int flag, boolean first) {

/* Transfers between the optimization algorithm's parameter vector and
   the neural network's link weights. */

int i, j, i1, i2, nmpars = 0;

double strtval, limit = 1.e5;

if (flag == 0) {

   // Initialization.

   nmpars = 0;
   for (i = 0; i < k; ++i) {
      for (j = 0; j < nmhid; ++j) {
	 for (i1 = 0; i1 <= nmnetp; ++i1) {

	    if (omegflg[i][j][i1]) {
	       if (first) {
	          strtval = .1 * Rndm.rndm1_(0, 0);
	          omega[i][j][i1] = strtval;
	       }
	       x[nmpars] = omega[i][j][i1];
	       ++nmpars;
	    }

	 }
      }
   }
   for (i = 0; i < k; ++i) {
      for (j = 0; j <= nmhid; ++j) {
	 if (first) {
	    strtval = Rndm.rndm1_(0, 0);
	    nu[i][j] = strtval;
	 }
         x[nmpars] = nu[i][j];
	 ++nmpars;
      }
   }

   printf_("xwghtx: nmnetp= " + nmnetp + " nmhid= " + nmhid +
      " nmpars= " + nmpars + " NMPAR= " + NMPAR);

} else if (flag == 1) {

   // Load link weights with the parameter vector values that are in "x."

   i2 = 0;
   for (i = 0; i < k; ++i) {
      for (j = 0; j < nmhid; ++j) {
	 for (i1 = 0; i1 <= nmnetp; ++i1) {
	    if (omegflg[i][j][i1]) {
               x[i2] = Math.max(x[i2], -limit);
               x[i2] = Math.min(x[i2], limit);

	       omega[i][j][i1] = x[i2];
	       ++i2;
	    }
	 }
      }
   }
   for (i = 0; i < k; ++i) {
      for (j = 0; j <= nmhid; ++j) {
         x[i2] = Math.max(x[i2], -limit);
         x[i2] = Math.min(x[i2], limit);

         nu[i][j] = x[i2];
         ++i2;
      }
   }
}

return nmpars;
}

// -------------------------------------------------------------------

public double func_(int option, double p[], double g[], int rspns[],
   double prds[][], int n, int ifirst, int fnm) {

/* Computes the objective function and gradients for fitting a modular
   neural network model.  Returns the evaluated function value.

   option = 0: do not calculate gradient, g.
   option = 1: calculate gradient in addition to function value, fp. */

boolean test = true;

int i, j, retval;

double step = 1.e-4, fp = 0.;

double errs[] = new double[MAXK];
double rawerrs[] = new double[MAXK];

/* Test function.
step = 1.e-5;
n = 2;
// Find objective function value.
*fp = -3803.84 - 138.08 * p[0] - 232.9 * p[1] + 123.08 * p[0] * p[0]
      + 203.64 * p[1] * p[1] + 182.25 * p[0] * p[1];
if (option == 1) {
   // Finite difference gradient approximation.
   for (i = 0; i < n; ++i) {
      psave = p[i];
      p[i] += step;
      g[i] = -3803.84 - 138.08 * p[0] - 232.9 * p[1] + 123.08 * p[0] * p[0]
             + 203.64 * p[1] * p[1] + 182.25 * p[0] * p[1];
      g[i] = (g[i] - *fp) / step;
      p[i] = psave;
   }
}
*/

if (fnm == 1) {

   // Load parameter values into appropriate locations.

   xwghtx_(p, 1, false);

   /* Find objective function value: the sum of the individual error
      rates. */

   neterr_(rspns, prds, errs, rawerrs, n);

   fp = 0.;
   for (i = 0; i < k; i++) {
      fp += errs[i];
   }

   // Update objective function evaluation counter.

   ++nmf;

   // Forward difference gradient approximation.

   if (option == 1) {
      for (i = 0; i < n; ++i) {
	 p[i] += step;
         xwghtx_(p, 1, false);

	 neterr_(rspns, prds, errs, rawerrs, n);

	 g[i] = 0.;
	 for (j = 0; j < k; ++j) {
	    g[i] += errs[j];
	 }
         ++nmf;

         // Compute gradient component.

         g[i] = (g[i] - fp) / step;

         // Restore parameter value.

	 p[i] -= step;
         xwghtx_(p, 1, false);
      }
   }
}

if (nmf > 5000) {
   iderr_("func: nmf= " + nmf + ", exiting.");
}

return fp;
}

// -----------------------------------------------------------------------

public int neterr_(int rspns[], double prds[][], double errs[],
   double rawerrs[], int n) {

// Computes the classification error rate vector.

int i, j, choice;

double err, dum;

double x[] = new double[MAXP + 1];
double znorm[] = new double[MAXK];

for (i = 0; i < k; ++i) {
   errs[i] = 0.;
   rawerrs[i] = 0.;
}

for (i = 0; i < n; ++i) {
   if (missdat[i]) {
      continue;
   }

   for (j = 0; j < nmnetp; ++j) {
      x[j] = prds[i][j];
   }

   choice = modnet_(x, znorm);

   // Compute raw error rate.

   if (choice != rspns[i]) {
      rawerrs[rspns[i] - 1] += 1.;
   }

   // Compute smooth error measure.

   err = 0.;
   for (j = 1; j <= k; ++j) {
      if (j == rspns[i]) {
	 dum = 1. - znorm[j - 1];

      } else {
	 dum = znorm[j - 1];
      }
      err += dum * dum;
   }
   errs[rspns[i] - 1] += err;
}
for (i = 0; i < k; ++i) {
   errs[i] /= cmpn[i];
   rawerrs[i] /= cmpn[i];
}

return 0;
}

}
