class Onlinelearn extends Beliefs {

static int nmprnts, nmobsnds;
static int obsnode[] = new int[5];
static int nmvalngh[] = new int[6];
static int iprntval[] = new int[6];
static int prnt[] = new int[6];

static double forgetparm = .5;
static double obsval[] = new double[5];
static double prntval[] = new double[6];

// -----------------------------------------------------------------

static void onlinelearn_() {

/* Performs online learning.  Updates the parameter values of the
   Bayesian network that results by conditioning the influence diagram
   at the inputs and the optimal decision. */

int i, k;

double maxutil;

// Set constants and find nodes.

idnmbrm1 = 0;
for (i = 1; i <= nmnds; ++i) {
   if (nodelbls[idnmbrm1][i - 1][0].equals("Time")) {
      Intridslve.timenode[idnmbrm1] = i;

   } else if (nodelbls[idnmbrm1][i - 1][0].equals("Input_Actor")) {
      Intridslve.inactrnode[idnmbrm1] = i;

   } else if (nodelbls[idnmbrm1][i - 1][0].equals("Input_Action")) {
      Intridslve.inactnnode[idnmbrm1] = i;

   } else if (nodelbls[idnmbrm1][i - 1][0].equals("Input_Subject")) {
      Intridslve.insubjnode[idnmbrm1] = i;

   } else if (nodelbls[idnmbrm1][i - 1][0].equals("Action")) {
      Intridslve.decnode[idnmbrm1] = i;

   } else if (nodelbls[idnmbrm1][i - 1][0].equals("Targets")) {
      Intridslve.trgtsnode[idnmbrm1] = i;
      Intridslve.nmtrgtlbls[idnmbrm1] = nodenghs[idnmbrm1][i - 1][0];
      for (k = 0; k < Intridslve.nmtrgtlbls[idnmbrm1]; ++k) {
         Intridslve.target_labels[idnmbrm1][k] =
            nodelbls[idnmbrm1][i - 1][k + 1];
      }

   } else if (nodelbls[idnmbrm1][i - 1][0].equals("Chosen_Target")) {
      Intridslve.ctrgtnode[idnmbrm1] = i;

   } else if (varinfo_dist[idnmbrm1][i - 1].equals("Determ_Loss") ||
      nodelbls[idnmbrm1][i - 1][0].equals("Utility") ||
      nodelbls[idnmbrm1][i - 1][0].equals("Overall_Goal_Attainment") ||
      nodelbls[idnmbrm1][i - 1][0].equals("Overall_Goal__Attainment")) {
      Intridslve.utlnode[idnmbrm1] = i;
   }
}
Intridslve.nmcondndes[idnmbrm1] = nmcondnds;

/* Compute the optimal decision and run the influence diagram at this
   optimum. */

maxutil = Idsolve.idsolve_(1);
fprintf_(1, "\nOptimal Decision= " +
   nodelbls[idnmbrm1][Intridslve.decnode[0] - 1]
           [Intridslve.optactn]);

if (hassituation) {
   fprintf_(1, "   Target= " +
      nodelbls[idnmbrm1][Intridslve.trgtsnode[0] - 1]
              [Intridslve.opttrgts]);
}

fprintf_(1, "Maximum Utility= " + fdble_(maxutil, 6, 3));

/* Read-in the observation.  This will eventually come from a file. */

nmobsnds = 1;
// obsnode[0] = 4;
// obsval[0] = 1.;

obsnode[0] = 9;
obsval[0] = 1.;

// Update each node's parameters in light of this multivariate observation.

for (i = 1; i <= nmnds; ++i) {
   votingEM_(i);
}
}

// -----------------------------------------------------------------

static void votingEM_(int nodenm) {

/* Update all parameters of the discrete chance node, "nodenm" using
   the Voting-EM algorithm. */

int i, j, k, j1, j2, j3, j4, j5, j6, nmvals;

double theta, newtheta;

// printf_("votingEM: dist= " + varinfo_dist[idnmbrm1][nodenm - 1]);
if (!varinfo_dist[idnmbrm1][nodenm - 1].equals("Discrete")) {
   return;
}

// Get number of values, and parent values.

nmvals = nodenghs[idnmbrm1][nodenm - 1][0];
for (i = 0; i < 6; ++i) {
   prnt[i] = nodenghs[idnmbrm1][nodenm - 1][i + 2];
   if (prnt[i] > 0) {
      nmvalngh[i] = nodenghs[idnmbrm1][prnt[i] - 1][0];

   } else {
      nmvalngh[i] = 1;
   }
}
printf_("votingEM: node= " + nodelbls[idnmbrm1][nodenm - 1][0]);

// Loop over all parent patterns.

for (j1 = 1; j1 <= nmvalngh[0]; ++j1) {
   for (j2 = 1; j2 <= nmvalngh[1]; ++j2) {
      for (j3 = 1 ; j3 <= nmvalngh[2]; ++j3) {
         for (j4 = 1; j4 <= nmvalngh[3]; ++j4) {
            for (j5 = 1; j5 <= nmvalngh[4]; ++j5) {
               for (j6 = 1; j6 <= nmvalngh[5]; ++j6) {
                  iprntval[0] = j1;
                  iprntval[1] = j2;
                  iprntval[2] = j3;
                  iprntval[3] = j4;
                  iprntval[4] = j5;
                  iprntval[5] = j6;

                  /* Update parameters for this parent pattern. */

                  for (j = 0; j < nmvals - 1; ++j) {
                     theta = Readnet.condprb[idnmbrm1][nodenm - 1][j]
	                           [iprntval[0] - 1][iprntval[1] - 1]
	                           [iprntval[2] - 1][iprntval[3] - 1]
	                           [iprntval[4] - 1][iprntval[5] - 1][1];
	             newtheta = updtparm_(nodenm, (j + 1), theta);
		     if (newtheta > 0.) {
                        Readnet.condprb[idnmbrm1][nodenm - 1][j]
	                      [iprntval[0] - 1][iprntval[1] - 1]
	                      [iprntval[2] - 1][iprntval[3] - 1]
	                      [iprntval[4] - 1][iprntval[5] - 1][1] =
                           newtheta;
		        printf_("votingEM: theta= " + fdble_(theta, 5, 3) +
                           " newtheta= " + fdble_(newtheta, 5, 3));
		     }
		  }
               }
            }
         }
      }
   }
}
}

// -----------------------------------------------------------------

static double updtparm_(int xnode, int xval, double theta) {

/* Updates a parameter of a discrete node having exclusively discrete
   parents. */

int i, j, k;

double condpxz, condpz, nmconddvts, thetaupdt = 0.;

/* First, compute approximations to P(Xi=k,Zi=zij|xobs), and P(Zi=zij|xobs)
   where X = "xnode," and k = "xval." */

nmconddvts = 0.;
condpz = 0.;
condpxz = 0.;
DVTLOOP: for (i = 0; i < idenom[0]; ++i) {

   /* First, check for conditioning joint event. */

   // printf_("updtparm: simdata= " + simdata[0][i][obsnode[1] - 1][0]);

   for (k = 0; k < nmobsnds; ++k) {
      if (Math.abs(simdata[0][i][obsnode[k] - 1][0] - obsval[k]) > 1.e-6) {
         continue DVTLOOP;
      }
   }
   nmconddvts += 1.;

   /* Check for the occurrence of the jth pattern of parent values. */

   for (k = 0; k < nmprnts; ++k) {
      if (Math.abs(simdata[0][i][prnt[k] - 1][0] - prntval[k]) > 1.e-6) {
         continue DVTLOOP;
      }
   }
   condpz += 1.;

   /* Check for the kth value of X. */

   if (Math.abs(simdata[0][i][xnode - 1][0] - xval) < 1.e-6) {
      condpxz += 1.;
   }
}

if (nmconddvts > 0.) {
   condpz /= nmconddvts;
   condpxz /= nmconddvts;
}
// iderr_("in updtparm");

/* Update parameter based on xobs. */

if (condpz > 0.) {
   thetaupdt = theta + forgetparm * ((condpxz / condpz) - theta);
}

if (condpz < 1.e-6 || nmconddvts < 2) {
   printf_("updtparm: condpz= " + condpz + " nmconddvts= " + nmconddvts);
   thetaupdt = -1.;
}

return thetaupdt;
}
}
