class Optf extends Surf {
static boolean start = true;

static int nmtstp, nmsstp, scheck, tcheck;

static int vrble[] = new int[DATSZE];

static double sintrvl, tintrvl, sstp, tstp, maxchisq = 1.,
   maxcnstrnt2 = 1.;

static double fftslag[] = new double[NMSSTP];
static double ffttlag[] = new double[NMTSTP];
static double tstmat[][] = new double[NUMVAR][NUMVAR];
static double cmplxf[][] = new double[NUMVAR][NUMVAR];
static double dummat[][] = new double[NUMVAR][NUMVAR];
static double p[] = new double[2];
static double covdat[][] = new double[NMSSTP][NMTSTP];
static double f[][][][] = new double[NUMMDLS + 1][NMSSTP + 1][NMTSTP + 1][2];
static double nugsve[] = new double[NUMMDLS];
static double orgval[][] = new double[NUMMDLS][NUMCNTR + 1];
static double xpos[] = new double[DATSZE];
static double ypos[] = new double[DATSZE];
static double tpos[] = new double[DATSZE];

// ----------------------------------------------------------------------

static double optf_(boolean cflag, int n, double a[], double g[],
   double h[]) {

/* Evaluates the covariogram matrix parameter estimation objective
   function under n degrees of freedom at the point a.  -1.e30 is the
   missing value indicator.  Validity constraints are computed if present. */

int i, i1, ii, j, j1, k, ncttl, tlags, mrank = 0, cvstrct;

double chisq, dif, smplval, mdlval, x, y, t, penaltyval = 0.;

if (parm_mvar == 1) {

   // Load varmod structure.

   Loadpar.loadpar_(3, 0, a, g, h);

} else if (parm_mvar > 1) {
   if (nmstmixcntr == 0) {

      /* For a LOMAP multivariate model, compute covariogram matrix
         constraints on the nuggets and continuous components of the
         covariogram matrix, respectively.  First, load varmod structure.
      */

      Loadpar.loadpar_(3, 0, a, g, h);

      Optimiz.cnstrnt[0] = nuggcnstrnt_();
      penaltyval = speccnstrnt_();

   } else {

      /* For a GLOMAP model, first load parameters from optimization
         vector.  Then, check each component's covariogram. */

      for (i = 1; i <= nmstmixcntr; ++i) {
         Loadpar.loadpar_(3, i, a, g, h);
      }
   
      for (i = 0; i < nmstmixcntr; ++i) {

         // Load this component's covariogram parameters.

         for (j = 0; j < nmmdls; ++j) {
            varmod_nugget[0][j] = varmod_nugget[i + 1][j];
            varmod_sill[0][j] = varmod_sill[i + 1][j];
            varmod_range[0][0][j] = varmod_range[i + 1][0][j];
            varmod_range[0][1][j] = varmod_range[i + 1][1][j];

            if (varmod_model[j] == 3) {
               varmod_oddnug[0][j] = varmod_oddnug[i + 1][j];
               varmod_oddsill[0][j] = varmod_oddsill[i + 1][j];
               varmod_oddrnge[0][j] = varmod_oddrnge[i + 1][j];
            }
         }
         Optimiz.cnstrnt[0] = nuggcnstrnt_();
         penaltyval = speccnstrnt_();
         if (Optimiz.cnstrnt[0] < 0. || penaltyval < 0.) {
	    break;
	 }
      }
   }
}

// Return if only constraints are being computed.

if (cflag) {
   return 0.;
}

/* Sample covariogram sum of squares objective function calculation.
   For the stationary model, calculate the sum of squared deviations. */

chisqd = 0.;
chisqc = 0.;
chisq = 0.;
ncttl = 0;
for (j = 0; j < nmmdls; ++j) {
   if (j < parm_mvar) {
      tlags = kmaxt;
      ii = 0;

   } else {
      tlags = 2 * kmaxt;
      ii = 1;
   }
   for (i = 0; i <= kmax; ++i) {
      for (k = 0; k <= tlags; ++k) {

	 /* Get the sample semivariogram value or, for cross-covariance,
	    the sample cross-covariance. */

	 smplval = gama_g[i][0][k][j];

	 /* If not missing, compute the model semivariogram value for each
	    variable (j < parm_mvar) and the model cross-covariogram
	    (j >= parm_mvar). */

         if (smplval > -1.e30) {
	    if (j < parm_mvar) {
	       mdlval = Covmodl.gmodel_(lags[i], lagt[ii][k], j + 1);

	    } else {
               mdlval = Covmodl.sttnrycov_(lags[i], lagt[ii][k], j + 1);
            }

	    /* Use the model value to compute each component of the
	       objective function.  Use the function studied by
	       Zhang et al. (1995, Computers and Geosciences) modified
	       for the spatio-temporal case. First, find the difference
	       between the sample variogram (or cross-covariogram) and
	       the model variogram (or model cross-covariogram).
	       ***Note: the wght array has been computed in vargrm. */

	    dif = smplval - mdlval;
	    dif = wght[j][i][k] * dif * dif;
            // dif = dif * dif;

            if (j < parm_mvar) {
	       chisqd += dif;
            
	    } else {
	       chisqc += dif;
            }

            chisq += dif;

            if (chisq == 0. || chisq > 1.e30) {
	       printf_("j= " + j + " chisq= " + chisq + " nd= " + nd +
	          " smplval= " + smplval + " mdlval= " + mdlval);
	       printf_("lags(" + i + ")= " + lags[i] + " lagt(" + k +
		  ")= " + lagt[ii][k]);
	       printf_("nug= " + varmod_nugget[0][0] + " sill= " +
		  varmod_sill[0][0] + " srnge= " +
		     varmod_range[0][0][0] + " trnge= " +
		     varmod_range[0][1][0]);
	       Covmodl.covprt_(0);
	       Covmodl.covprt_(1);
	       iderr_("optf: problem, terminating.");
            }
         }
      }
   }
}
chisq /= (double) ((kmax + 1) * (kmaxt + 1));

if (maxchisq < chisq) {
   maxchisq = chisq;
}

/* The continuous covariogram constraint is represented as a penalty
   function. */

if (maxcnstrnt2 < Math.abs(penaltyval)) {
   maxcnstrnt2 = Math.abs(penaltyval);
}

if (penaltyval >= 0.) {
   chisq /= maxchisq;

} else {
   chisq = chisq / maxchisq - 1.e3 * penaltyval / maxcnstrnt2;
}

return chisq;
}

// ---------------------------------------------------------------------

static double nuggcnstrnt_() {

/* For the symmetric cross-covariogram models, forms the matrix of nuggets
   and cross-nuggets and tests for positive semidefiniteness. */

int i, j, cvstrct, indx = 0;

if (varmod_model[nmmdls - 1] == 3) {
   return 0.;
}

indx = 0;
if (spatial && !temporal) indx = 0;
else if (!spatial && temporal) indx = 1;

for (i = 0; i < parm_mvar; ++i) {
   for (j = 0; j <= i; ++j) {
      if (i == j) {
         tstmat[i][j] = varmod_nugget[0][i];

      } else {
         cvstrct = crossmap[i][j];
         tstmat[i][j] = varmod_nugget[0][cvstrct - 1];
         tstmat[j][i] = tstmat[i][j];
      }
   }
}

return Choles.choles_(tstmat, dummat, 1, parm_mvar, false);
}

// ---------------------------------------------------------------------

static double speccnstrnt_() {

/* Compute the constraint on the covariogram matrix function that the
   spectral density function matrix be positive semidefinite at all
   frequencies.  Do this by computing the spectral density function
   matrix at each combination of spatial and temporal frequencies and
   then testing for the positive semidefiniteness of this matrix.
   Return a negative constraint value at the first failure of this test. */

int i, j, i1, j1, ipos, jpos, k, ival, cvstrct;

double val, ri, rj, realf, difx, dify, dist, dift, cnstrnt = 0.;

// Check of spectral density function matrix.

if (start) {

   /* Initialize spatio-temporal lag and frequency grids.  Note that
      initially, nmsstp and nmtstp are given as log_2 values.  Set
      constants: these are the powers of 2 that define the number of grid
      lines in the spatial and temporal dimensions of the spatio-temporal
      LAG region over which the spatio-temporal covariogram and
      cross-covariogram values will be computed as input to the FFT.

      Note 1: change NMSSTP and NMTSTP in Id.java to > 2^nmsstp and
              > 2^nmtstp, respectively.

      Note 2: Large values of nmsstp and/or nmtstp can result in spurious
              high frequencies.  The best approach is to set these values
              to small values, say 3 or 4 and then let any failures to
              detect a non-semidefinite spectral density matrix be caught
              during the attempt to form the Cholesky decomposition in
              routine mdobjf_().  In particular, if mdobjf_() NEVER detects
              a non-semidefinite spectral density matrix, speccnstrnt_()
              is probably being too conservative and not allowing enough
              cross-covariance to be modeled.

      Note 3: Another way to set nmsstp and nmtstp is to simulate a large
              number of randomly located observations and then set
              these parameters so that speccnstrnt sees a valid
              covariogram only when the Cholesky decomposition is
              successful.  See Mchtsts.simdat_() for simulating
              multivariate spatio-temporal fields. */

   if (spatial && !temporal) {
      nmsstp = 5; // was 5, much bigger than 7 results in spurious freqs.
      nmtstp = 0;

   } else if (!spatial && temporal) {
      nmsstp = 0;
      if (!lngmem) nmtstp = 4; // was 9
      else nmtstp = 8;

   } else if (spatial && temporal) {
      nmsstp = 4;
      nmtstp = 4;
   }
   ival = 1;
   for (i = 1; i <= nmsstp; ++i) ival *= 2;
   nmsstp = ival;
   if (nmsstp > NMSSTP) iderr_("speccnstrnt: nmsstp big");

   if (nmsstp == 1) scheck = 1;
   else scheck = nmsstp / 2;

   ival = 1;
   for (i = 1; i <= nmtstp; ++i) ival *= 2;
   nmtstp = ival;
   if (nmtstp > NMTSTP) iderr_("nmtstp big in speccnstrnt_()");

   if (nmtstp == 1) tcheck = 1;
   else tcheck = nmtstp / 2;

   start = false;
}

/* The spatio-temporal lag region is
   (-sintrvl, sintrvl) by (-tintrvl, tintrvl) The reason why
   this region is centered at 0,0 is as follows: The FFT always assumes
   an interval of (0,T) (one-dimension) or (0,T_1),(0,T_2)
   (two-dimension).  Therefore, to obtain an approximation of the
   Fourier Transform of an even covariogram, one must give the FFT
   values of the function over (-T_1,T_1) or (-T_2,T_2) and then
   time-shift back.  This back-shifting will produce the necessary
   cancellations so that the imaginary frequency components go to zero.
   Further, when a temporal process is modeled, the cross-covariogram
   must be transformed over the interval (-T_2,T_2) because this
   function, due to phase-shift, may not be even nor odd.  This means
   that the temporal covariograms must also be sampled over (-T_2,T_2)
   so that the same intervals are compared when testing for positive
   semi-definiteness of the spectral density function matrix. */

if (nmsstp > 1) {
   sintrvl = varmod_range[0][0][0];
   for (i = 1; i < parm_mvar; ++i) {
      if (sintrvl < varmod_range[0][0][i]) {
         sintrvl = varmod_range[0][0][i];
      }
   }
   sintrvl *= 2.;
   sstp = 2. * sintrvl / ((double) (nmsstp - 1));
   fftslag[0] = -sintrvl;
   for (i = 1; i < nmsstp; ++i) fftslag[i] = fftslag[i - 1] + sstp;

} else {
   fftslag[0] = 0.;
   sintrvl = 1.;
   sstp = 1.;
}

if (nmtstp > 1) {

   // was 2. * lagt

   if (varmod_model[parm_mvar] < 3) tintrvl = 1.1 * lagt[0][kmaxt];
   else tintrvl = 3. * lagt[0][kmaxt];
   tintrvl = 4. * (spacetime_tmax - spacetime_tmin);

   if (lngmem) tintrvl = 2.0 * lagt[0][kmaxt];

   tstp = tintrvl / (double) tcheck;
   ffttlag[0] = -tintrvl;
   for (i = 1; i < nmtstp; ++i) ffttlag[i] = ffttlag[i - 1] + tstp;

} else {
   ffttlag[0] = 0.;
   tintrvl = 1.;
   tstp = 1.;
}

/* Form nonnegative spatio-temporal frequency grid (in radians).
x[0] = 0.;
for (i = 1; i < scheck; ++i) {
x[i] = PIT2 * ((double) i) / (((double) nmsstp) * sstp);
}
y[0] = 0.;
for (i = 1; i < tcheck; ++i) {
   y[i] = PIT2 * ((double) i) / (((double) nmtstp) * tstp);
}
*/

/* Under a continuous-at-zero-lag cross-covariogram, compute the values of
   the parm_mvar zero-nugget covariograms plus the zero-nugget
   cross-covariogram over the spatio-temporal lag region.  The temporary
   zeroing of the nugget value is necessary to ensure that the FFT is
   computed of a continuous-at-lag-zero direct- or cross-covariogram only. */

for (i = 0; i < parm_mvar; ++i) {
   nugsve[i] = varmod_nugget[0][i];
   varmod_nugget[0][i] = 0.;

   for (j = 0; j < i; ++j) {
      cvstrct = crossmap[i][j];

      if (varmod_model[cvstrct - 1] != 3) {

         // Don't set the asymmetric model nugget to zero.

         nugsve[cvstrct - 1] = varmod_nugget[0][cvstrct - 1];
         varmod_nugget[0][cvstrct - 1] = 0.;
      }
   }
}

for (k = 1; k <= nmmdls; ++k) {
   for (i = 1; i <= nmsstp; ++i) {
      for (j = 1; j <= nmtstp; ++j) {
         if (fftslag[i - 1] < varmod_epsln) fftslag[i - 1] = varmod_epsln;
         covdat[i - 1][j - 1] = Covmodl.sttnrycov_(fftslag[i - 1],
            ffttlag[j - 1], k);
      }
   }

   /* Compute the spectral density function over a rectangular grid of
      spatio-temporal frequency points via the FFT.  For a temporal model,
      the cross-covariogram spectral density function may be asymmetric. */

   Fft.fft_(k - 1, nmsstp, nmtstp, sintrvl, tintrvl, covdat, f);
}

for (i = 0; i < parm_mvar; ++i) {
   varmod_nugget[0][i] = nugsve[i];
   for (j = 0; j < i; ++j) {
      cvstrct = crossmap[i][j];
      if (varmod_model[cvstrct - 1] != 3) {
         varmod_nugget[0][cvstrct - 1] = nugsve[cvstrct - 1];
      }
   }
}

/* Check each spatio-temporal frequency combination for positive
   semi-definiteness of the spectral density function matrix.  Do this
   by forming the spectral density function matrix at this spatio-temporal
   frequency and testing for its positive semi-definiteness by attempting
   to compute the Cholesky decomposition. */

sloop: for (i = 0; i < scheck; ++i) {
   for (j = 0; j < tcheck; ++j) {

      /* Compute FFT-based approximation of the spectral density function
         matrix at this combination of spatial and temporal frequencies. */

      for (i1 = 0; i1 < parm_mvar; ++i1) {
         for (j1 = 0; j1 <= i1; ++j1) {
            if (i1 == j1) {
               if (f[i1][i][j][0] < 0.) {
                  /*
                  iderr_("speccnstrnt: i1= " + i1 + " j= " + j +
                     " f= " + f[i1][i][j][0]);
                  */
                  f[i1][i][j][0] = 0.;
               }

               tstmat[i1][j1] = f[i1][i][j][0];
               cmplxf[i1][j1] = 0.;

            } else {
               cvstrct = crossmap[i1][j1];

               if (f[cvstrct - 1][i][j][0] < 0.) {
                  /*
                  iderr_("speccnstrnt: i1= " + i1 +
                     " j1= " + j1 + " j= " + j + " f= " + f[i1][i][j][0]);
                  */
                  f[cvstrct - 1][i][j][0] = -f[cvstrct - 1][i][j][0];
               }
               realf = f[cvstrct - 1][i][j][0];
               cmplxf[i1][j1] = f[cvstrct - 1][i][j][1];

               tstmat[i1][j1] = Math.sqrt(
                  realf * realf + cmplxf[i1][j1] * cmplxf[i1][j1]);
               tstmat[j1][i1] = tstmat[i1][j1];
               cmplxf[j1][i1] = cmplxf[i1][j1];
            }
         }
      }
      cnstrnt = Choles.choles_(tstmat, dummat, 1, parm_mvar, false);
      if (cnstrnt < 0.) {
         break sloop;
      }
   }
}
return cnstrnt;
}

// ----------------------------------------------------------------------

static double chkcovdat_(boolean validity, boolean fix, String routne) {

/* Verify the validity of the covariance matrix at the cylinder's set
   of observed variables and locations. */

int i, j, k, l, cvstrct = 0, cntr, cntrstrt;

double cnstrnt = 0.;

// Initialize GLOMAP component counter.

if (nmstmixcntr == 0) cntrstrt = 0;
else cntrstrt = 1;

// Loop at most three times until covariance matrix is valid.

for (k = 0; k < 4; ++k) {

   // Compute exact constraint value.

   cnstrnt = exactc_();
   if (cnstrnt >= 0.) return cnstrnt;

   /* If validity is being required, stop the code unless the matrix is
      valid. */

   if (validity && cnstrnt < 0.) {
      printf_("chkcovdat: invalid model, cnstrnt= " + cnstrnt);
      return cnstrnt;
   }

   /* Return if (a) no fix-ups are desired, i.e., this call to chkcovdat
      is for using the Cholesky check during covariogram matrix fitting,
      or (b) the covariance matrix is valid. */

   if (!fix || cnstrnt >= 0.) break;

   /* Adjust covariogram matrix parameters depending on loop counter
      and cross-covariogram model type. */

   if (k == 0 && varmod_model[nmmdls - 1] == 0) continue;

   if (k == 0) {
      for (i = 1; i < parm_mvar; ++i) {
         for (j = 0; j < i; ++j) {
            cvstrct = crossmap[i][j];
	    for (cntr = cntrstrt; cntr <= nmstmixcntr; ++cntr) {
               orgval[cvstrct - 1][cntr] =
                  varmod_sill[cntr][cvstrct - 1];
	    }
         }
      }
      for (l = 0; l < 11; ++l) {
         for (i = 1; i < parm_mvar; ++i) {
            for (j = 0; j < i; ++j) {
               cvstrct = crossmap[i][j];
	       for (cntr = cntrstrt; cntr <= nmstmixcntr; ++cntr) {
                  varmod_sill[cntr][cvstrct - 1] -=
                     orgval[cvstrct - 1][cntr] / 10.;
		  varmod_sill[cntr][cvstrct - 1] =
		     Math.max(varmod_sill[cntr][cvstrct - 1], 0.);
	       }
            }
         }
         cnstrnt = exactc_();
         if (cnstrnt >= 0.) return cnstrnt;
      }

   } else if (k == 1 && varmod_model[nmmdls - 1] != 3) {
      for (i = 1; i < parm_mvar; ++i) {
         for (j = 0; j < i; ++j) {
            cvstrct = crossmap[i][j];
	    for (cntr = cntrstrt; cntr <= nmstmixcntr; ++cntr) {
               fprintf_(1, "chkcovdat: fitted cross-nugget= " +
                  varmod_nugget[cntr][cvstrct - 1]);
               fprintf_(1, "chkcovdat: setting cross-nuggets to 0");
               varmod_nugget[cntr][cvstrct - 1] = 0.;
	    }
         }
      }

   } else if (k == 2 && varmod_model[nmmdls - 1] != 3) {
      fprintf_(1, "chkcovdat: setting direct nuggets to sample variances," +
         " direct sills to 0.");
      for (i = 0; i < parm_mvar; ++i) {
         fprintf_(1, "chkcovdat: Variable " + lomapnms[i] + " smplvr= " +
            varmod_smplvr[i]);
         for (cntr = cntrstrt; cntr <= nmstmixcntr; ++cntr) {
            varmod_nugget[cntr][i] = varmod_smplvr[i];
            varmod_sill[cntr][i] = 0.;
	 }
      }
 
   } else {
      iderr_("chkcovdat: cannot fix covariance matrix in routine " +
         routne);
   }
}
return cnstrnt;
}

// -------------------------------------------------------------------

static double exactc_() {

/* Load covariance function parameters, build covariance matrix, and
   then find its Cholesky decomposition.  First, zero cholesky matrix. */

int i, j, cvstrct, stnmi, stnmj;

for (i = 0; i < nd; ++i) {
   for (j = 0; j < nd; ++j) {
      form_a[i][j] = 0.;
      s[i][j] = 0.;
   }
}

// Form correlated error covariance matrix in form_a.

for (i = 0; i < nd; ++i) {
   for (j = 0; j <= i; ++j) {

      // Find covariance structure to be used.

      stnmi = idtostnm[vardat_vrble[i] - 1];
      stnmj = idtostnm[vardat_vrble[j] - 1];
      if (vardat_vrble[i] == vardat_vrble[j]) {
         cvstrct = stnmi;

      } else {
         cvstrct = crossmap[stnmi - 1][stnmj - 1];
      }

      /* Compute (possibly) nonstationary covariance and fill in
         upper half. */

      form_a[i][j] = Covmodl.covmodl_(i, j, vardat_x[i],
         vardat_y[i], vardat_t[i], vardat_x[j], vardat_y[j],
         vardat_t[j], cvstrct);

      if (i != j) {
         form_a[j][i] = form_a[i][j];
      }
   }

   // Check for exact singularity.

   if (i > 0) {
      exactsg_(form_a, i, "chkcovdat");
   }
}

// Attempt to form lower triangular matrix from form_a.

return Choles.choles_(form_a, s, 1, nd, false);
}
}
