public class Parlearn extends Beliefs {

static boolean learnnode[][] = new boolean[TNMIDS][TNMNDS];

static double oldbidprice = 0., oldwage = 0., l = 0., r = .6;

// ---------------------------------------------------------------

static void parlearn_() {

int i, j, k, sfamk, spcgk, dstm1 = 0;

double wage = 0., bidprice = 0., p1 = 0., p2 = 0., p3 = 0., a = 0., b = 0.;

// Specify distribution to be used.

if (!loadconsdst) {
   dstm1 = 0;

} else {
   dstm1 = 1;
}

if (thisidname.equals("poachers")) {

   /* An effect on poacher recruitment is the possiblity of
      legal employment opportunities.  The effect of legal employment
      wages relative to the bid price for a rhino horn on the
      attractiveness of seeking a legal job versus continuing to poach
      rhinos is modeled with the learning parameter, "l"
      (employment attractiveness). */

   for (i = 0; i < nmcondnds; ++i) {
      if (grph_label[idnmbrm1]
                    [condnodes[idnmbrm1][i] - 1].equals("INBPRICE")) {
         bidprice = condvals[i];

      } else if (grph_label[idnmbrm1]
                    [condnodes[idnmbrm1][i] - 1].equals("WAGE")) {
         wage = condvals[i];
      }
   }      

   if (bidprice + wage > 1.e-6) {
      l = wage / (bidprice + wage);

   } else {
      l = 0.;
   }
   if (l > .999) {
      l = .999;
   }

   /* To represent a pure-profit management strategy for running the
      manufacturing network, force the poacher's learning parameter
      to zero, i.e., l = 0.0. */
   
   /* Do not learn if this is the beginning of a temporal run, the sum
      of "bidprice" and "wage" is close to zero, or if there has been no
      change in these values since the last learning activity. */

   if (Intridslve.tindex <= 1 || (bidprice + wage < 1.e-6)) {
      return;
   }
   if (true) {
      return;
   }
 
   if (Math.abs(bidprice - oldbidprice) < 1.e-6 &&
       Math.abs(wage - oldwage) < 1.e-6) {
      return;
   }

   /*
   printf_("learn: t= " + fdble_(Intridslve.t, 8, 2) + " bprice= " +
      fdble_(bidprice, 8, 3) + " wage= " + fdble_(wage, 8, 3) +
      " newl= " + fdble_(l, 10, 7));
   */

   sfamk = Getmodlutils.getndnm_("SFAM");
   spcgk = Getmodlutils.getndnm_("SPCG");

   /* Learn the effect of this change in wages and/or bid price on the
      "take legal employment" action's effect on the Scenario Family
      node.  The parents of this node are Situation Family (FAM), and
      Action (ACTN). */

   for (i = 0; i < 3; ++i) {

      // Increase the attractiveness of legal employment.

      p1 = condprb[idnmbrm1][sfamk - 1][0][i][1][0][0][0][0][dstm1];
      p2 = condprb[idnmbrm1][sfamk - 1][1][i][1][0][0][0][0][dstm1];
      p3 = condprb[idnmbrm1][sfamk - 1][2][i][1][0][0][0][0][dstm1];

      /*
      printf_("parlearn: before1 p1-p3: " + fdble_(p1, 5, 2) + " " +
         fdble_(p2, 5, 2) + " " + fdble_(p3, 5, 2));
      */

      p1 = r * p1 + (1. - r) * p1 * (1. - l);
      p2 = r * p2 + (1. - r) * p2 * (1. - l);
      p3 = 1. - (p1 + p2);

      /*
      printf_("parlearn: after1 p1-p3: " + fdble_(p1, 5, 2) + " " +
         fdble_(p2, 5, 2) + " " + fdble_(p3, 5, 2));
      */

      condprb[idnmbrm1][sfamk - 1][0][i][1][0][0][0][0][dstm1] = p1;
      condprb[idnmbrm1][sfamk - 1][1][i][1][0][0][0][0][dstm1] = p2;
      condprb[idnmbrm1][sfamk - 1][2][i][1][0][0][0][0][dstm1] = p3;

      // Decrease the attractiveness of poaching.

      for (k = 2; k < 5; ++k) {
         p1 = condprb[idnmbrm1][sfamk - 1][0][i][k][0][0][0][0][dstm1];
         p2 = condprb[idnmbrm1][sfamk - 1][1][i][k][0][0][0][0][dstm1];
         p3 = condprb[idnmbrm1][sfamk - 1][2][i][k][0][0][0][0][dstm1];

         /*
         printf_("parlearn: before2 p1-p3: " + fdble_(p1, 5, 2) + " " +
            fdble_(p2, 5, 2) + " " + fdble_(p3, 5, 2));
         */

         p3 = r * p3 + (1. - r) * p3 * (1. - l);
         p2 = r * p2 + (1. - r) * p2 * (1. - l);
         p1 = 1. - (p3 + p2);

         /*
         printf_("parlearn: after2 p1-p3: " + fdble_(p1, 5, 2) + " " +
            fdble_(p2, 5, 2) + " " + fdble_(p3, 5, 2));
         */

         condprb[idnmbrm1][sfamk - 1][0][i][k][0][0][0][0][dstm1] = p1;
         condprb[idnmbrm1][sfamk - 1][1][i][k][0][0][0][0][dstm1] = p2;
         condprb[idnmbrm1][sfamk - 1][2][i][k][0][0][0][0][dstm1] = p3;
      }
   }

   /* Learn the effect on the Scenario Pursue Career Goal node.  The parents
      of this node are Scenario Family (SFAM), Situation Pursue Career Goal
      (PCG), and Action (ACTN). */

   for (i = 0; i < 3; ++i) {
      for (j = 0; j < 3; ++j) {
      
         // Increase the attractiveness of legal employment.

         p1 = condprb[idnmbrm1][spcgk - 1][0][i][j][1][0][0][0][dstm1];
         p2 = condprb[idnmbrm1][spcgk - 1][1][i][j][1][0][0][0][dstm1];
         p3 = condprb[idnmbrm1][spcgk - 1][2][i][j][1][0][0][0][dstm1];

         /*
         printf_("parlearn: before3 p1-p3: " + fdble_(p1, 5, 2) + " " +
            fdble_(p2, 5, 2) + " " + fdble_(p3, 5, 2));
         */
 
         p1 = r * p1 + (1. - r) * (p1 * (1. - l));
         p2 = r * p2 + (1. - r) * (p2 * (1. - l));
         p3 = 1. - (p1 + p2);

         /*
         printf_("parlearn: after3 p1-p3: " + fdble_(p1, 5, 2) + " " +
            fdble_(p2, 5, 2) + " " + fdble_(p3, 5, 2));
         */

         condprb[idnmbrm1][spcgk - 1][0][i][j][1][0][0][0][dstm1] = p1;
         condprb[idnmbrm1][spcgk - 1][1][i][j][1][0][0][0][dstm1] = p2;
         condprb[idnmbrm1][spcgk - 1][2][i][j][1][0][0][0][dstm1] = p3;

         // Decrease the attractiveness of poaching.

         for (k = 2; k < 5; ++k) {
            p1 = condprb[idnmbrm1][spcgk - 1][0][i][j][k][0][0][0][dstm1];
            p2 = condprb[idnmbrm1][spcgk - 1][1][i][j][k][0][0][0][dstm1];
            p3 = condprb[idnmbrm1][spcgk - 1][2][i][j][k][0][0][0][dstm1];
         
            /*
            printf_("parlearn: before4 p1-p3: " + fdble_(p1, 5, 2) + " " +
               fdble_(p2, 5, 2) + " " + fdble_(p3, 5, 2));
            */

            p3 = r * p3 + (1. - r) * p3 * (1. - l);
            p2 = r * p2 + (1. - r) * p2 * (1. - l);
            p1 = 1. - (p3 + p2);

            /*
            printf_("parlearn: after4 p1-p3: " + fdble_(p1, 5, 2) + " " +
               fdble_(p2, 5, 2) + " " + fdble_(p3, 5, 2));
            */

            condprb[idnmbrm1][spcgk - 1][0][i][j][k][0][0][0][dstm1] = p1;
            condprb[idnmbrm1][spcgk - 1][1][i][j][k][0][0][0][dstm1] = p2;
            condprb[idnmbrm1][spcgk - 1][2][i][j][k][0][0][0][dstm1] = p3;
         }
      }
   }

   // Store these (now) old values of bid price and wage.

   oldbidprice = bidprice;
   oldwage = wage;
}
}

// ------------------------------------------------------------------

static void initialize_() {

// Loads the consistent distribution with the hypothesis distribution.

int i, sfamk, spcgk;

sfamk = Getmodlutils.getndnm_("SFAM");
spcgk = Getmodlutils.getndnm_("SPCG");
for (i = 0; i < nmnds; ++i) {
   learnnode[idnmbrm1][sfamk - 1] = false;
}
learnnode[idnmbrm1][sfamk - 1] = true;
learnnode[idnmbrm1][spcgk - 1] = true;

Pxp.pxp_(-1, Optimiz.x, Optimiz.g, Optimiz.h, 0, 0, 0, false);
}
}
