public class Players extends SNA {

static boolean findremovaleffects = true;

static boolean removednode[] = new boolean[TNMNDS];

static final int loopmax = 1000;

static int m, r, nmnodesmm;

static int x[] = new int[TNMNDS];
static int xtrial[] = new int[TNMNDS];
static int inplayer[] = new int[TNMNDS];
static int removedplayer[] = new int[TNMNDS];
static int swapinplayer[] = new int[10];
static int swapoutplayer[] = new int[10];
static int levelsize[] = new int[4];

static double nopoachprob = 0., t_remove = 0., tdelay2 = 0.,
   tdelay3 = 0., tdelay4 = 0.;

static double selectprob[][] = new double[4][TNMNDS];

// ------------------------------------------------------------------

static void removemplayers_() {

// Randomly select m players for removal.

int i, j, l = 0;

nmnodesmm = nmnodes - m;
if (nmnodesmm < 1) {
   iderr_("removeplayers: nmnodesmm= " + nmnodesmm);
}
printf_("removeplayers: nmnodes= " + nmnodes + " m= " + m + " r= " + r +
   " nmnodesmm= " + nmnodesmm);

for (i = 0; i < nmnodes; ++i) {
   innode[i] = true;
}

for (i = 0; i < m; ++i) {
   for (l = 0; l < loopmax; ++l) {
      j = Rndm.unifint_(0, nmnodes);
      if (innode[j]) {
         innode[j] = false;
         break;
      }
   }
   if (l == loopmax) {
      iderr_("removemplayers: loopmax1 hit");
   }
}
}

// ---------------------------------------------------------------------

static int selectplayer_(boolean initialize) {

/* Selects a player from the associated social network at time t.
   Called from Intridutils.selectactions_().

   A social network is a static data structure.  Measures are computed
   that describe aspects of this structure but the network itself does
   not perform any activities.  A submodel in an IntIDs model, however,
   is an aggregated simulation model of group decision making where it
   is assumed that one member of the group actually implements the
   computed output action.

   For each output action posted by an SNA-related submodel at this time
   point, select a player from the social network who is at the same level
   as this SNA-related submodel.

   Note: Data on player-to-player phone calls could be added to the
         actions history used to fit the simulator.  But this could be
         a large amount of data, and each communication would need to be
         timestamped.  If this were done, a communication action would be
         recognized and there would be no need to select players because
         they would be known.  Currently, this type of data is contained
         in the data set used to fit the WTS network alone. */

String chosenplayername = "none";

int i, j = 0, l, level = 0, nmpresent, chosennodenm = 0;

double eigencentsum = 0., rn1 = 0., rn2 = 0., rn3 = 0., rn4 = 0.,
   rm1 = 0., rm2 = 0., rm3 = 0., rm4 = 0., alpha, avenmpoachraids = 0.,
   aveallpoachers = 0., removaleffect, aveallalpha2 = 0., avealpha2r = 0.,
   aveallalpha3 = 0., avealpha3r = 0., aveallalpha4 = 0., avealpha4r = 0.;

if (initialize) {

   // Read-in the network.

   nmnodes = SNAutils.readnetwork_(linksfle);

   // Compute centrality measures.

   SNA.findkeyplayers_();

   // Compute player selection probabilities by level.
 
   for (i = 1; i <= nmlevels; ++i) {
      eigencentsum = 0.;
      levelsize[i - 1] = 0;
      for (j = 0; j < nmnodes; ++j) {
         if (prednodelevel[j] == i) {
            eigencentsum += eigencent[j];
            ++levelsize[i - 1];
         }
      }
   
      for (j = 0; j < nmnodes; ++j) {
         if (prednodelevel[j] == i) {
            selectprob[i - 1][j] = eigencent[j] / eigencentsum;
            /*
            printf_("selectplayer: level= " + i + " player= " + (j + 1) +
               " selectprob= " + selectprob[i - 1][j]);
            */
         }
      } 
   } 
   return 0;
}

// Check if this actor is an SNA-related submodel.  If so, find its level.

if (thisidname.equals("poachers")) {
   level = 1;

} else if (thisidname.equals("middlemen")) {
   level = 2;

} else if (thisidname.equals("traders")) {
   level = 3;

} else if (thisidname.equals("retailers")) {
   level = 4;
}

if (level == 0) {
   return 0;
}

/* Select a player from the WTS network to be the author of this output
   action.

   Let n_i be the number of level-i players in the WTS network at time t_0.

   Select a player as follows.
   
   1. If $n_i = 0$, do not select a player.  In this case,
      the SNA-related submodel does not post any action.

   2. If a player is named in an output action, use that player.

   3. If the action is location-specific, randomly choose a player
      from that location.

   4. If the output action is not named and is not location-specific,
      randomly select a level-i player, e.g., if the
      trafficker submodel needs to post an action, randomly select a
      trafficker-level player.  Let the selection probability for the
      jth player in level-i, be
   
         p_select^(i_j) = xi_{i_j} / (sum{k=1}^{n_i} xi_{i_k})

      where xi_{i_j} is player i_j's eigenvector centrality. */

/* Use the selection probabilities to select a player.  First, check if
   there are any players to choose from. */

nmpresent = 0;
for (i = 0; i < nmnodes; ++i) {
   if (prednodelevel[i] == level && innode[i]) {
      ++nmpresent; 
   }
}
if (nmpresent == 0) {
   return 0;
} 

for (l = 0; l < loopmax; ++l) {
   j = Rndm.discrte_(0, selectprob[level - 1]);
   if (innode[j - 1]) {
      break;
   }
}

if (l == loopmax) {
   printf_("selectplayer: level= " + level + " nmpresent= " + nmpresent);
   for (i = 0; i < nmnodes; ++i) {
      printf_("selectplayer: prob= " + selectprob[level - 1][i] +
         " level= " + prednodelevel[i] + " innode= " + innode[i]);
   }
   iderr_("selectplayer: loopmax1 hit");
}

if (prednodelevel[j - 1] != level) {
   iderr_("selectplayer: j= " + j + " level= " + level + " prednodelevel= " +
      prednodelevel[j - 1]);
} 
chosenplayername = allid[j - 1];
chosennodenm = j;

// If players at desired level are present, one must be chosen.

if (nmpresent > 0 && chosennodenm == 0) {
   iderr_("selectplayer: nmpresent > 0 but chosennodenm = 0");
}

if (!removeplayers || !findremovaleffects) {
   return chosennodenm;
}

/* Compute the probability that a poaching action is not posted due to the
   removal of many high-performing poachers.  Also, compute the delay
   interval before the WTS submodel posts an an action due to the
   removal of some number of middlemen, traders, or retailers. */

for (i = 0; i < nmnodes; ++i) {
   if (prednodelevel[i] == 1) {
      allnmraids[i] = 1;
      aveallpoachers += allnmraids[i];
      rn1 += 1.;
      if (!innode[i]) {
         avenmpoachraids += allnmraids[i];
         rm1 += 1.;
      }

   } else if (prednodelevel[i] > 1) {
      alpha = allarrests[i] + allshipments[i] + allfirearms[i] +
                 allvehicles[i];

      if (prednodelevel[i] == 2) {
         aveallalpha2 += alpha;
         rn2 += 1.;
         if (!innode[i]) {
            avealpha2r += alpha;
            rm2 += 1.;
         }

      } else if (prednodelevel[i] == 3) {
         aveallalpha3 += alpha;
         rn3 += 1.;
         if (!innode[i]) {
            avealpha3r += alpha;
            rm3 += 1.;
         }

      } else if (prednodelevel[i] == 4) {
         aveallalpha4 += alpha;
         rn4 += 1.;
         if (!innode[i]) {
            avealpha4r += alpha;
            rm4 += 1.;
         }
      }
   }
}

if (rn1 < 1.e-6) {
   nopoachprob = 1.;

} else if (rm1 < 1.e-6) {
   nopoachprob = 0.;

} else if (aveallpoachers > 1.e-6) {
   aveallpoachers /= rn1;
   avenmpoachraids /= rm1;
   removaleffect = (rm1 * avenmpoachraids) /
                   (aveallpoachers * (rn1 - rm1 + 1.));
   nopoachprob = Math.min(1., removaleffect);
}

// Middlemen.

if (rn2 < 1.e-6) {
   tdelay2 = Intridslve.tfinal;

} else if (rm2 < 1.e-6) {
   tdelay2 = 0.;

} else if (resiliencyindex < 1.e-6) {
   tdelay2 = Intridslve.tfinal;

} else {
   aveallalpha2 /= rn2;
   avealpha2r /= rm2;
   tdelay2 = avealpha2r / (1. + resiliencyindex * aveallalpha2 * (rn2 - rm2));
}

// Traders.

if (rn3 < 1.e-6) {
   tdelay3 = Intridslve.tfinal;

} else if (rm3 < 1.e-6) {
   tdelay3 = 0.;

} else if (resiliencyindex < 1.e-6) {
   tdelay3 = Intridslve.tfinal;

} else {
   aveallalpha3 /= rn3;
   avealpha3r /= rm3;
   tdelay3 = avealpha3r / (1. + resiliencyindex * aveallalpha3 * (rn3 - rm3));
}

// Retailers.

if (rn4 < 1.e-6) {
   tdelay4 = Intridslve.tfinal;

} else if (rm4 < 1.e-6) {
   tdelay4 = 0.;

} else if (resiliencyindex < 1.e-6) {
   tdelay4 = Intridslve.tfinal;

} else {
   aveallalpha4 /= rn4;
   avealpha4r /= rm4;
   tdelay4 = avealpha4r / (1. + resiliencyindex * aveallalpha4 * (rn4 - rm4));
}
findremovaleffects = false;

/*
for (i = 0; i < nmnodes; ++i) {
   if (!innode[i]) {
      printf_("selectplayer: " + (i + 1) + " removed.");
   }
}
printf_("selectplayer: t= " + Intridslve.t + " nopoachprob= " +
   nopoachprob + " tdelay2= " + tdelay2 + "\n   tdelay3= " + tdelay3 +
   " tdelay4= " + tdelay4);
*/
return chosennodenm;
}

// ---------------------------------------------------------------------

static void recruitplayers_(double recruitrate[]) {

// Recruits level-i players at the rate of "recruitrate[i - 1]."

}

// --------------------------------------------------------------------

static void optimalremoval_() {

/* Uses Simulated Annealing to find the set of m players to remove from the
   WTS network that causes the largest reduction in the poaching rate.
   x is a binary vector wherein a "1" means the player is in the network
   and a "0" means the player is removed from the network. */

int i, j, k, mchooser, nsize, chlngt;

double eigencentsum = 0.;

// Initial solution.  First, remove m players.

removemplayers_();

mchooser = Minmax.nchsk_(m, r);
nsize = nmnodes;
for (i = 0; i < nsize; ++i) {
   x[i] = innode[i] == true ? 1 : 0;
}

// "chlngt" is the number of solutions reachable in one "move" step.

chlngt = mchooser * mchooser;

printf_("optimalremoval: mchooser= " + mchooser + " nsize= " + nsize +
   " chlngt= " + chlngt);

Simanel.nofslimit = 500;
Simanel.simanel_(nsize, chlngt, x, 20., 1.e-5, 4);
printf_("Optimal Removal Solution" +
   "\n    Player         innode= ");
for (i = 0; i < nsize; ++i) {
   printf_("  " + (i + 1) + "  " + x[i]);
}
}

// --------------------------------------------------------------------

static void swapplayers_(int n, int x[], int xtrial[]) {

// Swaps r removed-players for r in-players.

int i, j = 0, k = 0, l;

for (i = 0; i < n; ++i) {
   xtrial[i] = x[i];
   innode[i] = x[i] == 1 ? true : false;
}

// Load the sets of removed-, and in-players.

for (i = 1; i <= nmnodes; ++i) {
   if (!innode[i - 1]) {
      removedplayer[j] = i;
      ++j;

   } else {
      inplayer[k] = i;
      ++k;
   }
}

// Randomly select r players from the set of m removed-players.

for (i = 0; i < r; ++i) {
   SRCHOUT: for (l = 0; l < loopmax; ++l) {
      j = Rndm.unifint_(0, m);

      // Check for previous selection.

      for (k = 0; k < i; ++k) {
         if (removedplayer[j] == swapinplayer[k]) {
            continue SRCHOUT;
         }
      }
      swapinplayer[i] = removedplayer[j];
      break;
   }
   if (l == loopmax) {
      iderr_("swapplayers: l= " + l + " loopmax1 hit");
   }
}

// Randomly select r in-players from the m-reduced WTS network.

for (i = 0; i < r; ++i) {
   SRCHIN: for (l = 0; l < loopmax; ++l) {
      j = Rndm.unifint_(0, nmnodesmm);

      // Check for previous selection.

      for (k = 0; k < i; ++k) {
         if (inplayer[j] == swapoutplayer[k]) {
            continue SRCHIN;
         }
      }
      swapoutplayer[i] = inplayer[j];
      break;
   }
   if (l == loopmax) {
      iderr_("swapplayers: loopmax2 hit");
   }
}

// Swap these two sets of players and load the solution vector.

j = 0;
k = 0;
nodeloop: for (i = 1; i <= nmnodes; ++i) {
   for (j = 0; j < r; ++j) {
      if (i == swapinplayer[j]) {
         innode[i - 1] = true;
         xtrial[i - 1] = 1;
         continue nodeloop;
      }
   }
   for (j = 0; j < r; ++j) {
      if (i == swapoutplayer[j]) {
         innode[i - 1] = false;
         xtrial[i - 1] = 0;
         continue nodeloop;
      }
   }
}
}

// ------------------------------------------------------------

static double objf_(int n, int x[]) {

// Compute the average poaching rate.

int i;

double avepch = 0.;

findremovaleffects = true;

// Run the IntIDs model over the time interval.

for (i = 0; i < nmids; ++i) {
   Intridslve.nminoutpairs[i] = 0;
}

Intridslve.intridslve_(false, false);

printf_("objf: x= " + x[0] + x[1] + x[2] + x[3] + x[4] + x[5] + x[6] +
   x[7] + x[8] + x[9] + " meankilled= " + IBMcalcs.meankilled);

return (IBMcalcs.meankilled);
}
}
