class Plot extends Id {
static final int NMBARS = 900;

// Many of these arrays are needed for "pltdist_," below.

static char symbol[][] = new char[10][1000];

static String tmelbl[] = new String[TNMVALS];
static String title[] = new String[TNMIDS + MAXNMECO];
static String title1[] = new String[TNMIDS + MAXNMECO];
static String title2[] = new String[TNMIDS + MAXNMECO];
static String xtitle[] = new String[TNMIDS + MAXNMECO];
static String ytitle[] = new String[TNMIDS + MAXNMECO];
static String linelbl[] = new String[TNMVALS];
static String varname[] = new String[TNMNDS];
static String legendlbl[] = new String[TNMIDS + MAXNMECO];

static int linetype[] = new int[TNMIDS];
static int indx[] = new int[NMBARS];
static int nvals[] = new int[TNMVALS];
static int nmline[] = new int[TNMIDS + MAXNMECO];
static int n[] = new int[TNMIDS + MAXNMECO];

static double y[][][] = new double[TNMIDS + MAXNMECO][3][MAXTIMES];
static double x[][] = new double[TNMIDS + MAXNMECO][MAXTIMES];
static double tpts[] = new double[WLSSZE];
static double yplt[][] = new double[4][WLSSZE];
static double tme[] = new double[WLSSZE];
static double xmin[] = new double[TNMIDS + MAXNMECO];
static double xmax[] = new double[TNMIDS + MAXNMECO];
static double ymin[] = new double[TNMIDS + MAXNMECO];
static double ymax[] = new double[TNMIDS + MAXNMECO];
static double bars[] = new double[TNMIDS];

// ------------------------------------------------------------------------

static void xyplots_() {

// General x-y plotting routine.

int i, j, k, l, ndnm, nmdepvars;

// First, read the points to be plotted.

nmdepvars = Getdata.getdata_(spacetime_xyptsfle, varname);

title1[0] = null;

for (i = 0; i < nmdepvars; ++i) {
   ymin[i] = 1.e30;
   ymax[i] = -1.e30;

   ndnm = Getmodlutils.getndnm_(varname[i]);
   n[i] = nmobs[idnmbrm1][ndnm - 1];
   nmline[i] = 3;
   legendlbl[i] = null;
   linetype[i] = 1;

   if (i > 0) {
      title1[i] = null;
   }

   // Load the plot-point pairs.

   xtitle[i] = "Time_in_years";
   ytitle[i] = varname[i];
   k = 0;
   for (j = 0; j < nmecoobsttl; ++j) {
      if (dat2_vrble[0][j] != ndnm) {
	 continue;
      }

      // Load the x-axis value.

      x[i][k] = dat2_t[j];

      // Load the y-axis values.

      y[i][0][k] = dat2_dat[j];
      y[i][1][k] = y[i][0][k] - 2. * dat2_stddev[j];
      y[i][2][k] = y[i][0][k] + 2. * dat2_stddev[j];

      printf_("i= " + i + " k= " + k + " x= " + x[i][k] +
         " y0= " + y[i][0][k]);

      // Discover y-axis min, max.

      for (l = 0; l < nmline[i]; ++l) {
         if (y[i][l][k] < ymin[i]) {
	    ymin[i] = y[i][l][k];
         }
         if (ymax[i] < y[i][l][k]) {
	    ymax[i] = y[i][l][k];
         }
      }
      ++k;
   }
   xmin[i] = x[i][0];
   xmax[i] = x[i][k - 1];
}

Plotutils.multplt_(nmdepvars, 1, nmline, n, x, y, false, xmin, xmax,
   ymin, ymax, title1, title2, xtitle, ytitle, legendlbl, linetype);
}

// ------------------------------------------------------------------------

static void plttmeag_(int nd, double t[], int vrble[], double obs[],
   double trend[]) {

/* Aggregates data by time and plots the aggregate means with the time
   component in the regression model. */

int i, j, k;

double tmin, tmax, datmin, datmax;

// Sort times.

for (j = 0; j < nd; ++j) {
   tme[j] = t[j];
   indx[j] = j + 1;
}
Idsort.idsort_(tme, indx, 1, nd);
tmin = tme[0];
tmax = tme[nd - 1];

/* Find data mean for each time value, store in yplt[0][].  Store regression
   model mean in yplt[1][]. */

datmin = 1.e30;
datmax = 0.;
k = 0;
i = 0;
for (;;) {

   // Bounds check.

   if (k > WLSSZE) {
      iderr_("plttmeag: k>WLSSZE");
   }

   // Process a time point.

   tpts[k] = t[indx[i] - 1];
   yplt[0][k] = 0.;
   yplt[1][k] = 0.;
   j = 0;
   while(tpts[k] == t[indx[i] - 1]) {
      if (vrble[indx[i] - 1] == lomapnms[0]) {
         yplt[0][k] += obs[indx[i] - 1];
         yplt[1][k] += trend[indx[i] - 1];
         ++j;
      }
      ++i;
      if (i >= nd) {
	 break;
      }
   }

   yplt[0][k] /= (double) j;
   yplt[1][k] /= (double) j;

   if (yplt[0][k] < datmin) {
      datmin = yplt[0][k];
   }
   if (datmax < yplt[0][k]) {
      datmax = yplt[0][k];
   }
   if (yplt[1][k] < datmin) {
      datmin = yplt[1][k];
   }
   if (datmax < yplt[1][k]) {
      datmax = yplt[1][k];
   }
   ++k;
   if (i >= nd) {
      break;
   }
}

for (i = 0; i < k; ++i) {
   printf_("plttmeag: t= " + tpts[i] + " y= " + yplt[0][i] +
      " aggmdl= " + yplt[1][i]);
}

// Plot.

fleopen_(4, "out.dig", 'w');
linetype[0] = 1;
linetype[1] = 2;
iderr_("plttmeag: pltscat_ call not fixed.");
/*
Plotutils.pltscat_(4, 2, tpts, yplt, k, symbol, "none", "none", tmelbl,
   "Time", "Mean_deposition,_g/m^2", .8, .8, .1, .1, 0, bars, linetype,
   0., 0.);
*/
fclose_(4, 'w');

// Write PostScript file and close the .dig file.

Pltpost.pltpost_("tmeag.ps", 1.1); 
fprintf_(1, "PostScript time plot is written to file tmeag.ps.");
}

// ---------------------------------------------------------------------

static void pltdist_(int ndenm, int nmvals, int nmnghs, int ngh1,
   int nmvalngh1, int ngh2, int nmvalngh2, int ngh3, int nmvalngh3,
   double xpltvals[][], double ypltvals[][][]) {

/* Plots "ndenm"'s conditional distribution.
   For 1 parent, values of this parent are different lines in the plot.
   For 2 parents, 
      Values of parent 2 are different lines within the plot.
      Values of parent 1 are different rows of the multiple plot page.
   Fore 3 parents,
   Values of parent 3 are different lines within the plot.
   Values of parent 2 are different columns of the multiple plot page.
   Values of parent 1 are different rows of the multiple plot page. */

int i, j, pltnm = 0;

// Initialize PostScript multiple page plotting.

if (ndenm < nmnds) {
   Pltpost.stop = false;

} else if (ndenm == nmnds) {
   Pltpost.stop = true;
}

for (i = 0; i < TNMIDS; ++i) {
   linetype[i] = 1;
}

// Create plot file.

if (nmnghs == 0) {
   title1[0] = nodelbls[idnmbrm1][ndenm - 1][0];
   title2[0] = null;
   xtitle[0] = "Node_Value";
   ytitle[0] = "Probability";
   nmline[0] = 1;
   nvals[0] = nmvals;
   linelbl[0] = null;
   Plotutils.multplt_(1, 1, nmline, nvals, xpltvals, ypltvals, true, xmin,
      xmax, ymin, ymax, title1, title2, xtitle, ytitle, linelbl, linetype);

} else if (nmnghs == 1) {
   title1[0] = nodelbls[idnmbrm1][ndenm - 1][0];
   title2[0] = "Legend:_" + nodelbls[idnmbrm1][ngh1 - 1][0];
   xtitle[0] = "Node_Value";
   ytitle[0] = "Probability";
   nmline[0] = nmvalngh1;
   nvals[0] = nmvals;
   for (i = 0; i < nmline[0]; ++i) {
      linelbl[i] = nodelbls[idnmbrm1][ngh1 - 1][i + 1];
   }
   Plotutils.multplt_(1, 1, nmline, nvals, xpltvals, ypltvals, true, xmin,
      xmax, ymin, ymax, title1, title2, xtitle, ytitle, linelbl, linetype);

} else if (nmnghs == 2) {
   for (i = 0; i < nmvalngh1; ++i) {
      title1[i] = nodelbls[idnmbrm1][ngh1 - 1][0] + ":_" +
         nodelbls[idnmbrm1][ngh1 - 1][i + 1];
      title2[i] = "Legend:_" + nodelbls[idnmbrm1][ngh2 - 1][0];
      xtitle[i] = "Node_Value";
      ytitle[i] = "Probability";
      nmline[i] = nmvalngh2;
      nvals[i] = nmvals;
   }
   for (i = 0; i < nmvalngh2; ++i) {
      linelbl[i] = nodelbls[idnmbrm1][ngh2 - 1][i + 1];
   }
   Plotutils.multplt_(nmvalngh1, 1, nmline, nvals, xpltvals, ypltvals, true,
      xmin, xmax, ymin, ymax, title1, title2, xtitle, ytitle, linelbl,
      linetype);

} else if (nmnghs == 3) {
   pltnm = 0;
   for (i = 0; i < nmvalngh1; ++i) {
      for (j = 0; j < nmvalngh2; ++j) {
         title1[pltnm] = nodelbls[idnmbrm1][ngh1 - 1][i + 1] + ",_" +
	    nodelbls[idnmbrm1][ngh2 - 1][j + 1];
	 title2[pltnm] = "Legend:_" + nodelbls[idnmbrm1][ngh3 - 1][0];
         xtitle[pltnm] = "Node_Value";
         ytitle[pltnm] = "Probability";
         nmline[pltnm] = nmvalngh3;
	 nvals[pltnm] = nmvals;
	 ++pltnm;
      }
   }
   for (i = 0; i < nmline[0]; ++i) {
      linelbl[i] = nodelbls[idnmbrm1][ngh3 - 1][i + 1];
   }
   Plotutils.multplt_(nmvalngh1, nmvalngh2, nmline, nvals, xpltvals,
      ypltvals, true, xmin, xmax, ymin, ymax, title1, title2, xtitle,
      ytitle, linelbl, linetype);

} else {
   fprintf_(1,"multplt: can only plot nodes that have < 4 parents");
}

// Set PostScript multiple page plotting flags.

if (ndenm < nmnds) {
   Pltpost.start = false;

} else if (ndenm == nmnds) {
   Pltpost.start = true;
}
}
}
