import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import javax.swing.*;

public class Plotimage extends Dialog implements ActionListener {

// Creates a new window and plots the image in it.

int flenm = 4, mousex, mousey, nmclicked = 0;
double windsize = 950.; // was 950

GISwind giswind;
Image img;

int xval[] = new int[1000];
int yval[] = new int[1000];

// --------------------------------------------------------------------

public Plotimage (GISwind giswind, String imagefilename, String title) {
super(giswind, title);
this.giswind = giswind;
setLayout(new FlowLayout());
setSize((int) windsize, (int) windsize);
setModal(false);

// Create an object to handle window events.

PlotWindowAdapter plotadapter = new PlotWindowAdapter(this);

// Register it to receive those events.

addWindowListener(plotadapter);
addMouseListener(new PlotMouseAdapter(giswind, this));

// Set font, background and foreground colors.

Font f = new Font("SansSerif", Font.PLAIN, (int) (.015 * windsize));
setFont(f);
setBackground(Color.white);
setForeground(Color.black);

/* Get image.  JAVA can read .jpg, .gif, and .png image files.  If the
   original image is a .pdf file, you can use Adobe Photoshop to first
   read the file (it will automatically rasterize it), and then execute
   File > Save for Web   to write a .gif file.  For some reason,
   executing File > Save As (JPEG) produces a file that neither Internet
   Explorer nor "getImage" can read.  If an image file is too small
   when loaded into "id," edit the image in Microsoft Paint using
   Image > Stretch and then writing the edited image with File > Save. */

// img = getImage(getDocumentBase(), imagefilename);
img = new ImageIcon(imagefilename).getImage();
}

// ----------------------------------------------------------------------

public void actionPerformed(ActionEvent ae) {
String str;

str = ae.getActionCommand();

if (str.equals("Finish")) {
   repaint();

} else if (str.equals("Echo Input")) {
   repaint();
}
}

// ----------------------------------------------------------------------

public void itemStateChanged(ItemEvent ie) {
repaint();
}

// ----------------------------------------------------------------------

public void paint (Graphics g) {

int i, j, fontheight = 0, radius1 = 2, radius2 = 1,
   diameter1 = 2 * radius1, diameter2 = 2 * radius2, x, y, imgwidth,
   imgheight;

// Get font height.

FontMetrics fm = g.getFontMetrics();
fontheight = fm.getHeight();

// tanzania_pol_2003.jpg
// g.drawImage(img, -50, -100, this);

// uganda_pol_2005.jpg
// g.drawImage(img, 30, 30, this);

imgwidth = (int) (.85 * windsize);
imgheight = (int) (.9 * windsize);
imgwidth = img.getWidth(this);
imgheight = img.getHeight(this);
imgwidth = 1150;
imgheight = 850;
// Run_id.printf_("imgwidth= " + imgwidth + " imgheight= " + imgheight);

// g.drawImage(img, 50, 50, this);
g.drawImage(img, 50, 50, imgwidth, imgheight, this);

// Save this new point.

xval[nmclicked] = (int) giswind.xdum;
yval[nmclicked] = (int) giswind.ydum;
++nmclicked;

if (nmclicked >= 1000) {
   nmclicked = 0;
}

if (giswind.digitizesurface) {

   /* Draw a longitude-latitude grid on the image.  Use empty circles
      for any point not equal to the surface value being digitized and
      and filled circle for the surface value that is being digitized. */

   for (i = 0; i < giswind.nmrows; ++i) {
      for (j = 0; j < giswind.nmcols; ++j) {
	 x = (int) ((giswind.collngval[j] - giswind.xtrans) /
		    giswind.xscale);
	 y = (int) ((giswind.rowlatval[i] - giswind.ytrans) /
		    giswind.yscale);
	 if (giswind.level[i][j] != giswind.surfval) {
	    g.drawOval(x, y, diameter2, diameter2);
	 
	 } else {
	    g.fillOval(x, y, diameter2, diameter2);
	 }
      }
   }

} else {

   // Draw small circles at the most recent mouse-click points.

   for (i = 0; i < nmclicked; ++i) {
      g.drawOval(xval[i] - radius1, yval[i] - radius1, diameter1,
	 diameter1);
   }
}

}

}

// ******************************************************************

class PlotWindowAdapter extends WindowAdapter {
Plotimage plotimage;

// ------------------------------------------------------------------

public PlotWindowAdapter (Plotimage plotimage) {
this.plotimage = plotimage;
}

// ------------------------------------------------------------------

public void windowClosing(WindowEvent we) {
plotimage.setVisible(false);
}
}

// **********************************************************************

class PlotMouseAdapter extends MouseAdapter {
GISwind giswind;
Plotimage appWindow;

// -----------------------------------------------------------------------

public PlotMouseAdapter(GISwind giswind, Plotimage appWindow) {
this.giswind = giswind;
this.appWindow = appWindow;
}

// -----------------------------------------------------------------------

public void mousePressed(MouseEvent me) {
appWindow.mousex = me.getX();
appWindow.mousey = me.getY();

giswind.xdum = (double) appWindow.mousex;
giswind.ydum = (double) appWindow.mousey;

if (giswind.digitizepath) {
   giswind.updatepath_();

} else if (giswind.digitizesurface) {
   giswind.updatesurface_();

} else {
   giswind.readytoref = true;
}

appWindow.repaint();

giswind.repaint();
}
}
