class Pltpost extends Id {

static boolean start = true, stop = true;

static double xmin = 0., ymin = 0., xmax = 1., ymax = 1.;

// ----------------------------------------------------------------------

static int pltpost_(String outfle, double psscale) {

/* Reads a device independent graphics file (*.dig) and writes a
   PostScript file, "outfle." */

boolean lndscp = false;

String strng2, cmd, prevcmd = "none", color = "none";

int i, nmpts, level, xminbb = 0, yminbb = 0, xmaxbb = 0, ymaxbb = 0;

double xpos, ypos, x, y, xsize, ysize, radius, bang, eang, xsave = 0.,
   ysave = 0., xshift, yshift, nmcolor = 0., slngth, clpxmin, clpxmax,
   clpymin, clpymax, charsze, graylevel, arrowlength = 0.;

// Open input, output files.

fleopen_(3, "out.dig", 'r');
if (start) {
   fleopen_(4, outfle, 'w');
}

/* Set x and y size in points (1/72 inches) and initialize open path
   indicator.  Rotate user coordinate axes. 
xsize = 550;
ysize = 550.;
xshift = 50.;
yshift = 100.; */

xsize = 450. * psscale;
ysize = 450. * psscale;
xshift = 70.;
yshift = 100.;

if (start) {

   // Place PostScript procedures library in PostScript output file.

   // Pltgrph.pslib_(4);

   /* Write PostScript preamble.  For non-Encapsulated PostScript,
      replace the "%!PS" line below with "%!PS-Adobe-2.0 EPSF-1.2\n" */

   fprintf_(4,   "%!PS-Adobe-3.0 EPSF-3.0\n"
            + "%%%Creator: BGI by Borland International\n"
            + "%%%Title: BGI Graphics");

   if (lndscp) {
      fprintf_(4, "%%BoundingBox: 24 184 587 607"); 
   
   } else {
      printf_("pltpost: xmin= " + xmin + " ymin= " + ymin);

      // fprintf_(4, "%%BoundingBox: 50 100 500 625");
      xminbb = (int) (xshift + (xsize * xmin));
      yminbb = (int) (yshift + (ysize * ymin));
      xmaxbb = (int) (xshift + 1.02 * (xsize * xmax));
      ymaxbb = (int) (yshift + 1.02 * (ysize * ymax));
      fprintf_(4, "%%BoundingBox: " + xminbb + " " + yminbb + " " +
         xmaxbb + " " + ymaxbb);
   }

   fprintf_(4,
     "%*****************************************************************\n"
   + "% File: preamble.bgi\n"
   + "% Postscript preamble file for BGI Postscript driver\n"
   + "% (c) Copyright 1989 Borland International\n"
   + "% Last Update: 02-11-91\n"
   + "%*****************************************************************\n"
   + "%%%EndComments");

   // Set line width.

   fprintf_(4,"0.25 setlinewidth"); // was 0.5.

   // Define vertical printing routine.

   fprintf_(4,
     "/vshowdict 4 dict def\n" +
     "/vshow\n" +
     "{vshowdict begin\n" +
     "  /thestring exch def\n" +
     "  /lineskip exch def\n" +
     "  thestring\n" +
     "   {\n" +
     "    /charcode exch def\n" +
     "    /thechar ( ) dup 0 charcode put def\n" +
     "    0 lineskip neg rmoveto\n" +
     "    gsave\n" +
     "     thechar stringwidth pop 3 div neg 0 rmoveto\n" +
     "     thechar show\n" +
     "    grestore\n" +
     "   }forall\n" +
     "  end\n" +
     "}def");

   // Define centered text routine, arrow, and arrowhead.

   fprintf_(4,
     "/center_show {\n" +
     "   currentpoint\n" +
     "   3 -1 roll\n" +
     "   dup\n" +
     "   stringwidth pop 2 div\n" +
     "   4 -1 roll exch sub\n" +
     "   3 -1 roll moveto\n" +
     "   dup\n" +
     "   gsave\n" +
     "   newpath\n" +
     "   0 0 moveto\n" +
     "   false charpath flattenpath pathbbox\n" +
     "   exch pop exch sub exch pop\n" +
     "   grestore\n" +
     "   -2 div 0 exch rmoveto\n" +
     "   show\n" +
     "} def" +
     "/arrow {\n" +
     "   % Draws an arrow from (x1,y1) to (x2,y2).\n" +
     "   % Arguments are x1 y1 x2 y2.\n" +
     "   4 2 roll\n" +
     "   moveto\n" +
     "   currentlinewidth currentpoint 5 3 roll\n" +
     "   lineto\n" +
     "   currentpoint stroke moveto\n" +
     "   arrowhead\n" +
     "} def\n" +
     "/arrowhead {\n" +
     "   % Draws a correctly oriented arrow head, from the Green Book.\n" +
     "   gsave\n" +
     "      currentpoint\n" +
     "      4 2 roll exch 4 -1 roll exch\n" +
     "      sub 3 1 roll sub\n" +
     "      exch atan rotate dup scale\n" +
     "      -6 0 rmoveto\n" +
     "      -1 4 rlineto\n" +
     "      9 -4 rlineto\n" +
     "      -9 -4 rlineto\n" +
     "      closepath fill\n" +
     "   grestore\n" +
     "   newpath\n" +
     "} def\n");
}

// Translation loop.

while (checkeof_(3) != true) {
   cmd = fgetstrng_(3);
   if (prevcmd.equals("LINETO") && !cmd.equals("LINETO")) {
      fprintf_(4, "stroke");
   }
   if (prevcmd.equals("ARROWTO") && !cmd.equals("ARROWTO")) {
      fprintf_(4, "stroke");
   }

   // Command ladder.

   if (cmd.equals("SCALE")) {

      // Read x and y.

      xpos = fgetdble_(3);
      ypos = fgetdble_(3);

      fprintf_(4, xpos + " " + ypos + " scale");

   } else if (cmd.equals("ROTATE")) {

      // Read rotation angle.

      xpos = fgetdble_(3);

      fprintf_(4, xpos + " rotate");

   } else if (cmd.equals("LANDSCAPE") && lndscp) {
      fprintf_(4,"700. -100. translate");
      fprintf_(4,"90. rotate");
      fprintf_(4,"1.4 1.4 scale");

   } else if (cmd.equals("SETCHARSIZE")) {

      // Note, the argument to this command is in "points."

      charsze = fgetdble_(3);
      fprintf_(4,"/TxtFont");
      // fprintf_(4,"   /Times-Roman findfont " + charsze +
      fprintf_(4,"   /Helvetica findfont " + charsze +
	 " scalefont def");
      fprintf_(4,"/CenFont");
      fprintf_(4,"   /Times-Roman findfont " + (charsze - 1.) +
	 " scalefont def");

   } else if (cmd.equals("SETLINEWIDTH")) {
      x = fgetdble_(3);
      fprintf_(4, (.333 * x) + " setlinewidth");

   } else if (cmd.equals("SETNUMCOLOR")) {
      nmcolor = fgetdble_(3);

   } else if (cmd.equals("SETCOLOR")) {
      color = fgetstrng_(3);
      if (color.equals("red")) {
         fprintf_(4, "1 0 0 setrgbcolor");

      } else if (color.equals("green")) {
         fprintf_(4, "0 1 0 setrgbcolor");

      } else if (color.equals("black")) {
         fprintf_(4, "0 0 0 setrgbcolor");
      }

   } else if (cmd.equals("SETDASH")) {
      fprintf_(4, "[3] 0 setdash");

   } else if (cmd.equals("SOLID")) {
      fprintf_(4, "[] 0 setdash");

   } else if (cmd.equals("MOVETO")) {

      // Read and scale x and y.

      xpos = fgetdble_(3);
      if (xpos > .999) {
	 printf_("pltpost MOVETO: xpos= " + xpos + " >.999");
      }
      ypos = fgetdble_(3);
      x = xsize * xpos;
      y = ysize * ypos;

      fprintf_(4, "newpath");
      fprintf_(4, (x + xshift) + " " + (y + yshift) + " moveto");
      xsave = x;
      ysave = y;

   } else if (cmd.equals("LINETO")) {

      // Read and scale x and y.

      xpos = fgetdble_(3);
      ypos = fgetdble_(3);
      x = xsize * xpos;
      y = ysize * ypos;

      fprintf_(4, (x + xshift) + " " + (y + yshift) + " lineto");

   } else if (cmd.equals("ARROWTO")) {

      // Read and scale x and y.

      xpos = fgetdble_(3);
      ypos = fgetdble_(3);
      x = xsize * xpos;
      y = ysize * ypos;

      // Only draw arrows that are longer than 5 units.

      arrowlength = Math.pow(xsave - x, 2.) + Math.pow(ysave - y, 2.);
      if (arrowlength > 1.e-6) {
	 arrowlength = Math.sqrt(arrowlength);
      }
      if (arrowlength > 5.0) {
         fprintf_(4, (xsave + xshift) + " " + (ysave + yshift) + " " +
		     (x + xshift) + " " + (y + yshift) + " arrow");
      }

      // To connect arrows head-to-tail.

      xsave = x;
      ysave = y;

   } else if (cmd.equals("GRTEXT")) {

      // Read and scale x and y.

      xpos = fgetdble_(3);
      ypos = fgetdble_(3);
      x = xsize * xpos;
      y = ysize * ypos;

      // Get string.

      strng = fgetstrng_(3);
      strng = strngsub_(strng, "xzx", "-");
      strng = strngsub_(strng, "yzy", "_");
      strng = strngsub_(strng, "_", " ");
      strng = strng.trim();

      fprintf_(4, "newpath");
      fprintf_(4, "TxtFont setfont");
      fprintf_(4, (x + xshift) + " " + (y + yshift) + " moveto");
      strng = strngmd_(strng);
      fprintf_(4, "(" + strng + ") show");

   } else if (cmd.equals("CGRTEXT")) {

      // Read and scale x and y.

      xpos = fgetdble_(3);
      ypos = fgetdble_(3);
      x = xsize * xpos;
      y = ysize * ypos;

      // Get string.

      strng = fgetstrng_(3);
      if (strng.equals("hyphen")) {
	 strng = "-";
      
      } else if (strng.equals("numbersign")) {
         strng = "#";

      } else if (strng.equals("underscore")) {
         strng = "_";

      } else if (strng.equals("plus")) {
         strng = "+";

      } else if (strng.equals("ampersand")) {
         strng = "&";

      } else if (strng.equals("equal")) {
         strng = "=";

      } else if (strng.equals("asterisk")) {
         strng = "*";

      } else if (strng.equals("at")) {
         strng = "@";
      }

      fprintf_(4, "newpath");
      fprintf_(4, (x + xshift) + " " + (y + yshift) + " moveto");
      fprintf_(4,"CenFont setfont");
      fprintf_(4,"(" + strng + ") center_show");
      fprintf_(4, (x + xshift) + " " + (y + yshift) + " moveto");

   } else if (cmd.equals("VGRTEXT")) {

      // Read and scale x and y.

      xpos = fgetdble_(3);
      ypos = fgetdble_(3);
      x = xsize * xpos;
      y = ysize * ypos;

      // Get string.

      strng = fgetstrng_(3);

      fprintf_(4, "newpath");
      strng = strngmd_(strng);
      fprintf_(4, (x + xshift) + " " + (y + yshift) + " moveto");
      fprintf_(4, "90. rotate");
      fprintf_(4, "TxtFont setfont");
      fprintf_(4, "(" + strng + ") show");
      fprintf_(4, "-90. rotate");

   } else if (cmd.equals("GRTEXTV")) {

      // Read and scale x and y.

      xpos = fgetdble_(3);
      ypos = fgetdble_(3);
      x = xsize * xpos;
      y = ysize * ypos;

      // Get string.

      strng = fgetstrng_(3);

      fprintf_(4, "newpath");
      slngth = (double) strng.length();
      fprintf_(4,
	 (x + xshift) + " " + (y + yshift + slngth * 7. / 2.) + " moveto");
      fprintf_(4,"TxtFont setfont");
      fprintf_(4, " 7. " + strng + " vshow");

   } else if (cmd.equals("CLIP")) {

      // Read x and y.

      xpos = fgetdble_(3);
      ypos = fgetdble_(3);

      fprintf_(4, "newpath");
      clpxmin = xshift + xpos * xsize;
      clpxmax = xshift + ypos * xsize;
      xpos = fgetdble_(3);
      ypos = fgetdble_(3);
      clpymin = yshift + xpos * ysize;
      clpymax = yshift + ypos * ysize;
      fprintf_(4, "newpath " + clpxmin + " " + clpymin + " moveto");
      fprintf_(4, clpxmax + " " + clpymin + " lineto");
      fprintf_(4, clpxmax + " " + clpymax + " lineto");
      fprintf_(4, clpxmin + " " + clpymax + " lineto");
      fprintf_(4, "closepath clip");

   } else if (cmd.equals("POLYGON")) {

      // Read and scale x and y.

      xpos = fgetdble_(3);
      ypos = fgetdble_(3);
      x = xsize * xpos;
      y = ysize * ypos;

      fprintf_(4, "newpath " + (x + xshift) + " " + (y + yshift) +
	 " moveto");
      nmpts = fgetint_(3);
      level = fgetint_(3);
      for (i = 1; i <= nmpts - 1; ++i) {
	 xpos = fgetdble_(3);
	 ypos = fgetdble_(3);
         x = xsize * xpos;
         y = ysize * ypos;
	 fprintf_(4, (x + xshift) + " " + (y + yshift) + " lineto");
      }
      fprintf_(4, "closepath");

      // Fill in polygon.

      if (level > 0) {
         fprintf_(4, "30 0 { dup mul exch dup mul add 1 exch sub }");
         fprintf_(4, " setscreen");
	 graylevel = 1. - ((double) (level)) / nmcolor;
	 fprintf_(4, graylevel + " setgray fill 0 setgray");
         
      } else if (level < 0) {
         fprintf_(4, "30 0 { pop } setscreen");
	 graylevel = ((double) (((int) nmcolor) + level)) / nmcolor;
	 fprintf_(4, graylevel + " setgray fill 0 setgray");

      } else if (level == 0) {
         fprintf_(4, "0 setgray");
      }

   } else if (cmd.equals("BOX")) {

      // Read and scale x and y.

      xpos = fgetdble_(3);
      ypos = fgetdble_(3);
      x = xsize * xpos;
      y = ysize * ypos;

      fprintf_(4, "0 " + y + " rlineto");
      fprintf_(4, x + " 0 rlineto");
      fprintf_(4, "0 " + (-y) + " rlineto");
      fprintf_(4, (-x) + " 0 rlineto");
      fprintf_(4, "closepath stroke");
      fprintf_(4, "newpath");
      fprintf_(4, (.1*x+xsave+xshift) + " " + (.1*y+ysave+yshift) +
         " moveto");
      fprintf_(4, "(" + strng + ") show");

   } else if (cmd.equals("BOX2")) {

      // Read and scale x and y.

      xpos = fgetdble_(3);
      ypos = fgetdble_(3);
      x = xsize * xpos;
      y = ysize * ypos;

      strng = fgetstrng_(3);
      strng2 = fgetstrng_(3);
      strng = strngmd_(strng);
      strng2 = strngmd_(strng2);
      fprintf_(4, "0 " + y + " rlineto");
      fprintf_(4, x + " 0 rlineto");
      fprintf_(4, "0 " + (-y) + " rlineto");
      fprintf_(4, (-x) + " 0 rlineto");
      fprintf_(4, "closepath stroke");
      fprintf_(4, "newpath");
      fprintf_(4, (.06*x+xsave+xshift) + " " + (.6*y+ysave+yshift) +
         " moveto");
      fprintf_(4, "(" + strng + ") show");
      fprintf_(4, "newpath");
      fprintf_(4, (.06*x+xsave+xshift) + " " + (.2*y+ysave+yshift) +
         " moveto");
      fprintf_(4, "(" + strng2 + ") show");

   } else if (cmd.equals("OVAL")) {

      // Read and scale x and y.

      xpos = fgetdble_(3);
      ypos = fgetdble_(3);
      x = xsize * xpos;
      y = ysize * ypos;

      strng = fgetstrng_(3);
      fprintf_(4, "newpath");
      radius = fgetdble_(3);
      bang = fgetdble_(3);
      eang = fgetdble_(3);
      radius *= xsize;
      fprintf_(4, (x + xshift) + " " + (y + yshift) + " " + radius +
	 " " + bang + " " + eang + " arc");
      fprintf_(4, "stroke");

   } else if (cmd.equals("TRNSINFO")) {
      xpos = fgetdble_(3);
      xpos = fgetdble_(3);
      xpos = fgetdble_(3);
      xpos = fgetdble_(3);
   }
   prevcmd = cmd;
}
fclose_(3, 'r');

if (prevcmd.equals("LINETO") || prevcmd.equals("ARROWTO")) {
    fprintf_(4,"stroke");
}

if (stop) {

   // Print page.

   fprintf_(4,"showpage");

   // Close Postscript output file.

   fclose_(4, 'w');
}
return 0;
}

// ----------------------------------------------------------------------

static String strngmd_(String strng) {

// Replace parentheses with octal numbers.

String newstrng;

newstrng = strngsub_(strng, "#", "\\43");
if (strng.indexOf("#") >= 0) {
   printf_("strngmd: strng= " + strng + " newstrng= " + newstrng);
}
newstrng = strngsub_(newstrng, "(", "\\50");
newstrng = strngsub_(newstrng, ")", "\\51");
return newstrng;
}
}
