class Pltsleg extends Pltsurf {

static boolean plotsites = false;

static String sitesfle;

static char sitesymbol[] = new char[100];

// ----------------------------------------------------------------------

static void pltsleg_(int flenm, int option, int surf, String legtitle) {

// Plots title, legend, and optionally, sampling sites for surface plotting.

boolean reglabels, outsideonly = false;

String title, legunits, flenme, xlab, ylab;

char symbol[] = new char[5];

int i, j, k, nmsegpts, nmdat, izero, color, nmsplt;

double xlegend, ylegend, predtime, dum1, dum2, levelval, xtitle, ytitle,
   xpos, ypos, datmin, datmax, hlfside;

double xval[] = new double[DATSZE];
double yval[] = new double[DATSZE];
double dat[] = new double[DATSZE];

// Set region label printing option.

if (surf == 0) {
   reglabels = true;

} else {
   reglabels = false;
}

// Write translation information to the file.

fprintf_(flenm, "TRNSINFO " + spacetime_xmin + " " + spacetime_ymin);
fprintf_(flenm, xshift + " " + yshift + " " + xscale + " " + yscale);

if (option == 5) {

   // Scatter plot of a spatial data set.

   fleopen_(4, spacetime_datfle, 'r');
   fprintf_(flenm, "SETCHARSIZE 10");

   // Define half-width of an observation box.

   if (spacetime_xmax - spacetime_xmin > spacetime_ymax - spacetime_ymin) {
      hlfside = .008 * (spacetime_xmax - spacetime_xmin) * xscale;
   
   } else {
      hlfside = .005 * (spacetime_ymax - spacetime_ymin) * yscale;
   }
   nmdat = 0;
   datmin = 1.e30;
   datmax = -1.e30;
   for (;;) {
      if (checkeof_(4)) break;
      xval[nmdat] = fgetdble_(4);
      yval[nmdat] = fgetdble_(4);
      predtime = fgetdble_(4);
      dat[nmdat] = fgetdble_(4);
      xval[nmdat] = xshift + (xval[nmdat] - spacetime_xmin) * xscale;
      yval[nmdat] = yshift + (yval[nmdat] - spacetime_ymin) * yscale;
      if (dat[nmdat] < datmin) datmin = dat[nmdat];
      if (datmax < dat[nmdat]) datmax = dat[nmdat];
      ++nmdat;
      if (nmdat >= DATSZE) {
         printf_("First " + DATSZE + " points only are plotted.");
	 break;
      }
   }
   fclose_(4, 'r');

   // Modify data min, max values here.

   // Assign levels.

   level[0] = datmin;
   for (i = 1; i <= nmlevls; ++i) {
      level[i] = level[i - 1] + Math.abs(datmax - datmin) /
				    (double) nmlevls;
   }

   // Find interval containing zero and assign colors to level intervals.

   izero = 1;
   if (0. <= level[0]) {
      for (i = 1; i <= nmlevls; ++i) colors[i - 1] = i;

   } else if (level[0] < 0.) {
      for (i = 1; i < nmlevls - 1; ++i) {
         if (level[i - 1] <= 0. &&  0. < level[i]) izero = i;
      }

      /* Increasingly negative intervals receive increasingly negative colors,
         increasingly positive intervals receive increasingly positive colors.
         The interval that contains zero is colored 0. */

      for (i = 1; i <= nmlevls; ++i) colors[i - 1] = i - izero;
   }
   if (level[nmlevls] <= 0.) izero = nmlevls;

   // Now plot the data points as greyscale squares.

   for (i = 0; i < nmdat; ++i) {
      
      // Find level, assign a color and write polygon command.

      levelval = dat[i];

      // First and last colors are open intervals. 

      color = colors[0];
      for (k = 2; k <= nmlevls - 1; ++k) {
         if (level[k - 2] <= levelval && levelval < level[k - 1]) {
	    color = colors[k - 1];
	 }
      }

      if (level[nmlevls - 2] <= levelval) {
	 color = colors[nmlevls - 1];
      }

      if (xval[i] > hlfside && yval[i] > hlfside) {
         fprintf_(flenm, "POLYGON " + (xval[i] - hlfside) + " " +
	    (yval[i] - hlfside));
         fprintf_(flenm, "4 " + color);
         fprintf_(flenm, (xval[i] + hlfside) + " " + (yval[i] - hlfside));
         fprintf_(flenm, (xval[i] + hlfside) + " " + (yval[i] + hlfside));
         fprintf_(flenm, (xval[i] - hlfside) + " " + (yval[i] + hlfside));
      }
   }
}

// Create legend.

/*
printf_("Title and legend positions refer to their upper left corner.");
printf_("The plotting region is the unit square, and spaces are allowed");
printf_(" in strings.");
printf_(" `none' produces no title.");
*/

xtitle = .2;
ytitle = .9;
title = "none";
// printf_("title= " + title + " xtitle= " + xtitle + " ytitle= " + ytitle);

// Write title.

if (!title.equals("none")) {
   printf_("printing title");
   fprintf_(flenm, "SETCHARSIZE 20");
   fprintf_(flenm, "GRTEXT " + xtitle + " " + ytitle + " " + title);
}

if (surf == 1 || option == 5) {

   /* Plot gray-scale surface legend.  If legtitle units string is
      `none', no legend is displayed. */
   
   xlegend = .005;
   ylegend = .15;

   if (!legtitle.equals("none")) {
      printf_("printing legend...");

      fprintf_(flenm, "SETCHARSIZE 20" +
         "\nGRTEXT " + xlegend + " " + ylegend + " " + legtitle);

      fprintf_(flenm, "SETCHARSIZE 20");
      ylegend -= .031;
      for (i = 0; i < nmlevls; ++i) {
	 fprintf_(flenm, "MOVETO " + xlegend + " " + ylegend);
         fprintf_(flenm, "LINETO " + (xlegend + .015) + " " + ylegend);
         fprintf_(flenm, "LINETO " + (xlegend + .015) + " " +
	    (ylegend + .015));
         fprintf_(flenm, "LINETO " + xlegend + " " + (ylegend + .015));
         fprintf_(flenm, "LINETO " + xlegend + " " + ylegend);

         fprintf_(flenm, "POLYGON " + xlegend + " " + ylegend);
         fprintf_(flenm, "4 " + colors[i]);
         fprintf_(flenm, (xlegend + .015) + " " + ylegend);
         fprintf_(flenm, (xlegend + .015) + " " + (ylegend + .015));
         fprintf_(flenm, xlegend + " " + (ylegend + .015));
         fprintf_(flenm, "GRTEXT " + (xlegend + .03) + " " + ylegend +
	    " '" + lgndlbl[i] + "'");
         ylegend -= .03;
      }
   }

} else if (surf == 2) {

   // Draw axes and query for labels.

   fprintf_(flenm, "MOVETO " + xshift + " " +
      ((spacetime_ymax - spacetime_ymin) * yscale + yshift));
   fprintf_(flenm, "LINETO " + xshift + " " + yshift);
   fprintf_(flenm, "LINETO " +
      ((spacetime_xmax - spacetime_xmin) * xscale + xshift) + " " + yshift);

   xlab = "xlab";
   ylab = "ylab";

   xpos = (spacetime_xmax - spacetime_xmin) * xscale + xshift + .05;
   ypos = yshift - .05;
   fprintf_(flenm, "GRTEXT " + xpos + " " + ypos + " " + xlab);
   xpos = xshift - .09;
   ypos = (spacetime_ymax - spacetime_ymin) * yscale + yshift + .05;
   fprintf_(flenm, "GRTEXT " + xpos + " " + ypos + " " + ylab);

   // Draw axis labels and tic marks.

   xpos = xshift;
   ypos = yshift - .025;
   fprintf_(flenm, "GRTEXT " + xpos + " " + ypos + " " + spacetime_xmin);
   xpos = xshift - .06;
   ypos = yshift;
   fprintf_(flenm, "GRTEXT " + xpos + " " + ypos + " " + spacetime_ymin);

   for (i = 1; i <= 4; ++i) {

      // x axis.

      xpos = (spacetime_xmax - spacetime_xmin) * xscale *
         (.25 * ((double) i)) + xshift;
      ypos = yshift;
      fprintf_(flenm, "MOVETO " + xpos + " " + ypos);
      ypos = yshift + .03 * yscale;
      fprintf_(flenm, "LINETO " + xpos + " " + ypos);
      ypos = yshift - .025;
      fprintf_(flenm, "GRTEXT " + xpos + " " + ypos + " " +
         (spacetime_xmin + ((double) i) / 4. *
         (spacetime_xmax-spacetime_xmin)));

      // y axis.

      xpos = xshift;
      ypos = (spacetime_ymax - spacetime_ymin) * yscale *
         (.25 * ((double) i)) + yshift;
      fprintf_(flenm, "MOVETO " + xpos + " " + ypos);
      xpos = xshift + .03 * xscale;
      fprintf_(flenm, "LINETO " + xpos + " " + ypos);
      xpos = xshift - .06;
      fprintf_(flenm, "GRTEXT " + xpos + " " + ypos + " " +
         (spacetime_ymin + ((double) i) / 4. *
         (spacetime_ymax-spacetime_ymin)));
   }
}

// Plot boundary files.

pltbdry_(flenm, reglabels);

if (plotsites) {

   // Site or feature plotting.

   if (outsideonly) {
      printf_("pltsleg: ONLY SITES OUTSIDE REGIONS ARE PLOTTED");
   }

   fprintf_(flenm, "SETCHARSIZE 10");

   fleopen_(8, sitesfle, 'r');
   printf_(fgetline_(8) + "\n" + fgetline_(8));
   nmsplt = fgetint_(8);
   printf_("pltsleg: number of sites= " + nmsplt +
      " variable= " + fgetstrng_(8));
   fgetint_(8);
   for (i = 0; i < nmsplt; ++i) {
      xval[i] = fgetdble_(8);
      yval[i] = fgetdble_(8);
      xval[i] = xshift + (xval[i] - spacetime_xmin) * xscale;
      yval[i] = yshift + (yval[i] - spacetime_ymin) * yscale;
      sitesymbol[i] = fgetstrng_(8).charAt(0);

      // Plot site if it is not in a region.

      if (!outsideonly || (outsideonly && !inregn[i])) { 
	 /*
         fprintf_(flenm, "CGRTEXT " + xval[i] + " " + yval[i] + " " +
	    "numbersign"); // was '.'
	 xval[i] += .02;
	 */
         fprintf_(flenm, "CGRTEXT " + xval[i] + " " + yval[i] + " " +
	    sitesymbol[i]);
      }
   }
   fclose_(8, 'r');
}

if (spacetime_option == 3 || spacetime_option == 4) {

   // Location grid.

   pltgrid_(flenm);
}
}

// ----------------------------------------------------------------------

static void pltgrid_(int flenm) {

/* Creates a grid of grid point labels that are laid over the boundaries.
   This allows a discrete surface to be rasterized by hand.
   
   ***Note: The preferred method now is to use the "gistools" id relation
   and use the interactive tool "Digitize a surface."
   
   Procedure:
   1. Generate this plot, use nmrows = nmcols = 50 if using an 81/2 by
      11 piece of paper.
   2. To scale this label grid, measure the height and width of the
      surface boundaries to be rasterized and then multiply xscale and
      yscale in Surf.java by the ratio of these values to the original
      height and width of the label grid.  Regenerate the label grid.
   3. Make a transparency of the label grid and lay it over the surface.
   4. Make a list of all labels that are inside the region of a surface
      value.
   5. Run the command "convert_label-grid."

   Longitude-latitude discrete-surface grid file specification:
      Record 1: "Long-Lat Discrete Surface Grid"
      Record 2: min-longitude max-longitude min-latitude max-latitude
      Record 3: number-of-rows number-of-columns
      Remaining records: longitude latitude surface-value iblank
                         note that these records are the values of the
			 discrete surface at the grid-line intersections
			 (not the grid-cell centers).  How this file is
			 displayed is up to the display algorithms in
			 Pltsurf.java.
*/

int i, j, k, l, nmlbls, blank, dscrtval, intgr;
int rownm[] = new int[10000];
int colnm[] = new int[10000];
int dscrtsurf[][] = new int[ROWLIM][COLLIM];

double x, y, incx, incy, xdig, ydig, xdigmax, ydigmax;
double xval[] = new double[COLLIM];
double yval[] = new double[ROWLIM];

String alphbet[] = new String[26];
String addrss[] = new String[10000];

// First, check bounds.

if (spacetime_nmrows > ROWLIM) iderr_("pltgrid: nmrows= " +
   spacetime_nmrows + " > " + " ROWLIM= " + ROWLIM);
if (spacetime_nmcols > COLLIM) iderr_("pltgrid: nmcols= " +
   spacetime_nmcols + " > " + " COLLIM= " + COLLIM);

// Load alphabet array.  Note that m and w are lowercase.

alphbet[0] = "A";
alphbet[1] = "B";
alphbet[2] = "C";
alphbet[3] = "D";
alphbet[4] = "E";
alphbet[5] = "F";
alphbet[6] = "G";
alphbet[7] = "H";
alphbet[8] = "I";
alphbet[9] = "J";
alphbet[10] = "K";
alphbet[11] = "L";
alphbet[12] = "m";
alphbet[13] = "N";
alphbet[14] = "O";
alphbet[15] = "P";
alphbet[16] = "Q";
alphbet[17] = "R";
alphbet[18] = "S";
alphbet[19] = "T";
alphbet[20] = "U";
alphbet[21] = "V";
alphbet[22] = "w";
alphbet[23] = "X";
alphbet[24] = "Y";
alphbet[25] = "Z";

l = 0;
for (i = 0; i < 10; ++i) {
   for (j = 0; j < 26; ++j) {
      for (k = 0; k < 26; ++k) {
	 addrss[l] = i + alphbet[j] + alphbet[k];
	 ++l;
      }
   }
}

// Set character size and x, y increments.

fprintf_(flenm, "SETCHARSIZE 5.5");
incx = (spacetime_xmax - spacetime_xmin) / (double) (spacetime_nmcols - 1);
incy = (spacetime_ymax - spacetime_ymin) / (double) (spacetime_nmrows - 1);
xdigmax = xshift + (spacetime_xmax - spacetime_xmin) * xscale;
ydigmax = yshift + (spacetime_ymax - spacetime_ymin) * yscale;

l = 0;
y = spacetime_ymin;
for (i = 0; i < spacetime_nmrows; ++i) {
   x = spacetime_xmin;
   for (j = 0; j < spacetime_nmcols; ++j) {
      rownm[l] = i;
      colnm[l] = j;
      if (i == 0) xval[j] = x;
      yval[i] = y;
      xdig = xshift + (x - spacetime_xmin) * xscale;
      ydig = yshift + (y - spacetime_ymin) * yscale;
      if (spacetime_option == 3) {
         fprintf_(flenm, "CGRTEXT " + xdig + " " + ydig + " " +
            "'" + addrss[l] + "'");
      }
      ++l;
      x += incx;
   }
   y += incy;
}
nmlbls = l;

if (spacetime_option == 4) {

   /* Convert a label-grid file to standard "x,y,val,blank" format (.sgd
      file). */

   fleopen_(4, spacetime_labelfle, 'r');

   /* Read value of background (value that is not explicitly in
      the fle). */

   strng = fgetstrng_(4);
   if (!strng.equals("background")) iderr_("pltgrid: no background");
   dscrtval = fgetint_(4);
   for (i = 0; i < spacetime_nmrows; ++i) {
      for (j = 0; j < spacetime_nmcols; ++j) dscrtsurf[i][j] = dscrtval;
   }

   // Open .sgd file.

   fleopen_(5, spacetime_surffle[0], 'w');

   // Verify number of rows and columns agree.

   if (fgetint_(4) != spacetime_nmrows) iderr_("pltgrid: bad nmrows");
   if (fgetint_(4) != spacetime_nmcols) iderr_("pltgrid: bad nmcols");

   // Write header line to .sgd file.

   fprintf_(5, "1 " + spacetime_nmrows + " " + spacetime_nmcols +
      " " + spacetime_xmin + " " + spacetime_xmax +
      " " + spacetime_ymin + " " + spacetime_ymax +
      " " + 0. + " " + 1000000.);

   dscrtval = fgetint_(4);
   strng = fgetstrng_(4);
   if (!strng.equals("value")) iderr_("pltgrid: no value");

   // Read each label, check both for the next value and EOF.

   while (checkeof_(4) != true) {

      /* Read a string, if a "value" statement, start a new value.
	 Otherwise, find the corresponding (x, y) location. */

      intgr = fgetint_(4);
      strng = fgetstrng_(4);
      if (strng.equals("value")) {
         dscrtval = intgr;
         strng = fgetint_(4) + fgetstrng_(4);

      } else {
	 strng = intgr + strng;
      }

      for (l = 0; l < nmlbls; ++l) {
         if (strng.equals(addrss[l])) {
	    dscrtsurf[rownm[l]][colnm[l]] = dscrtval;
	    break;
         }
      }
   }
   fclose_(4, 'r');

   // Now, write the standard format file.

   for (i = 0; i < spacetime_nmrows; ++i) {
      for (j = 0; j < spacetime_nmcols; ++j) {

         /* Check for boundary membership, if any.  Set blank value
            accordingly. */

         blank = 1;
         for (k = 0; k < bdry_nmbdrys; ++k) {
            if (bdry_(bdry_nmbdpts[k], bdry_xbdry[k], bdry_ybdry[k],
               xval[j], yval[i]) > 0.) {
               blank = 0;
               break;
            }
         }

         fprintf_(5, xval[j] + " " + yval[i] + " " +
            fdble_((double) dscrtsurf[i][j], 3, 1) + " " + blank);
      }
   }
   fclose_(5, 'w');
}

/*
// Plot horizontal lines.

y = spacetime_ymin;
for (i = 0; i < spacetime_nmrows; ++i) {
   x = spacetime_xmin;
   xdig = xshift + (x - spacetime_xmin) * xscale;
   ydig = yshift + (y - spacetime_ymin) * yscale;
   fprintf_(flenm, "GRTEXT " + (xdig - .03) + " " + ydig + " " +
      (i + 1));
   fprintf_(flenm, "MOVETO " + xdig + " " + ydig);
   fprintf_(flenm, "LINETO " + xdigmax + " " + ydig);
   y += incy;
}

// Plot vertical lines.

x = spacetime_xmin;
for (i = 0; i < spacetime_nmcols; ++i) {
   y = spacetime_ymin;
   xdig = xshift + (x - spacetime_xmin) * xscale;
   ydig = yshift + (y - spacetime_ymin) * yscale;
   fprintf_(flenm, "GRTEXT " + xdig + " " + (ydig - .02) + " " +
      (i + 1));
   fprintf_(flenm, "MOVETO " + xdig + " "  + ydig);
   fprintf_(flenm, "LINETO " + xdig + " " + ydigmax);
   x += incx;
}
*/
}

// ----------------------------------------------------------------------

static void pltbdry_(int flenm, boolean labelregs) {

// Plot boundary file(s).  First, define clipping region.

boolean dash;

int i, j;

double xpos, ypos, regxcntr, regycntr;

clpxmin = 0.;
clpxmax = 1.;
clpymin = 0.;
clpymax = 1.;
fprintf_(flenm, "CLIP " + clpxmin + " " + clpxmax);
fprintf_(flenm, clpymin + " " + clpymax);

dash = false;
for (j = 0; j < bdry_nmbdrys; ++j) {

   // Move to first point.

   fprintf_(flenm, "MOVETO " +
      fdble_(xshift + (bdry_xbdry[j][0] - spacetime_xmin) * xscale, 5, 3) +
      " " +
      fdble_(yshift + (bdry_ybdry[j][0] - spacetime_ymin) * yscale, 5, 3));
   // if (dash) fprintf_(flenm, "SETDASH");

   // Set color of boundary line.

   if (bdry_reglabel[j].indexOf("At") >= 0 ||
       bdry_reglabel[j].indexOf("a") >= 0) {
      fprintf_(flenm, "SETCOLOR red");

   } else if (bdry_reglabel[j].indexOf("IP") >= 0 ||
              bdry_reglabel[j].indexOf("i") >= 0 ||
              bdry_reglabel[j].indexOf("TM") >= 0) {
      fprintf_(flenm, "SETCOLOR green");
   }

   regxcntr = 0.;
   regycntr = 0.;
   for (i = 1; i < bdry_nmbdpts[j]; ++i) {
      xpos = xshift + (bdry_xbdry[j][i] - spacetime_xmin) * xscale;
      ypos = yshift + (bdry_ybdry[j][i] - spacetime_ymin) * yscale;

      if (bdry_countrynm[j] == 0) {
         fprintf_(flenm, "ARROWTO " + fdble_(xpos, 5, 3) + " " +
            fdble_(ypos, 5, 3));

      } else {
         fprintf_(flenm, "LINETO " + fdble_(xpos, 5, 3) + " " +
            fdble_(ypos, 5, 3));
      }

   // if (dash) fprintf_(flenm, "SOLID");
      /*
      if (i == 1 || i == 3) {
         regxcntr += .2 * bdry_xbdry[j][i];
         regycntr += .2 * bdry_ybdry[j][i];
      
      } else if (i == 2) {
         regxcntr += .6 * bdry_xbdry[j][i];
         regycntr += .6 * bdry_ybdry[j][i];
      }
      */
      if (i == 1) {
         regxcntr = bdry_xbdry[j][i];
         regycntr = bdry_ybdry[j][i];
      }
   }
   
   if (labelregs && !bdry_reglabel[j].equals("Frame")) {
      
      // Label region.

      xpos = xshift + (regxcntr - spacetime_xmin) * xscale;
      ypos = yshift + (regycntr - spacetime_ymin) * yscale;
      fprintf_(flenm, "GRTEXT " + fdble_(xpos, 5, 3) + " " +
         fdble_(ypos, 5, 3) + " " + bdry_reglabel[j].substring(0,
            Math.min(bdry_reglabel[j].length(), 3)));
   } 
}
fprintf_(flenm, "SETCOLOR black");
}
}
