class Pltsurf extends Surf {
static String legtitle = "none";
static String surfnme[] = new String[4];
static String lgndlbl[] = new String[MAXNMLV];

static int nmmaplevels = 0, nmlevls = 0;

static int colors[] = new int[MAXNMLV+1];
static int lnectr[] = new int[MAXNMLV+1];
static int hexagon_blnk[] = new int[ROWLIM * COLLIM];
static int levelsmap[] = new int[MAXNMLV];

static double level[] = new double[MAXNMLV+1];
static double hexagon_x[][] = new double[ROWLIM * COLLIM][6];
static double hexagon_y[][] = new double[ROWLIM * COLLIM][6];
static double hexagon_level[] = new double[ROWLIM * COLLIM];
static double xpos[] = new double[8];
static double ypos[] = new double[8];
static double sortarry[] = new double[6];
static double khcx[] = new double[4000];
static double khcy[] = new double[4000];
static double khcflg[] = new double[4000];
static double relerrx[] = new double[4000];
static double relerry[] = new double[4000];
static double relerrv[] = new double[4000];

// ---------------------------------------------------------------------

static int pltsurf_(int surf, String sgdfle, int flenm, String ps_flenme) {

/* Reads a SAS-like grid surface file (x, y, z) and creates a  gray-scale
   or contour plot.  If two surfaces, plots a function of surfaces 1 and 2.
   "flenm": out.dig file number
   "ps_flenme": PostScript file name.

SURFACE OPTIONS (surf):
   0: boundary and sites only,
   1: boundary, sites, and surface,
   2: contour plot.

SURFACE PLOTTNG OPTIONS (option):
   1: One surface,
   2: Comparison of two surfaces: (surf2 - surf1) / surf2,
   3: Surface plotted if less than cut value of another surface,
   4: Overlay two surfaces,
   5: Spatial scatter plot of a data set,
   6: Percent confidence interval overlap. */

boolean wrterrh, negest = true, zoom = false;

String flenme;

int i, j, k, l, color = 1, nmsegpts, rowhex, colhex = 0, ikhc, irelerr,
   inbdry, polyblnk, nmsrfs = 0, nmhex = 0, nmvals, nmout, option = 1,
   nmcut, nmkhc, nmkblnk = 0, maplevel;

int iblank[][] = new int[3][NMPLTCOLS];

double est1, est2, std1, std2, levelval, xdif, ydif, xminz = 0.,
   xmaxz = 0., yminz = 0., ymaxz = 0., valx, valy, comp, scale, hexcenx,
   hexceny, cutval, dstmin, hexmin = 1.e20, hexmax = -1.e20, psscale,
   srfmean, zval, cil1, cil2, mostrecent = 1.;

double x[][] = new double[3][NMPLTCOLS];
double y[][] = new double[3][NMPLTCOLS];
double est[][] = new double[3][NMPLTCOLS];

// Initialize constants.

negest = true;
nmhex = 0;
nmkblnk = 0;
nmsrfs = 0;
hexmax = -1.e20;
hexmin = 1.e20;

// Set character size.

fprintf_(flenm, "SETCHARSIZE 10");

// Rotate grayscale plots.

if (surf == 2) {
   fprintf_(flenm, "SCALE 1.");

} else {
   fprintf_(flenm, "LANDSCAPE");
}

wrterrh = false;
if (option == 3) {
   wrterrh = true;
}

// STRTSRF:

++nmsrfs;

// Get surface multiplier constant.

scale = 1.;

/* Optionally, process zoom file.

if (zoom) {
   gprint("Enter name of zoom file:\n");
   gets(flenme);
   fp8 = fleopen_(zoom.dat","r");
   fscanf(fp8,"%d",&nmsegpts);

   // Find min and max of zoom boundary file.

   xminz = 1.e+10;
   yminz = 1.e+10;
   xmaxz = 0.;
   ymaxz = 0.;
   for (i = 1; i <= nmsegpts; ++i) {
      fscanf(fp8,"%lf%lf",&valx,&valy);
      if (valx < xminz) xminz = valx;
      if (valx > xmaxz) xmaxz = valx;
      if (valy < yminz) yminz = valy;
      if (valy > ymaxz) ymaxz = valy;
   }
   fclose(fp8);
} 
*/

// STRTCUT:

// Get surface file (*.sgd).

if (!wrterrh) {
   surfnme[0] = sgdfle;
   if (option == 2) {
      surfnme[1] = "surf2.sgd";
   
   } else if (option == 6) {
      surfnme[1] = "surf2.sgd";
      surfnme[2] = "surf3.sgd";
      surfnme[3] = "surf4.sgd";
   }

} else {

   // Get cut value.

   cutval = 0.;
}

if (option != 2 && option != 6 && surf > 0) {
   fleopen_(4, surfnme[0], 'r');
}

/*
} else if (option == 2) {
   fp8 = fleopen_(surfnme[0],"r");
   fp26 = fleopen_(surfnme[1],"r");
   fp20 = fleopen_("scratch","w+");

} else if (option == 6) {
   gprint("Enter the files est1, est2, std1, std2:\n");
   fp8 = fleopen_(surfnme[0],"r");
   fp26 = fleopen_(surfnme[1],"r");
   fp4 = fleopen_(surfnme[2],"r");
   fp5 = fleopen_(surfnme[3],"r");
   fp20 = fleopen_("scratch","w+");
}
*/

/* If cut is desired and wrterrh is true, write file of hex center, value
   of cut surface.  Otherwise read in cut surface centers.

if (option == 3 && wrterrh) {
   fp24 = fleopen_("relerr.out","w"); 

} else if (option == 3 && !wrterrh) {
   fp24 = fleopen_("khc.out","r");
   nmkhc = 0;
   while(fscanf(fp24,"%lf%lf%*lf%lf",
      &khcx[nmkhc],&khcy[nmkhc],&khcflg[nmkhc]) == 3) {
	 ++nmkhc;
   }
   fclose(fp24);

   fp24 = fleopen_("relerr.out","r");
   nmcut = 0;
   while(fscanf(fp24,"%lf%lf%lf",
      &relerrx[nmcut],&relerry[nmcut],&relerrv[nmcut]) == 3) {
	 ++nmcut;
   }
   fclose(fp24); 
} 

if (option == 2) {
   fscanf(fp26,"%*d%*d%*d%*lf%*lf%*lf%*lf%*lf%*lf");

} else if (option == 6) {
   fscanf(fp26,"%*d%*d%*d%*lf%*lf%*lf%*lf%*lf%*lf");
   fscanf(fp4,"%*d%*d%*d%*lf%*lf%*lf%*lf%*lf%*lf");
   fscanf(fp5,"%*d%*d%*d%*lf%*lf%*lf%*lf%*lf%*lf");
   zval = 1.96;
}

spacetime_estmin *= scale;
spacetime_estmax *= scale;
*/

// Can't do a cut surface if spacetime_grdtyp is 1.

if (spacetime_grdtyp == 1 && option == 3) {
   iderr_("pltsurf: spacetime_grdtyp=1, option=3.");
}

/* If comparing two or more surfaces, read surfaces from fp8 and fp26,
   and possibly fp4 and fp5.  Search for spacetime_estmax, spacetime_estmin,
   compute mean value, and write to fp20.

nmvals = 0;
srfmean = 0.;
if (option == 2 || option == 6) {
   spacetime_estmin = 1.e20;
   spacetime_estmax = -1.e20;
   while (
      fscanf(fp8,"%lf%lf%lf%d",&x[0][0],&y[0][0],&est1,&iblank[0][0]) == 4) {
      fscanf(fp26,"%lf%lf%lf%d",&x[0][1],&y[0][1],&est2,&iblank[0][1]);
      if (option == 2) {
         if (iblank[0][0] == 0 && iblank[0][1] == 0) {
  	    if (est2 == 0.) comp = 0.;
  	    else comp = 1. - est1 / est2;
	    fprintf(fp20,"%lf %lf %lf %d\n",
	       x[0][0],y[0][0],comp,iblank[0][0]);
	    if (comp > spacetime_estmax) spacetime_estmax = comp;
	    if (comp < spacetime_estmin) spacetime_estmin = comp;
	    srfmean += comp;
	    ++nmvals;
         } else fprintf(fp20,"%lf %lf %lf %d\n",x[0][0],y[0][0],0.,1);

      } else if (option == 6) {
         fscanf(fp4,"%lf%lf%lf%d",&x[0][2],&y[0][2],&std1,&iblank[0][2]);
         fscanf(fp5,"%lf%lf%lf%d",&x[0][3],&y[0][3],&std2,&iblank[0][3]);
         if (iblank[0][0] == 0 && iblank[0][1] == 0 &&
             iblank[0][2] == 0 && iblank[0][3] == 0) {
	    cil1 = 2. * zval * std1;
	    comp = MIN((est1 + zval * std1),(est2 + zval * std2)) -
		   MAX((est1 - zval * std1),(est2 - zval * std2));
	    comp = (cil1 - comp) / cil1;
	    if (comp < 0.) comp = 0.;
	    fprintf(fp20,"%lf %lf %lf %d\n",
	       x[0][0],y[0][0],comp,iblank[0][0]);
	    if (comp > spacetime_estmax) spacetime_estmax = comp;
	    if (comp < spacetime_estmin) spacetime_estmin = comp;
	    srfmean += comp;
	    ++nmvals;
         } else fprintf(fp20,"%lf %lf %lf %d\n",x[0][0],y[0][0],0.,1);
      }
   }
   fclose(fp8);
   fclose(fp26);
   if (option == 6) {
      fclose(fp4);
      fclose(fp5);
   }
   rewind(fp20);

   // Print out min, max, and average comparison.

   gprint("Minimum comp= %lf Maximum comp= %lf\n",spacetime_estmin,
      spacetime_estmax);
   if (nmvals > 0) gprint("Average comp= %lf\n",srfmean / (double) nmvals);
}
*/

// Read input grid files and create rectangles or hexagons.

for (l = 0; l < spacetime_nminfles; ++l) {

   // Read or set surface file characteristics.

   if (surf > 0) {
      fgetline_(4);
      fgetline_(4);
      spacetime_grdtyp = fgetint_(4);
      spacetime_nmrows = fgetint_(4);
      spacetime_nmcols = fgetint_(4);

      /* Use max, mins found previously if processing multiple input
	 grid files. */

      if (spacetime_nminfles == 1) {
         spacetime_xmin = fgetdble_(4);
         spacetime_xmax = fgetdble_(4);
         spacetime_ymin = fgetdble_(4);
         spacetime_ymax = fgetdble_(4);
         spacetime_estmin = fgetdble_(4);
         spacetime_estmax = fgetdble_(4);

      } else {
	 fgetdble_(4);
	 fgetdble_(4);
	 fgetdble_(4);
	 fgetdble_(4);
	 fgetdble_(4);
	 fgetdble_(4);
      }
      printf_("pltsurf: estmin= " + spacetime_estmin + " estmax= " +
         spacetime_estmax);

   } else {
      spacetime_grdtyp = 1;
   }

   // If zooming, find width and height of plot.

   if (zoom) {
      spacetime_xmin = xminz;
      spacetime_xmax = xmaxz;
      spacetime_ymin = yminz;
      spacetime_ymax = ymaxz;
   }

   // Set scale, and x, y-shifts.

   xdif = spacetime_xmax - spacetime_xmin;
   ydif = spacetime_ymax - spacetime_ymin;
   xscale = xdif;
   if (ydif > xdif) {
      xscale = ydif;
   }
   xscale = .75 * (1. / xscale);
   yscale = xscale;
   xshift = .05;
   yshift = .05;

   printf_("pltsurf: xdif= " + fdble_(xdif, 6, 3) + " ydif= " +
      fdble_(ydif, 6, 3) +
      "\n    xscale= " + fdble_(xscale, 6, 3) + " yscale= " +
      fdble_(yscale, 6, 3) +
      "\n   xshift= " + fdble_(xshift, 6, 3) + " yshift= " +
      fdble_(yshift, 6, 3));

   if (surf == 0 || option == 5) {

      if (surf > 0) {
      
         // Close input grid file.

         fclose_(4, 'r');
      }

      /* Only plot boundaries and possibly sampling locations.  Then, close
         the "out.dig" file. */

      Pltsleg.pltsleg_(flenm, option, surf, legtitle);
      fclose_(flenm, 'w');

      // Create a PostScript file.

      Pltpost.pltpost_(ps_flenme, 1.4);

      return 0;
   }

   // Rectangular grid type processing.

   if (spacetime_grdtyp == 1) {
      for (k = 0; k < nmlevls; ++k) {
         lnectr[k] = 0;
      }

      // Find levels and colors.

      Colors.colors_(spacetime_estmax, spacetime_estmin);
      fprintf_(flenm, "SETNUMCOLOR " + nmlevls);

      // Step 1, read in first row of surface.

      for (j = 1; j <= spacetime_nmcols; ++j) {
         x[0][j - 1] = fgetdble_(4);
         y[0][j - 1] = fgetdble_(4);
         est[0][j - 1] = fgetdble_(4);
         iblank[0][j - 1] = fgetint_(4);

         x[0][j-1] -= spacetime_xmin;
         y[0][j-1] -= spacetime_ymin;

	 // Transform from map-levels if necessary.

	 if (nmmaplevels > 0 && est[0][j - 1] > 0.) {
	    maplevel = (int) est[0][j - 1];
	    est[0][j - 1] = (double) levelsmap[maplevel - 1];
	 }
         est[0][j - 1] *= scale;
      }

      // Process row-wise.

      for (i = 1; i <= spacetime_nmrows - 1; ++i) {

         // Read in a row.

         for (j = 0; j < spacetime_nmcols; ++j) {
	    x[1][j] = fgetdble_(4);
	    y[1][j] = fgetdble_(4);
	    est[1][j] = fgetdble_(4);
	    iblank[1][j] = fgetint_(4);

            x[1][j] -= spacetime_xmin;
            y[1][j] -= spacetime_ymin;

	    // Transform from map-levels if necessary.

	    if (nmmaplevels > 0 && est[1][j] > 0.) {
	       maplevel = (int) est[1][j];
	       est[1][j] = (double) levelsmap[maplevel - 1];
	    }

	    // Filter "est" values.

	    if (iblank[1][j] == 0) {
	       if (est[1][j] < spacetime_estmin) {
	          est[1][j] = mostrecent;

	       } else {
	          mostrecent = est[1][j];
	       }
	    }

            est[1][j] *= scale;
         }

         for (j = 1; j <= spacetime_nmcols - 1; ++j) {

            // Process this rectangle.

            xpos[0] = xshift + x[0][j-1] * xscale;
            ypos[0] = yshift + y[0][j-1] * yscale;
            xpos[1] = xshift + x[0][j] * xscale;
            ypos[1] = yshift + y[0][j] * yscale;
            xpos[2] = xshift + x[1][j] * xscale;
            ypos[2] = yshift + y[1][j] * yscale;
            xpos[3] = xshift + x[1][j-1] * xscale;
            ypos[3] = yshift + y[1][j-1] * yscale;

            // Blank rectangle if 2 or more vertices are outside boundary.

            nmout = 0;
            if (iblank[0][j - 1] == 1) ++nmout;
            if (iblank[0][j] == 1) ++nmout;
            if (iblank[1][j] == 1) ++nmout;
            if (iblank[1][j - 1] == 1) ++nmout;
            if (nmout >= 2) polyblnk = 1;
            else polyblnk = 0;

	    if (surf == 1) {

               /* For each rectangle, find level (average of the 4
	          vertices), assign a color and write polygon command. */

               color = 0;
	       if (polyblnk == 0) {
                  levelval = (est[0][j - 1] + est[0][j] + est[1][j] +
		              est[1][j - 1]) / 4.;
	          if (levelval < level[0]) {
		     color = colors[0];
	          }
                  for (k = 0; k < nmlevls; ++k) {
                     if (level[k] <= levelval && levelval < level[k + 1]) {
		        color = colors[k];
	             }
	          }
                  if (level[nmlevls] <= levelval) {
		     color = colors[nmlevls - 1];
	          }

               }

	       // Do not plot invisible rectangles.

	       if (color != 0) {
                  fprintf_(flenm, "POLYGON " + xpos[0] + " " + ypos[0]);
                  fprintf_(flenm, "4 " + color);
                  for (k = 2; k <= 4; ++k) {
                     fprintf_(flenm, xpos[k - 1] + " " + ypos[k - 1]);
                  }
               }

	    } else if (surf == 2) {

	       /* Divide rectangle into 4 triangles and draw contour line
	          crossings.

	       for (k = 0; k < nmlevls - 1; ++k) {
	          contour_(xpos[0], ypos[0], est[0][j - 1], xpos[1], ypos[1],
		     est[0][j], xpos[2], ypos[2], est[1][j], xpos[3],
		     ypos[3], est[1][j - 1], level[k], 5, lnectr, k, nmsrfs);
	       }
	       */
	    }
         }

         // Ratchet arrays.

         for (j = 1; j <= spacetime_nmcols; ++j) {
            x[0][j - 1] = x[1][j - 1];
            y[0][j - 1] = y[1][j - 1];
            est[0][j - 1] = est[1][j - 1];
	    iblank[0][j - 1] = iblank[1][j - 1];
         }
      } // End of row loop.

// Hexagon grid type processing.

} else if (spacetime_grdtyp == 2) {

   // Step 1, read in first 2 rows of surface.

   for (i = 0; i < 2; ++i) {
      for (j=0; j < spacetime_nmcols; ++j) {
	 x[i][j] = fgetdble_(4);
	 y[i][j] = fgetdble_(4);
	 est1 = fgetdble_(4);
	 iblank[i][j] = fgetint_(4);
	 est[i][j] = est1;
	 x[i][j] -= spacetime_xmin;
         y[i][j] -= spacetime_ymin;
         est[i][j] *= scale;
      }
   }

   /* Main loop: read in a row, find level, assign a color and write polygon
      command. */

   rowhex = 0;
   for (i = 1; i <= spacetime_nmrows - 2; ++i) {
      printf_("Starting row " + i);

      // Toggle row hexagon position switch.

      if (rowhex == 0) {
         rowhex = 1; 
         colhex = 0;

      } else if (rowhex == 1) {
         rowhex = 0;
         colhex = 1;
      }

      // Read in needed third row of estimates.

      for (j = 0; j < spacetime_nmcols; ++j) {
	 x[2][j] = fgetdble_(4);
	 y[2][j] = fgetdble_(4);
	 est1 = fgetdble_(4);
	 iblank[2][j] = fgetint_(4);

	 est[2][j] = est1;
	 x[2][j] -= spacetime_xmin;
         y[2][j] -= spacetime_ymin;
         est[2][j] *= scale;
      }

      for (j = 1; j <= spacetime_nmcols - 1; ++j) {

      // Check if we are at the lower left vertex of a hexagon.

         if (colhex == 0) colhex = 1;
         else if (colhex == 1) colhex = 0;
         if (colhex == 1) {
            color = 0;

            // Level is the mean of the 6 corners.

            sortarry[0] = est[0][j - 1];
            sortarry[1] = est[1][j - 1];
            sortarry[2] = est[2][j - 1];
            sortarry[3] = est[2][j];
            sortarry[4] = est[1][j];
            sortarry[5] = est[0][j];
	    levelval = 0.;
	    for (k = 0; k < 6; ++k) {
	       levelval += sortarry[k];
	    }
	    levelval /= 6.;

	    /* If negative estimates are not allowed, reset estimate
	       to zero. */
	    
	    if (!negest && levelval < 0.) {
	       levelval = 0.;
            }

            xpos[0] = x[0][j - 1];
            ypos[0] = y[0][j - 1];
            xpos[1] = x[0][j];
            ypos[1] = y[0][j];
            xpos[2] = x[1][j];
            ypos[2] = y[1][j];
            xpos[3] = x[2][j];
            ypos[3] = y[2][j];
            xpos[4] = x[2][j - 1];
            ypos[4] = y[2][j - 1];
            xpos[5] = x[1][j - 1];
            ypos[5] = y[1][j - 1];
            xpos[6] = xpos[0];
	    ypos[6] = ypos[0];

	    // Compute hexagon center.

	    hexcenx = 0.;
	    hexceny = 0.;
	    for (k = 0; k < 6; ++k) {
	       hexcenx += xpos[k];
	       hexceny += ypos[k];
	    }
	    hexcenx *= .16667;
	    hexceny *= .16667;

	    /* Blank hexagon if 3 or more vertices are outside boundary. */

	    polyblnk = 0;
	    nmout = 0;
	    if (iblank[0][j - 1] == 1) ++nmout;
	    if (iblank[0][j] == 1) ++nmout;
	    if (iblank[1][j] == 1) ++nmout;
	    if (iblank[2][j] == 1) ++nmout;
	    if (iblank[2][j - 1] == 1) ++nmout;
	    if (iblank[1][j - 1] == 1) ++nmout;
            if (nmout >= 3) polyblnk = 1;

	    /* Write this center if relative error centers are being found.

	    if (option == 3) {
	       if (wrterrh) {
                  fprintf(fp24,"%lf %lf %lf\n",hexcenx,hexceny,level); 
                  goto NEXT;

	       } else if (!wrterrh) {

	          // See if any of the blanking file points are inside this
		  // hexagon.  If so, check for the blanking value (!= 0).

	          for (ikhc = 0; ikhc < nmkhc; ++ikhc) {
                     bdry_(7, xpos, ypos, khcx[ikhc], khcy[ikhc], &inbdry,
		        &dstmin);
                     if (inbdry == 1 && khcflg[ikhc] != 0.) {
		        ++nmkblnk;
		        color = 0;
		        break;
		     }
	          }

	          // Find the corresponding cut file hexagon.

	          irelerr = 0;
	          do {
	             ++irelerr;
	             if (irelerr > nmcut) {
			iderr_("pltsurf: relerr failure.");
		     }
	          } while( fabs(hexcenx-relerrx[irelerr - 1])
		      + fabs(hexceny-relerry[irelerr - 1]) > .001); 
             
	          // Check for hexagon blanking due to surface being
		  // above cut value.

	          if (relerrv[irelerr - 1] > cutval) color = 0; 
	       }
            }
	    */

	    // Translate to plotting coordinates.

	    for (k = 0; k < 6; ++k) {
	       xpos[k] = xshift + xscale * xpos[k];
	       ypos[k] = yshift + yscale * ypos[k];
	    }

	    // Find min, max and write this hexagon to the plotting array.

	    if (levelval < hexmin) {
	       hexmin = levelval;
	    }
	    if (hexmax < levelval) {
	       hexmax = levelval;
            }

	    hexagon_blnk[nmhex] = polyblnk;
	    hexagon_level[nmhex] = levelval;
	    for (k = 0; k < 6; ++k) {
	       hexagon_x[nmhex][k] = xpos[k];
	       hexagon_y[nmhex][k] = ypos[k];
	    }
	    ++nmhex;

// NEXT:

	    continue;
         }
      }

      // Ratchet row buffers.

      for (j = 0; j < spacetime_nmcols; ++j) {
         x[0][j] =           x[1][j];
         y[0][j] =           y[1][j];
         est[0][j] =       est[1][j];
         iblank[0][j] = iblank[1][j];

         x[1][j] =           x[2][j];
         y[1][j] =           y[2][j];
         est[1][j] =       est[2][j];
         iblank[1][j] = iblank[2][j];
      }
   }
} // End of grdtyp == 2 option.
} // End of loop over input grid files.

/* If cutting on a surface, process surface to be cut.

if (option == 3 && wrterrh) {
   wrterrh = false;
   rewind(fp24);
   goto STRTCUT;
}
*/

/* If overlaying two surfaces, plot second surface with dashed lines.

if (option == 4) {
   if (nmsrfs < 2) {
      if (surf == 2) fprintf_(flenm, "SETDASH");
      goto STRTSRF;

   } else if (nmsrfs == 2 && surf == 2) fprintf_(flenm, "SOLID");
}
*/

if (spacetime_grdtyp == 2) {
   printf_("Number of khc blanks= " + nmkblnk);

   // Find levels and colors.

   Colors.colors_(hexmin, hexmax);
   fprintf_(flenm, "SETNUMCOLOR " + nmlevls);

   // Write the hexagon plotting commands.

   for (i = 0; i < nmhex; ++i) {
   
      // Find hexagon color.

      if (hexagon_blnk[i] == 1) {

         // If hexagon is out of boundary, set color to clear.

         color = 0;

      } else if (hexagon_blnk[i] == 0) {
         if (hexagon_level[i] < level[0]) {
	    color = colors[0];
	 }

         for (k = 0; k < nmlevls; ++k) {
            if (level[k] <= hexagon_level[i] &&
	        hexagon_level[i] < level[k + 1]) color = colors[k];
         }

         if (level[nmlevls] <= hexagon_level[i]) {
	    color = colors[nmlevls - 1];
	 }
      }

      // Write plotting commands.

      fprintf_(flenm, "POLYGON " + hexagon_x[i][0] + " " +
         hexagon_y[i][0] +
         "\n6 " + color);

      for (k = 1; k < 6; ++k) {
	 fprintf_(flenm, hexagon_x[i][k] + " " + hexagon_y[i][k]);
      }
   }
}

// Close input grid file.

if (option != 2 && option != 6 && surf > 0) {
   fclose_(4, 'r');
}

/* Plot title, legend, and optionally, sampling locations.  Then, close
   the "out.dig" file. */

Pltsleg.pltsleg_(flenm, option, surf, legtitle);
fclose_(flenm, 'w');

// Create a PostScript file of this surface.

Pltpost.pltpost_(ps_flenme, 1.4);

return 0;
}
}
