class Pxp extends Readnet {

static boolean cnstrntsonly = false, badsum = false, prntssum = false;

static String vartype[] = new String[OPTSIZE];
static String nodename[] = new String[OPTSIZE];

static int beginpars, begincnstrnts, xi = 0, ci = 0, ndeparm = 0, flenm = 0;

static int idownerm1[] = new int[OPTSIZE];

static double tol = .001;

static double previousnodeval[] = new double[OPTSIZE];
static double previousxval[] = new double[OPTSIZE];
static double prbvec[] = new double[OPTSIZE];


// -----------------------------------------------------------------------

public Pxp() {
int index;

for (index = 0; index < OPTSIZE; ++index) {
   vartype[index] = "unknown";
}
}

// -----------------------------------------------------------------------

static int pxp_(int dirxtn, double x[], double g[], double h[], int dst,
   int startpars, int startcnstrnts, boolean onlycnstrnts) {

/* Transfers parameter values to and from the probabilty-parameter
   array, "condprb" and the optimization vector, "x."

   x:    Parameter vector.
   dst:  "condprb" distribution to use as either a target or a source.

   dirxtn = -1: condprb...[1] <-- condprb[0]
   dirxtn = 0:  condprb...[dstm1] --> x
   dirxtn = 1:  x --> condprb...[dstm1]

   When prntssum=true, a Discrete node's conditional distributions are
   searched only at the points defined in "getdistpttrn_" which are
   indexed by the sum of the values of the node's parents. */

int i, j, j1, j2, j3, j4, j5, j6, retval, nmvarsfornode, nmnghs;

if (dirxtn > -1) {
   cnstrntsonly = onlycnstrnts;
   beginpars = startpars;
   begincnstrnts = startcnstrnts;
}

badsum = false;

// Main loop.

xi = beginpars;
ci = begincnstrnts;

NDELOOP: for (i = 1; i <= nmnds; ++i) {

   // Check if the parameters of this node are to be estimated.

   if (dirxtn > -1 && !varinfo_parest[idnmbrm1][i - 1]) {
      continue;

   } else if (dirxtn == -1 && !Parlearn.learnnode[idnmbrm1][i - 1]) {
      printf_("pxp: dirxtn=-1, node " + i + " not a learn node, continuing.");
      continue;
   }

   /*
   printf_("pxp: ID= " + idname[idnmbrm1] + " i= " + i + " parest= " +
      varinfo_parest[idnmbrm1][i - 1]);
   */

   /* Get number of values (or parameters), and number of parents.
      Initialize parameter index. */

   if (varinfo_dist[idnmbrm1][i - 1].equals("Determ_Contin") ||
       varinfo_dist[idnmbrm1][i - 1].equals("Discrete") ||
       varinfo_dist[idnmbrm1][i - 1].equals("Logit")) {
      nmvarsfornode = nodenghs[idnmbrm1][i - 1][0];

   } else {

      /* All other nodes such as a Determ_Discrete, use the number
	 of parameters for the number of optimization variables on
	 the node. */

      nmvarsfornode = varinfo_nmparms[idnmbrm1][i - 1];
   }

   nmnghs = nodenghs[idnmbrm1][i - 1][1];
   ndeparm = 0;

   /*
   if (dirxtn == 0) {
      printf_("pxp: i= " + i + " dist= " + varinfo_dist[idnmbrm1][i - 1] +
         " nmnghs= " + nmnghs + " nmvarsfornode= " + nmvarsfornode +
         " dirxtn= " + dirxtn);
   }
   */

   // Transfer values depending on the number of parents.

   if (nmnghs == 0) {
      retval = trnsfr_(i, dirxtn, x, g, h, dst, nmvarsfornode, 0, 0, 0,
	 0, 0, 0);

   } else if (nmnghs == 1) {
      ngh1 = nodenghs[idnmbrm1][i - 1][2];
      nmvalngh1 = nodenghs[idnmbrm1][ngh1 - 1][0];
      for (j1 = 0; j1 < nmvalngh1; ++j1) {
         
	 /* For an MPEMP, only load parameters relevant to the out-action,
	    "poach_for_protection" of the Number_Poached node. */
        
	 if (findmpemp &&
             (!nodelbls[idnmbrm1][ngh1 - 1][j1 + 1].equals("poach_for_protection"))) {
            continue;
         }

         retval = trnsfr_(i, dirxtn, x, g, h, dst, nmvarsfornode, j1,
	    0, 0, 0, 0, 0);

         if (retval == 1) {
	    continue NDELOOP;
	 }
      }

   } else if (nmnghs == 2) {
      ngh1 = nodenghs[idnmbrm1][i - 1][2];
      ngh2 = nodenghs[idnmbrm1][i - 1][3];
      nmvalngh1 = nodenghs[idnmbrm1][ngh1 - 1][0];
      nmvalngh2 = nodenghs[idnmbrm1][ngh2 - 1][0];
      for (j1 = 0; j1 < nmvalngh1; ++j1){
         for (j2 = 0; j2 < nmvalngh2; ++j2){
            retval = trnsfr_(i, dirxtn, x, g, h, dst, nmvarsfornode, j1,
	       j2, 0, 0, 0, 0);

            if (retval == 1) {
	       continue NDELOOP;
	    }
         }
      }

   } else if (nmnghs == 3) {
      ngh1 = nodenghs[idnmbrm1][i - 1][2];
      ngh2 = nodenghs[idnmbrm1][i - 1][3];
      ngh3 = nodenghs[idnmbrm1][i - 1][4];
      nmvalngh1 = nodenghs[idnmbrm1][ngh1 - 1][0];
      nmvalngh2 = nodenghs[idnmbrm1][ngh2 - 1][0];
      nmvalngh3 = nodenghs[idnmbrm1][ngh3 - 1][0];
      for (j1 = 0; j1 < nmvalngh1; ++j1){

         /* For either a CA run or an MPEMP run, only load parameters relevant to the
	    out-action: "poach_for_cash". */
        
         if ((cacalc || findmpemp) &&
             (!nodelbls[idnmbrm1][ngh1 - 1][j1 + 1].equals("poach_for_cash"))) {
            continue;
         }

         for (j2 = 0; j2 < nmvalngh2; ++j2){
            for (j3 = 0; j3 < nmvalngh3; ++j3){
               retval = trnsfr_(i, dirxtn, x, g, h, dst, nmvarsfornode,
		  j1, j2, j3, 0, 0, 0);

               if (retval == 1) {
		  continue NDELOOP;
	       }
            }
         }
      }

   } else if (nmnghs == 4) {
      ngh1 = nodenghs[idnmbrm1][i - 1][2];
      ngh2 = nodenghs[idnmbrm1][i - 1][3];
      ngh3 = nodenghs[idnmbrm1][i - 1][4];
      ngh4 = nodenghs[idnmbrm1][i - 1][5];
      nmvalngh1 = nodenghs[idnmbrm1][ngh1 - 1][0];
      nmvalngh2 = nodenghs[idnmbrm1][ngh2 - 1][0];
      nmvalngh3 = nodenghs[idnmbrm1][ngh3 - 1][0];
      nmvalngh4 = nodenghs[idnmbrm1][ngh4 - 1][0];
      for (j1 = 0; j1 < nmvalngh1; ++j1){
         for (j2 = 0; j2 < nmvalngh2; ++j2){
            for (j3 = 0; j3 < nmvalngh3; ++j3){
               for (j4 = 0; j4 < nmvalngh4; ++j4){
                  retval = trnsfr_(i, dirxtn, x, g, h, dst,
		     nmvarsfornode, j1, j2, j3, j4, 0, 0);

                  if (retval == 1) {
		     continue NDELOOP;
		  }
               }
            }
         }
      }

   } else if (nmnghs == 5) {
      ngh1 = nodenghs[idnmbrm1][i - 1][2];
      ngh2 = nodenghs[idnmbrm1][i - 1][3];
      ngh3 = nodenghs[idnmbrm1][i - 1][4];
      ngh4 = nodenghs[idnmbrm1][i - 1][5];
      ngh5 = nodenghs[idnmbrm1][i - 1][6];
      nmvalngh1 = nodenghs[idnmbrm1][ngh1 - 1][0];
      nmvalngh2 = nodenghs[idnmbrm1][ngh2 - 1][0];
      nmvalngh3 = nodenghs[idnmbrm1][ngh3 - 1][0];
      nmvalngh4 = nodenghs[idnmbrm1][ngh4 - 1][0];
      nmvalngh5 = nodenghs[idnmbrm1][ngh5 - 1][0];
      for (j1 = 0; j1 < nmvalngh1; ++j1){
         for (j2 = 0; j2 < nmvalngh2; ++j2){
            for (j3 = 0; j3 < nmvalngh3; ++j3){
               for (j4 = 0; j4 < nmvalngh4; ++j4){
                  for (j5 = 0; j5 < nmvalngh5; ++j5){
                     retval = trnsfr_(i, dirxtn, x, g, h, dst,
			nmvarsfornode, j1, j2, j3, j4, j5, 0);

                     if (retval == 1) {
			continue NDELOOP;
		     }
                  }
               }
            }
         }
      }

   } else if (nmnghs == 6) {
      ngh1 = nodenghs[idnmbrm1][i - 1][2];
      ngh2 = nodenghs[idnmbrm1][i - 1][3];
      ngh3 = nodenghs[idnmbrm1][i - 1][4];
      ngh4 = nodenghs[idnmbrm1][i - 1][5];
      ngh5 = nodenghs[idnmbrm1][i - 1][6];
      ngh6 = nodenghs[idnmbrm1][i - 1][7];
      nmvalngh1 = nodenghs[idnmbrm1][ngh1 - 1][0];
      nmvalngh2 = nodenghs[idnmbrm1][ngh2 - 1][0];
      nmvalngh3 = nodenghs[idnmbrm1][ngh3 - 1][0];
      nmvalngh4 = nodenghs[idnmbrm1][ngh4 - 1][0];
      nmvalngh5 = nodenghs[idnmbrm1][ngh5 - 1][0];
      nmvalngh6 = nodenghs[idnmbrm1][ngh6 - 1][0];
      for (j1 = 0; j1 < nmvalngh1; ++j1){
         for (j2 = 0; j2 < nmvalngh2; ++j2){
            for (j3 = 0; j3 < nmvalngh3; ++j3){
               for (j4 = 0; j4 < nmvalngh4; ++j4){
                  for (j5 = 0; j5 < nmvalngh5; ++j5){
                     for (j6 = 0; j6 < nmvalngh6; ++j6){
                        retval = trnsfr_(i, dirxtn, x, g, h, dst,
			   nmvarsfornode, j1, j2, j3, j4, j5, j6);

                        if (retval == 1) {
			   continue NDELOOP;
			}
		     }
                  }
               }
            }
         }
      }
   }
}

return 0;
}

// ----------------------------------------------------------------------

static int trnsfr_(int i, int dirxtn, double x[], double g[], double h[],
   int dst, int nmvarsfornode, int j1, int j2, int j3, int j4, int j5,
   int j6) {

int j, k, retval, dstm1 = dst - 1;

double abeta, bbeta, prbsum, nodeval = 0., diff = 0.;

/* Transfers optimization vector components to ID parameters and
   visa-versa.  Also sets bounds. */

if (varinfo_dist[idnmbrm1][i - 1].equals("Discrete-Beta")) {

   /* If the node has a Beta distribution, then:
      dirxtn = 0: place a, b into x,
      dirxtn=1: use a, b from x to fit a new distribution to the node. */

   if (dirxtn == 0) {

      if ( xi >= OPTSIZE) {
	 iderr_("trnsfr: xi= " + xi + ">=OPTSIZE");
      }

      x[xi] = betaprb[i - 1][0][j1][j2][j3][j4][j5][j6][dstm1];
      x[xi + 1] = betaprb[i - 1][1][j1][j2][j3][j4][j5][j6][dstm1];
      vartype[xi] = "Discrete-Beta";

   } else if (dirxtn == 1) {
      abeta = x[xi];
      bbeta = x[xi + 1];

      // If a boundary is violated, use the closest value.

      if (abeta < 1.) abeta = 1.;
      if (abeta > 6.) abeta = 6.;
      if (bbeta < 1.) bbeta = 1.;
      if (bbeta > 6.) bbeta = 6.;

      betaprb[i - 1][0][j1][j2][j3][j4][j5][j6][dstm1] = abeta;
      betaprb[i - 1][1][j1][j2][j3][j4][j5][j6][dstm1] = bbeta;
      densfit_(nmvarsfornode, prbvec);
      for (k = 0; k < nmvarsfornode; ++k) {
         condprb[idnmbrm1][i - 1][k][j1][j2][j3][j4][j5][j6][dstm1] =
	    prbvec[k];
      }
   }
   xi += 2;

} else if (varinfo_dist[idnmbrm1][i - 1].equals("Discrete")) {

   // Discrete nodes.

   if (dirxtn == -1) {
      hyptocons_(i, nmvarsfornode, j1, j2, j3, j4, j5, j6);

   } else if (dirxtn == 0) {
      if (prntssum) {
         xi = j1 + j2 + j3;
         if (condprb[idnmbrm1][i - 1][0][j1][j2][j3][j4][j5][j6][0] >
             condprb[idnmbrm1][i - 1][1][j1][j2][j3][j4][j5][j6][0] +
             condprb[idnmbrm1][i - 1][2][j1][j2][j3][j4][j5][j6][0]) {
            x[xi] = 1.;
         
         } else if (
            condprb[idnmbrm1][i - 1][2][j1][j2][j3][j4][j5][j6][0] >
             condprb[idnmbrm1][i - 1][0][j1][j2][j3][j4][j5][j6][0] +
             condprb[idnmbrm1][i - 1][1][j1][j2][j3][j4][j5][j6][0]) {
            x[xi] = 4.;

         } else {
            x[xi] = 2.;
	 }

         g[xi] = 1.0;
	 h[xi] = 4.0;

	 vartype[xi] = "Discrete";
         idownerm1[xi] = idnmbrm1;
         nodename[xi] = nodelbls[idnmbrm1][i - 1][0];

         ++xi;
         if ( xi >= OPTSIZE) {
            iderr_("trnsfr: xi= " + xi + ">OPTSIZE");
         }
         ndeparm = xi;

      } else {
         for (k = 0; k < nmvarsfornode; ++k) {

	    if ( xi >= OPTSIZE) {
	       iderr_("trnsfr: xi= " + xi + ">OPTSIZE");
            }

            x[xi] = condprb[idnmbrm1][i - 1][k][j1][j2][j3][j4][j5][j6][dstm1];
            g[xi] = varinfo_bounds[idnmbrm1][i - 1][ndeparm][0];
            h[xi] = varinfo_bounds[idnmbrm1][i - 1][ndeparm][1];
            vartype[xi] = "Discrete";
            idownerm1[xi] = idnmbrm1;
            nodename[xi] = nodelbls[idnmbrm1][i - 1][0];

	    /* Write plotting file.
	    if (grph_label[idnmbrm1][i - 1].equals("SMMG")) {
	       fprintf_(flenm, " " + dst + " " + (j1 + 1) + " " +
                  (j2 + 1) + " " + (k + 1) + " " +
		  fdble_(x[xi], 5, 3));
            }
            */

	    // Increment counters.

	    ++xi;
	    if (xi >= OPTSIZE) {
	       iderr_("trnsfr: xi= " + xi + ">OPTSIZE");
	    }
	    ++ndeparm;
	 }
      }

   } else {
      if (prntssum) {
         
	 // Sum of parent values determines variable number.

         xi = j1 + j2 + j3;
	 getdistpttrn_(nmvarsfornode, ((int) x[xi]), prbvec);
      }
      prbsum = 0.;
      for (k = 0; k < nmvarsfornode; ++k) {

	 if (!prntssum) {

	    // Get current optimization vector component value.

            prbvec[k] = x[xi];
            ++xi;
         }

	 /* Note infeasibility if parameter is not a probability or
            an allowed-value for a Directed Graph, i.e., all states
	    must have nonzero probability. */

	 if (prbvec[k] <= 0. || prbvec[k] >= 1.) {
	    iderr_("trnsfr: infeasible: node= " +
	       nodelbls[idnmbrm1][i - 1][0] +
	       "\n   k= " + k + " idnmbrm1= " + idnmbrm1 +
	       " prbvec= " + prbvec[k] + " dirxtn= " + dirxtn + " prntssum= " + prntssum);
         }

	 // Sum the optimization variable values.

         prbsum += prbvec[k];
      }

      // Normalize and load the distribution.

      for (k = 0; k < nmvarsfornode; ++k) {
         condprb[idnmbrm1][i - 1][k][j1][j2][j3][j4][j5][j6][dstm1] =
            prbvec[k] / prbsum;
      }
   }

} else if (varinfo_dist[idnmbrm1][i - 1].equals("Logit")) {

   // Logit nodes.

   if (dirxtn == 0) {
      for (k = 0; k < varinfo_nmparms[idnmbrm1][i - 1]; ++k) {

	 if ( xi >= OPTSIZE) {
            iderr_("trnsfr: xi= " + xi + ">OPTSIZE");
         }

	 x[xi] = logit_pars[idnmbrm1][i - 1][k];
	 g[xi] = varinfo_bounds[idnmbrm1][i - 1][ndeparm][0];
	 h[xi] = varinfo_bounds[idnmbrm1][i - 1][ndeparm][1];
         vartype[xi] = "Logit";
         idownerm1[xi] = idnmbrm1;
         nodename[xi] = nodelbls[idnmbrm1][i - 1][0];

	 ++xi;
	 if ( xi >= OPTSIZE) {
	    iderr_("trnsfr: xi= " + xi + ">OPTSIZE");
	 }
	 ++ndeparm;
      }

   } else {
      for (k = 0; k < varinfo_nmparms[idnmbrm1][i - 1]; ++k) {
	 if (!cnstrntsonly) {
	    logit_pars[idnmbrm1][i - 1][k] = x[xi];
	 }
	 ++xi;
      }
   }
   
   return 1;

} else if (varinfo_dist[idnmbrm1][i - 1].equals("SDE") ||
           varinfo_dist[idnmbrm1][i - 1].equals("HIBM") ||
           varinfo_dist[idnmbrm1][i - 1].equals("PIBM") ||
           varinfo_dist[idnmbrm1][i - 1].equals("R_Horn_ABM") ||
           varinfo_dist[idnmbrm1][i - 1].equals("M_Network_ABM") ||
           varinfo_dist[idnmbrm1][i - 1].equals("SMS") ||
           varinfo_dist[idnmbrm1][i - 1].equals("Determ_Discrete") ||
           varinfo_dist[idnmbrm1][i - 1].equals("Determ_Linear") ||
           varinfo_dist[idnmbrm1][i - 1].equals("Determ_Contin")) {

   /* SDE, HIBM, PIBM, ABM, SMS, Determ_Discrete, Determ_Linear, or
      Determ_Contin (Utility) node. */

   if (dirxtn == 0) {
      for (k = 0; k < nmvarsfornode; ++k) {
         
	 /* Something similar to this should be done for the other distribution
	    types, above. */

	 if (!varinfo_dist[idnmbrm1][i - 1].equals("Determ_Contin")) {
	    ++ndeparm;

	 } else if (nodenghs[idnmbrm1][i - 1][1] == 1) {
            ndeparm = j1 + 1;
	 }

	 /* To fit the intercalving interval only in the rhino model.
         if (k != 2) {
            continue;
         }
         */

	 ++xi;
	 if ( xi >= OPTSIZE) {
	    iderr_("trnsfr: xi= " + xi + ">OPTSIZE");
	 }

         x[xi - 1] = condprb[idnmbrm1][i - 1][k]
                            [j1][j2][j3][j4][j5][j6][dstm1];
         previousxval[xi - 1] = x[xi - 1];
         previousnodeval[xi - 1] = x[xi - 1];

	 // Lower bound.

         g[xi - 1] = varinfo_bounds[idnmbrm1][i - 1][ndeparm - 1][0];

	 // Upper bound.

         h[xi - 1] = varinfo_bounds[idnmbrm1][i - 1][ndeparm - 1][1];

         if (g[xi - 1] >= h[xi - 1]) {
            iderr_("trnsfr: i= " + i + " ndeparm= " + ndeparm + " g= " +
	       g[xi - 1] + " h= " + h[xi - 1]);
         }
         vartype[xi - 1] = varinfo_dist[idnmbrm1][i - 1];
         idownerm1[xi - 1] = idnmbrm1;
         nodename[xi - 1] = nodelbls[idnmbrm1][i - 1][0];

	 if (nmids == 1 && phenomenon_class[0].equals("ecosystem") &&
            k == (CA.n - 1)) {
            return 1;
         }
      }

   } else {
      for (k = 0; k < nmvarsfornode; ++k) {
	 
         /* To fit the intercalving interval only in the rhino model.
         if (k != 2) {
            continue;
         }
	 */

         ++xi;

	 /*
	 if (i < 10) {
	    printf_("trnsfr: i= " + i + " j1= " + j1 + " j2= " + j2 +
	       "\n j3= " + j3 + " j4= " + j4 + " j5= " + j5 + " j6= " +
	       j6 + " dst= " + dst);
	    printf_("trnsfr: k= " + k + " x= " + x[xi - 1] - 1);
	 }
         */

	 if (varinfo_dist[idnmbrm1][i - 1].equals("Determ_Discrete")) {
	 
	    // Determ_Discrete node processing.

	    /* Note: the following code is replaced by the code in
	       "hooke" that sets "delta" appropriately for either an
	       ordinal or a continuously-valued variable.
	    if (previousxval[xi - 1] < x[xi - 1]) {
               nodeval = previousnodeval[xi - 1] + 1.;
	    } else if (Math.abs(previousxval[xi - 1] - x[xi - 1]) < 1.e-6) {
	       nodeval = previousnodeval[xi - 1];
	    } else {
	       nodeval = previousnodeval[xi - 1] - 1.;
	    }
            if (Math.abs(x[xi - 1] - previousxval[xi - 1]) > 1.e-6) {
               printf_("trnsfr: node= " + grph_label[idnmbrm1][i - 1] +
		  " nodediff= " + (nodeval - previousnodeval[xi - 1]) +
		  " xdiff= " + (x[xi - 1] - previousxval[xi - 1]));
            }
	    previousnodeval[xi - 1] = nodeval;
            previousxval[xi - 1] = x[xi - 1];
            */

	    nodeval = x[xi - 1];

	    // If "nodeval" is not in [1, nmvals], say so and quit.

	    nmvals = nodenghs[idnmbrm1][i - 1][0];
	    if (nodeval < 1.) {
	       printf_("trnsfr: xi= " + xi + " g= " + g[xi - 1] +
		  " h= " + h[xi - 1]);
	       iderr_("  node= " + nodelbls[idnmbrm1][i - 1][0] +
		  " Determ_Discrete val= " + nodeval);

	    } else if (nodeval > (double) nmvals) {
	       printf_("trnsfr: xi= " + xi + " g= " + g[xi - 1] +
		  " h= " + h[xi - 1]);
	       iderr_("  node= " + nodelbls[idnmbrm1][i - 1][0] +
		  " Determ_Discrete val= " + nodeval);
	    }

	 } else {
	    nodeval = x[xi - 1];
	 }

	 /*
         diff = condprb[idnmbrm1][i - 1][k][j1][j2][j3][j4][j5][j6][dstm1]
	    - nodeval;
	 if (Math.abs(diff) > 1.e-6) {
	    printf_("pxp: continuous var xi= " + xi + " diff= " + diff);
         }
	 if (k == 0) {
	    printf_("trnsfr: idnmbrm1= " + idnmbrm1 + " node= " + i +
	       " dst= " + dst + " N0= " + nodeval);
         }
         */

         if (!cnstrntsonly) {
            condprb[idnmbrm1][i - 1][k][j1][j2][j3][j4][j5][j6][dstm1] =
	       nodeval;
	    /*
	    printf_("trnsfr: dst= " + dst + " cnstrntsonly= " +
               cnstrntsonly + " xi= " + xi + " nodeval= " + x[xi]);
	    */
	 }

	 if (nmids == 1 && phenomenon_class[0].equals("ecosystem") &&
            k == (CA.n - 1)) {

            return 1;
         }
      }
   }
}
return 0;
}

// ---------------------------------------------------------------------

static int densfit_(int n, double x[]) {

/* Finds the probability mass function of a discrete random variable with
   n values that is closest to the Beta(a,b) density function.  Returns
   this parameter vector in x.*/

int i, err = 0;

double ysum, lower, upper;

iderr_("densfit is broken");

// Set the initial distribution to be uniform.

for (i = 0; i < n; ++i) {
   x[i] = 1. / (double) n;
}

/* Find values of x that minimize the sum of squares between the
   x-values (discrete probabilities) and the Beta density function values
   at the same support points. */

lower = .01;
upper = .99;

// err = optimization_algorithm_(n,x);

// Reset any infeasible optimization vector component to the boundary value.

ysum = 0.;
for (i = 0; i < n; ++i) {
   if (x[i] < lower) {
      x[i] = lower;
   }

   if (upper < x[i]) {
      x[i] = upper;
   }

   ysum += x[i];
}

return err;
}

// --------------------------------------------------------------------

static void getdistpttrn_(int nmvals, int pttrnnm, double pttrn[]) {

/* Returns a discrete distribution of a node that has "nmvals" values.
   First, load the different distributions. */


if (nmvals == 2) {
   if (pttrnnm == 1) {
      pttrn[0] = .9;
      pttrn[1] = .1;

   } else if (pttrnnm == 2) {
      pttrn[0] = .5;
      pttrn[1] = .5;

   } else if (pttrnnm == 3) {
      pttrn[0] = .1;
      pttrn[1] = .9;
   
   } else {
      iderr_("getdistpttrn: nmvals= " + nmvals + " pttrnnm= " + pttrnnm);
   }

} else if (nmvals == 3) {
   if (pttrnnm == 1) {
      pttrn[0] = .8;
      pttrn[1] = .15;
      pttrn[2] = .05;

   } else if (pttrnnm == 2) {
      pttrn[0] = .6;
      pttrn[1] = .3;
      pttrn[2] = .1;

   } else if (pttrnnm == 3) {
      pttrn[0] = .1;
      pttrn[1] = .3;
      pttrn[2] = .6;

   } else if (pttrnnm == 4) {
      pttrn[0] = .05;
      pttrn[1] = .15;
      pttrn[2] = .8;

   } else {
      iderr_("getdistpttrn: nmvals= " + nmvals + " pttrnnm= " + pttrnnm);
   }

} else {
   iderr_("getdistpttrn: nmvals= " + nmvals + " pttrnnm= " + pttrnnm);
}
}

// ----------------------------------------------------------------------

static void hyptocons_(int i, int nmvarsfornode, int j1, int j2, int j3,
   int j4, int j5, int j6) {

// Copies the hypothesis distribution to the consistent distribution.

int k;

for (k = 0; k < nmvarsfornode; ++k) {
   condprb[idnmbrm1][i - 1][k][j1][j2][j3][j4][j5][j6][1] =
      condprb[idnmbrm1][i - 1][k][j1][j2][j3][j4][j5][j6][0];
}
}
}
