public class Quad extends Id {
static boolean rtf;

static int splmin, splmax, splout, nomax, nofin, spl, nim, i, j, jj, nofun,
  fnm;

static double a, b, result, errest, abserr = 1.e-6, relerr = 1.e-6, flag, w0,
   w1, w2, w3, w4, area, x0, f0, s1, s2, cor11, temp, qprev, qnow, qdiff,
   qleft, esterr, tolerr;

static double qright[] = new double[31];
static double f[] = new double[16];
static double x[] = new double[16];
static double fsave[][] = new double[8][30];
static double xsave[][] = new double[8][30];

// -------------------------------------------------------------------

static double adquad_(int fnmber, double lower, double upper) {

/* Adaptive quadrature.  From Hultquist, P. F. (1988), Numerical
   Methods for Engineers and Computer Scientists, Menlo Park, CA:
   The Benjamin/Cummings Publishing Company, Inc., pp. 230-236. 

   An adaptive Newton-Cotes nine-point integration scheme.

   a: lower limit of integration interval
   b: upper limit of integration interval
   result: estimated value of integral
   errest: estimate of the magnitutde of the error
   nofun: number of evaluations of fun(x) made during the integration
          process
   abserr: absolute error tolerance (non-negative)
   relerr: relative error tolerance (non-negative)
   flag: reliability indicator.  If flag is zero, then result is
         probably good to the least restrictive error tolerance.  if
         flag is xxx.yyy (nonzero), then xxx is the number of which have
         converged, and 0.yyy is the fraction of the whole interval left
         to do when the limit on nofun was reached.
   fun(x): the user must furnish a function fun(x) for the integrand
           function.  */

fnm = fnmber;
a = lower;
b = upper;

/* Used for the test function in fun_().
a = 0.;
b = 10.;
*/

splmin = 1;
splmax = 30;
splout = 6;
nomax = 1000;
nofin = nomax - 8 * (splmax - splout) + ((int) (Math.pow(2., splout + 1)));

// If nofun reaches nofin then we have trouble.

w0 = 3956.0 / 14175.0;
w1 = 23552.0 / 14175.0;
w2 = -3712.0 / 14175.0;
w3 = 41984.0 / 14175.0;
w4 = -18160.0 / 14175.0;

// Initialize sums.

flag = 0.;
result = 0.;
cor11 = 0.;
area = 0.;
errest = 0.;
nofun  = 0;

if (a != b) {

   // Initialize.

   initialize_();
   rtf = false;
   do {
      mainclc_();

      // Interval convergence test.

      esterr = Math.abs(qdiff) / 1023.;
      tolerr = Math.max(abserr, relerr * Math.abs(area)) * (s1 / s2);

      if (spl < splmin) leveldown_();
      else if (spl >= splmax) flagincr_();
      else if (nofun > nofin) trouble_();
      else if (esterr <= tolerr) sumup_();
      else leveldown_();
   } while (rtf == false);
}

printf_("adquad: result= " + result + " errest= " + errest + " nofun= " +
   nofun);

return result;
}

// --------------------------------------------------------------------

static void mainclc_() {

/* Central calculation.  Calculates x1, ..., x15, f1, ..., f15, qleft,
   qright, qnow, qdiff, and area from x0, x2, ..., x16, and f0, f2,
   ..., f16. */

x[0] = (x0 + x[1]) / 2.;
f[0] = fun_(x[0]);
for (jj = 1; jj <= 7; ++jj) {
   j = jj * 2 + 1;
   x[j - 1] = (x[j - 2] + x[j]) / 2.;
   f[j - 1] = fun_(x[j - 1]);
}
nofun += 8;
s1 = (x[15] - x0) / 16.;

qleft = (w0 * (f0 + f[7]) +
         w1 * (f[0] + f[6]) +
         w2 * (f[1] + f[5]) +
         w3 * (f[2] + f[4]) +
         w4 *  f[3]) * s1;

qright[spl] = (w0 * (f[7] + f[15]) +
               w1 * (f[8] + f[14]) +
               w2 * (f[9] + f[13]) +
               w3 * (f[10] + f[12]) +
               w4 * f[11]) * s1;

qnow = qleft + qright[spl];
qdiff = qnow - qprev;
area += qdiff;
}

// ------------------------------------------------------------------

static void leveldown_() {

// No convergence, locate the next interval.

nim = 2 * nim;
++spl;

// Store right-hand elements for the future.

for (i = 1; i <= 8; ++i) {
   fsave[i - 1][spl - 1] = f[i + 7];
   xsave[i - 1][spl - 1] = x[i + 7];
}

// Store left-hand elements for use now.

qprev = qleft;
for (i = 1; i <= 8; ++i) {
   j = -i;
   f[2 * j + 17] = f[j + 8];
   x[2 * j + 17] = x[j + 8];
}
}

// --------------------------------------------------------------------

static void setreturn_() {

// Finalization in preparation for return.

result += cor11;

// Make sure that errest is not less than roundoff.

printf_("setreturn: errest= " + errest);
if (errest != 0.) {
   temp = Math.abs(result) + errest;
   if (temp == Math.abs(result)) {
      do {
         errest = 2. * errest;
         temp = Math.abs(result) + errest;
      } while (temp == Math.abs(result));
   }
}
rtf = true;
}

// --------------------------------------------------------------------

static void sumup_() {

// Add contributions into running sums.

result += qnow;
errest += esterr;
cor11 += qdiff / 1023.;

// Find next interval.

while (nim != 2. * (nim / 2)) {
   nim = (nim / 2);
   --spl;
}
++nim;

if (spl <= 0) {
   setreturn_();

} else {

   // Gather elements for next interval.

   qprev = qright[spl - 1];
   x0 = x[15];
   f0 = f[15];
   for (i = 1; i <= 8; ++i) {
      f[2 * i - 1] = fsave[i - 1][spl - 1];
      x[2 * i - 1] = xsave[i - 1][spl - 1];
   }
}
}

// --------------------------------------------------------------------

static void trouble_() {

// Trouble; number of function values about to exceed limit.

nofin *= 2;
splmax = splout;
flag += (b - x0) / (b - a);
sumup_();
}

// ---------------------------------------------------------------------

static void flagincr_() {

// Current level is splmax.

flag += 1.;
sumup_();
}

// ---------------------------------------------------------------------

static void initialize_() {

// Initialization for first interval.

spl = 0;
nim = 1;
x0 = a;
x[15] = b;
qprev = 0.;
f0 = fun_(x0);
s2 = (b - a) / 16.;
x[7] = (x0 + x[15]) / 2.;
x[3] = (x0 + x[7]) / 2.;
x[11] = (x[7] + x[15]) / 2.;
x[1] = (x0 + x[3]) / 2.;
x[5] = (x[3] + x[7]) / 2.;
x[9] = (x[7] + x[11]) / 2.;
x[13] = (x[11] + x[15]) / 2.;
for (j = 1; j <= 8; ++j) {
   f[2 * j - 1] = fun_(x[2 * j - 1]);
}
nofun = 9;
}

// --------------------------------------------------------------------

static double fun_(double x) {

// Integrand function.

double val1, val2, retval = 0.;

/* Test function.  The integral over the interval (0, 10) should be 5.0.
retval = .5 + .5 * (1. - Math.exp(-.05 * x)) * Math.sin(x * x);
printf_("fun: x= " + x + " retval= " + retval);
if (true) return retval;
*/

if (fnm <= 2) {
   /* Expected value (fnm = 1) and variance (fnm = 2) of a function of a
      gaussian random variable.
   val1 = Math.exp(-.5 * x * x) / Math.sqrt(PIT2);
   val2 = Trnsfrm.backtrns_(x);
   if (fnm == 2) {
      val2 = Math.pow(val2 - Trnsfrm.expval[Trnsfrm.k - 1], 2);
   }
   retval = val1 * val2;
   */
} else if (fnm == 3) {

   // Evaluate the heading utility function.

   retval = SMScalcs.hdutilityfcn_(x);
}

return retval;
}
}
