import java.io.File;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.coverage.grid.*;
import org.opengis.coverage.grid.*;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.OverviewPolicy;

public class Readgeotiff extends GISutils {

// ---------------------------------------------------------------------

public static void readgeotiff_(String animalfilename) throws Exception {

int i, j, k, w, h, numBands;

double lat, lon, minval = 1.e6, maxval = 0.;

File file = new File(animalfilename);

ParameterValue<OverviewPolicy> policy =
   AbstractGridFormat.OVERVIEW_POLICY.createValue();
policy.setValue(OverviewPolicy.IGNORE);

/* Setting read type: use JAI ImageRead (true) or
   ImageReaders read methods (false). */

GridCoverage2DReader reader = new GeoTiffReader(file);
GridEnvelope dimensions = reader.getOriginalGridRange();
GridCoordinates maxDimensions = dimensions.getHigh();

w = maxDimensions.getCoordinateValue(0)+1;
h = maxDimensions.getCoordinateValue(1)+1;
numBands = reader.getGridCoverageCount();

ParameterValue<Boolean> useJaiRead =
   AbstractGridFormat.USE_JAI_IMAGEREAD.createValue();
useJaiRead.setValue(true); // was true

// This will basically read 4 tiles worth of data at once from the disk...

ParameterValue<String> gridsize =
   AbstractGridFormat.SUGGESTED_TILE_SIZE.createValue();

GridCoverage2D coverage = reader.read(
new GeneralParameterValue[]{policy, gridsize, useJaiRead});
GridGeometry2D geometry = coverage.getGridGeometry();

// Check image size.

Run_id.printf_("readgeotiff: w= " + w + " h= " + h + " numBands= " + numBands);

if (w > MAXNMPXLS || h > MAXNMPXLS) {
   Run_id.printf_("readgeotiff: w= " + w + " h= " + h + " one is too big.");
   Run_id.iderr_("in readgeotiff");
}

// Read each pixel's colors and store them in an array.

for (i=0; i<w; i++) {
   for (j=0; j<h; j++) {
      org.geotools.geometry.Envelope2D pixelEnvelop =
      geometry.gridToWorld(new GridEnvelope2D(i, j, 1, 1));
      lat = pixelEnvelop.getCenterY();
      lon = pixelEnvelop.getCenterX();
      double[] vals = new double[numBands];
      coverage.evaluate(new GridCoordinates2D(i, j), vals);

      for (k = 0; k < numBands; ++k) {
	 if (vals[k] < minval) {
            minval = vals[k];
	 }
	 if (maxval < vals[k]) {
            maxval = vals[k];
	 }
         pxlbandval[i][j][k] = (int) vals[k];
      }
   }
}
Run_id.iderr_("readgeotiff: minval= " + minval + " maxval= " + maxval);

}
}
