class Readnet extends Id {
static boolean newdst = false, usebig = false, rdpflag = true;

static boolean createarray[] = new boolean[TNMIDS];

static int ngh1, ngh2, ngh3, ngh4, ngh5, ngh6, ngh7, nmvalngh1, nmvalngh2,
   nmvalngh3, nmvalngh4, nmvalngh5, nmvalngh6, nmvalngh7, pltnm,
   parmfle = 0, nmvals, nmnghs;

static int nmndepars[] = new int[TNMNDS];

static double bdspct = 3.;

static double xpltvals[][] = new double[100][TNMVALS];
static double ypltvals[][][] = new double[100][TNMVALS][TNMVALS];
static double condprb[][][][][][][][][][] =
   new double[TNMIDS][TNMNDS][][][][][][][][];
static double betaprb[][][][][][][][][] =
   new double[TNMNDS][][][][][][][][];
static double logit_pars[][][] = new double[TNMIDS][TNMNDS][NMWRPAR];

// --------------------------------------------------------------------------

static void readnet_(String flename, int flenm, int nmnds, int dstnm) {

/* Reads a conditional distribution file.  The Hypothesis distribution
   is "dstnm" = 1.  The initial consistent distribution is "dstnm" = 2
   in the array "condprb."

   If "newdst" is true, all conditional distributions are generated as
   uniform. */

boolean test = false;

String strng = "not_read_yet", vname = "none", dumstrng = "none";

int i, j, j1, j2, j3, j4, j5, j6, j7, k, k1, nmtoread = 0;

double prb, unif = 0.;

// Set printing flag.

if (nmids > 1 && !test) {
   rdpflag = false;
}

// Open distribution file on file number 1.

if (!newdst) {
   parmfle = flenm + 1;

   fleopen_(parmfle, flename, 'r');

   if (rdpflag) {
      printf_("\nreadnet: idname= " + thisidname +
	 " reading dists file " + flename + " into dstnm= " + dstnm);
   }

   // Read 2-line title.

   strng = fgetline_(parmfle);
   if (rdpflag) {
      printf_("readnet: title1= " + strng);
   }

   strng = fgetline_(parmfle);
   if (rdpflag) {
      printf_("readnet: title2= " + strng);
   }
}

/* Loop through all nodes to create one of "condprb," or "betaprb"
   subarrays and and place probabilities or parameters therein. */

for (i = 0; i < nmnds; ++i) {

   // Set the range for continuous nodes.

   if (varinfo_dist[idnmbrm1][i].equals("SDE") ||
      varinfo_dist[idnmbrm1][i].equals("HIBM") ||
      varinfo_dist[idnmbrm1][i].equals("PIBM") ||
      varinfo_dist[idnmbrm1][i].equals("LOMAP") ||
      varinfo_dist[idnmbrm1][i].equals("GLOMAP") ||
      varinfo_dist[idnmbrm1][i].equals("Determ_Linear")) {
      varinfo_range[idnmbrm1][i][0] = -1.e6;
      varinfo_range[idnmbrm1][i][1] = 1.e6;

   } else if (varinfo_dist[idnmbrm1][i].equals("Determ_Frctn")) {
      varinfo_range[idnmbrm1][i][0] = 0.;
      varinfo_range[idnmbrm1][i][1] = 1.;
   }
   
   // Find the number of nodes to be read.

   if (!varinfo_dist[idnmbrm1][i].equals("Determ_Decision") &&
       !varinfo_dist[idnmbrm1][i].equals("Determ_Root") &&
       !varinfo_dist[idnmbrm1][i].equals("Determ_Ratio")) {
      ++nmtoread;
   }
}

if (rdpflag) {
   printf_(
   "\n-----------------------------------------------------------------"
 + "\n i |     Node Being Read     | nmvals or nmparms | nmnghs" +
   "\n-----------------------------------------------------------------");
}

i = 0;
for (k1 = 1; k1 <= nmtoread; ++k1){

   // Get or read node name.

   if (newdst) {

      // Find next non-root node.

      do {
         ++i;
      } while(varinfo_dist[idnmbrm1][i - 1].equals("Determ_Decision") ||
       varinfo_dist[idnmbrm1][i - 1].equals("Determ_Root") ||
       varinfo_dist[idnmbrm1][i - 1].equals("Determ_Ratio"));

      vname = grph_label[idnmbrm1][i - 1];

   } else {

      if (checkeof_(parmfle)) {
	 printf_("readnet: k1= " + k1 + " nmtoread= " + nmtoread);
	 iderr_("readnet: should not be at EOF on file " + flename);
      }

      // Throw away "Node:" and then read node name.

      strng = fgetstrng_(parmfle);
      if (!strng.equals("Node:")) {
	 printf_("readnet: idname= " + thisidname + " last vname= " +
            vname);
	 iderr_("readnet: strng= " + strng + " should be:   Node:");
      }
      vname = fgetstrng_(parmfle);
   }
   i = Getmodlutils.getndnm_(vname);

   /* Read the number of parents and then determine the node's number of
      values.
      
      !!Note that for a logit node, the conditional probabilities are
      read here AND the logit model parameters are read below with
      "loadlogit_." */

   nmnghs = nodenghs[idnmbrm1][i - 1][1];
   if (varinfo_dist[idnmbrm1][i - 1].equals("Determ_Discrete") ||
              varinfo_dist[idnmbrm1][i - 1].equals("Determ_Temporal") ||
              varinfo_dist[idnmbrm1][i - 1].equals("Determ_Contin") ||
              varinfo_dist[idnmbrm1][i - 1].equals("Discrete") ||
              varinfo_dist[idnmbrm1][i - 1].equals("Logit")) {
      nmvals = nodenghs[idnmbrm1][i - 1][0];

   } else {
      nmvals = varinfo_nmparms[idnmbrm1][i - 1];
   }

   if (test || rdpflag) {
      printf_(" " + i + "  " + fstrng_(vname, 30) +
	 "         " + nmvals + "           " + nmnghs);

      if (varinfo_dist[idnmbrm1][i - 1].equals("Discrete-Beta")) {
         printf_("Beta density fitted node.");
      }
   }

   // Assign new probability or parameter values or read existing ones.

   if (newdst) {
      if (varinfo_dist[idnmbrm1][i - 1].equals("Determ_Discrete")) {

         /* Default value for a "Determ_Discrete" type node is it's
	    approximate middle value no matter what the parental
	    conditioning pattern is. */

	 unif = (double) (nmvals / 2);

      } else if (varinfo_dist[idnmbrm1][i - 1].equals("Determ_Temporal")) {
         
         unif = 0.;

      } else {

	 // Default value for all other node types.

         unif = 1. / (double) nmvals;
      }

   } else {

      /* In the existing .par file, throw away "Value_Labels:" or
	 "Parameters:" strings and associated labels. */

      strng = fgetstrng_(parmfle);
      if (!strng.equals("Value_Labels:") &&
          !strng.equals("Parameters:")) {
	     iderr_("strng= " + strng + " is not Value_Labels or" +
		" Parameters");
      }
      if (strng.equals("Parameters:")) {
   
         // Read or assign parameter bounds.

         for (j1 = 0; j1 < nmvals; ++j1) {

	    /* Throw away parameter name.  Note that this call to
	       fgetstrng does not write to "strng." */

            fgetstrng_(parmfle);

            varinfo_bounds[idnmbrm1][i - 1][j1][0] = fgetdble_(parmfle);
            varinfo_bounds[idnmbrm1][i - 1][j1][1] = fgetdble_(parmfle);

	    /*
	    printf_("lower= " + varinfo_bounds[idnmbrm1][i-1][j1][0] +
               " upper= " + varinfo_bounds[idnmbrm1][i-1][j1][1]);
	    */
         }

      } else {

         // Read and throw away value labels.

         for (j1 = 0; j1 < nmvals; ++j1) {
	    dumstrng = fgetstrng_(parmfle);
	 }
      }

      if (nmnghs > 0) {

         // Throw away "Parents:" string.

         strng = fgetstrng_(parmfle);
         if (!strng.equals("Parent:") &&
             !strng.equals("Parents:")) {
            iderr_("readnet: " + strng + " is not Parent or Parents");
         }

         // Throw away parent names.

         for (k = 0; k < nmnghs; ++k) {
            dumstrng = fgetstrng_(parmfle);
         }
         /*
	 printf_("readnet: strng= " + strng + " last dumstrng= " + dumstrng);
         */
      }
   
      /* For this node, read any CPT rules listed in the existing .par
	 file. */

      //Cptrules.cptrules_(i);
   }

   /* For each node, depending on its number of parents, first create
      the appropriately-dimensioned subarray and then read the node's
      parameter values into it. */

   pltnm = 1;
   nmndepars[i - 1] = 0;
   if (nmnghs == 0){
      if (!createarray[idnmbrm1]) {
         if (varinfo_dist[idnmbrm1][i - 1].equals("Discrete-Beta")) {
	    betaprb[i - 1] = new double[2][1][1][1][1][1][1][2];

         } else {
            condprb[idnmbrm1][i - 1] = new double[nmvals]
						 [1][1][1][1][1][1][2];
	 }
      }
      loadprb_(i, 1, 1, 1, 1, 1, 1, 1, nmvals, nmnghs, unif, dstnm);

   } else if (nmnghs == 1) {
      ngh1 = nodenghs[idnmbrm1][i - 1][2];
      nmvalngh1 = nodenghs[idnmbrm1][ngh1 - 1][0];

      if (nmvalngh1 == 1 &&
	  varinfo_dist[idnmbrm1][i - 1].equals("Logit")) {
      
	 /* For a Logit node with a continuous predictor, store
	    representative distributions on 3 values of the predictor. */

	 nmvalngh1 = 3;
      }
	 
      if (!createarray[idnmbrm1]) {
         if (varinfo_dist[idnmbrm1][i - 1].equals("Discrete-Beta")) {
	    betaprb[i - 1] = new double[2][nmvalngh1][1][1][1][1][1][2];

         } else {
            condprb[idnmbrm1][i - 1] =
	       new double[nmvals][nmvalngh1][1][1][1][1][1][2];
	 }
      }

      /*
      printf_("readnet: ID= " + thisidname + " node= " +
	 nodelbls[idnmbrm1][i - 1][0] + " nmvals= " + nmvals +
	 " nmvalngh1= " + + nmvalngh1);
      */

      for (j1 = 1; j1 <= nmvalngh1; ++j1) {
         loadprb_(i, j1, 1, 1, 1, 1, 1, 1, nmvals, nmnghs, unif, dstnm);
      }

   } else if (nmnghs == 2) {
      ngh1 = nodenghs[idnmbrm1][i-1][2];
      ngh2 = nodenghs[idnmbrm1][i-1][3];
      nmvalngh1 = nodenghs[idnmbrm1][ngh1-1][0];
      nmvalngh2 = nodenghs[idnmbrm1][ngh2-1][0];

      if (nmvalngh1 == 1 && nmvalngh2 == 1 &&
	  varinfo_dist[idnmbrm1][i - 1].equals("Logit")) {
      
	 /* For a Logit node with continuous predictors, store
	    representative distributions on 3 values of each predictor. */

	 nmvalngh1 = 3;
	 nmvalngh2 = 3;
      }

      if (!createarray[idnmbrm1]) {
         if (varinfo_dist[idnmbrm1][i - 1].equals("Discrete-Beta")) {
	    betaprb[i - 1] = new double[2][nmvalngh1][nmvalngh2]
				       [1][1][1][1][2];

         } else {
            condprb[idnmbrm1][i - 1] = new double[nmvals][nmvalngh1]
						 [nmvalngh2][1][1][1][1][2];
	 }
      }

      for (j1 = 1; j1 <= nmvalngh1; ++j1){
         for (j2 = 1; j2 <= nmvalngh2; ++j2){
            loadprb_(i, j1, j2, 1, 1, 1, 1, 1, nmvals, nmnghs, unif,
               dstnm);

            if (varinfo_dist[idnmbrm1][i - 1].equals("Determ_Discrete") &&
               condprb[idnmbrm1][i - 1][0][j1 - 1][j2 - 1]
		      [0][0][0][0][dstnm - 1] < 1.) {
               printf_("readnet: node= " + i + " k= 0" + " j1= " + j1 +
                  " j2= " + j2);
	       iderr_("readnet: node= " + nodelbls[idnmbrm1][i - 1][0] +
                  " val0= " + condprb[idnmbrm1][i - 1][0][j1 - 1][j2 - 1]
			             [0][0][0][0][dstnm - 1]);
            }

         }
         ++pltnm;
      }

   } else if (nmnghs == 3) {
      ngh1 = nodenghs[idnmbrm1][i-1][2];
      ngh2 = nodenghs[idnmbrm1][i-1][3];
      ngh3 = nodenghs[idnmbrm1][i-1][4];
      nmvalngh1 = nodenghs[idnmbrm1][ngh1-1][0];
      nmvalngh2 = nodenghs[idnmbrm1][ngh2-1][0];
      nmvalngh3 = nodenghs[idnmbrm1][ngh3-1][0];

      if (nmvalngh2 == 1 && nmvalngh3 == 1 &&
	  varinfo_dist[idnmbrm1][i - 1].equals("Logit")) {
      
	 /* For a Logit node with parents 2 and 3 being continuous
	    predictors, store representative distributions on 3
	    values of each of these predictors. */

	 nmvalngh2 = 3;
	 nmvalngh3 = 3;
      }

      if (!createarray[idnmbrm1]) {
         if (varinfo_dist[idnmbrm1][i - 1].equals("Discrete-Beta")) {
	    betaprb[i - 1] = new double[2][nmvalngh1][nmvalngh2][nmvalngh3]
	                               [1][1][1][2];

         } else {
            condprb[idnmbrm1][i - 1] = new double[nmvals][nmvalngh1]
					         [nmvalngh2][nmvalngh3]
					         [1][1][1][2];
	 }
      }

      for (j1 = 1; j1 <= nmvalngh1; ++j1){
         for (j2 = 1; j2 <= nmvalngh2; ++j2){
            for (j3 = 1; j3 <= nmvalngh3; ++j3){
               loadprb_(i, j1, j2, j3, 1, 1, 1, 1, nmvals, nmnghs, unif,
                  dstnm);
            }
            ++pltnm;
         }
      }

   } else if (nmnghs == 4) {
      ngh1 = nodenghs[idnmbrm1][i-1][2];
      ngh2 = nodenghs[idnmbrm1][i-1][3];
      ngh3 = nodenghs[idnmbrm1][i-1][4];
      ngh4 = nodenghs[idnmbrm1][i-1][5];
      nmvalngh1 = nodenghs[idnmbrm1][ngh1-1][0];
      nmvalngh2 = nodenghs[idnmbrm1][ngh2-1][0];
      nmvalngh3 = nodenghs[idnmbrm1][ngh3-1][0];
      nmvalngh4 = nodenghs[idnmbrm1][ngh4-1][0];

      if (nmvalngh3 == 1 && nmvalngh4 == 1 &&
	  varinfo_dist[idnmbrm1][i - 1].equals("Logit")) {
      
	 /* For a Logit node with parents 3 and 4 being continuous
	    predictors, store representative distributions on 3
	    values of each of these predictors. */

	 nmvalngh3 = 3;
	 nmvalngh4 = 3;
      }

      if (!createarray[idnmbrm1]) {
         if (varinfo_dist[idnmbrm1][i - 1].equals("Discrete-Beta")) {
	    betaprb[i - 1] = new double[2][nmvalngh1][nmvalngh2][nmvalngh3]
	                               [nmvalngh4][1][1][2];

         } else {
            condprb[idnmbrm1][i - 1] = new double[nmvals][nmvalngh1]
						 [nmvalngh2][nmvalngh3]
						 [nmvalngh4][1][1][2];
	 }
      }

      for (j1 = 1; j1 <= nmvalngh1; ++j1){
         for (j2 = 1; j2 <= nmvalngh2; ++j2){
            for (j3 = 1; j3 <= nmvalngh3; ++j3){
               for (j4 = 1; j4 <= nmvalngh4; ++j4){
                  loadprb_(i, j1, j2, j3, j4, 1, 1, 1, nmvals, nmnghs,
                     unif, dstnm);
               }
            }
         }
      }

   } else if (nmnghs == 5) {
      ngh1 = nodenghs[idnmbrm1][i-1][2];
      ngh2 = nodenghs[idnmbrm1][i-1][3];
      ngh3 = nodenghs[idnmbrm1][i-1][4];
      ngh4 = nodenghs[idnmbrm1][i-1][5];
      ngh5 = nodenghs[idnmbrm1][i-1][6];
      nmvalngh1 = nodenghs[idnmbrm1][ngh1-1][0];
      nmvalngh2 = nodenghs[idnmbrm1][ngh2-1][0];
      nmvalngh3 = nodenghs[idnmbrm1][ngh3-1][0];
      nmvalngh4 = nodenghs[idnmbrm1][ngh4-1][0];
      nmvalngh5 = nodenghs[idnmbrm1][ngh5-1][0];

      if (!createarray[idnmbrm1]) {
         if (varinfo_dist[idnmbrm1][i - 1].equals("Discrete-Beta")) {
	    betaprb[i - 1] = new double[2][nmvalngh1][nmvalngh2][nmvalngh3]
	                               [nmvalngh4][nmvalngh5][1][2];

         } else {
            condprb[idnmbrm1][i - 1] = new double[nmvals][nmvalngh1]
						 [nmvalngh2][nmvalngh3]
						 [nmvalngh4] [nmvalngh5]
						 [1][2];
	 }
      }

      for (j1 = 1; j1 <= nmvalngh1; ++j1){
         for (j2 = 1; j2 <= nmvalngh2; ++j2){
            for (j3 = 1 ; j3 <= nmvalngh3; ++j3){
               for (j4 = 1; j4 <= nmvalngh4; ++j4){
                  for (j5 = 1; j5 <= nmvalngh5; ++j5){
                     loadprb_(i, j1, j2, j3, j4, j5, 1, 1, nmvals,
                        nmnghs, unif, dstnm);
                  }
               }
            }
         }
      }

   } else if (nmnghs == 6) {
      ngh1 = nodenghs[idnmbrm1][i-1][2];
      ngh2 = nodenghs[idnmbrm1][i-1][3];
      ngh3 = nodenghs[idnmbrm1][i-1][4];
      ngh4 = nodenghs[idnmbrm1][i-1][5];
      ngh5 = nodenghs[idnmbrm1][i-1][6];
      ngh6 = nodenghs[idnmbrm1][i-1][7];
      nmvalngh1 = nodenghs[idnmbrm1][ngh1-1][0];
      nmvalngh2 = nodenghs[idnmbrm1][ngh2-1][0];
      nmvalngh3 = nodenghs[idnmbrm1][ngh3-1][0];
      nmvalngh4 = nodenghs[idnmbrm1][ngh4-1][0];
      nmvalngh5 = nodenghs[idnmbrm1][ngh5-1][0];
      nmvalngh6 = nodenghs[idnmbrm1][ngh6-1][0];

      if (!createarray[idnmbrm1]) {
         if (varinfo_dist[idnmbrm1][i - 1].equals("Discrete-Beta")) {
	    betaprb[i - 1] = new double[2][nmvalngh1][nmvalngh2][nmvalngh3]
	                               [nmvalngh4][nmvalngh5][nmvalngh6][2];

         } else {
            condprb[idnmbrm1][i - 1] = new double[nmvals][nmvalngh1]
						 [nmvalngh2][nmvalngh3]
						 [nmvalngh4][nmvalngh5]
						 [nmvalngh6][2];
	 }
      }

      for (j1 = 1; j1 <= nmvalngh1; ++j1){
         for (j2 = 1; j2 <= nmvalngh2; ++j2){
            for (j3 = 1 ; j3 <= nmvalngh3; ++j3){
               for (j4 = 1; j4 <= nmvalngh4; ++j4){
                  for (j5 = 1; j5 <= nmvalngh5; ++j5){
                     for (j6 = 1; j6 <= nmvalngh6; ++j6){
                        loadprb_(i, j1, j2, j3, j4, j5, j6, 1, nmvals,
			   nmnghs, unif, dstnm);
		     }
                  }
               }
            }
         }
      }

   /*
   } else if (nmnghs == 7) {
      ngh1 = nodenghs[idnmbrm1][i-1][2];
      ngh2 = nodenghs[idnmbrm1][i-1][3];
      ngh3 = nodenghs[idnmbrm1][i-1][4];
      ngh4 = nodenghs[idnmbrm1][i-1][5];
      ngh5 = nodenghs[idnmbrm1][i-1][6];
      ngh6 = nodenghs[idnmbrm1][i-1][7];
      ngh7 = nodenghs[idnmbrm1][i-1][8];
      nmvalngh1 = nodenghs[idnmbrm1][ngh1-1][0];
      nmvalngh2 = nodenghs[idnmbrm1][ngh2-1][0];
      nmvalngh3 = nodenghs[idnmbrm1][ngh3-1][0];
      nmvalngh4 = nodenghs[idnmbrm1][ngh4-1][0];
      nmvalngh5 = nodenghs[idnmbrm1][ngh5-1][0];
      nmvalngh6 = nodenghs[idnmbrm1][ngh6-1][0];
      nmvalngh7 = nodenghs[idnmbrm1][ngh7-1][0];
      for (j1 = 1; j1 <= nmvalngh1; ++j1){
         for (j2 = 1; j2 <= nmvalngh2; ++j2){
            for (j3 = 1 ; j3 <= nmvalngh3; ++j3){
               for (j4 = 1; j4 <= nmvalngh4; ++j4){
                  for (j5 = 1; j5 <= nmvalngh5; ++j5){
                     for (j6 = 1; j6 <= nmvalngh6; ++j6){
                        for (j7 = 1; j7 <= nmvalngh7; ++j7){
                           loadprb_(i, j1, j2, j3, j4, j5, j6, j7,
			      nmvals, nmnghs, unif, dstnm);
			}
		     }
                  }
               }
            }
         }
      }
   */

   } // end of number-of-parents "if" ladder.

   if (varinfo_dist[idnmbrm1][i - 1].equals("Logit")) {

      // Read a logit model's coefficients.

      loadlogit_(i);
   }

   // Create plot of this distribution.

   /*
   Plot.pltdist_(i, nmvals, nmnghs, ngh1 nmvalngh1, ngh2, nmvalngh2,
                 ngh3, nmvalngh3, xpltvals, ypltvals);
   */
} // End of "nmtoread" for-loop.

createarray[idnmbrm1] = true;

if (!newdst) {
   fclose_(parmfle, 'r');
   if (rdpflag) {
      printf_("readnet: done reading distributions from file " + parmfle);
   }
}
}

//------------------------------------------------------------------------

static void loadlogit_(int node) {

   // Read logit parameter values.

boolean test = false;

String strng;

int k;

if (varinfo_nmparms[idnmbrm1][node - 1] > NMWRPAR) {
   iderr_("loadlogit: nmparms= " + varinfo_nmparms[idnmbrm1][node - 1] +
      " > NMWRPAR= " + NMWRPAR);
}

for (k = 0; k < varinfo_nmparms[idnmbrm1][node - 1]; ++k) {
   if (newdst) {
      logit_pars[idnmbrm1][node - 1][k] = 0.;
   
   } else {
      parmlbls[idnmbrm1][node - 1][k] = fgetstrng_(parmfle);
      logit_pars[idnmbrm1][node - 1][k] = fgetdble_(parmfle);
   }
   if (test) {
      printf_("node= " + nodelbls[idnmbrm1][node - 1][0] + " parm= " +
         parmlbls[idnmbrm1][node - 1][k] + " value= " +
	 logit_pars[idnmbrm1][node - 1][k]);
   }
}
}

// -----------------------------------------------------------------------

static void loadprb_(int i, int j1, int j2, int j3, int j4, int j5,
   int j6, int j7, int nmvals, int nmnghs, double unif, int dstnm) {

/* Reads parameter values for node i under parent conditioning values
   j1 through j7. */

boolean checkbounds = true, ldprbtest = false;

int j = 0, k, nghbr = 0, memnde;

double probsum, val = 0., lowerbound, upperbound;

// Get memory node number.

if (varinfo_memnde[idnmbrm1][i - 1].equals("none")) {
   memnde = 0;

} else {
   memnde = Getmodlutils.getndnm_(varinfo_memnde[idnmbrm1][i - 1]);
}

if (!newdst) {
   for (k = 0; k < nmnghs; ++k) {
      if (varinfo_dist[idnmbrm1][i - 1].equals("Logit")) {
	 if (k == 0) {
	    nghbr = ngh1;
	    j = j1;

	 } else if (k == 1) {
	    nghbr = ngh2;
	    j = j2;

	 } else if (k == 2) {
	    nghbr = ngh3;
	    j = j3;

	 } else if (k == 3) {
	    nghbr = ngh4;
	    j = j4;

	 } else if (k == 4) {
	    nghbr = ngh5;
	    j = j5;

	 } else if (k == 5) {
	    nghbr = ngh6;
	    j = j6;
         }
	 
	 if (nodenghs[idnmbrm1][nghbr - 1][0] == 1) {

	    /* For a Logit node with a continuous predictor(s), read each
	       continuous predictor value to be used in the logit model
	       model approximation algorithm.  Note that 3 such values
	       are needed for each predictor (the number of parent values
	       has been temporarily set to 3 in the calling routine). */

            Fitlogit.continvals[nghbr - 1][j - 1] = fgetdble_(parmfle);
 
	 } else {
            strng = fgetstrng_(parmfle);
	 }

      } else {
      
	 /* For a non-Logit node or a Logit node on a discrete parent,
	    just throw away parent labels. */

         if (!ldprbtest) {
            fgetstrng_(parmfle);

	 } else {
            printf_("loadprb: parent value= " + fgetstrng_(parmfle));
	 }
      }
   }
}

// If this is a Discrete-Beta node, load betaprb.

if (varinfo_dist[idnmbrm1][i - 1].equals("Discrete-Beta")) {
   if (newdst) {
      betaprb[i - 1][0][j1 - 1][j2 - 1][j3 - 1][j4 - 1][j5 - 1][j6 - 1]
	     [dstnm - 1] = 1.;
      betaprb[i - 1][1][j1 - 1][j2 - 1][j3 - 1][j4 - 1][j5 - 1][j6 - 1]
	     [dstnm - 1] = 1.;

   } else {
      betaprb[i - 1][0][j1 - 1][j2 - 1][j3 - 1][j4 - 1][j5 - 1][j6 - 1]
	     [dstnm - 1] = fgetdble_(parmfle);
      betaprb[i - 1][1][j1 - 1][j2 - 1][j3 - 1][j4 - 1][j5 - 1][j6 - 1]
	     [dstnm - 1] = fgetdble_(parmfle);
   }

   return;
}

/* For all other node types, load the "condprb" subarray with either a
   discrete node's conditional distribution parameter values or the
   parameter values for a Lognormal, Gamma, SDE, HIBM or PIBM node. */

probsum = 0.;
for (k = 1; k <= nmvals; ++k) {
   checkbounds = true;

   // Load hypothesis distribution.

   if ((varinfo_dist[idnmbrm1][i - 1].equals("Determ_Discrete") ||
        varinfo_dist[idnmbrm1][i - 1].equals("Determ_Contin")) &&
       k == 1) {

      /* These two node types have only one parameter value per
         parent combination. */

      if (newdst) {
         if (varinfo_dist[idnmbrm1][i - 1].equals("Determ_Discrete")) {
            val = nmvals / 2;
    
	 } else {
           val = unif;
	 }

      } else {

	 /*
	 if (checkeof_(parmfle)) {
            iderr_("loadprb: Determ_Discrete/Contin, should not be at EOF");
	 }
         */

         val = fgetdble_(parmfle);
      }

      if (varinfo_dist[idnmbrm1][i - 1].equals("Determ_Contin")) {

         // Set bounds for a Determ_Contin node.

         if (nodelbls[idnmbrm1][i - 1][0].equals("Overall_Goal_Attainment")) {
            varinfo_bounds[idnmbrm1][i - 1][nmndepars[i - 1]][0] = .0000;
            varinfo_bounds[idnmbrm1][i - 1][nmndepars[i - 1]][1] = 1.0;

         } else if (nodelbls[idnmbrm1][i - 1][0].equals("Number_Poached")) {
	    lowerbound = 0.;
            varinfo_bounds[idnmbrm1][i - 1][nmndepars[i - 1]][0] = lowerbound;
	    upperbound = 6.;
            varinfo_bounds[idnmbrm1][i - 1][nmndepars[i - 1]][1] =  upperbound;

         } else {
	    lowerbound = 0.;
            varinfo_bounds[idnmbrm1][i - 1][nmndepars[i - 1]][0] = lowerbound;
	    upperbound = (1. + bdspct) * val;
            varinfo_bounds[idnmbrm1][i - 1][nmndepars[i - 1]][1] =  upperbound;
	    printf_("loadprb: nmndepars= " + nmndepars[i - 1]);
	    printf_("loadprb: lowerbound= "  + lowerbound + " val= " + val +
               " upperbound= " + upperbound);
	 }

      } else if (varinfo_dist[idnmbrm1][i - 1].equals("Determ_Discrete")) {
         
	 // Set bounds for a Determ_Discrete node.

         varinfo_bounds[idnmbrm1][i - 1][nmndepars[i - 1]][0] = 1.;
         varinfo_bounds[idnmbrm1][i - 1][nmndepars[i - 1]][1] =
	    (double) nmvals;
      }

      // Increment node parameter counter.

      ++nmndepars[i - 1];
      if (nmndepars[i - 1] >= MAXNMNDEPAR) {
         iderr_("loadprb location 1: node= " + nodelbls[idnmbrm1][i - 1][0] +
            " nmndepars= " + nmndepars[i - 1] + " >MAXNMNDEPAR");
      }

   } else if (varinfo_dist[idnmbrm1][i - 1].equals("Discrete") ||
       varinfo_dist[idnmbrm1][i - 1].equals("Logit")) {

      /* These node types do not have the last node value's parameter
	 read because all probabilities taken together sum to one.  A
	 simple ID memory mechanism is also implemented here.

	 !!!NOTE: Read discrete probabilities of Logit nodes just like
	 Discrete nodes.  The Logit model approximation is used later
	 to find the best fitting logit parameters.  The lines below
	 read the discrete probabilities and "loadlogit," below, reads
	 the logit parameters.
         
	 Also, always read a value from the distribution file no matter
	 what the value of memnde is. */

      if (newdst) {
         val = unif; // Default distribution is uniform.

      } else if (k < nmvals) {
         val = fgetdble_(parmfle);

         /*
         if (varinfo_dist[idnmbrm1][i - 1].equals("Discrete")) {
            printf_("loadprb: node= " + nodelbls[idnmbrm1][i - 1][0] +
               " discrete val= " + val);
         }
         if (varinfo_dist[idnmbrm1][i - 1].equals("Logit")) {
            printf_("loadprb: logit val= " + val);
         }
         */
      }

      /* Memory mechanism.  Broken.
      if (memnde > 0 && Intridslve.t > Intridslve.t0) {
         val = Beliefs.memorydst[idnmbrm1][memnde - 1][k - 1];
      }
      */
            
      // Set bounds.

      varinfo_bounds[idnmbrm1][i - 1][nmndepars[i - 1]][0] = 1.e-3;
      varinfo_bounds[idnmbrm1][i - 1][nmndepars[i - 1]][1] = 1. - 1.e-3;

      // Increment node parameter counter.

      ++nmndepars[i - 1];
      if (nmndepars[i - 1] >= MAXNMNDEPAR) {
         iderr_("loadprb location 2: node= " + nodelbls[idnmbrm1][i - 1][0] +
            " nmndepars= " + nmndepars[i - 1] + " >MAXNMNDEPAR");
      }

      if (k == nmvals) {
         val = 1. - probsum;
      }

   } else if (varinfo_dist[idnmbrm1][i - 1].equals("SDE") ||
      varinfo_dist[idnmbrm1][i - 1].equals("HIBM") ||
      varinfo_dist[idnmbrm1][i - 1].equals("PIBM") ||
      varinfo_dist[idnmbrm1][i - 1].equals("SMS") ||
      varinfo_dist[idnmbrm1][i - 1].equals("R_Horn_ABM") ||
      varinfo_dist[idnmbrm1][i - 1].equals("M_Network_ABM") ||
      varinfo_dist[idnmbrm1][i - 1].equals("Determ_Frctn") ||
      varinfo_dist[idnmbrm1][i - 1].equals("LOMAP") ||
      varinfo_dist[idnmbrm1][i - 1].equals("GLOMAP") ||
      varinfo_dist[idnmbrm1][i - 1].equals("Determ_Linear") ||
      varinfo_dist[idnmbrm1][i - 1].equals("Determ_Temporal")) {

      // These node types need all "nmvals" parameter values read.

      if (newdst) {
         val = 0.;

      } else {
         val = fgetdble_(parmfle);
      }

      /* Set bounds by re-using the bounds read-in in the calling
         program. */

      varinfo_bounds[idnmbrm1][i - 1][nmndepars[i - 1]][0] = 
         varinfo_bounds[idnmbrm1][i - 1][k - 1][0]; 
      varinfo_bounds[idnmbrm1][i - 1][nmndepars[i - 1]][1] =
         varinfo_bounds[idnmbrm1][i - 1][k - 1][1];
      
      // Increment node parameter counter.

      ++nmndepars[i - 1];
      if (nmndepars[i - 1] >= MAXNMNDEPAR) {
         iderr_("loadprb location 3: node= " + nodelbls[idnmbrm1][i - 1][0] +
            " nmndepars= " + nmndepars[i - 1] + " >MAXNMNDEPAR");
      }
   }

   // Check parameter bounds.

   if (val < varinfo_bounds[idnmbrm1][i - 1][nmndepars[i - 1] - 1][0]) {
      if (rdpflag) {
         printf_("loadprb location 4: ID= " + idname[idnmbrm1] + " nmvals= " +
            nmvals + " dist= " + varinfo_dist[idnmbrm1][i - 1] +
            "\n   node= " + nodelbls[idnmbrm1][i - 1][0] +
            "\n   lowerbound= " +
            varinfo_bounds[idnmbrm1][i - 1][nmndepars[i - 1] - 1][0] +
            " val(" + k + ")= " + val +
	    "\n   upperbound= " +
            varinfo_bounds[idnmbrm1][i - 1][nmndepars[i - 1] - 1][1] +
	    "\n   j1= " + j1 + 
            "\n   value is not in bounds, resetting.");
      }
      val = 1.001 * varinfo_bounds[idnmbrm1][i - 1]
                                  [nmndepars[i - 1] - 1][0];
   }

   if (varinfo_bounds[idnmbrm1][i - 1][nmndepars[i - 1] - 1][1] < val) {
      if (rdpflag) {
         printf_("loadprb location 5: ID= " + idname[idnmbrm1] + " nmvals= " +
            nmvals + " dist= " + varinfo_dist[idnmbrm1][i - 1] +
            "\n   node= " + nodelbls[idnmbrm1][i - 1][0] +
            "\n   lowerbound= " +
            varinfo_bounds[idnmbrm1][i - 1][nmndepars[i - 1] - 1][0] +
            " val(" + k + ")= " + val +
	    "\n   upperbound= " +
            varinfo_bounds[idnmbrm1][i - 1][nmndepars[i - 1] - 1][1] +
            "\n   value is not in bounds, resetting.");
      }
      val = 0.999 * varinfo_bounds[idnmbrm1][i - 1]
                                  [nmndepars[i - 1] - 1][1];
   }

   if (ldprbtest) {
      printf_("loadprb location 6: val= " + val);
   }

   // Finally, load this value into the distribution array.

   condprb[idnmbrm1][i - 1][k - 1][j1 - 1][j2 - 1][j3 - 1][j4 - 1][j5 - 1]
          [j6 - 1][dstnm - 1] = val;
   probsum += val;

   // Store x and y values in plotting arrays.

   if (nmnghs == 0) {
      ypltvals[pltnm - 1][0][k - 1] = val;
     
   } else if (nmnghs == 1) {
      ypltvals[pltnm - 1][j1 - 1][k - 1] = val;
     
   } else if (nmnghs == 2) {
      ypltvals[pltnm - 1][j2 - 1][k - 1] = val;
      
   } else if (nmnghs == 3) {
      ypltvals[pltnm - 1][j3 - 1][k - 1] = val;
   }
   xpltvals[pltnm - 1][k - 1] = k;

   if (varinfo_dist[idnmbrm1][i - 1].equals("Determ_Discrete") ||
       varinfo_dist[idnmbrm1][i - 1].equals("Determ_Contin")) {

      /* After reading one node value, exit the number-of-node-values
	 loop for these two types of nodes. */
      
      break;
   }
}

/* Apply any rules for this node.  Note that (a) rules supersede values
   in the .par file, and (b) any combination of parent values not
   specified by a rule has been assigned by reading the .par file,
   above. */

Cptrules.applyrules_(i, j1, j2, j3, j4, j5, j6, j7, nmvals, nmnghs, dstnm);
}

// ----------------------------------------------------------------------

static void readdsts_(boolean trial) {

String savename = " ";
int i;

// Loop through IDs.

for (i = 0; i < nmids; ++i) {
   thisidname = idname[i];
   idnmbrm1 = i;

   // Write this ID's consistent parameter (.par) file.

   savename = dstfle[idnmbrm1][0];

   if (trial) {
      dstfle[idnmbrm1][0] = "tmp" + dstfle[idnmbrm1][2];

   } else {
      dstfle[idnmbrm1][0] = dstfle[idnmbrm1][2];
   }

   nmnds = Intridslve.nmndes[idnmbrm1];
   readnet_(dstfle[idnmbrm1][0], Writenet.flenm, nmnds, 1);

   dstfle[idnmbrm1][0] = savename;
}
}

}
