public class Report extends Id {

static boolean estimatenodes = false, confidenceintervals = false,
   detectinsiderthreat = false;

// --------------------------------------------------------------------

public boolean report_() {

// Calls appropriate routines and then writes the HTML report file.

int i;

double endtime = 0.;

// Open report file, write HTML header, and then the 2-line analysis title.

if (rptfle == null) {
   iderr_("report: rptfle=null");
}

fleopen_(1, rptfle, 'w');
fprintf_(1,
"<HTML>\r\n" +
"<HEAD>\r\n" +
"<TITLE>id Report File</TITLE>\r\n" +
"<LINK REL=\"STYLESHEET\" HREF=\"stylesheet.css\">\r\n" +
"</HEAD>\r\n" +
"<BODY>\r\n" +
"<PRE>\r\n" +
"<H2 ALIGN=CENTER><STRONG>id</STRONG> Report File</H2>");
fprintf_(1, " " + gphtitl[0]);
fprintf_(1, " " + gphtitl[1]);

// Give links to PostScript ID graph and distributions.

fprintf_(1,"<HR>\r\n" +
   "ID graph is at <A HREF=\"" + Pltgrph.flename + "\">ID</A>\r\n" +
   "<HR>");

fprintf_(1,"Conditional distribution plots are at <A HREF=\"" +
   spacetime_psfle + "\">" + spacetime_psfle + "</A>");

// Initialize random number generators.

for (i = 0; i <= nmthreads; ++i) {
   Rndm.rndm1_(i, 1);
}
Rndm.shuffle_(1, 10, 1);

// Process report request.

if (reportqualifier.equals("prepare_data")) {

   // Input file pre-processing.

   fprintf_(1, "Report type: Data Preparation");

   if (spacetime_option == -1) {
  
      // Read NWS data.

      Readnws.readnws_();

   } else if (spacetime_option == 0) {
   
      // Boundaries file conversion.

      Convrt.convrt_(0);

   } else if (spacetime_option == 1) {

      // Spatio-temporal data file conversion.

      Convrt.convrt_(1);

   } else if (GISwind.pointfle != null) {

      // GIS tools.

      GISwind.giswindow_();
      return true;

   } else if (Storyparse.htmlfle != null) {

      // Remove HTML tags from a set of web news articles.

      Dehtml.removehtml_();

   } else if (Storyparse.storiesfle[0] != null &&
	      PolEcolDB.dbname == "none") {

      // Parse news stories.

      Storyparse.parse_stories_();

   } else if (!Storyparse.dboption.equals("none")) {

      // Maintain relational database.

      PolEcolDB.runDB_();

   } else if (Groupdata.grpactnsfle != null) {
   
      // Raw group actions file processing.

      readrawgroup = true;

      if (nmids <= 1) {
	 iderr_("report: nmids= " + nmids +
	    " must be > 1 to read raw group actions");
      }

      // Set up IntIDs model arrays.

      Intridslve.intridslve_(true, true);

      /* Read raw group data and write an actions history data file
	 from it. */

      Groupdata.readrawgroup_();

   } else if (HIBMutils.riskfle != null) {

      // Compute extinction risk.

      HIBMutils.computerisk_(0.);

   } else if (ProductThemes.socialmediaposts != null) {

      // Find themes in social media postings.

      ProductThemes.themeclusters_();
   }

} else if (reportqualifier.equals("describe_data")) {

   // Compute descriptive statistics and write plot files of the data set.

   fprintf_(1, "Report type: Data Description");
   spacetime_option = -1;
   Describe.describe_();

   if (Getmodl.nmpairs > 0) {

      // Compare pairs of samples.

      Describe.compare_();
   }

} else if (reportqualifier.equals("estimate")) {

   fprintf_(1, "Report type: Estimate");
   if (Fitlogit.nmtofit > 0) {

      // Logit parameter fitting to conditional probabilities in .par file.

      Fitlogit.fitlogit_();

   } else if (parm_mvar > 0) {

      // For LOMAP variables, process any spatio-temporal commands.

      Surf.surf_();

   } else if (interdict) {

      // Find an interdiction patrol route.

      Interdict.interdictpatrol_();

   } else if (pursuit) {

      // Adaptively find a pursuit patrol route.

      Pursuit.pursuittest_();

   } else if (deduplicateplayers) {

      // Deduplicate an observed collection of players and their attributes.

      Deduplicate.dedup_(0);

   } else if (estimatesocialnetwork) {

      // Reconstruct a social network.

      Estnetwork.estnet_(0);
      printf_("-------------- estnet completed. -----------------");
      Estnetwork.reconstructnetwork_(0);
   
   } else if (findmpemp) {

      /* Find the Most Practical Ecosystem Management Plan (MPEMP) or a
	 constrained one that is close by. */

      Mpemp.findmpemp_();

   } else if (predskill) {

      // Compute the one-step-ahead prediction error rates.

      CAutils.caSetup_(true);
      CAapps.predskill_();
 
   } else if (CA.runtype.equals("online_learning")) {

      if (nmids > 1) {
         iderr_("report: online_learning but nmids>1");
      }

      // Online learning.

      Onlinelearn.onlinelearn_();

   } else if (estimatenodes) {

      /* Estimate ID parameters with Consistency Analysis (CA) over all
         time points and observations.  First, set up the CA. */

      fprintf_(1, "\n-------------------- Consistency Analysis" +
         " --------------------\n");

      CAutils.caSetup_(true);
      CA.ca_(true);

      // Write SMS path plotting files.

      if (Beliefs.issms) {
         SMSutils.plotpaths_();
         SMSutils.pathmetrics_();
         SMSutils.medianloc_();
      }

   } else if (confidenceintervals) {

      /* Compute jackknife confidence intervals for those model parameters
         fitted in a previous consistency analysis.  First, set up the CA.
      */

      fprintf_(1, "\n----------------Jackknife Confidence Intervals" +
         " --------------------\n");

      CAutils.caSetup_(true);
      CAapps.jackknifecis_();

   } else if (detectinsiderthreat) {

      // Detect an insider threat against a database.

      ITD.manage_();
   }

} else if (reportqualifier.equals("evaluate")) {
   
   /* ID evaluation.  Compute and report ID marginal distributions or
      solve the ID (find the maximum utility decision option).  Then,
      write out or map distributions of requested variables. */

   fprintf_(1, "Report type: Evaluate");

   if (map == 1) {
      Surf.surf_();

   } else if (tutor) {
	   
      if (PlagDetect.docfle.equals("none")) {

         /* Simulate a MOC's use of an Online Intelligent Tutoring
	    System (OITS). */

         MOC.MOCsim_();

      } else {

	 // Compute author-cluster separation scores.

         PlagDetect.clstrsep_();
      }

   } else if (evaluatesocialnetwork) {

      /* Given a social network, compute centrality measures and write the
         Actionable Intelligence report. */

      SNA.findKeyPlayers_();

   } else if (nmids == 1 && !optimal_decision) {
      Beliefs.initializetmefcns[0] = true;
      Beliefs.beliefs_(1, 0.);
      
   } else if (nmids > 1 || optimal_decision) {

      // First call is for setup, second to solve for actions history.

      Intridslve.intridslve_(true, true);
      Intridslve.intridslve_(false, true);
   }

} else if (reportqualifier.equals("sensitivity_analysis")) {

   // Sensitivity analysis.

   if (dsensanalysis) {
      fprintf_(1, "Report type: Deterministic sensitivity Analysis");
      Dsens.dsens_();

   } else if (ssensanalysis) {
      fprintf_(1, "Report type: Sustainably-focused sensitivity Analysis");
      Ssens.ssens_();

   } else if (psensanalysis) {
      fprintf_(1, "Report type: Probabilistic sensitivity Analysis");
      Psens.psens_();
   }

} else if (reportqualifier.equals("mc_hypothesis_test")) {

   // Monte Carlo hypothesis test.

   fprintf_(1, "Report type: Monte Carlo Hypothesis Test");
   CAutils.caSetup_(true);
   CAapps.mchyptst_();

} else if (reportqualifier.equals("display")) {

   // Graphical displays.

   fprintf_(1, "Report type: Display");

   if (Pltgrph.draw) {

      // Draw the ID graph.

      Pltgrph.pltgrph_();

   } else if (spacetime_option == 4 ||
       spacetime_option ==  5 ||
       spacetime_option ==  10 ||
       spacetime_option == 11) {
      Surf.surf_();

   } else if (spacetime_option == 12) {
      Plot.xyplots_();

   } else if (!Displayactions.plottype.equals("none")) {
      Displayactions.displayactnshist_();

   } else {
      iderr_("report: display option not recognized");
   }
}

// Write HTML trailer and close the HTML output file.

fprintf_(1,"</PRE>\r\n</BODY>\r\n</HTML>");

fclose_(1, 'w');
return false;
}
}
