class Resdiag extends Surf {
static double vsse[] = new double[NUMVAR];
static double vssy[] = new double[NUMVAR];

// ----------------------------------------------------------------------

static void resdiag_(String routne, boolean test) {

/* Residual analysis.  First, open residual plotting file and plot
   data, trend, residual, standardized, "whitened" residual. */

int i, stnm = 0;
double resid, rnd, sst, sse, datmean, resmean;

fleopen_(7, "stdres.plt", 'w');
for (i = 0; i < nd; ++i) {
   fprintf_(7, i + " " + vardat_vrble[i] + " " + vardat_obs[i] + " " +
      vardat_trend[i] + " " + vardat_dat[i] + " " + vardat_stdres[i]);
}

// Close the plotting file and then create the normal Q-Q plot.

fclose_(7, 'w');

fprintf_(1,"Q-Q plot of standard normal residuals.");
Pltnrm.pltnrm_();

// Plot residual versus trend.

fleopen_(7, "restrend1.dat",'w');
if (test) {
   printf_("Variable         Observed          Trend          Residual");
}
for (i = 0; i < nd; ++i) {
   vardat_dat[i] = vardat_obs[i] - vardat_trend[i];

   if (test) {
      printf_(" " + vardat_vrble[i] + " " + vardat_obs[i] + " " +
      vardat_trend[i] + " " + vardat_dat[i]);
   }

   // Plot residual versus trend.

   fprintf_(7, vardat_vrble[i] + " " + vardat_obs[i] +
         " " + vardat_trend[i] + " " + vardat_dat[i]);
}
fclose_(7, 'w');

// Compute R^2.
 
rnd = (double) nd;
sse = 0.;
datmean = 0.;
resmean = 0.;
sst = 0.;
for (i = 0; i < NUMVAR; ++i) {
   vsse[i] = 0.;
   vssy[i] = 0.;
}
for (i = 0; i < nd; ++i) {
   stnm = idtostnm[vardat_vrble[i] - 1];
   
   // printf_("resdiag: i= " + i + " vrble= " + vardat_vrble[i] +
   //    " stnm= " + stnm);

   datmean += vardat_obs[i];
   resmean += vardat_dat[i];
   sse += vardat_dat[i] * vardat_dat[i];
   sst += vardat_obs[i] * vardat_obs[i];
   vsse[stnm - 1] += vardat_dat[i] * vardat_dat[i];
   vssy[stnm - 1] += vardat_obs[i] * vardat_obs[i];
}
datmean /= rnd;
resmean /= rnd;

fprintf_(1, routne + ": nd= " + nd + " sse= " + sse + " sst= " + sst);

if (sst > 0.) {
   r2 = 1. - (sse / sst);

} else {
   r2 = 0.;
}

fprintf_(1, routne + ": datmean= " + fdble_(datmean, 7, 3) + " resmean= " +
   fdble_(resmean, 7, 3) + " rsquared= " + fdble_(r2, 7, 3));

if (r2 < 0.) {
   iderr_("resdiag: r2= " + r2);
}

}
}
