public class Rndmsrch extends Optimiz {
static double wage = 0.;

static double scale[] = new double[OPTSIZE];
static double step[] = new double[OPTSIZE];
static double pt[] = new double[OPTSIZE];
static double xworst[] = new double[OPTSIZE];
static double trialpt1[] = new double[OPTSIZE];
static double trialpt2[] = new double[OPTSIZE];

// --------------------------------------------------------------------

public static void rndmsrch_(int fcnnm, double initialpt[], double epsilon) {

/* Performs random search in "n" dimensions using the adaptive step
   size algorithm of Schumer, M. A. and Steiglitz, K. (1968), ``Adaptive
   Step Size Random Search,'' IEEE Transactions on Automatic Control,
   AC-13(3): 270-276.  This routine attempts to find "pt" that maximizes
   the value of "f."
   
   Schumer and Steiglitz argue that Newton methods become
   excessively expensive as the number of variables increases because of
   the squared growth of the number of second derivatives that need to be
   computed for the Hessian.  At some point, the efficiency of a Newton
   method is drowned out by all of these function evaluations making a
   less efficient, random method like theirs, competitive.

   One way to make this method sensitive to "good" directions is as
   follows:

   In getstep_(), instead of drawing random directions from an
   n-dimensional uniform distribution, use an n-dimensional normal
   distribution.  Use as the mean, d, the average of the last m <= M
   directions that resulted in an improvement.  When m = 0 (start-up),
   use the unit vector with a large variance on each dimension,
   sigma_i^2 = 3R_i^2 where R_i is the width of the feasibility interval
   of the i^th variable, i = 1, ..., n.  M is preset.  Decrease the
   variance as convergence approaches.  One rule (assuming function
   minimization is the goal) is to compute
   sigma_i^2 *= (f_(j-5) - f_j)/(f_0 - f_j) where f_k is the objective
   function value after the k^th improvement and f_0 is the function
   value at the initial (starting) point.

   See the article: Luus, R. and Brenek, P. (1989), "Incorporating
      Gradient into Random Search Optimization,'' Chemical Engineering
      and Technology, 12(1): 309-318.

                 --------------------------------

   A simple way to parallelize this algorithm is as follows.
   1. Compute m (trialpt1, f(trialpt1)) pairs and pick the largest
      f-value from these.
   2. Compute m (trialpt2, f(trialpt2)) pairs and pick the largest
      f-value from these.
   Doing so would result in one pass through the main loop being computed
   in the wall-clock time of two function evaluations.  But the search would
   be much more extensive each pass through the loop.

   A more complex parallelization of this algorithm is via JavaSpaces as
   follows.

   1) Post m random starting points to the space.  m is at least as
      large as the number of processors.

   2) Each worker begins to execute rndmsrch_() (see below).

   3) As soon as a worker discovers a point at which the function improves,
      that point is posted to the space.  Along with this posting, the
      worker computes a convergence measure.

   4) Each worker reads this point and convergence measure.  If
      convergence has been reached, the worker self-terminates.
      Otherwise, the worker restarts "rndmsrch_" at this point.
      Because each worker has a different set of random numbers,
      workers are not necessarily generating the same trial points.

   5) Go to 3.

   The algorithm suggested above for taking advantage of "good" directions
   allows many workers to start with the same d and Sigma and yet be
   searching mostly different points since actual points checked are
   randomly generated from the m-dimensional normal and each worker has a
   different seed.

   Workers do however, need to "check-in" frequently to see if somebody has
   posted an improvement.  Such frequent checking of the space needs
   to be coded in the worker protocol so that a worker checks the space
   after every (say) 5 function evaluations. */
      
boolean outbds, uniformonly = false;

int i, i1, i2 = 0, nm1, nmsteps = 10000, nmtrys = 0, maxnmtrys = 10000;

double sbig, f = 0., lastf, convtest = 0., bestf = -1.e6, worstf = 1.e6, trialf1, trialf2,
   a = .001, // was .4, then .01
   s = .05;  // was .05

// Initialize this method's random number generator.

Rndm.rndm2_(0, 1);

// Set scaling values, initial point, and initial f.

//printf_("rndmsrch: Variable    g      initialpt       h");
for (i = 0; i < n; ++i) {
   scale[i] = h[i] - g[i];
   pt[i] = (initialpt[i] - g[i]) / scale[i];
   xbest[i] = pt[i];
   xworst[i] = pt[i];
   //printf_("         " + i + "  " + g[i] + "  " + initialpt[i] + "  " + h[i]);
}

/* Perform a hybrid random search to find a starting point.  Do this
   by checking the boundaries and then a few random points within the
   feasible region. */

for (i = 0; i < 5; ++i) {
   if (i == 0) {
      pt[3] = .01;

   } else if (i == 4) {
      pt[3] = .99;

   } else {
      pt[3] = Rndm.rndm2_(0, 0);
   }
   f = getf_(fcnnm, pt);

   if (fcnnm == 2) {
      printf_("rndmsrch: i= " + i + " pt= " + fdble_(pt[3], 8, 5) +
         " f= " + fdble_(f, 8, 2) + " wage= " + fdble_(wage, 8, 3));
   }

   if (bestf < f) {
      xbest[3] = pt[3];
      bestf = f;
   }

   if (f < worstf) {
      xworst[3] = pt[3];
      worstf = f;
   }
}

// Load this best point.

for (i = 0; i < n; ++i) {
   pt[i] = xbest[i];

   // Uniform search only.

   if (uniformonly) {
      initialpt[i] = scale[i] * pt[i] + g[i];
   }
}

if (uniformonly) {

   return;
}

printf_("rndmsrch: Starting random search with xbest3= " + xbest[3]);

// Main loop

i2 = 0;
lastf = f;
for (i1 = 1; i1 <= nmsteps; ++i1) {

   // Small step.

   nmtrys = 0;
   do {
      getstep_(s, step);
      for (i = 0; i < n; ++i) {
         trialpt1[i] = pt[i] + step[i];
      }

      // Check for an explicit bound violation.
   
      outbds = false;
      for (i = 0; i < n; ++i) {
         if (trialpt1[i] < 0. || trialpt1[i] > 1.) {
	    //printf_("rndmsrch: bounds, i= " + i + " trialpt1= " + trialpt1[i]);
            outbds = true;
	    break;
         }
      }
      ++nmtrys;
      if (nmtrys == maxnmtrys) {
         iderr_("rndmsrch: maxnmtrys exceeded loop 1");
      }
   } while (outbds);
   trialf1 = getf_(fcnnm, trialpt1);

   // Big step.
   
   sbig = s * (1. + a);
   nmtrys = 0;
   do {
      getstep_(sbig, step);
      for (i = 0; i < n; ++i) {
         trialpt2[i] = pt[i] + step[i];
      }

      // Check for an explicit bound violation.
   
      outbds = false;
      for (i = 0; i < n; ++i) {
         if (trialpt2[i] < 0. || trialpt2[i] > 1.) {
	    //printf_("rndmsrch: bounds, i= " + i + " trialpt2= " + trialpt2[i]);
            outbds = true;
	    break;
         }
      }
      ++nmtrys;
      if (nmtrys == maxnmtrys) {
         iderr_("rndmsrch: nmtrys exceeded loop 2");
      }
   } while (outbds);
   trialf2 = getf_(fcnnm, trialpt2);
 
   if (trialf1 > f || trialf2 > f) {
      lastf = f;
      if (trialf1 < trialf2) {
         s = sbig;
	 for (i = 0; i < n; ++i) {
	    pt[i] = trialpt2[i];
	    xbest[i] = trialpt2[i];
	 }
	 f = trialf2;
      
      } else {
	 for (i = 0; i < n; ++i) {
	    pt[i] = trialpt1[i];
	    xbest[i] = trialpt1[i];
	 }
	 f = trialf1;
      }

      // Check for convergence.

      convtest = Math.abs(f - lastf) / Math.abs(f);
      //printf_("rndmsrch: convtest= " + convtest);
      if (convtest < epsilon) {
         printf_("rndmsrch: lastf= " + lastf + " f= " + f +
            "\n   convtest= " + convtest + " epsilon= " + epsilon + ", Converged!");
         break;
      }

      i2 = 0;
   
   } else {
      ++i2;
   }
    
   if (i2 > 4) {
      s *= .5;
      i2 = 0;
   }
   /*
   printf_("rndmsrch: i1= " + i1 + " i2= " + i2 + " s= " + s +
      " f= " + f);
   */

   if (funevals > maxnmf) {
      printf_("rndmsrch: funevals > maxnmf, terminating");
      break;
   }
} // End of main loop.

for (i = 0; i < n; ++i) {
   pt[i] = xbest[i];
}

f = getf_(fcnnm, pt);

// Transform back to original scale.

for (i = 0; i < n; ++i) {
   initialpt[i] = scale[i] * pt[i] + g[i];
}

printf_("rndmsrch: nmsteps= " + i1 + " maxnmsteps= " + nmsteps +
   " final f= " + f + " funevals= " + funevals);
}
 
// ----------------------------------------------------------------------
 
public static void getstep_(double s, double step[]) {
 
// Computes a step given the stepsize, s.
 
int i;

double lngth = 0.;

/* Generate a random point on the n-dimensional uniform distribution
   wherein each dimension is the interval (-1, 1)
   (to implement the suggested improved search idea described above,
   replace below with an "n"-dimensional normal distribution). */

for (i = 0; i < n; ++i) {
   step[i] = -1. + Rndm.rndm2_(0, 0) * 2.;
   lngth += step[i] * step[i];
}
lngth = Math.sqrt(lngth);

for (i = 0; i < n; ++i) {
   step[i] *= s / lngth;
}
}
 
// ----------------------------------------------------------------------
 
public static double getf_(int fcnnm, double pt[]) {
 
// Evaluate the objective function.

int i;

for (i = 0; i < n; ++i) {
   x[i] = scale[i] * pt[i] + g[i];
   wage = x[i];
}
++funevals;

if (fcnnm == 1) {
   return (objf_(x));

} else if (fcnnm == 2) {
   return (Estnetwork.blckmdlobjf_(x));

} else if (fcnnm == 3) {
   return (Interdict.updateobjf_(n, x));
}

return 1.0;
}
}
