class SMScalcs extends Ecosyscalcs {

/* Implements individual-based models of animal movement, also called
   a "Stochastic Movement Simulator" (SMS).

   Animal movement can be integrated with an IBM of population
   dynamics.  For example, the current version of HIBMcalcs.java is of
   the South African rhino population.  Hence, this method could be
   called within HIBMcalcs.step_() at the point where rhinos are
   randomly moved between patches.  This is around line 1012 and the
   comment starting with the sentence: "Update each individual's
   patch membership."  Time steps need to be attended to: This class
   needs its own time step as movement dynamics happen over much
   shorter time scales than do energy budgets.  For example, the
   current version of the rhino IBM has a time step of one week and
   can be computed with:
   
   beltmept[thrd] - HIBMcalcs.lasttme
*/

static boolean readsmsfles = false;

static String gisflename[] = new String[5];

static int nmanimals = 0, pathplotflenm = 3, nmtwivals = 0, nmdists = 5;

static int index[][] = new int[NMTHRDS][NMTHRDS * SIMSZE];
static int nmobssteps[] = new int[DATSZE];
static int subsnmsteps[] = new int[DATSZE];

static double sensrange = .7, stepduration = .10, stepsize = .05,
   twimax = 0., twiscale = 0.;

static double loc[][] = new double[NMTHRDS][2];
static double newloc[][] = new double[NMTHRDS][2];
static double hdutilityloc[][] = new double[NMTHRDS][2];
static double rotangle[] = new double[NMTHRDS];
static double coeff[] = new double[10];
static double dist[][] = new double[NMTHRDS][100];
static double hdcnstnt[] = new double[NMTHRDS];
static double hdunifprb[] = new double[NMTHRDS];
static double hprev[][][] = new double[NMTHRDS][SIMSZE][NMSMSINDIV];

// TWI surface.

static double twiloc[][] = new double[100][2];
static double twival[] = new double[100];

// Observed and subsampled paths arrays.

static double obspath[][][] = new double[DATSZE][NMSTEPS][2];
static double subspath[][][] = new double[DATSZE][NMSTEPS][2];

// This array can get very large.

static double path[][][][][] =
   new double[NMTHRDS][SIMSZE][NMSMSINDIV][NMSTEPS][2];

// Variables and arrays for adquad.

static boolean rtf[] = new boolean[NMTHRDS];

static int splmin, splmax, splout, nomax, nofin;

static int spl[] = new int[NMTHRDS];
static int nim[] = new int[NMTHRDS];
static int nofun[] = new int[NMTHRDS];
static int nmsteps[] = new int[NMTHRDS];

static double a, b, w0, w1, w2, w3, w4, s2, abserr = 1.e-6, relerr = 1.e-6;

static double errest[] = new double[NMTHRDS];
static double result[] = new double[NMTHRDS];
static double flag[] = new double[NMTHRDS];
static double area[] = new double[NMTHRDS];
static double x0[] = new double[NMTHRDS];
static double f0[] = new double[NMTHRDS];
static double s1[] = new double[NMTHRDS];
static double cor11[] = new double[NMTHRDS];
static double qprev[] = new double[NMTHRDS];
static double qnow[] = new double[NMTHRDS];
static double qdiff[] = new double[NMTHRDS];
static double qleft[] = new double[NMTHRDS];
static double esterr[] = new double[NMTHRDS];

static double qright[][] = new double[NMTHRDS][31];
static double f[][] = new double[NMTHRDS][16];
static double x[][] = new double[NMTHRDS][16];
static double fsave[][][] = new double[NMTHRDS][8][30];
static double xsave[][][] = new double[NMTHRDS][8][30];

// -----------------------------------------------------------------

static void simpaths_(int thrd, double nodevals[][][],
   double avepathrange[][], int dst) {

/* Has each member of the population take "nmsteps" steps across the
   time interval "(lasttme, beltmept[thrd])."  Note that "nmsteps"
   is internally computed based on the time interval and the value of
   "stepduration" which in turn, is an internal value that
   corresponds to how long this type of animal takes to make one
   step.  Returns the population's average tortuosity. */

int i, j, k, mcpathnm, nmtrys = 100;

double h = -1.;

if (nmanimals == 0) {
   iderr_("simpaths: nmanimals=0");
}

// Get Monte Carlo simulation sample path.

mcpathnm = idenom[thrd];

// At the first time point only, initialize the model.

--dst;
if (firsttimepoint[thrd]) {
   if (initialIntridsTime) {
      initialsms_(thrd, mcpathnm, nodevals, dst);
   }
}

// Figure out how many steps a herbivore is to take.

if (idinfo_hashibm[nmids - 1]) {
   nmsteps[thrd] = (int) Math.round((beltmept[thrd] - HIBMcalcs.lasttme) /
	       	   stepduration);

} else {
   nmsteps[thrd] = (int) Math.round((Intridslve.tfinal - Intridslve.t0) /
	       	   stepduration);
} 

// Loop over these steps.

/*
printf_("simpaths: thrd= " + thrd + " nmsteps= " + nmsteps[thrd] +
   " nmanimals= " + nmanimals);
*/

rotangle[thrd] = PIT2 * Rndm.rndm1_(0,0); 
for (i = 1; i < nmsteps[thrd]; ++i) {
   for (j = 1; j <= nmanimals; ++j) {

      /* Form the heading probability distribution as a function of
         the covariates by finding the normalizing constant with
	 numerical integration.  First, locate the animal. */

      loc[thrd][0] = path[thrd][mcpathnm][j - 1][i - 1][0];
      loc[thrd][1] = path[thrd][mcpathnm][j - 1][i - 1][1];
      hdcnstnt[thrd] = adquad_(thrd, 0., PIT2);

      /*
      if (hdcnstnt[thrd] < 1.e-4) {
         printf_("simpaths: animal= " + j + " step= " + i);
      }
      */

      /* Sample one deviate from this distribution repeatedly until a
         traversable path is found. */

      for (k = 0; k < nmtrys; ++k) {
         h = samplehd_(thrd) - rotangle[thrd];
         h = .999 * h + .001 * hprev[thrd][mcpathnm][j - 1];
	 takestep_(h, stepsize, path[thrd][mcpathnm][j - 1][i - 1],
		   newloc[thrd]);
	 if (traversablepath_(path[thrd][mcpathnm][j - 1][i - 1],
                              newloc[thrd])) {
            hprev[thrd][mcpathnm][j - 1] = h;
            break;
	 }
      }

      /*
      printf_("simpaths: nmtries= " + (k + 1) + " step= " + i +
         " animal= " + j + " h= " + h);
      */

      // Move this animal to its new location.

      path[thrd][mcpathnm][j - 1][i][0] = newloc[thrd][0];
      path[thrd][mcpathnm][j - 1][i][1] = newloc[thrd][1];

      /*
      printf_("simpaths: x= " + path[thrd][mcpathnm][j - 1][i][0] +
         " y= " + path[thrd][mcpathnm][j - 1][i][1]);
      */
   }

   /*
   printf_("simpaths: thrd= " + thrd + " path= " + mcpathnm + " step= " +
      i);
   */
}
}

// ------------------------------------------------------------

static double hdutilityfcn_(int thrd, double h) {

/* Evaluates the animal's heading utility function at the value "h"
   using covariate values in "x." */

int i;

double dist = 0., twival = 0., twiprev = 0., twidif = 0., twigrad = 0.,
   twimaxgrad = 0., utility = 0.;

/* Topographic Wetness Index (TWI) effect.  First, sense TWI at
   your current location. */

twiprev = rasterlookup_(thrd, 1, loc[thrd]);

/* Use the maximum gradient of sensed TWI value at several different
   distances.  This gradient has been scaled so that its maximum
   value is 10.0. */

for (i = 1; i <= nmdists; ++i) {
   dist = sensrange * ((double) i) / ((double) nmdists);
   hdutilityloc[thrd][0] = loc[thrd][0] + dist * Math.cos(h);
   hdutilityloc[thrd][1] = loc[thrd][1] + dist * Math.sin(h);

   /*
   printf_("hdutilityfcn: h= " + h + " x= " + hdutilityloc[thrd][0] +
      " y= " + hdutilityloc[thrd][1] + " xorig= " + loc[thrd][0] +
      " yorig= " + loc[thrd][1]);
   */

   // Look up the TWI value at "newloc" and compute the gradient.

   twidif = rasterlookup_(thrd, 1, hdutilityloc[thrd]) - twiprev;
   twigrad = twidif / dist;
   if (twigrad > twimaxgrad) {
      twimaxgrad = twigrad;
   }
}

utility = coeff[0] * 10. * twimaxgrad / twiscale;
if (utility <= 0.) {
   utility = 0.00001;
}

/*
printf_("hdutilityfcn: h= " + h + " xorig= " + loc[thrd][0] +
      " yorig= " + loc[thrd][1] + " twimax= " + twimax);
*/

return utility;
}

// ---------------------------------------------------------------

static double rasterlookup_(int thrd, int varnm, double loc[]) {

/* Finds the location closest to "loc" and returns the value of the
   spatial variable, "varnm" at that location. */

int i;

double xdiff = 0., ydiff = 0.;

// Compute the distance between "loc" and each raster location.

for (i = 0; i < nmtwivals; ++i) {
   xdiff = loc[0] - twiloc[i][0];
   ydiff = loc[1] - twiloc[i][1];
   dist[thrd][i] = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
   index[thrd][i] = i + 1;
}

Idsort.shellsort_(dist[thrd], index[thrd], nmtwivals);

return (.5 * (twival[index[thrd][0] - 1] +
              twival[index[thrd][1] - 1]));
}

// -------------------------------------------------------------

static double samplehd_(int thrd) {

// Samples one deviate from the heading distribution.

double h = 0., sol = 0.;

// Draw a deviate from the unit-interval uniform distribution.

hdunifprb[thrd] = Rndm.rndm1_(0, 0);

/* Evaluate the heading distribution's quantile function at this
   probablity value. */

sol = SMSutils.fmin_(thrd, 0., PIT2);
h = rotangle[thrd] + sol;

/*
if (SMSutils.iter < 5) {
   printf_("samplehd: solprb= " + SMSutils.solprb + " hdunifprb= " +
      hdunifprb[thrd]);
}
*/

if (h > PIT2) {
   h -= PIT2;
}

return h;
}

// ------------------------------------------------------------------

static void takestep_(double h, double stepsize, double loc[],
   double newloc[]) {

// Takes a step along the heading, h.

newloc[0] = loc[0] + stepsize * Math.cos(h);
newloc[1] = loc[1] + stepsize * Math.sin(h);
}

// -----------------------------------------------------------------

static boolean traversablepath_(double loc[], double trialloc[]) {

// Checks if the path (loc, trialloc) is traversable.

boolean traversable = false;

double dstmin;

dstmin = Surf.bdry_(bdry_nmbdpts[0], bdry_xbdry[0],
               bdry_ybdry[0], trialloc[0], trialloc[1]); 

if (dstmin >= 0.) {
   traversable = true; 
}

return traversable;
}

// -----------------------------------------------------------------

static void initialsms_(int thrd, int pathnm, double nodevals[][][],
   int dst) {

/* Specify initial positions of the "nmanimals" animals.  These
   should be the beginning locations in the animal movement
   data set. */

int i;

/*
path[thrd][pathnm][0][0][0] = 1.01 * bdry_xmin[0];
path[thrd][pathnm][0][0][1] = 1.01 * bdry_ymin[0];
path[thrd][pathnm][1][0][0] = .99 * bdry_xmax[0];
path[thrd][pathnm][1][0][1] = .99 * bdry_ymax[0];
*/

for (i = 0; i < nmanimals; ++i) {
   path[thrd][pathnm][i][0][0] = subspath[i][0][0];
   path[thrd][pathnm][i][0][1] = subspath[i][0][1];
}
}

// -----------------------------------------------------------------

static void smsreadfles_(int dst) {

// Read input files.

int i, flenm = 4;

double xdif, ydif;

// Read data file to discover number of animals.

CA.nmobsnds = Getdata.getdata_(datafle, CA.obsnd);
if (nmecoobsttl == 0) {
   iderr_("smsreadfles: ecosystem data file is empty.");
}

// Read boundary file.

fleopen_(3, spacetime_bdrysfle, 'r');

fgetline_(3);
fgetline_(3);
bdry_nmbdpts[0] = fgetint_(3);
fgetstrng_(3);
fgetint_(3);

bdry_xmin[0] = 1.e6;
bdry_xmax[0] = 0.;
bdry_ymin[0] = 1.e6;
bdry_ymax[0] = 0.;

for (i = 0; i < bdry_nmbdpts[0]; ++i) {
   bdry_xbdry[0][i] = fgetdble_(3);
   bdry_ybdry[0][i] = fgetdble_(3);
   if (bdry_xmin[0] > bdry_xbdry[0][i]) {
      bdry_xmin[0] = bdry_xbdry[0][i];
   }
   if (bdry_ymin[0] > bdry_ybdry[0][i]) {
      bdry_ymin[0] = bdry_ybdry[0][i];
   }
   if (bdry_xmax[0] < bdry_xbdry[0][i]) {
      bdry_xmax[0] = bdry_xbdry[0][i];
   }
   if (bdry_ymax[0] < bdry_ybdry[0][i]) {
      bdry_ymax[0] = bdry_ybdry[0][i];
   }
}
fclose_(3, 'r');

xdif = bdry_xmax[0] - bdry_xmin[0];
ydif = bdry_ymax[0] - bdry_ymin[0];

// Read-in GIS layers, if any.

if (nmgisfles == 0) {
   return;
}

fleopen_(flenm, gisflename[0], 'r');

nmtwivals = 0;
while (!checkeof_(flenm)) {
   twiloc[nmtwivals][0] = fgetdble_(flenm);
   twiloc[nmtwivals][1] = fgetdble_(flenm);
   twival[nmtwivals] = fgetdble_(flenm);

   if (twival[nmtwivals] > twimax) {
      twimax = twival[nmtwivals];
   }

   ++nmtwivals;
}
fclose_(flenm, 'r');
}

// ---------------------------------------------------------------

static void smssetup_(int dst) {

// Read input files and initialize the population.

int i, k;

--dst;

// Read input files and open path plotting file.

if (!readsmsfles) {
   smsreadfles_(dst);
   fleopen_(pathplotflenm, spacetime_xyptsfle, 'w');
   readsmsfles = true;
}

// Load parameter values.

for (k = 1; k <= nmnds; ++k) {
   if (varinfo_dist[idnmbrm1][k - 1].equals("SMS")) {
      break;
   }
}

/* Parameter         Name
      1              TWI effect size
*/

coeff[0] = condprb[idnmbrm1][k - 1][0][0][0][0][0][0][0][dst];

// Compute TWI scaling constant.

twiscale = twimax / (sensrange / ((double) nmdists));
}

// ----------------------------------------------------------------

static void impute_animal_locations_(int nmobsanimals,
   double obsanimal[][], double obsanimaltime[], int nmtimes,
   double time[], int nmanimals, double animal[][][]) {

/* Impute the locations of a region's animal population at each time
   point.  Animals move according to an individual-based model of
   movement.  If a live animal is observed (called an "observed
   animal"), the nearest simulated animal at the associated observed
   time is moved to that observed location and the simulation is
   continued from this updated set of animal locations. */

int i, j, nmattempts;

double xdif = 0., ydif = 0., x, y, dstmin;

// Read boundary file.

smsreadfles_(1);

xdif = bdry_xmax[0] - bdry_xmin[0];
ydif = bdry_ymax[0] - bdry_ymin[0];

/* Locate animals in the reserve by randomly dithering the locations
   of the observed animals.  Do not move them through time. */

printf_("impute: nmanimals= " + nmanimals);

MAINLOOP: for (i = 0; i < nmanimals; ++i) {

   /* Use rejection sampling to find a random point that is within
      the boundary. */

   nmattempts = 0;
   do {
      dstmin = Surf.bdry_(bdry_nmbdpts[0], bdry_xbdry[0], bdry_ybdry[0],
		          obsanimal[i][0], obsanimal[i][1]);
      if (dstmin < 0.) {
         continue MAINLOOP;
      }
      x = obsanimal[i][0] + .001 * xdif * (-1. + 2. * Rndm.rndm1_(0, 0));
      y = obsanimal[i][1] + .001 * ydif * (-1. + 2. * Rndm.rndm1_(0, 0));
      dstmin = Surf.bdry_(bdry_nmbdpts[0], bdry_xbdry[0], bdry_ybdry[0],
		          x, y);
      ++nmattempts;
      if (nmattempts > 1000) {
         iderr_("impute_animals: nmattempts= " + nmattempts);
      }
   } while (dstmin < 0.);

   // Keep this animal at this location for all time points.

   for (j = 0; j < nmtimes; ++j) {
      animal[j][i][0] = x;
      animal[j][i][1] = y;
   }
}
}

// ----------------------------------------------------------------

static double adquad_(int thrd, double lower, double upper) {

// Adaptive quadrature, see Quad.java.

double tolerr = 0.;

a = lower;
b = upper;

/*
a = 0.;
b = 10.;
*/

splmin = 1;
splmax = 30;
splout = 6;
nomax = 2000;
nofin = nomax - 8 * (splmax - splout) + ((int) (Math.pow(2., splout + 1)));

// If nofun reaches nofin then we have trouble.

w0 = 3956.0 / 14175.0;
w1 = 23552.0 / 14175.0;
w2 = -3712.0 / 14175.0;
w3 = 41984.0 / 14175.0;
w4 = -18160.0 / 14175.0;

// Initialize sums.

flag[thrd] = 0.;
result[thrd] = 0.;
cor11[thrd] = 0.;
area[thrd] = 0.;
errest[thrd] = 0.;
nofun[thrd]  = 0;

if (a != b) {

   // Initialize.

   initialize_(thrd);
   rtf[thrd] = false;
   do {
      mainclc_(thrd);

      // Interval convergence test.

      esterr[thrd] = Math.abs(qdiff[thrd]) / 1023.;
      tolerr = Math.max(abserr, relerr * Math.abs(area[thrd])) *
	       (s1[thrd] / s2);

      if (spl[thrd] < splmin) leveldown_(thrd);
      else if (spl[thrd] >= splmax) flagincr_(thrd);
      else if (nofun[thrd] > nofin) trouble_(thrd);
      else if (esterr[thrd] <= tolerr) sumup_(thrd);
      else leveldown_(thrd);
   } while (rtf[thrd] == false);
}
return result[thrd];
}

// -----------------------------------------------------------------

static void mainclc_(int thrd) {

/* Central calculation.  Calculates x1, ..., x15, f1, ..., f15,
   qleft[thrd], qright[thrd], qnow[thrd], qdiff[thrd][thrd], and
   area[thrd] from x0[thrd], x2, ..., x16, and f0[thrd],
   f2, ..., f16. */

int j, jj;

x[thrd][0] = (x0[thrd] + x[thrd][1]) / 2.;
f[thrd][0] = fun_(thrd, x[thrd][0]);
for (jj = 1; jj <= 7; ++jj) {
   j = jj * 2 + 1;
   x[thrd][j - 1] = (x[thrd][j - 2] + x[thrd][j]) / 2.;
   f[thrd][j - 1] = fun_(thrd, x[thrd][j - 1]);
}
nofun[thrd] += 8;
s1[thrd] = (x[thrd][15] - x0[thrd]) / 16.;

qleft[thrd] = (w0 * (f0[thrd] + f[thrd][7]) +
         w1 * (f[thrd][0] + f[thrd][6]) +
         w2 * (f[thrd][1] + f[thrd][5]) +
         w3 * (f[thrd][2] + f[thrd][4]) +
         w4 *  f[thrd][3]) * s1[thrd];

qright[thrd][spl[thrd]] = (w0 * (f[thrd][7] + f[thrd][15]) +
               w1 * (f[thrd][8] + f[thrd][14]) +
               w2 * (f[thrd][9] + f[thrd][13]) +
               w3 * (f[thrd][10] + f[thrd][12]) +
               w4 * f[thrd][11]) * s1[thrd];

qnow[thrd] = qleft[thrd] + qright[thrd][spl[thrd]];
qdiff[thrd] = qnow[thrd] - qprev[thrd];
area[thrd] += qdiff[thrd];
}

// ------------------------------------------------------------------

static void leveldown_(int thrd) {

// No convergence, locate the next interval.

int i, j;

nim[thrd] *= 2;
++spl[thrd];

// Store right-hand elements for the future.

for (i = 1; i <= 8; ++i) {
   fsave[thrd][i - 1][spl[thrd] - 1] = f[thrd][i + 7];
   xsave[thrd][i - 1][spl[thrd] - 1] = x[thrd][i + 7];
}

// Store left-hand elements for use now.

qprev[thrd] = qleft[thrd];
for (i = 1; i <= 8; ++i) {
   j = -i;
   f[thrd][2 * j + 17] = f[thrd][j + 8];
   x[thrd][2 * j + 17] = x[thrd][j + 8];
}
}

// ---------------------------------------------------------------

static void setreturn_(int thrd) {

// Finalization in preparation for return.

double temp = 0.;

result[thrd] += cor11[thrd];

// Make sure that errest[thrd] is not less than roundoff.

if (errest[thrd] != 0.) {
   temp = Math.abs(result[thrd]) + errest[thrd];
   if (temp == Math.abs(result[thrd])) {
      do {
         errest[thrd] = 2. * errest[thrd];
         temp = Math.abs(result[thrd]) + errest[thrd];
      } while (temp == Math.abs(result[thrd]));
   }
}
rtf[thrd] = true;
}

// ----------------------------------------------------------------

static void sumup_(int thrd) {

// Add contributions into running sums.

int i;

result[thrd] += qnow[thrd];
errest[thrd] += esterr[thrd];
cor11[thrd] += qdiff[thrd] / 1023.;

// Find next interval.

while (nim[thrd] != 2. * (nim[thrd] / 2)) {
   nim[thrd] /= 2;
   --spl[thrd];
}
++nim[thrd];

if (spl[thrd] <= 0) {
   setreturn_(thrd);

} else {

   // Gather elements for next interval.

   qprev[thrd] = qright[thrd][spl[thrd] - 1];
   x0[thrd] = x[thrd][15];
   f0[thrd] = f[thrd][15];
   for (i = 1; i <= 8; ++i) {
      f[thrd][2 * i - 1] = fsave[thrd][i - 1][spl[thrd] - 1];
      x[thrd][2 * i - 1] = xsave[thrd][i - 1][spl[thrd] - 1];
   }
}
}

// ---------------------------------------------------------------

static void trouble_(int thrd) {

// Trouble; number of function values about to exceed limit.

nofin *= 2;
splmax = splout;
flag[thrd] += (b - x0[thrd]) / (b - a);
sumup_(thrd);
}

// ----------------------------------------------------------------

static void flagincr_(int thrd) {

// Current level is splmax.

flag[thrd] += 1.;
sumup_(thrd);
}

// ----------------------------------------------------------------

static void initialize_(int thrd) {

// Initialization for first interval.

int j;

spl[thrd] = 0;
nim[thrd] = 1;
x0[thrd] = a;
x[thrd][15] = b;
qprev[thrd] = 0.;
f0[thrd] = fun_(thrd, x0[thrd]);
s2 = (b - a) / 16.;
x[thrd][7] = (x0[thrd] + x[thrd][15]) / 2.;
x[thrd][3] = (x0[thrd] + x[thrd][7]) / 2.;
x[thrd][11] = (x[thrd][7] + x[thrd][15]) / 2.;
x[thrd][1] = (x0[thrd] + x[thrd][3]) / 2.;
x[thrd][5] = (x[thrd][3] + x[thrd][7]) / 2.;
x[thrd][9] = (x[thrd][7] + x[thrd][11]) / 2.;
x[thrd][13] = (x[thrd][11] + x[thrd][15]) / 2.;
for (j = 1; j <= 8; ++j) {
   f[thrd][2 * j - 1] = fun_(thrd, x[thrd][2 * j - 1]);
}
nofun[thrd] = 9;
}

// ----------------------------------------------------------------

static double fun_(int thrd, double x) {

// Integrand function.

double val1, val2, retval = 0.;

/* Test function.  The integral over the interval (0, 10) should be
   5.0.

retval = .5 + .5 * (1. - Math.exp(-.05 * x)) * Math.sin(x * x);
printf_("fun: x= " + x + " retval= " + retval);
if (true) return retval;
*/

// Evaluate the heading utility function.

retval = hdutilityfcn_(thrd, x);
return retval;
}
}
