class SNA extends Id {

// Main class for Social Network Analysis (SNA).

static boolean innode[] = new boolean[TNMNDS];
static boolean containsnodei[] = new boolean[TNMLINKS];
static boolean unobsadjmat[][] = new boolean[TNMNDS][TNMNDS];
static boolean linkused[] = new boolean[TNMNDSSQRD / 2];
static boolean inactivePlayer[] = new boolean[TNMNDS];

static String linksfle, firstarrest = "none", secondarrest = "none",
   eigensccssr = "none", betweensccssr = "none",
   actionableIntelligenceReportFile = "none";

static String playerID[] = new String[TNMNDS];
static String name[][] = new String[NMSNETS][TNMNDS];
static String town[][] = new String[NMSNETS][TNMNDS];
static String country[][] = new String[NMSNETS][TNMNDS];
static String vehicles[][][] = new String[NMSNETS][TNMNDS][10];
static String contacts[][][] = new String[NMSNETS][TNMNDS][TNMNDS];
static String allid[] = new String[TNMNDS];
static String noderpts[][] = new String[TNMNDS][100];
static String regionresidence[][] = new String[NMSNETS][TNMNDS];
static String region[] = new String[TNMVALS];

static int nmlevels, prednmlinks, nmtimepts = 1, nmnewlinks, nmlinks,
   nmobslinks = 0, nmunobslinks, nmlevelpttrns, nmunobslinkpttrns,
   linksfletype = 0;

static int nmnodes[] = new int[NMSNETS];
static int index[] = new int[TNMLINKS];
static int obsindex[] = new int[TNMNDS];
static int nPaths[][] = new int[TNMNDS][TNMNDS];
static int prednodelevel[] = new int[TNMNDS];
static int predlink[][] = new int[TNMNDSSQRD / 2][2];
static int newlink[][] = new int[500][2];
static int nmlevelk[] = new int[3];
static int predindex[] = new int[TNMNDS];
static int newnm[] = new int[TNMNDS];
static int nodelevel[] = new int[TNMNDS];
static int levelsim[][] = new int[SIMSZE][TNMNDS];
static int obslink[][] = new int[TNMNDS][2];
static int alllink[][][] = new int[NMSNETS][TNMNDS][2];
static int link[][] = new int[TNMNDS][2];
static int nmalllinks[] = new int[NMSNETS];
static int net[][] = new int[NMSNETS][TNMNDS];
static int netsze[] = new int[NMSNETS];
static int cnvrtdnmbr[] = new int[TNMNDS];
static int friend[] = new int[TNMLINKS];
static int friendi[] = new int[TNMNDS];
static int friendj[] = new int[TNMNDS];
static int idumvec[] = new int[TNMNDS];
static int allnmraids[] = new int[TNMNDS];
static int allarrests[] = new int[TNMNDS];
static int allshipments[] = new int[TNMNDS];
static int allphones[] = new int[TNMNDS];
static int allvehicles[] = new int[TNMNDS];
static int allfirearms[] = new int[TNMNDS];
static int nmphones[] = new int[TNMNDS];
static int nmvehicles[][] = new int[NMSNETS][TNMNDS];
static int nmfirearms[] = new int[TNMNDS];
static int nmcontacts[][] = new int[NMSNETS][TNMNDS];
static int nmrpts[] = new int[TNMNDS];
static int maxeigenindex[] = new int[NMSNETS];
static int maxbetweenindex[] = new int[NMSNETS];

static double resiliencyindex = 1.;

static double connectindex[] = new double[NMSNETS];
static double curAdj[][] = new double[TNMNDS][TNMNDS];
static double dists[][] = new double[TNMNDS][TNMNDS];
static double eigencent[][] = new double[NMSNETS][TNMNDS];
static double betweencent[][] = new double[NMSNETS][TNMNDS];
static double sortedbetween[] = new double[TNMNDS];
static double degreecent[][] = new double[NMSNETS][TNMNDS];
static double brokercent[][] = new double[NMSNETS][TNMNDS];
static double dumvec[] = new double[TNMNDS];
static double thetak[] = new double[3];
static double etakl[][] = new double[TNMNDS][TNMNDS];
static double predadjmat[][] = new double[TNMNDS][TNMNDS];
static double nolinkcfscr[] = new double[TNMNDSSQRD / 2];
static double nolinktfscr[] = new double[TNMNDSSQRD / 2];
static double linkcfscr[] = new double[TNMNDSSQRD / 2];
static double linktfscr[] = new double[TNMNDSSQRD / 2];
static double attributemax[] = new double[NMSNETS];
static double nodeattribute[][] = new double[TNMNDS][10];
static double adjmat[][] = new double[TNMNDS][TNMNDS];
static double obsdegree[] = new double[TNMNDS];
static double preddegree[] = new double[TNMNDS];
static double degree[] = new double[TNMNDS];
static double degreesim[][] = new double[SIMSZE][TNMNDS];
static double par[] = new double[OPTSIZE];
static double rptwght[][] = new double[TNMNDS][TNMNDS];
static double timept[] = new double[10];
static double medianeigenval[] = new double[NMSNETS];
static double playerextinctrisk[] = new double[TNMNDS];
static double regionextinctrisk[] = new double[TNMVALS];

// ------------------------------------------------------------------

static void findKeyPlayers_() {

/* Finds a network's key players by computing several centrality measures.
   This method assumes that the network is observed at three different
   times, t_1, t_2, and t_3.  The network is quietly observed at t_1.
   At t_2, the network is observed again in order to build the Detain,
   Surveil, and Interdict lists -- and also to identify those players who
   are Rising Stars.  Just after t_2, this method assumes that the
   recommended players to arrest have actually been arrested and removed
   from the network.  The time point t_3 is several weeks after these
   arrests have been made.  Observing the size and connectivity of the
   network at t_3 allows the network's Resiliency Index to be computed.

   The network is initially observed at t_1.  At t_2, some players have
   increased their connectivity and may have become Rising Stars.  This
   t_2 network can only be observed, not computed from the network at
   t_1.  Likewise, the network at t_3 has rebuilt itself in some fashion
   after the arrests made just after t_2.  Hence, there is no way to
   compute the network at t_3 given the network at t_2.  The two network
   plots at t_2 and t_3 are of interest to law enforcement but the network
   at t_1 contains less information than the network at t_2 and hence is
   not plotted.
 */

boolean foundstars = false;

String plotfilename = "none";

int i, j, k, puppetmaster = 0, nmtoprint = 0, nmregions;

double maxratio, betweentodegree, val = 0., wght = 0.;

/* Read-in the syndicate's entire social network at each observed time.
   First, read the links section header and the number of time points. */

fleopen_(4, linksfle, 'r');
fgetline_(4);
linksfletype = fgetint_(4);
nmtimepts = fgetint_(4);
if (nmtimepts != 3) {
   iderr_("findKeyPlayers: nmtimepts= " + nmtimepts);
}

// Now read player connectivity.

for (i = 0; i < nmtimepts; ++i) {
   SNAutils.readnetwork_(4, i);
}
fclose_(4, 'r');

// Open the actionable intelligence report file.

fleopen_(9, actionableIntelligenceReportFile, 'w');
fprintf_(9, "\n           ACTIONABLE INTELLIGENCE REPORT\n");
fprintf_(9, "\n---------- Social Network Analysis Metrics -------------");

// Loop over time points.

for (i = 0; i < nmtimepts; ++i) {

   // Initialize arrays.

   for (j = 0; j < TNMNDSSQRD / 2; ++j) {
      predlink[j][0] = 0;
      predlink[j][1] = 0;
   }
   for (j = 0; j < TNMNDS; ++j) {
      for (k = 0; k < TNMNDS; ++k) {
         predadjmat[j][k] = 0.;
         adjmat[j][k] = 0.;
      }
   }

   // Load "predlink" and "predadjmat" network linkage arrays.

   prednmlinks = nmalllinks[i];
   for (j = 0; j < prednmlinks; ++j) {

      // Compute the link's weight.
      /*
      wght = 2.;
      for (j = 0; j < nmattributes; ++j) {
         val = Math.abs(nodeattribute[predlink[i][0] - 1][j] -
                     nodeattribute[predlink[i][1] - 1][j]);
         val /= 2. * attributemax[j];
         wght -= val;
         wght = 1.;
      }
      */

      wght = 1.;
 
      // Weight from number of evidence reports in common.
      //wght += rptwght[predlink[i][0] - 1][predlink[i][1] - 1];

      predlink[j][0] = alllink[i][j][0];
      predlink[j][1] = alllink[i][j][1];
      predadjmat[predlink[j][0] - 1][predlink[j][1] - 1] = wght;
      predadjmat[predlink[j][1] - 1][predlink[j][0] - 1] = wght;
      adjmat[predlink[j][0] - 1][predlink[j][1] - 1] = wght;
      adjmat[predlink[j][1] - 1][predlink[j][0] - 1] = wght;
   }

   /* Compute each player's eigenvector centrality and the
      network connectivity index. */

   connectindex[i] = eigencent_(nmnodes[i], predadjmat, eigencent[i]);

   // Compute each player's degree centrality.

   degree_(nmnodes[i], prednmlinks, predlink, degreecent[i]);

   /* Perform a descending sort on player eigenvector centrality and
      print them. */

   for (j = 0; j < nmnodes[i]; ++j) {
      index[j] = j + 1;
      eigencent[i][j] *= -1.;
   }
   Idsort.idsort_(eigencent[i], index, 1, nmnodes[i]);
   for (j = 0; j < nmnodes[i]; ++j) {
      eigencent[i][j] *= -1.;
   }
   maxeigenindex[i] = index[i];
   medianeigenval[i] = eigencent[i][index[nmnodes[i] / 2] - 1];

   // Restrict printing of giant networks to only 20 players.
   //nmtoprint = Math.min(nmnodes[i], 20);
   nmtoprint = nmnodes[i];

   fprintf_(9, "\nTime point " + (i + 1));
   fprintf_(9, " Player  Eigenvector  Degree      Predicted\n" +
               "         Centrality   Centrality  Level");
   for (j = 0; j < nmtoprint; ++j) {
      fprintf_(9, fstrng_(name[i][index[j] - 1], 5) + "      " +
         fdble_(eigencent[i][j], 8, 3) + "    " +
         fdble_(degreecent[i][index[j] - 1], 8, 3) + "    " +
         prednodelevel[index[j] - 1]);
   }

   // Compute each player's betweenness centrality.

   betweencent_(nmnodes[i], predadjmat, betweencent[i]);

   /* Perform a descending sort of the players on their betweenness score
      from the first time point's network.  Print this sorted list. */

   for (j = 0; j < nmnodes[i]; ++j) {
      index[j] = j + 1;
      sortedbetween[j] = -betweencent[i][j];
   }
   Idsort.idsort_(sortedbetween, index, 1, nmnodes[i]);
   maxbetweenindex[i] = index[0];
   if (maxbetweenindex[i] == maxeigenindex[i]) {
      maxbetweenindex[i] = index[1];
   }
   for (j = 0; j < nmnodes[i]; ++j) {
      sortedbetween[j] *= -1.;
   }

   fprintf_(9, "\n             Betweenness Between/Degree");
   for (j = 0; j < nmtoprint; ++j) {
      fprintf_(9, fstrng_(name[i][index[j] - 1], 5) + "        " +
         fdble_(sortedbetween[j], 8, 3) + "     " +
         fdble_((sortedbetween[j] / degreecent[i][index[j] - 1]), 8, 3) +
         "    " + prednodelevel[index[j] - 1]);
   }

   // Compute each player's brokerage score centrality.

   brokeragecent_(nmnodes[i], predadjmat, brokercent[i]);

   // Sort players on descending brokerage score and print them.

   for (j = 0; j < nmnodes[i]; ++j) {
      index[j] = j + 1;
      brokercent[i][j] *= -1.;
   }
   Idsort.idsort_(brokercent[i], index, 1, nmnodes[i]);
   fprintf_(9, "\n  Gould-Fernandez total brokerage score");
   for (j = 0; j < nmtoprint; ++j) {
      brokercent[i][j] *= -1.;
      fprintf_(9, "   " + fstrng_(name[i][index[j] - 1], 5) + "       " +
         fdble_(brokercent[i][j], 6, 1) + "        " +
         prednodelevel[index[j] - 1]);
   }

   // Compute the network's community structure.

   SNAutils.assigncomm_(nmnodes[i]);
   fprintf_(9, "\n  Network Community Structure");
   fprintf_(9, "Number of algorithm iterations = " + SNAutils.nmiters +
      "\nNumber of communities: " + SNAutils.nmcomms);
   fprintf_(9, "\n Player    Community");
   for (j = 0; j < nmnodes[i]; ++j) {
      fprintf_(9, fstrng_(name[i][j], 5) + "       " + SNAutils.nodecomm[j]);
   }

   /* Plot the network either just before arrests (t_2) or after the
      network has had some chance to recover from these arrests (t_3). */
   
   if (i == 1 || i == 2) {
      plotfilename = "netplot" + i + ".ps";   
      Forcegrph.forcegrph_(i, plotfilename);
   }
} // End of loop over time points.

// ------------------ Arrest Sequence Computation ---------------------

/* Because Felbab-Brown (2018) shows that removing local players has the most
   impact on curbing local extinctions, arrest those players who both reside
   in regions of high local extinction risk and who have the highest
   eigenvector centrality.
 
   Implement this idea by sorting all players into an arrest sequence list.
   The level 1 is a descending sort of all players by the local extinction
   risk of the region of their residence.  The second level is a
   descending sort on their time point 1 eigenvector centrality.

   Leave the decision of how many players to arrest to Law Enforcement.
   Depending on the political situation, Law Enforcement may have enough
   resources to arrest a large number of players. */

// Step 1: Read-in per-region extinction risk.

fleopen_(11, "riskbyregion.txt", 'r');
printf_("findKeyPlayers: strn1= " + fgetstrng_(11));
printf_("findKeyPlayers: Time point= " + fgetdble_(11));
fgetline_(11);
i = 0;
do {
   region[i] = fgetstrng_(11);
   
   // extinction probability is not used here.

   printf_("findKeyPlayers: region= " + region[i] + " strng2= " +
      fgetstrng_(11) + " extinctprob= " + fgetdble_(11));

   printf_("findKeyPlayers: strng3= " + fgetstrng_(11));
   regionextinctrisk[i] = fgetdble_(11);
   printf_("findKeyPlayers: i= " + i + " risk= " + regionextinctrisk[i] +
      " strng4= " + fgetstrng_(11) + " strng5= " + fgetstrng_(11));
   /*
   fprintf_(11, " " + nodelbls[idnmbrm1][regionnodenumber - 1][indx[i]] +
      " & " + fdble_(extinctprob[indx[i] - 1], 5, 3) + " & " +
      fdble_(risk[indx[i] - 1], 5, 3) + " \\\\");
   */
   ++i;
} while (!checkbuffeof_(11));
fclose_(11, 'r');
nmregions = i;

// Remove country tags.

for (i = 0; i < nmregions; ++i) {
   region[i] = region[i].replaceAll("k_", "");
   region[i] = region[i].replaceAll("t_", "");
}

/* Step 2: Assign an extinction risk to each player according to the region of
   of their residency. */

for (i = 0; i < nmnodes[0]; ++i) {
   playerextinctrisk[i] = -1.;
   for (j = 0; j < nmregions; ++j) {
      if (regionresidence[0][i].equals(region[j])) {
         playerextinctrisk[i] = regionextinctrisk[j];
	 break;
      }
   }
   if (playerextinctrisk[i] == -1.) {
      printf_("findKeyPlayers: name= " + name[0][i] + " risk not found");
   }
}

// Step 3: Perform the two-level descending sort.

for (i = 0; i < nmnodes[0]; ++i) {
   index[i] = i + 1;
   playerextinctrisk[i] *= -1.0;
   eigencent[0][i] *= -1.0;
}

Idsort.twoLevelSort_(playerextinctrisk, eigencent[0], index, nmnodes[0]);

for (i = 0; i < nmnodes[0]; ++i) {
   playerextinctrisk[i] *= -1.0;
   eigencent[0][i] *= -1.0;
}

firstarrest = name[0][index[0] - 1];
secondarrest = name[0][index[1] - 1];

// ------------------------ Detain List -------------------------------

fprintf_(9, "\n----- Detain List (Based on Network at Time point 1) -----");
fprintf_(9, "\n Simulator-SNA-generated Optimal Arrest Sequence:" +
	    "\n Arrest_Priority  Extinction_Risk Eigenvector_Centrality" +
	    "  Player_Name");
for (i = 0; i < nmnodes[0]; ++i) {
   fprintf_(9, "   " + (i + 1) + "       " +
      fdble_(playerextinctrisk[i], 6, 3) + "        " +
      fdble_(eigencent[0][i], 6, 3) + "       " + name[0][index[i] - 1]); 
}

// -----------------------------Surveil List ----------------------------

// First, compute successors and list them.

successors_(maxeigenindex[0], maxbetweenindex[0]);

fprintf_(9, "\n---- Surveil List (Based on Network at Time point 2) ------");
fprintf_(9, "SNA-generated Successor Prediction(s):");
fprintf_(9, "   " + eigensccssr + " will succeed " + firstarrest + ".");
if (!betweensccssr.equals(firstarrest)) {
   fprintf_(9, "   " + betweensccssr + " will succeed " + secondarrest);
}

// List the "puppetmaster": The influential player who is attempting to hide.

maxratio = 0.;
puppetmaster = -1;
for (i = 0; i < nmnodes[0]; ++i) {
   betweentodegree = betweencent[0][i] / degreecent[0][i];
   if (maxratio < betweentodegree) {
      maxratio = betweentodegree;
      puppetmaster = i;
   }
}

fprintf_(9, "\nSNA-predicted Influential Player Attempting to Hide" +
   "\n(highest ratio of betweenness centrality-to-degree centrality): " +
   "\n     " + name[0][puppetmaster]);

// List any Rising Stars.

fprintf_(9, "\nSNA-predicted Rising Stars (Based on Time points 1 and 2): ");
if (nmtimepts < 2) {
   fprintf_(9, "   Need two or more time points to predict rising stars.");
}

/* Match on player name because time point 1 and time point 2 networks may be
   different. */

for (i = 0; i < nmnodes[1]; ++i) {
   for (j = 0; j < nmnodes[0]; ++j) {
      if (name[0][j].equals(name[1][i])) {
         if (eigencent[0][j] < eigencent[1][i] &&
             eigencent[1][i] > medianeigenval[1]) {
            fprintf_(9, "   " + name[1][i] + " is a Rising Star");
            foundstars = true;
         }
         break;
      }
   }
}
if (!foundstars) {
   fprintf_(9, "No Rising Stars found.");
}

// -------------------------- Interdict List -------------------------

fprintf_(9, "\n------------------- Interdict List --------------------");
//fprintf_(9, "   middleman m3 will sell rhino horns in town A, country Y.");
fprintf_(9, "           To Be Completed");

// -------------------- Network Resiliency Index -------------------------

fprintf_(9, "\n--- Network Resiliency Index (Recovery Time) ---" +
   "\n  (assumes arrests were made just after time point 2)" +
   "\n  Connectivity Index at latest time = " +
   fdble_(connectindex[nmtimepts - 1], 8, 3));

if (nmtimepts < 3) {
   fprintf_(9, "   Need three or more time points to compute " +
      "Network Resiliency Index.");

} else {
   fprintf_(9, "   Connectivity Index prior to arrests = " +
      fdble_(connectindex[1], 8, 3));

   if (connectindex[2] < 0.9 * connectindex[1]) {
      resiliencyindex = connectindex[2] /
                        ((timept[2] - timept[1]) * 0.9 * connectindex[1]);
      fprintf_(9, "   Network Resiliency Index = " +
         fdble_(resiliencyindex, 8, 3) + " or about " +
         fdble_((1. / resiliencyindex), 8, 3) + " weeks.");

   } else {
      resiliencyindex = 1 / (timept[2] - timept[1]);
      fprintf_(9, "   Network Resiliency Index >" +
         fdble_(resiliencyindex, 8, 3) + ".");
   }
}
fclose_(9, 'w');
}

// ------------------------------------------------------------------

static void successors_(int firstarresti, int secondarresti) {

// Predicts players who will succeed arrested players.

int i, nmfriends, sccssr = 0;

double absdiff = 0., minabsdiff;

/* Find the player who is directly connected to the first arrested
   player and has the most similar eigenvector centrality value. */

nmfriends = 0;
for (i = 0; i < prednmlinks; ++i) {
   if (predlink[i][0] == firstarresti) {
      friend[nmfriends] = predlink[i][1];
      ++nmfriends;

   } else if (predlink[i][1] == firstarresti) {
      friend[nmfriends] = predlink[i][0];
      ++nmfriends;
   }
}

minabsdiff = 1.e6;
for (i = 0; i < nmfriends; ++i) {
   absdiff = Math.abs(eigencent[0][firstarresti - 1] -
		      eigencent[0][friend[i] - 1]);
   if (absdiff < minabsdiff) {
      minabsdiff = absdiff;
      sccssr = friend[i];
   }
}
eigensccssr = name[0][sccssr - 1];

/* Find the player who is directly connected to the second arrested
   player and has the most similar betweenness centrality value. */

nmfriends = 0;
for (i = 0; i < prednmlinks; ++i) {
   if (predlink[i][0] == secondarresti) {
      friend[nmfriends] = predlink[i][1];
      ++nmfriends;

   } else if (predlink[i][1] == secondarresti) {
      friend[nmfriends] = predlink[i][0];
      ++nmfriends;
   }
}

minabsdiff = 1.e6;
for (i = 0; i < nmfriends; ++i) {
   absdiff = Math.abs(betweencent[0][secondarresti - 1] -
		      betweencent[0][friend[i] - 1]);
   if (absdiff < minabsdiff) {
      minabsdiff = absdiff;
      sccssr = friend[i];
   }
}
betweensccssr = name[0][sccssr - 1];
}

// ------------------------------------------------------------------

static double eigencent_(int nmnodes, double adjmat[][],
   double eigencent[]) {

/* Computes eigenvector centrality values of nodes in the network defined
   by "nmnodes" and the matrix "adjmat." */

int i;

double eigenval;

// First, compute the dominant eigenvector of "adjmat."

for (i = 0; i < nmnodes; ++i) {
   eigencent[i] = 1.;
}
eigenval = Eigenvec.powerm_(adjmat, eigencent, .001, nmnodes, 100);

/* Form the centrality measure, and return the first eigenvalue as the
   network's connectedness index. */

for (i = 0; i < nmnodes; ++i) {
   eigencent[i] = Math.abs(eigencent[i]);
}

return (eigenval);
}

// ------------------------------------------------------------------

static void brokeragecent_(int nmnodes, double adjmat[][], double score[]) {

/* Computes the Gould-Fernandez (GF) Total Brokerage Score for nodes
   defined by "adjmat."  Assumes a symmetric "adjmat" matrix. */

int i, j, k;

for (i = 0; i < nmnodes; ++i) {

   // Search all node pairs for the required condition.

   score[i] = 0.;
   for (j = 0; j < nmnodes; ++j) {
      for (k = j + 1; k < nmnodes; ++k) {
         if (adjmat[j][k] > 0.) {
            continue;
	 }
	 if ((adjmat[i][j] > 0. || adjmat[j][i] > 0.) &&
             (adjmat[i][k] > 0. || adjmat[k][i] > 0.)) {
            score[i] += 1.;
	 }
      }
   }
}
}

// ------------------------------------------------------------------

static double grphdist_(boolean ignorelevels, int nmnodes,
   double degree1[], int level1[], double degree2[], int level2[]) {

/* Computes an inexact measure of distance between two graphs.
   Assumes each "degree" vector has been sorted in descending order
   -- and the level vectors have been sorted according to the
   "degree" vector sort order. */

boolean subset = true;

int i, nmmissmatches = 0;

double maxdegree = 0., dist = 0.;

for (i = 0; i < nmnodes; ++i) {
   if (maxdegree < degree1[i]) {
      maxdegree = degree1[i];
   }
}
if (maxdegree < 1.e-6) {
   maxdegree = 1.;
}

for (i = 0; i < nmnodes; ++i) {
   dist += Math.abs(degree1[i] - degree2[i]);
   if (degree1[i] > degree2[i]) {
      subset = false;
   }
   if (level1[i] != level2[i]) {
      ++nmmissmatches;
   }
}

dist /= maxdegree * ((double) nmnodes);
dist += ((double) nmmissmatches) / ((double) nmnodes);

if (ignorelevels && subset) {
   dist = -1.;
}

return (dist);
}

// ------------------------------------------------------------------

static void degree_(int nmnodes, int nmlinks, int link[][],
   double degree[]) {

/* Finds the degree of each node and sorts this vector in descending
   order. */

int i, j, node = 0;

for (i = 0; i < nmnodes; ++i) {
   degree[i] = 0.;
   node = i + 1;
   for (j = 0; j < nmlinks; ++j) {
      if (link[j][0] == node || link[j][1] == node) {
         degree[i] += 1.;
      }
   }
}
}

// ------------------------------------------------------------------

static void betweencent_(int nmnodes, double adj[][],
   double centval[]) {

// Computes each node's betweeness centrality value.

int i, j, k;

double scale;

computeShortestPaths_(nmnodes, adj, dists, nPaths);

for (i = 0; i < nmnodes; ++i) {
   centval[i] = computeBetweenness_(nmnodes, dists, nPaths, i);
}
}

// ------------------------------------------------------------------

static void computeShortestPaths_(int n, double adj[][], double dists[][],
   int nPaths[][]) {

/* Computes matrix of distances and #s of shortest paths between any
   2 vertices. 

   n: size of matrix/graph
   adj: adjacency matrix of graph
   dists: n x n matrix to set up with distances (return value)
   nPaths: n x n matrix to set up with shortest paths (return value)
 
   From blaisemath (http://code.google.com/p/blaisemath/source)
*/

int i, j, k, nFound;

double power = 1.;

for (i = 0; i < n; ++i) {
   dists[i][i] = 0.;
   nPaths[i][i] = 1;
   for (j = 0; j < n; j++) {
      if (i == j) {
         continue;
      }
      curAdj[i][j] = adj[i][j];
      if (adj[i][j] == 0) {
         dists[i][j] = -1.;
	 nPaths[i][j] = -1;

      } else {
         dists[i][j] = 1.;
	 nPaths[i][j] = 1;
      }
   }
}

nFound = -1;
while (nFound != 0) {
   nFound = 0;
   
   // curAdj = Matrices.matrixProduct(curAdj, adj);

   for (i = 0; i < n; ++i) {
      for (j = 0; j < n; j++) {
	 dumvec[j] = 0.;
         for (k = 0; k < n; ++k) {
            dumvec[j] += curAdj[i][k] * adj[k][j];
	 }
      }
      for (j = 0; j < n; j++) {
         curAdj[i][j] = dumvec[j];
      }
   }

   power++;
   for (i = 0; i < n; ++i) {
      for (j = 0; j < n; j++) {
         if (i == j) {
            continue;
	 }
	 if (dists[i][j] == -1. && curAdj[i][j] != 0) {
	    dists[i][j] = power;
	    nPaths[i][j] = (int) curAdj[i][j];
	    nFound++;
	 }
      }
   }
}
}

// -----------------------------------------------------------------

static double computeBetweenness_(int n, double dists[][], int nPaths[][],
   int v0) {

/* Computes the betweenness of a specified vertex.
 
   n: size of matrix/graph
   dists: the matrix of distances between vertices
   nPaths: the matrix of # of shortest paths between any two vertices
   v0: the index of the node whose betweenness is to be computed
   directed: whether the graph for the computation is directed or not
   returns the betweenness of the vertex
*/

int i, j;

double result = 0.0;

for (i = 0; i < n; ++i) {
   for (j = 0; j < n; j++) {
      if (i == j) {
         continue;
    
      } else if ((i == v0 || j == v0) && dists[i][j] != -1.) {
         result++;
    
      } else if (dists[i][v0] != -1. && dists[v0][j] != -1. &&
                 dists[i][j] != -1. &&
	         dists[i][v0] + dists[v0][j] == dists[i][j]) {
         result += nPaths[i][v0] * nPaths[v0][j] / (double) nPaths[i][j];
      }
   }
}

return result;
}
}
