public class SNAutils extends SNA {

static int nmiters, nmcomms = 0;

static final int MAXITERS = 100;

static int ishufflvec[] = new int[TNMNDS];
static int kshufflvec[] = new int[TNMNDS];
static int nodecomm[] = new int[TNMNDS];
static int oldcomm[] = new int[TNMNDS];
static int d[][] = new int[TNMNDS][TNMNDS];

// --------------------------------------------------------------------

static void readnetwork_(int flenm, int netindex) {

boolean newnode = false, linkfound = false;

String candidateid = "none", leftend, rightend, lefttype,
   righttype, node1name = "none", node2name = "none", evidencetype = "none";

int i, j, nmread = 0, node1 = 0, node2 = 0, node3 = 0, intval = 0;

/* Reads-in a social network.  First, read the nodes section of the
   links file. */

if (linksfletype <= 2) {
   fgetstrng_(4);
   fgetstrng_(4);
   nmnodes[0] = fgetint_(4);

   // Read all node labels.

   for (;;) {
      strng = fgetstrng_(4);
      if (isString) {
         strng = fgetstrng_(4);
         break;

      } else {
         streamTokenizer[3].pushBack();
      }
      i = fgetint_(4);
      allid[i - 1] = fgetstrng_(4);
      innode[i - 1] = true;

      if (linksfletype == 2) {
         prednodelevel[i - 1] = fgetint_(4);
      }
      ++nmread;
   }
   printf_("readnetwork: netindex= " + netindex + " allnmnodes= " +
      nmnodes[netindex] + " nmread= " + nmread);

} else if (linksfletype == 3) {
   fgetline_(4);

   // Read every integer in the file no matter what column it is in.

   nmnodes[0] = 0;
   readnodes: do {

      /* Read an integer and see if it is unique.  If so, create a new
         node. */

      intval = fgetint_(4);
      if (intval == 0) {
         continue;
      }
      candidateid = "h" + Integer.toString(intval);
      for (i = 0; i < nmnodes[0]; ++i) {
         if (candidateid.equals(allid[i])) {
            continue readnodes;
	 }
      }
      allid[nmnodes[0]] = candidateid;
      idumvec[nmnodes[0]] = intval;
      ++nmnodes[0];
   } while (!checkeof_(4));
   fclose_(4, 'r');

} else if (linksfletype == 5) {
   fgetline_(4);
   timept[netindex] = fgetdble_(4);
   nmnodes[netindex] = fgetint_(4);
   nmlevels = fgetint_(4);
   nmlinks = fgetint_(4);
   fgetline_(4);

   for (i = 0; i < nmnodes[netindex]; ++i) {
      allid[i] = fgetstrng_(4);
      name[netindex][i] = allid[i];
      playerID[i] = "h" + Integer.toString(i + 1);
      innode[i] = true;

      prednodelevel[i] = fgetint_(4);

      town[netindex][i] = fgetstrng_(4);
      regionresidence[netindex][i] = fgetstrng_(4);
      country[netindex][i] = fgetstrng_(4);
      allvehicles[i] = fgetint_(4);
      for (j = 0; j < allvehicles[i]; ++j) {
         vehicles[netindex][i][j] = fgetstrng_(4);
      }
   }
}

/* Read all observed edges (links).  For linksfletype = 3, re-read the
   file.  This time, read the primary linked player in column 2 and the
   (possibly) player linked to this player in column 3. */

if (linksfletype == 3) {
   fleopen_(4, linksfle, 'r');
   fgetint_(4);
}

nmalllinks[netindex] = 0;
if (linksfletype <= 2) {
   node1 = fgetint_(4);
   node2 = fgetint_(4);
   nmalllinks[netindex] = addlink_(0, nmalllinks[netindex], node1, node2);

} else if (linksfletype == 3) {
   node1 = fgetint_(4);
   for (i = 0; i < nmnodes[netindex]; ++i) {
      if (idumvec[i] == node1) {
         node1 = i + 1;
         break;
      }
   }
   node2 = fgetint_(4);
   node3 = fgetint_(4);
   for (i = 0; i < nmnodes[netindex]; ++i) {
      if (idumvec[i] == node3) {
         node3 = i + 1;
         break;
      }
   }
   if (node2 > 0) {
      for (i = 0; i < nmnodes[netindex]; ++i) {
         if (idumvec[i] == node2) {
            node2 = i + 1;
            break;
         }
      }
      nmalllinks[netindex] = addlink_(netindex, nmalllinks[netindex],
                                      node1, node2);
      if (node3 > 0) {
         nmalllinks[netindex] = addlink_(netindex, nmalllinks[netindex],
                                         node2, node3);
      }

   } else if (node3 > 0) {
      nmalllinks[netindex] = addlink_(netindex, nmalllinks[netindex],
                                      node1, node3);
   }

} else if (linksfletype == 4) {

   /* MEMEX "decode" file.  Both nodes and links are read at the
      same time.  Assumes "," has been replaced with " ". */

   readlinks: do {
      strng = fgetstrng_(4);
      if (!strng.equals("xxlinked")) {
         continue readlinks;
      }
      leftend = fgetstrng_(4);
      leftend = leftend.substring(2);
      rightend = fgetstrng_(4);
      rightend = rightend.substring(2);

      lefttype = findtype_(leftend);
      righttype = findtype_(rightend);

      // Detect and add new nodes.

      if (lefttype.equals("human")) {
         newnode = true;
         for (i = 0; i < nmnodes[netindex]; ++i) {
            if (leftend.equals(allid[i])) {
               node1 = i + 1;
               newnode = false;
               break;
            }
         }
         if (newnode) {
            allid[nmnodes[netindex]] = leftend;
            ++nmnodes[netindex];
            node1 = nmnodes[netindex];
         }
      }
      if (righttype.equals("human")) {
         newnode = true;
         for (i = 0; i < nmnodes[netindex]; ++i) {
            if (rightend.equals(allid[i])) {
               node2 = i + 1;
               newnode = false;
               break;
            }
         }
         if (newnode) {
            allid[nmnodes[netindex]] = rightend;
            ++nmnodes[netindex];
            node2 = nmnodes[netindex];
         }
      }

      // Store each player's "evidencerpt" identifiers.

      if (lefttype.equals("human") && righttype.equals("evidencerpt")) {
         noderpts[node1 - 1][nmrpts[node1 - 1]] = rightend;
         ++nmrpts[node1 - 1];

      } else if (lefttype.equals("evidencerpt") &&
                 righttype.equals("human")) {
         noderpts[node2 - 1][nmrpts[node2 - 1]] = leftend;
         ++nmrpts[node2 - 1];
      }

      // Add a link.

      if (lefttype.equals("human") && righttype.equals("human")) {
          nmalllinks[netindex] = addlink_(netindex, nmalllinks[netindex],
                                          node1, node2);
      }         

      // Count the number of phones each player has.
      
      if (lefttype.equals("human") && righttype.equals("phone")) {
          ++allphones[node1 - 1];

      } else if (lefttype.equals("phone") && righttype.equals("human")) {
         ++allphones[node2 - 1];
      }

      // Count the number of vehicles each player has.
      
      if (lefttype.equals("human") && righttype.equals("car")) {
          ++allvehicles[node1 - 1];

      } else if (lefttype.equals("car") && righttype.equals("human")) {
         ++allvehicles[node2 - 1];
      }

      // Count the number of firearms each player has.
      
      if (lefttype.equals("human") && righttype.equals("gun")) {
          ++allfirearms[node1 - 1];

      } else if (lefttype.equals("gun") && righttype.equals("human")) {
         ++allfirearms[node2 - 1];
      }
   } while (!checkeof_(4));
   // ------------- End of MEMEX linksfletype. ---------------

} else if (linksfletype == 5) {
   printf_("readnetwork: line= " + fgetline_(4));

   // Read each link and its evidence-type.

   for (j = 0; j < nmlinks; ++j) {
      node1name = fgetstrng_(4);
      node1 = findnodenm_(netindex, nmnodes[netindex], node1name);
      node2name = fgetstrng_(4);
      node2 = findnodenm_(netindex, nmnodes[netindex], node2name);
      evidencetype = fgetstrng_(4);

      nmalllinks[netindex] = addlink_(netindex, nmalllinks[netindex],
                                      node1, node2);
      addcontacts_(netindex, node1, node1name, node2, node2name);
   }
}
return;
}

// ------------------------------------------------------------------

public static int addlink_(int netindex, int nmlinks, int node1, int node2) {

int i;

alllink[netindex][nmlinks][0] = node1;
alllink[netindex][nmlinks][1] = node2;

// Eliminate any duplicate links.

for (i = 0; i < nmlinks; ++i) {
   if ((alllink[netindex][i][0] == alllink[netindex][nmlinks][0] &&
        alllink[netindex][i][1] == alllink[netindex][nmlinks][1]) ||
       (alllink[netindex][i][1] == alllink[netindex][nmlinks][0] &&
        alllink[netindex][i][0] == alllink[netindex][nmlinks][1])) {

      printf_("addlink: nmlinks= " + nmlinks + " returning");

      return (nmlinks);
   }
}
++nmlinks;

/*
printf_("addlink: leftnode= " + alllink[netindex][nmlinks - 1][0] +
   " rightnode= " + alllink[netindex][nmlinks - 1][1]);
!! sed substitution on only a few lines:    :296,305s/link\[net/link\[met/g
*/

return (nmlinks);
}

// ------------------------------------------------------------------

static int findnodenm_(int netindex, int nmnodes, String nodename) {

// Finds node number from node name.

int i, nodenm = 0;

for (i = 1; i <= nmnodes; ++i) {
   if (nodename.equals(name[netindex][i - 1])) {
      nodenm = i;
      break;
   }
}

if (nodenm == 0) {
   iderr_("findnodenm: netindex= " + netindex + " nmnodes= " + nmnodes +
      " nodename= " + nodename);
}

return nodenm;
}

// ------------------------------------------------------------------

public static void addcontacts_(int netindex, int node1, String node1name,
   int node2, String node2name) {

// Adds contacts based on this link.  First, add node2 to node1's contacts.

boolean contactexists = false;

int i;

for (i = 0; i < nmcontacts[netindex][node1 - 1]; ++i) {
   if (node2name.equals(contacts[netindex][node1 - 1][i])) {
      contactexists = true;
      break;
   }
}

if (!contactexists) {
   contacts[netindex][node1 - 1]
           [nmcontacts[netindex][node1 - 1]] = node2name;
   ++nmcontacts[netindex][node1 - 1];
}

// Now, add node1 to node2's contacts.

contactexists = false;
for (i = 0; i < nmcontacts[netindex][node2 - 1]; ++i) {
   if (node1name.equals(contacts[netindex][node2 - 1][i])) {
      contactexists = true;
      break;
   }
}

if (!contactexists) {
   contacts[netindex][node2 - 1]
           [nmcontacts[netindex][node2 - 1]] = node1name;
   ++nmcontacts[netindex][node2 - 1];
}
}

// ------------------------------------------------------------------

public static String findtype_(String entity) {

// Finds what type "entity" is.

String type = "none";

if (entity.indexOf("TA", 0) >= 0 ||
   entity.indexOf("TK", 0) >= 0 ||
   entity.indexOf("CP", 0) >= 0 ||
   entity.indexOf("CE", 0) >= 0 ||
   entity.indexOf("TT", 0) >= 0 ||
   entity.indexOf("SM", 0) >= 0 ||
   entity.indexOf("NN", 0) >= 0) {
   type = "human";

} else if (entity.indexOf("CP", 0) >= 0 ||
   entity.indexOf("TT", 0) >= 0 ||
   entity.indexOf("CE", 0) >= 0 ||
   entity.indexOf("SM", 0) >= 0 ||
   entity.indexOf("TK", 0) >= 0) {
   type = "phone";

} else if (entity.indexOf("VV", 0) >= 0 ||
   entity.indexOf("VC", 0) >= 0) {
   type = "car";

} else if (entity.indexOf("TY", 0) >= 0 ||
   entity.indexOf("WE", 0) >= 0) {
   type = "gun";

} else if (entity.indexOf("CR", 0) >= 0 ||
   entity.indexOf("KK", 0) >= 0 ||
   entity.indexOf("EI", 0) >= 0 ||
   entity.indexOf("VB", 0) >= 0 ||
   entity.indexOf("IN", 0) >= 0 ||
   entity.indexOf("UC", 0) >= 0 ||
   entity.indexOf("NR", 0) >= 0 ||
   entity.indexOf("RP", 0) >= 0) {
   type = "evidencerpt";
}
return type;
}

// ------------------------------------------------------------------

static void assigncomm_(int nmnodes) {

// Assigns a community to each node.

boolean commfound = false, reassign = false;

int i, j, k, ishuffled = 0, kshuffled = 0;

// To initialize, assign each node to its own community.

for (i = 0; i < nmnodes; ++i) {
   nodecomm[i] = i + 1;
   oldcomm[i] = nodecomm[i];
}
nmcomms = nmnodes;

/* Iteratively reassign nodes to communities until no reassignments
   are made. */

for (nmiters = 0; nmiters < MAXITERS; ++nmiters) {
   reassign = false;

   ishufflvec = Rndm.shuffle_(0, nmnodes - 1, 0);
   for (i = 0; i < nmnodes; ++i) {
      ishuffled = ishufflvec[i];

      /* Count the number of members of each community that this node is
         connected to. */

      for (k = 0; k < nmcomms; ++k) {
         d[ishuffled][k] = 0;
         for (j = 0; j < nmnodes; ++j) {
            if (ishuffled != j && nodecomm[j] == (k + 1) &&
                adjmat[ishuffled][j] == 1) {
               ++d[ishuffled][k];
            }
         }
      }

      // Search for a community.

      kshufflvec = Rndm.shuffle_(0, nmcomms - 1, 0);
      KLOOP: for (k = 0; k < nmcomms; ++k) {
         kshuffled = kshufflvec[k];
         commfound = true;
         for (j = 0; j < nmcomms; ++j) {
            if (j != kshuffled &&
                d[ishuffled][kshuffled] < d[ishuffled][j]) {
               commfound = false;
               continue KLOOP;
            }
         }
         if (commfound) {
            nodecomm[ishuffled] = kshuffled + 1;

            // Check if this node has been reassigned.

            if (nodecomm[ishuffled] != oldcomm[ishuffled]) {
               reassign = true;
            }
            break;
         }
      }
   }

   if (!reassign) {
      break;
   }

   for (i = 0; i < nmnodes; ++i) {
      oldcomm[i] = nodecomm[i];
   }
}

// Find the number of communities.

nmcomms = 1;
for (i = 1; i < nmnodes; ++i) {
   commfound = false;
   for (j = 0; j < i; ++j) {
      if (nodecomm[j] == nodecomm[i]) {
         commfound = true;
         break;
      }
   }
   if (!commfound) {
      ++nmcomms;
   }
}
return;
}
}
