public class Simanel extends Id {

static boolean infeasible = false, terminate = false;

static int nofs, nofslimit = 400000;

static int xtrial[] = new int[SIMASZE];
static int xmin[] = new int[SIMASZE];
static int xmax[] = new int[SIMASZE];
static int xfeas[] = new int[SIMASZE];
static int inarry[] = new int[SIMASZE];
static int delarry[] = new int[SIMASZE];

static double smin[] = new double[3];
static double smax[] = new double[3];

// -----------------------------------------------------------------------

public static int simanel_(int n, int chlngt, int x[], double t, double estop,
   int fnm) {

/* Uses simulated annealing to solve a nonlinear integer programming
   problem by MINIMIZING the objective function.  For "fnm"=1 and 4, this
   is the combinatorial optimization 0, 1 problem.  The cooling
   schedule and stopping criterion is the finite-time approximation
   (chapter 4) in "Simulated Annealing and Boltzmann Machines" by
   E. Aarts and J. Korst, Wiley, 1989.

   The length of each inner loop's Markov chain is equal to the size of
   the neighborhood (p. 65).

   Set the initial temperature in the call to this method.
   An initial value of t = 0.3 has worked in the past for monitoring
   network redesign ("fnm"=1). */

boolean test = false, feasibleexists = false;

int i, j, k, nmaccpt, nmiter, ttlacpt, maxiter;

double avescr = 1., scrstdev, rchlngt, sold, snew, delta, cnvstat,
   avescri = 1., avescro = 0., told = 0., denom, accpt = 0., nmgood = 0.;

// Set maximum number of iterations.

maxiter = 100; // was 100

// Quit if n is too small or too big. was 10 < n <= SIMASZE

if (n <= 0) {
   iderr_("simanel: n= " + n);
}
if (n > SIMASZE) {
   iderr_("simanel: n= " + n + " > SIMASZE= " + SIMASZE);
}

// Initialize nofs.

nofs = 0;

if (test) {
 
   // Open solution history file.

   fleopen_(10, "simhist.plt", 'w');
}

rchlngt = (double) chlngt;
printf_("simanel: rchlngt= " + rchlngt + " Convergence epsilon= " + estop);

/* Initialization: find initial control parameter t defined to be the value
   for which the percentage of moves accepted is between 90 and 100. */

for (j = 0; j < 50; ++j) {
   nmaccpt = 0;
   avescr = 0.;
   scrstdev = 0.;
   sold = 1.e30;

   nmgood = 0.;
   for (i = 0; i < chlngt; ++i) {
      move_(n, x, xtrial, fnm);
      snew = screval_(n, xtrial, fnm);

      if (infeasible) {
         if (feasibleexists) {
            for (k = 0; k < n; ++k) {
               x[k] = xfeas[k];
            }
         }
         continue;

      } else {
         feasibleexists = true;
         for (k = 0; k < n; ++k) {
            xfeas[k] = x[k];
         }
      }

      nmgood += 1.;

      /* Always accept solutions that are smaller than sold.  Accept
	 other solutions with probability exp(-(snew - sold) / t). */

      if ((t * Math.log(Rndm.rndm1_(0, 0))) < (sold - snew)) {
	 storesol_(n, x, fnm);
	 sold = snew;
	 ++nmaccpt;
      }
      avescr += sold;
      scrstdev += sold * sold;
   }

   if (nmgood < 2.) {
      continue;
   }

   accpt = ((double) nmaccpt) / nmgood;
   avescr /= nmgood;
   scrstdev = Math.sqrt((scrstdev - (nmgood * avescr * avescr)) /
	      (nmgood - 1.));

   printf_("simanel: tinitial= " + fdble_(t, 8, 4) + " avescr= " +
      fdble_(avescr, 8, 4) + " scrstdev= " +
      fdble_(scrstdev, 8, 4) + " accpt= " + fdble_(accpt, 8, 4));

   // Adjust t accordingly.

   if (accpt < .9) {
      t *= 1.2;
   
   } else if (accpt > .99) {
      t /= 1.5;
   }

   // Stop if t is negative.

   if (t < 0.) {
      iderr_("simanel: initial t < 0");
   }

   if (accpt >= .85 && accpt <= .99) {
      break;
   }
}

if (accpt < .85 || accpt > .99) {
   printf_("simanel: initialization failed");
   return 0;
}

avescri = avescr;

/* Outer loop of simulated annealing.  delta is the distance parameter
   and estop is the convergence criterion parameter (pp. 63-64). */

delta = 2.; // was 2.
nmiter = 1;
smin[0] = 1.e30;
smax[0] = -1.e30;
sold = 1.e30;
ttlacpt = 0;

printf_("simanel: Initialization completed." +
   "\nIteration  t  avescr   scrstdev   accpt    evals    cnvstat");
for (;;) {
   
   // Inner loop.

   avescr = 0.;
   scrstdev = 0.;
   nmaccpt = 0;
   for (i = 0; i < chlngt; ++i) {

      // Generate a move and calculate score function.

      move_(n, x, xtrial, fnm);
      snew = screval_(n, xtrial, fnm);

      if (infeasible) {
         if (feasibleexists) {
            for (k = 0; k < n; ++k) {
               x[k] = xfeas[k];
            }
         }
         continue;

      } else {
         feasibleexists = true;
         for (k = 0; k < n; ++k) {
            xfeas[k] = x[k];
         }
      }

      // Keep smallest and largest solutions.

      if (snew < smin[0]) {
	 smin[0] = snew;
	 storemin_(n, xtrial, fnm);

      } else if (snew > smax[0]) {
	 smax[0] = snew;
	 storemax_(n, xtrial, fnm);
      }

      // Accept with probability exp(-(snew - sold) / t).

      if ((t * Math.log(Rndm.rndm1_(0, 0))) < (sold - snew)) {
	 storesol_(n, x, fnm);
	 sold = snew;
	 ++nmaccpt;
	 ++ttlacpt;
	 if (test) {
            fprintf_(10, nmiter + " " + t + " " +
	       ((double) ttlacpt) + " " + snew);
	 }
      }

      avescr += sold;
      scrstdev += sold * sold;
   }

   /* Find the acceptance ratio, the average score, and the score standard
      deviation. */

   accpt = ((double) nmaccpt) / rchlngt;
   avescr /= rchlngt;
   scrstdev = (scrstdev - (rchlngt * avescr * avescr)) / (rchlngt - 1.);
   if (scrstdev > 1.e-6) {
      scrstdev = Math.sqrt(scrstdev);
   }

   // Print statistics for the first chain.

   if (nmiter <= 1) {
      printf_(nmiter + "   " + fdble_(t, 8, 4) + "  " +
         fdble_(avescr, 8, 4) + "  " + fdble_(scrstdev, 8, 4) + "  " +
	 fdble_(accpt, 8, 4) + "  " + nofs);
   }

   /* After first iteration, test for convergence, p. 64:
      (t/avescri) * d(avescr)/dt < estop.  Also demand that the acceptance
      ratio be lower than .5. */

   if (nmiter > 1) {
      if (t < told) {
         cnvstat = (avescr - avescro) / (t - told);
      
      } else if (t > 0.) {
         cnvstat = (avescr - avescro) / t;
      
      } else {
         cnvstat = 0.;
      }

      if (avescri > 0.) {
         cnvstat *= t / avescri;
      
      } else {
	 cnvstat = 0.;
      }

      printf_(nmiter + " " + fdble_(t, 8, 4) + "  " +
         fdble_(avescr, 8, 4) + "  " + fdble_(scrstdev, 8, 4) + "  " +
         fdble_(accpt, 8, 4) + "  " + nofs + "  " + fdble_(cnvstat, 8, 4));

      // Convergence test.
      
      if (Math.abs(cnvstat) < estop || nmiter > maxiter || terminate) {
	 printf_("simanel: cnvstat = " + cnvstat + " estop = " + estop);

	 if (nmiter > maxiter || terminate) {
            printf_("simanel: Max iteration or nofs exceeded," +
	    " current best solution is printed");
         }

	 loadmin_(n, x, fnm);
         smin[0] = screval_(n, xmin, fnm);
      
	 if (infeasible) {
            continue;
         }

         printf_("simanel: smin= " + smin[0] + " nofs= " + nofs);

	 // Return.

	 if (test) {
	    fclose_(10, 'w');
	 }
	 return 0;
      }
   }

   ++nmiter;
   avescro = avescr;
   told = t;

   /* If the standard deviation is not zero, decrement t, the control
      parameter (p. 63). */

   if (scrstdev > 1.e-6) {
      denom = 1. + (t * Math.log(1. + delta)) / (3. * scrstdev);
      t /= denom;
   }
}
}

// --------------------------------------------------------------------

public static void move_(int n, int x[], int xtrial[], int fnm) {

// Calculate a new state, "xtrial" from the old state, "x".

int i;

if (fnm == 1) {
   Surfcalcs.movesites_(n, x, xtrial);

} else if (fnm == 2) {
   Pltgrph.movenodes_(n, x, xtrial);

} else if (fnm == 3) {
   Interdict.move_(n, x, xtrial);
}
}

// ----------------------------------------------------------------------

public static double screval_(int n, int x[], int fnm) {

int i;

double retval = 0.;

// Update function counter and initialize feasible-point indicator.

++nofs;
if (nofs > nofslimit) {
   //printf_("screval: nofs= " + nofs);
   terminate = true;

   return 0.;
}
infeasible = false;

// Evaluate the score function and return its value.

if (fnm == 1) {
   return Surfcalcs.screvalsites_(n, x);

} else if (fnm == 2) {
   return Pltgrph.nmcross_(false, x);

} else if (fnm == 3) {

   /*
   retval = Interdict.updateobjf_(n, x);
   if (Optimiz.endopt) {
      infeasible = true;
   }
   */

   // printf_("screval: nofs= " + nofs + " retval= " + retval);

   return (retval);
}

return 0.;
}

// --------------------------------------------------------------------

public static void storesol_(int n, int x[], int fnm) {

// Store the "xtrial" solution.

int i;

for (i = 0; i < n; ++i) {
   x[i] = xtrial[i];
}
}

// --------------------------------------------------------------------

public static void storemin_(int n, int xstoremin[], int fnm) {

// Store minimum solution.

int i, j;

for (i = 0; i < n; ++i) {
   xmin[i] = xstoremin[i];
}

if (fnm == 1) {
   smin[1] = Surfcalcs.objfcn[0];
   smin[2] = Surfcalcs.objfcn[1];

} else if (fnm == 2) {
   for (i = 0; i < Pltgrph.nmhierarc; ++i) {
      for (j = 0; j < Pltgrph.npcols; ++j) {
	 Pltgrph.hiermin[i][j] = Pltgrph.ndetrial[i][j];
      }
   }
}
}

// --------------------------------------------------------------------

public static void storemax_(int n, int x[], int fnm) {

// Store maximum solution.

int i, j;

for (i = 0; i < n; ++i) {
   xmax[i] = x[i];
}

if (fnm == 1) {
   smax[1] = Surfcalcs.objfcn[0];
   smax[2] = Surfcalcs.objfcn[1];

} else if (fnm == 2) {
   for (i = 0; i < Pltgrph.nmhierarc; ++i) {
      for (j = 0; j < Pltgrph.npcols; ++j) {
	 Pltgrph.hiermax[i][j] = Pltgrph.ndetrial[i][j];
      }
   }
}
}

// ---------------------------------------------------------------------

public static void loadmin_(int n, int xloadmin[], int fnm) {

// Load the stored minimum solution.

int i, j;

for (i = 0; i < n; ++i) {
   xloadmin[i] = xmin[i];
}

if (fnm == 2) {
   for (i = 0; i < Pltgrph.nmhierarc; ++i) {
      for (j = 0; j < Pltgrph.npcols; ++j) {
	 Pltgrph.ndetrial[i][j] = Pltgrph.hiermin[i][j];
      }
   }
}
}
}
