// JavaSpaces Space accessor.

// Jini core packages.

import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.*;
import net.jini.core.entry.Entry;

// Jini extension package.

import net.jini.space.JavaSpace;
import net.jini.lookup.entry.*;

// Java core packages.

import java.io.*;
import java.rmi.*;
import java.net.*;
import java.util.*;

// **
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.Constants;
// **

// -----------------------------------------------------------------

public class SpaceAccessor {

/* ------ FIELDS ------ */
     
/* To find the IP address of a PC, run "ping" at a DOS prompt.
   Example:   "ping n219-01"   will return the IP address of the first
   PC in N219.  For example, "162" is n219-01 and "218" is n219-02.

   ***NOTE: find and use the default port number (for apache river it is
   4160 rather than the port number used in other classes because otherwise,
   you will get a "SocketTimoutException: Read timed out" error. */

// static String jiniURL   = "jini://" + Id.impresarioip + ":4160/";
static String jiniURL   = "jini://" + Id.impresarioip;

static final long MAX_LOOKUP_WAIT = 2000L;
static final int WAIT = 100000;

JavaSpace space;
   
// ------------------------------------------------------------------

public SpaceAccessor() {
LookupLocator locator = null;
ServiceRegistrar registrar = null;
     
// Security manager

try {
   System.setSecurityManager(new SecurityManager());
}
catch (Exception e) {
   e.printStackTrace();
}

if (Id.client) {
   jiniURL = "jini://" + Id.impresarioip + ":4160/";
}
Id.printf_("spaceaccessor: jiniURL= " + jiniURL);

try {

   // Get lookup service locator at "jini://hostname"
   // use default port and register of the locator

   locator = new LookupLocator(jiniURL);
   Thread.sleep(1000);

   Id.printf_("locator= " + locator.toString());
   Socket socket = new Socket(locator.getHost(),locator.getPort());
   printSocketInformation(socket);
   Id.printf_("isConnected= " + (socket.isConnected()));

   registrar = locator.getRegistrar(WAIT);
 
   Id.printf_("Service Registrar: " + registrar.getServiceID());

   ServiceTemplate template;
   if (Id.spacename != null) {
      
      /* Specify the service requirement, array (length 1) of 
         Entry interfaces (such as the Name interface)

      Entry [] attr = new Entry[1];
      attr[0] = new Name(Id.spacename);
      template = new ServiceTemplate(null, null, attr);
      */

      Class [] types = new Class[] {JavaSpace.class};
      template = new ServiceTemplate(null, types, null);
      ServiceMatches sms = registrar.lookup(template, 10);
     if(0 < sms.items.length) {
        space = (JavaSpace) sms.items[0].service;

     } else {
        Id.printf_("No Java Space found.");
     }

   } else {

      // Specify the service requirement, array (length 1) of 
      // instances of Class
      
       Class [] types = new Class[] {JavaSpace.class};
       template = new ServiceTemplate (null, types, null);
   }
}
catch(Exception e) {
   System.out.println(e.getMessage());
   e.printStackTrace();
   Id.iderr_("JavaSpace creation failed");
}   
if (space == null) {
   Id.iderr_("SpaceAccessor: space=null");
}
}
 
/* GET SPACE */
  
public JavaSpace getSpace() {
   return space;
}

// ---------------------------------------------------------------

public void discoverSpace() {

/* We're going to look for all ServiceRegistrar instances in all
   groups - everything we can find via a multicast */

try {
LookupDiscovery myDiscovery =
   new LookupDiscovery(LookupDiscovery.ALL_GROUPS);
myDiscovery.addDiscoveryListener(new DiscoveryListenerImpl());
} catch (IOException anIOE) {
System.err.println("Couldn't setup LookupDiscovery - exiting");
anIOE.printStackTrace(System.err);
System.exit(-1);
}

/* The thing we need to remember about this kind of discovery is
   that things take *time*.  Locating a ServiceRegistrar doesn't happen
   immediately and is actually being done *asynchronously* (on another
   thread).  So, we wait a while or, in this case, forever.  Note
   that, depending on implementation, this might not be necessary.
   It may be enough to have an active LookupDiscovery instance if it
   uses normal threads.  However, we assume it uses all daemon threads. */

try {
Object myLock = new Object();
synchronized(myLock) {
   myLock.wait(0);
}
} catch (InterruptedException anIE) {
System.err.println("Whoops main thread interrupted");
}
}

// ----------------------------------------------------------------

private static class DiscoveryListenerImpl implements DiscoveryListener {
public void discarded(DiscoveryEvent anEvent) {
// We don't care about these
}

public void discovered(DiscoveryEvent anEvent) {
ServiceRegistrar[] myRegs = anEvent.getRegistrars();

for (int i = 0; i < myRegs.length; i++) {
   try {
   ServiceRegistrar myRegistrar = myRegs[i];
   if (myRegistrar != null) {
      System.out.println("Found registrar:");
      DiscoveryUtil.dumpRegistrar(myRegistrar);

      /* HACK: If we find a registrar, it may have just
         started and not have any services yet (they haven't
         found it at this point).  So we wait a while before
         doing the interrogation.  We could fix this by
         registering a listener with the ServiceRegistar
         via notify() but there's an easier way
         - ServiceDiscoveryManager. */

      try {
      Thread.sleep(5000);
      } catch (InterruptedException anIE) {
      }

      ServiceMatches myMatches = 
         DiscoveryUtil.findServicesOfType(JavaSpace.class, myRegistrar);
      DiscoveryUtil.dump(myMatches);
   }
   } catch (IOException ex) {
   System.err.println("Couldn't talk to ServiceRegistrar");
   ex.printStackTrace(System.err);
   }
}
}
}

// ---------------------------------------------------------------

public void printSocketInformation(Socket socket){
try  {
System.out.format("Port:                 %s\n",   socket.getPort());
System.out.format("Canonical Host Name:  %s\n",
   socket.getInetAddress().getCanonicalHostName());
System.out.format("Host Address:         %s\n\n",
   socket.getInetAddress().getHostAddress());
System.out.format("Local Address:        %s\n",   socket.getLocalAddress());
System.out.format("Local Port:           %s\n",   socket.getLocalPort());
System.out.format("Local Socket Address: %s\n\n",
   socket.getLocalSocketAddress());
System.out.format("Receive Buffer Size:  %s\n",
   socket.getReceiveBufferSize());
System.out.format("Send Buffer Size:     %s\n\n", socket.getSendBufferSize());
System.out.format("Keep-Alive:           %s\n",   socket.getKeepAlive());
System.out.format("SO Timeout:           %s\n",   socket.getSoTimeout());
}  catch (Exception e)  {
e.printStackTrace();
}}
}
